/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import org.apache.lucene.search.FieldComparator;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldComparatorSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFieldInsensitiveComparatorSource
extends SharedFieldComparatorSource {
    private static final long serialVersionUID = -8727818091475897471L;

    public SharedFieldInsensitiveComparatorSource(String fieldname, ItemDataConsumer ism, NamespaceMappings nsMappings) {
        super(fieldname, ism, nsMappings);
    }

    @Override
    protected FieldComparator<?> createSimpleComparator(int numHits, QPath path) throws IllegalNameException {
        return new SimpleFieldInsensitiveComparator(this.nsMappings.translatePath(path), this.field, numHits);
    }

    @Override
    protected FieldComparator<?> createCompoundComparator(int numHits, QPath path, SharedFieldComparatorSource.SimpleFieldComparator simple) {
        return new CompoundScoreFieldInsensitiveComparator(new FieldComparator[]{simple, new SharedFieldComparatorSource.RelPathFieldComparator(this, path, numHits)}, numHits);
    }

    private static Comparable<?> makeInsensitiveValue(Comparable<?> val) {
        if (val instanceof String) {
            return ((String)((Object)val)).toUpperCase();
        }
        if (val instanceof QPathEntry) {
            QPathEntry entry = (QPathEntry)val;
            return new QPathEntry(entry.getNamespace().toUpperCase(), entry.getName().toUpperCase(), entry.getIndex());
        }
        return val;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompoundScoreFieldInsensitiveComparator
    extends SharedFieldComparatorSource.CompoundScoreFieldComparator {
        public CompoundScoreFieldInsensitiveComparator(FieldComparator<?>[] fieldComparators, int numHits) {
            super(fieldComparators, numHits);
        }

        @Override
        protected int compare(Comparable<?> val1, Comparable<?> val2) {
            val1 = SharedFieldInsensitiveComparatorSource.makeInsensitiveValue(val1);
            val2 = SharedFieldInsensitiveComparatorSource.makeInsensitiveValue(val2);
            return super.compare(val1, val2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleFieldInsensitiveComparator
    extends SharedFieldComparatorSource.SimpleFieldComparator {
        public SimpleFieldInsensitiveComparator(String propertyName, String fieldName, int numHits) {
            super(propertyName, fieldName, numHits);
        }

        @Override
        protected int compare(Comparable<?> val1, Comparable<?> val2) {
            val1 = SharedFieldInsensitiveComparatorSource.makeInsensitiveValue(val1);
            val2 = SharedFieldInsensitiveComparatorSource.makeInsensitiveValue(val2);
            return super.compare(val1, val2);
        }
    }
}

