/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.jcr.storage.value.ValueStorageURLStreamHandler;

public class StreamPersistedValueData
extends FilePersistedValueData {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    protected InputStream stream;
    protected SpoolFile tempFile;
    protected URL url;
    protected boolean spoolContent;

    public StreamPersistedValueData(int orderNumber, InputStream stream, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, stream, (File)null, spoolConfig);
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, tempFile, null, spoolConfig);
    }

    public StreamPersistedValueData(int orderNumber, InputStream stream, File destFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, destFile, spoolConfig);
        this.tempFile = null;
        this.stream = stream;
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile, File destFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, destFile, spoolConfig);
        this.tempFile = tempFile;
        this.stream = null;
        if (tempFile != null) {
            tempFile.acquire(this);
        }
    }

    public StreamPersistedValueData(int orderNumber, URL url, SpoolFile tempFile, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, tempFile, null, spoolConfig);
        this.url = url;
    }

    public StreamPersistedValueData() throws IOException {
    }

    public InputStream getStream() throws IOException {
        return this.stream;
    }

    public SpoolFile getTempFile() {
        return this.tempFile;
    }

    public void setPersistedFile(File file) throws FileNotFoundException {
        if (file instanceof SwapFile) {
            ((SwapFile)file).acquire(this);
        }
        this.file = file;
        if (this.tempFile != null) {
            this.tempFile.release(this);
            this.tempFile = null;
        }
        this.stream = null;
    }

    public InputStream setPersistedURL(URL url, boolean spoolContent) throws IOException {
        FileInputStream result = null;
        this.url = url;
        this.spoolContent = spoolContent;
        if (!spoolContent && this.tempFile != null) {
            this.tempFile.release(this);
            this.tempFile = null;
        } else if (spoolContent && this.tempFile == null && this.stream != null) {
            this.spoolContent(this.stream);
            result = new FileInputStream(this.tempFile);
        }
        this.stream = null;
        return result;
    }

    public boolean isPersisted() {
        return this.file != null || this.url != null;
    }

    public long getLength() {
        if (this.file != null) {
            return PrivilegedFileHelper.length((File)this.file);
        }
        if (this.tempFile != null) {
            return PrivilegedFileHelper.length((File)this.tempFile);
        }
        if (this.stream instanceof FileInputStream) {
            try {
                return ((FileInputStream)this.stream).getChannel().size();
            }
            catch (IOException e) {
                return -1L;
            }
        }
        if (this.url != null) {
            try {
                URLConnection connection = this.url.openConnection();
                return connection.getContentLength();
            }
            catch (IOException e) {
                return -1L;
            }
        }
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.file instanceof SwapFile) {
                ((SwapFile)this.file).release(this);
            }
            if (this.tempFile != null) {
                this.tempFile.release(this);
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof StreamPersistedValueData) {
            StreamPersistedValueData streamValue = (StreamPersistedValueData)another;
            if (this.file != null && this.file.equals(streamValue.file)) {
                return true;
            }
            if (this.tempFile != null && this.tempFile.equals(streamValue.tempFile)) {
                return true;
            }
            if (this.stream != null && this.stream == streamValue.stream) {
                return true;
            }
            if (this.url != null && streamValue.url != null && this.url.getFile().equals(streamValue.url.getFile())) {
                return true;
            }
        }
        return false;
    }

    public InputStream getAsStream() throws IOException {
        if (this.url != null) {
            if (this.tempFile != null) {
                return PrivilegedFileHelper.fileInputStream((File)this.tempFile);
            }
            if (this.spoolContent) {
                this.spoolContent();
                return PrivilegedFileHelper.fileInputStream((File)this.tempFile);
            }
            return this.url.openStream();
        }
        return super.getAsStream();
    }

    private void spoolContent() throws IOException, FileNotFoundException {
        this.spoolContent(this.url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolContent(InputStream is) throws IOException, FileNotFoundException {
        SwapFile swapFile = SwapFile.get(this.spoolConfig.tempDirectory, System.currentTimeMillis() + "_" + SEQUENCE.incrementAndGet(), this.spoolConfig.fileCleaner);
        try {
            FileOutputStream os = PrivilegedFileHelper.fileOutputStream((File)swapFile);
            try {
                int length;
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) != -1) {
                    ((OutputStream)os).write(bytes, 0, length);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((OutputStream)os).close();
                throw throwable;
            }
            ((OutputStream)os).close();
            Object var9_9 = null;
            swapFile.spoolDone();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            swapFile.spoolDone();
            is.close();
            throw throwable;
        }
        is.close();
        this.tempFile = swapFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAsByteArray() throws IllegalStateException, IOException {
        if (this.url != null) {
            byte[] byArray;
            if (this.tempFile != null) {
                return this.fileToByteArray(this.tempFile);
            }
            if (this.spoolContent) {
                this.spoolContent();
                return this.fileToByteArray(this.tempFile);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = this.url.openStream();
            try {
                int length;
                byte[] bytes = new byte[1024];
                while ((length = is.read(bytes)) != -1) {
                    baos.write(bytes, 0, length);
                }
                byArray = baos.toByteArray();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return byArray;
        }
        return super.getAsByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(OutputStream stream, long length, long position) throws IOException {
        if (this.url != null) {
            long l;
            if (this.tempFile != null) {
                return this.readFromFile(stream, this.tempFile, length, position);
            }
            if (this.spoolContent) {
                this.spoolContent();
                return this.readFromFile(stream, this.tempFile, length, position);
            }
            InputStream is = this.url.openStream();
            try {
                is.skip(position);
                byte[] bytes = new byte[(int)length];
                int lg = is.read(bytes);
                if (lg > 0) {
                    stream.write(bytes, 0, lg);
                }
                l = lg;
                Object var12_8 = null;
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                is.close();
                stream.close();
                throw throwable;
            }
            is.close();
            stream.close();
            return l;
        }
        return super.read(stream, length, position);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        int size = in.readInt();
        if (size > 0) {
            byte[] buf = new byte[size];
            in.readFully(buf);
            final String path = new String(buf, "UTF-8");
            File f = new File(path);
            if (PrivilegedFileHelper.exists((File)f)) {
                this.file = f;
            } else if (path.startsWith("vs:/")) {
                this.url = (URL)SecurityHelper.doPrivilegedMalformedURLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                    @Override
                    public URL run() throws Exception {
                        return new URL(null, path, ValueStorageURLStreamHandler.INSTANCE);
                    }
                });
            } else {
                this.file = null;
                this.url = null;
            }
        } else {
            this.file = null;
            this.url = null;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.url == null) {
            super.writeExternal(out);
            return;
        }
        out.writeInt(this.orderNumber);
        byte[] buf = this.url.toString().getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        if (this.url != null) {
            return new StreamPersistedValueData(orderNumber, this.url, this.tempFile, this.spoolConfig);
        }
        return super.createPersistedCopy(orderNumber);
    }

    public URL getUrl() {
        return this.url;
    }
}

