/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionChangesLog
extends PlainChangesLogImpl {
    public SessionChangesLog(ExtendedSession session) {
        super(session);
    }

    public SessionChangesLog(List<ItemState> items, ExtendedSession session) {
        super(items, session);
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            ItemState change = items.get(i);
            this.addItem(change);
        }
    }

    public void eraseEventFire(String identifier) {
        ItemState item = this.getItemState(identifier);
        if (item != null) {
            item.eraseEventFire();
            Map children = (Map)this.lastChildPropertyStates.get(identifier);
            if (children != null) {
                for (ItemState child : children.values()) {
                    child.eraseEventFire();
                }
            }
            if ((children = (Map)this.lastChildNodeStates.get(identifier)) != null) {
                for (ItemState child : children.values()) {
                    this.eraseEventFire(child.getData().getIdentifier());
                }
            }
        }
    }

    public PlainChangesLog pushLog(QPath rootPath) {
        PlainChangesLogImpl cLog = new PlainChangesLogImpl(this.getDescendantsChanges(rootPath), this.session);
        if (rootPath.equals(Constants.ROOT_PATH)) {
            this.clear();
        } else {
            this.remove(rootPath);
        }
        return cLog;
    }
}

