/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;

public class MSSQLSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    private static final String FIND_NODES_AND_PROPERTIES_TEMPLATE = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_SVALUE V WITH (INDEX (JCR_IDX_SVALUE_PROPERTY)), JCR_SITEM P join (select TOP ${TOP} I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_SITEM I WITH (INDEX (JCR_PK_SITEM)) where I.CONTAINER_NAME=? AND I.I_CLASS=1 AND I.ID > ? order by I.ID) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and V.PROPERTY_ID=P.ID order by J.ID";

    public MSSQLSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_PROPERTY_BY_ID = "select len(DATA), I.P_TYPE, V.STORAGE_DESC from JCR_SITEM I, JCR_SVALUE V where I.ID = ? and V.PROPERTY_ID = I.ID";
        this.FIND_WORKSPACE_DATA_SIZE = "select sum(len(DATA)) from JCR_SITEM I, JCR_SVALUE V where I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_NODE_DATA_SIZE = "select sum(len(DATA)) from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.ID=V.PROPERTY_ID";
        this.FIND_VALUE_STORAGE_DESC_AND_SIZE = "select len(DATA), STORAGE_DESC from JCR_SVALUE where PROPERTY_ID=?";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_LAST_ORDER_NUMBER = "exec " + this.JCR_ITEM_NEXT_VAL + " 'LAST_N_ORDER_NUM' , ? , ?";
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_SVALUE V, JCR_SITEM P  join (select TOP ${TOP} J.* from JCR_SITEM J where J.CONTAINER_NAME=? AND J.I_CLASS=1 and J.PARENT_ID=?  AND J.N_ORDER_NUM  >= ? order by J.N_ORDER_NUM, J.ID  ) I on P.PARENT_ID = I.ID where P.I_CLASS=2 and P.CONTAINER_NAME=? and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        }
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties != null) {
            this.findNodesAndProperties.close();
        }
        this.findNodesAndProperties = this.dbConnection.prepareStatement(FIND_NODES_AND_PROPERTIES_TEMPLATE.replace("${TOP}", new Integer(offset + limit).toString()));
        this.findNodesAndProperties.setString(1, this.containerConfig.containerName);
        this.findNodesAndProperties.setString(2, this.getInternalId(lastNodeId));
        this.findNodesAndProperties.setString(3, this.containerConfig.containerName);
        return this.findNodesAndProperties.executeQuery();
    }

    protected boolean needToSkipOffsetNodes() {
        return true;
    }

    protected ResultSet findLastOrderNumber(int localMaxOrderNumber, boolean increment) throws SQLException {
        if (this.findLastOrderNumber == null) {
            this.findLastOrderNumber = this.dbConnection.prepareCall(this.FIND_LAST_ORDER_NUMBER);
        } else {
            this.findLastOrderNumber.clearParameters();
        }
        int value = increment ? 1 : 0;
        this.findLastOrderNumber.setInt(1, localMaxOrderNumber);
        this.findLastOrderNumber.setInt(2, value);
        this.findLastOrderNumber.execute();
        return this.findLastOrderNumber.getResultSet();
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replace("${TOP}", new Integer(offset + limit).toString()));
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, this.containerConfig.containerName);
        this.findNodesByParentIdLazilyCQ.setString(2, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(3, fromOrderNum);
        this.findNodesByParentIdLazilyCQ.setString(4, this.containerConfig.containerName);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    protected String escapeSpecialChars(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbol());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }
}

