/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.statistics;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.jcr.statistics.Statistics;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@ManagedDescription(value="JCR statistics manager")
@NameTemplate(value={@Property(key="view", value="jcr"), @Property(key="service", value="statistic")})
@RESTEndpoint(path="jcrstatistics")
public class JCRStatisticsManager {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JCRStatisticsManager");
    private static final String GLOBAL_STATISTICS_NAME = "global";
    private static volatile boolean STARTED;
    private static Map<String, StatisticsContext> CONTEXTS;
    public static final boolean PERSISTENCE_ENABLED;
    public static final long PERSISTENCE_TIMEOUT;

    private JCRStatisticsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerStatistics(String category, Statistics global, Map<String, Statistics> allStatistics) {
        if (category == null || category.length() == 0) {
            throw new IllegalArgumentException("The category of the statistics cannot be empty");
        }
        if (allStatistics == null || allStatistics.isEmpty()) {
            throw new IllegalArgumentException("The list of statistics " + category + " cannot be empty");
        }
        PrintWriter pw = null;
        if (PERSISTENCE_ENABLED && (pw = JCRStatisticsManager.initWriter(category)) == null) {
            LOG.warn((Object)("Cannot create the print writer for the statistics " + category));
        }
        JCRStatisticsManager.startIfNeeded();
        Class<JCRStatisticsManager> clazz = JCRStatisticsManager.class;
        synchronized (JCRStatisticsManager.class) {
            HashMap<String, StatisticsContext> tmpContexts = new HashMap<String, StatisticsContext>(CONTEXTS);
            StatisticsContext ctx = new StatisticsContext(pw, global, allStatistics);
            tmpContexts.put(category, ctx);
            if (pw != null) {
                JCRStatisticsManager.printHeader(ctx);
            }
            CONTEXTS = Collections.unmodifiableMap(tmpContexts);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static PrintWriter initWriter(String category) {
        PrintWriter pw = null;
        File file = null;
        try {
            file = new File(PrivilegedSystemHelper.getProperty((String)"user.dir"), "Statistics" + category + "-" + System.currentTimeMillis() + ".csv");
            file.createNewFile();
            pw = new PrintWriter(file);
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot create the file for the statistics " + category + " in the user directory, we will try to create it in the temp directory"), (Throwable)e);
            try {
                file = PrivilegedFileHelper.createTempFile((String)("Statistics" + category), (String)("-" + System.currentTimeMillis() + ".csv"));
                pw = new PrintWriter(file);
            }
            catch (IOException e1) {
                LOG.error((Object)("Cannot create the file for the statistics " + category), (Throwable)e1);
            }
        }
        if (file != null) {
            LOG.info((Object)("The file for the statistics " + category + " is " + file.getPath()));
        }
        return pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void startIfNeeded() {
        if (STARTED) return;
        Class<JCRStatisticsManager> clazz = JCRStatisticsManager.class;
        synchronized (JCRStatisticsManager.class) {
            if (STARTED) return;
            JCRStatisticsManager.addTriggers();
            ExoContainer container = ExoContainerContext.getTopContainer();
            ManagementContext ctx = null;
            if (container != null) {
                ctx = container.getManagementContext();
            }
            if (ctx == null) {
                LOG.warn((Object)"Cannot register the statistics");
            } else {
                ctx.register((Object)new JCRStatisticsManager());
            }
            STARTED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void addTriggers() {
        if (!PERSISTENCE_ENABLED) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread("JCRStatisticsManager-Hook"){

            public void run() {
                JCRStatisticsManager.printData();
            }
        });
        Thread t = new Thread("JCRStatisticsManager-Writer"){

            public void run() {
                while (true) {
                    try {
                        2.sleep(PERSISTENCE_TIMEOUT);
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"InterruptedException", (Throwable)e);
                    }
                    JCRStatisticsManager.printData();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private static void printHeader(StatisticsContext context) {
        if (context.writer == null) {
            return;
        }
        boolean first = true;
        if (context.global != null) {
            context.global.printHeader(context.writer);
            first = false;
        }
        for (Statistics s : context.allStatistics.values()) {
            if (first) {
                first = false;
            } else {
                context.writer.print(',');
            }
            s.printHeader(context.writer);
        }
        context.writer.println();
        context.writer.flush();
    }

    private static void printData() {
        Map<String, StatisticsContext> tmpContexts = CONTEXTS;
        for (StatisticsContext context : tmpContexts.values()) {
            JCRStatisticsManager.printData(context);
        }
    }

    private static void printData(StatisticsContext context) {
        if (context.writer == null) {
            return;
        }
        boolean first = true;
        if (context.global != null) {
            context.global.printData(context.writer);
            first = false;
        }
        for (Statistics s : context.allStatistics.values()) {
            if (first) {
                first = false;
            } else {
                context.writer.print(',');
            }
            s.printData(context.writer);
        }
        context.writer.println();
        context.writer.flush();
    }

    private static StatisticsContext getContext(String category) {
        if (category == null) {
            return null;
        }
        return CONTEXTS.get(category);
    }

    static String formatName(String name) {
        return name == null ? null : name.replaceAll(" ", "").replaceAll("[,;]", ", ");
    }

    private static Statistics getStatistics(String category, String name) {
        StatisticsContext context = JCRStatisticsManager.getContext(category);
        if (context == null) {
            return null;
        }
        if ((name = JCRStatisticsManager.formatName(name)) == null) {
            return null;
        }
        Statistics statistics = GLOBAL_STATISTICS_NAME.equalsIgnoreCase(name) ? context.global : (Statistics)context.allStatistics.get(name);
        return statistics;
    }

    @Managed
    @ManagedDescription(value="The minimum value of the time spent for one call.")
    public static long getMin(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        return statistics == null ? 0L : statistics.getMin();
    }

    @Managed
    @ManagedDescription(value="The maximum value of the time spent for one call.")
    public static long getMax(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        return statistics == null ? 0L : statistics.getMax();
    }

    @Managed
    @ManagedDescription(value="The total time spent for all the calls.")
    public static long getTotal(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        return statistics == null ? 0L : statistics.getTotal();
    }

    @Managed
    @ManagedDescription(value="The total amount of calls.")
    public static long getTimes(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        return statistics == null ? 0L : statistics.getTimes();
    }

    @Managed
    @ManagedDescription(value="The average value of the time spent for one call.")
    public static float getAvg(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        return statistics == null ? 0.0f : statistics.getAvg();
    }

    @Managed
    @ManagedDescription(value="Reset the statistics.")
    public static void reset(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category, @ManagedDescription(value="The name of the expected method or global for the global value") @ManagedName(value="statisticsName") String name) {
        Statistics statistics = JCRStatisticsManager.getStatistics(category, name);
        if (statistics != null) {
            statistics.reset();
        }
    }

    @Managed
    @ManagedDescription(value="Reset all the statistics.")
    public static void resetAll(@ManagedDescription(value="The name of the category of the statistics") @ManagedName(value="categoryName") String category) {
        StatisticsContext context = JCRStatisticsManager.getContext(category);
        if (context != null) {
            context.reset();
        }
    }

    static {
        CONTEXTS = Collections.unmodifiableMap(new HashMap());
        PERSISTENCE_ENABLED = Boolean.valueOf(PrivilegedSystemHelper.getProperty((String)"JCRStatisticsManager.persistence.enabled", (String)"true"));
        PERSISTENCE_TIMEOUT = Long.valueOf(PrivilegedSystemHelper.getProperty((String)"JCRStatisticsManager.persistence.timeout", (String)"15000"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StatisticsContext {
        private final PrintWriter writer;
        private final Map<String, Statistics> allStatistics;
        private final Statistics global;

        public StatisticsContext(PrintWriter writer, Statistics global, Map<String, Statistics> allStatistics) {
            this.writer = writer;
            this.global = global;
            this.allStatistics = allStatistics;
        }

        public void reset() {
            if (this.global != null) {
                this.global.reset();
            }
            for (Statistics statistics : this.allStatistics.values()) {
                statistics.reset();
            }
        }
    }
}

