/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ispn;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.TemplateConfigurationHelper;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.util.TypedProperties;

public class Utils {
    private Utils() {
    }

    public static boolean loadJGroupsConfig(ConfigurationManager cfm, GlobalConfiguration config, GlobalConfigurationBuilder configBuilder) throws ExoCacheInitException {
        TypedProperties properties = config.transport().properties();
        if (properties == null || !properties.containsKey("configurationFile")) {
            return false;
        }
        String filename = properties.getProperty("configurationFile");
        InputStream inputStream = TemplateConfigurationHelper.getInputStream((ConfigurationManager)cfm, (String)filename);
        if (inputStream == null) {
            throw new IllegalStateException("The jgroups configuration cannot be loaded from '" + filename + "'");
        }
        try {
            properties.setProperty("configurationXml", org.exoplatform.container.util.Utils.readStream((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new IllegalStateException("The jgroups configuration cannot be read from '" + filename + "'", e);
        }
        properties.remove("configurationFile");
        configBuilder.transport().withProperties((Properties)properties);
        return true;
    }
}

