/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.command.NotificationExecutor;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.notification.impl.command.NotificationCommandImpl;
import org.exoplatform.commons.notification.impl.command.NotificationExecutorImpl;
import org.exoplatform.commons.notification.impl.setting.NotificationPluginContainer;
import org.exoplatform.commons.utils.CommonsUtils;

public final class NotificationContextImpl
implements NotificationContext {
    private static final NotificationContext DEFAULT = new NotificationContextImpl();
    private Map<String, Object> arguments = new ConcurrentHashMap<String, Object>();
    private NotificationInfo notification;
    private List<NotificationInfo> notifications;
    private Exception exception;
    private final NotificationExecutor executor = new NotificationExecutorImpl();
    private final NotificationPluginContainer pluginService = CommonsUtils.getService(NotificationPluginContainer.class);
    private final PluginSettingService settingService = CommonsUtils.getService(PluginSettingService.class);
    private final ChannelManager channelManager = CommonsUtils.getService(ChannelManager.class);
    private boolean writingStatus = false;

    private NotificationContextImpl() {
    }

    public static NotificationContext cloneInstance() {
        return DEFAULT.clone();
    }

    public NotificationExecutor getNotificationExecutor() {
        return this.executor;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginService;
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public PluginSettingService getPluginSettingService() {
        return this.settingService;
    }

    public <T> NotificationContext append(ArgumentLiteral<T> argument, Object value) {
        this.arguments.put(argument.getKey(), value);
        return this;
    }

    public <T> NotificationContext remove(ArgumentLiteral<T> argument) {
        this.arguments.remove(argument);
        return this;
    }

    public void clear() {
        this.arguments.clear();
    }

    public <T> T value(ArgumentLiteral<T> argument) {
        Object value = this.arguments.get(argument.getKey());
        T got = null;
        try {
            if (value != null) {
                got = argument.getType().cast(value);
            } else if (argument.getType().equals(Boolean.class)) {
                got = argument.getType().cast(new Boolean(false));
            }
        }
        catch (Exception e) {
            return null;
        }
        return got;
    }

    public NotificationInfo getNotificationInfo() {
        return this.notification;
    }

    public NotificationContext setNotificationInfo(NotificationInfo notification) {
        this.notification = notification;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public <T> T getException(Class<T> type) {
        if (type == this.exception.getClass()) {
            return type.cast(this.exception);
        }
        return null;
    }

    public void setException(Throwable t) {
        this.exception = t == null ? null : (t instanceof Exception ? (Exception)t : new Exception("Exception occurred during execution", t));
    }

    public boolean isFailed() {
        return this.getException() != null;
    }

    public void setNotificationInfos(List<NotificationInfo> notifications) {
        this.notifications = notifications;
    }

    public List<NotificationInfo> getNotificationInfos() {
        return this.notifications;
    }

    public NotificationCommand makeCommand(PluginKey key) {
        BaseNotificationPlugin plugin = this.pluginService.getPlugin(key);
        return plugin != null ? new NotificationCommandImpl(plugin) : null;
    }

    public NotificationContext clone() {
        return new NotificationContextImpl();
    }

    public boolean isWritingProcess() {
        return this.writingStatus;
    }

    public void setWritingProcess(boolean writingStatus) {
        this.writingStatus = writingStatus;
    }
}

