/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;

public class StringCommonUtils {
    private static final Pattern SCRIPT_TAG_PATTERN = Pattern.compile("(<(/|)?[ ]*(script|iframe|object|embed)>|<(iframe|object|embed)|((background|expression|style)=)|javascript:\\w+|(on\\w+=))", 2);
    private static final int BUFFER_SIZE = 32;
    private static List<String> MATCHED_WORDS = new ArrayList<String>(){
        {
            this.add("on");
            this.add("javascript");
            this.add("background");
            this.add("src");
            this.add("style");
        }
    };

    public static String encodeScriptMarkup(String input) {
        if (input != null) {
            String decodeInput = StringEscapeUtils.unescapeHtml((String)input);
            Matcher matcher = SCRIPT_TAG_PATTERN.matcher(decodeInput);
            StringBuffer str = new StringBuffer(decodeInput.length());
            while (matcher.find()) {
                if (StringCommonUtils.matchedWord(matcher.group())) {
                    matcher.appendReplacement(str, "");
                    continue;
                }
                matcher.appendReplacement(str, HTMLEntityEncoder.getInstance().encodeHTMLAttribute(matcher.group()));
            }
            matcher.appendTail(str);
            input = str.toString();
        }
        return input;
    }

    private static boolean matchedWord(String input) {
        if (input == null || input.length() == 0) {
            return true;
        }
        String lowerStr = input.toLowerCase();
        for (String word : MATCHED_WORDS) {
            if (!lowerStr.contains(word)) continue;
            return true;
        }
        return false;
    }

    public static InputStream compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return new ByteArrayInputStream(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(InputStream is) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(is, 32);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            String string = new String(buffer.toByteArray());
            return string;
        }
        finally {
            gis.close();
            is.close();
            buffer.close();
        }
    }
}

