/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs;

import io.swagger.jaxrs.AbstractAllowableValuesProcessor;
import io.swagger.jaxrs.AllowableRangeValues;

abstract class AbstractRangeProcessor<C>
extends AbstractAllowableValuesProcessor<C, AllowableRangeValues> {
    AbstractRangeProcessor() {
    }

    @Override
    public void process(C container, AllowableRangeValues values) {
        Double maximum;
        Double minimum = values.getMinimum();
        if (minimum != null) {
            this.setMinimum(container, minimum);
        }
        if (values.isExclusiveMinimum()) {
            this.setExclusiveMinimum(container, true);
        }
        if ((maximum = values.getMaximum()) != null) {
            this.setMaximum(container, maximum);
        }
        if (values.isExclusiveMaximum()) {
            this.setExclusiveMaximum(container, true);
        }
    }

    protected abstract void setMinimum(C var1, Double var2);

    protected abstract void setExclusiveMinimum(C var1, Boolean var2);

    protected abstract void setMaximum(C var1, Double var2);

    protected abstract void setExclusiveMaximum(C var1, Boolean var2);
}

