/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.gatein.api.Portal;
import org.gatein.api.PortalRequest;
import org.gatein.api.common.Filter;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.ApiNode;
import org.gatein.api.navigation.FilteredNode;
import org.gatein.api.navigation.NavigationImpl;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.page.Page;
import org.gatein.api.security.Permission;
import org.gatein.api.security.User;

public class ApiFilteredNode
extends ApiNode
implements FilteredNode {
    private final FilteredNodeMap map;

    public ApiFilteredNode(NavigationImpl navigation, NodeContext<ApiNode> context) {
        super(navigation, context);
        this.map = null;
    }

    private ApiFilteredNode(NavigationImpl navigation, NodeContext<ApiNode> context, FilteredNodeMap map) {
        super(navigation, context);
        this.map = map;
    }

    @Override
    public Node addChild(int index, String childName) {
        return this.getFiltered(super.addChild(this.realIndex(index), childName));
    }

    @Override
    public Node addChild(String childName) {
        return this.getFiltered(super.addChild(childName));
    }

    @Override
    public Node getChild(int index) {
        int i = 0;
        Iterator<Node> itr = this.iterator();
        while (itr.hasNext()) {
            if (i == index) {
                return this.getFiltered(itr.next());
            }
            ++i;
            itr.next();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Node getChild(String childName) {
        Node n = super.getChild(childName);
        return this.isAccepted(n) ? this.getFiltered(n) : null;
    }

    @Override
    public int getChildCount() {
        int i = 0;
        Iterator<Node> itr = this.iterator();
        while (itr.hasNext()) {
            ++i;
            itr.next();
        }
        return i;
    }

    @Override
    public Node getNode(NodePath nodePath) {
        ApiFilteredNode n = this;
        for (String e : nodePath) {
            if ((n = n.getChild(e)) != null) continue;
            return null;
        }
        return n;
    }

    @Override
    public Node getParent() {
        return super.getParent() != null ? this.getFiltered(super.getParent()) : null;
    }

    @Override
    public boolean hasChild(String childName) {
        Node n = super.getChild(childName);
        return n != null ? this.isAccepted(n) : false;
    }

    @Override
    public int indexOf(String childName) {
        int i = 0;
        Iterator<Node> itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next().getName().equals(childName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Iterator<Node> iterator() {
        return new FilteredNodeIterator();
    }

    @Override
    public void moveTo(int index) {
        super.moveTo(this.getFiltered(super.getParent()).realIndex(index));
    }

    @Override
    public void moveTo(int index, Node parent) {
        super.moveTo(this.getFiltered(parent).realIndex(index), parent);
    }

    public FilteredNode showAll() {
        return new ApiFilteredNode(this.navigation, (NodeContext<ApiNode>)this.context, new FilteredNodeMap(Collections.EMPTY_LIST));
    }

    public FilteredNode showDefault() {
        return this.showVisible().showHasAccess(PortalRequest.getInstance().getUser());
    }

    public FilteredNode showHasAccess(User user) {
        return this.show(new PermissionFilter(user, true));
    }

    public FilteredNode showHasEdit(User user) {
        return this.show(new PermissionFilter(user, false));
    }

    public FilteredNode showVisible() {
        return this.show(new VisibleFilter());
    }

    public FilteredNode show(Filter<Node> filter) {
        LinkedList<Object> filters = new LinkedList<Object>();
        if (this.map != null) {
            filters.addAll(this.map.filters);
        }
        filters.add(Parameters.requireNonNull(filter, (String)"filter"));
        return new ApiFilteredNode(this.navigation, (NodeContext<ApiNode>)this.context, new FilteredNodeMap(filters));
    }

    private int realIndex(int index) {
        int i = 0;
        int j = 0;
        Iterator<Node> itr = super.iterator();
        while (itr.hasNext() && j <= index) {
            if (this.isAccepted(itr.next())) {
                ++j;
            }
            ++i;
        }
        if (j < index) {
            throw new IndexOutOfBoundsException();
        }
        return j > index ? i - 1 : i;
    }

    private ApiFilteredNode getFiltered(Node node) {
        ApiNode apiNode = (ApiNode)node;
        if (this.map == null) {
            return new ApiFilteredNode(apiNode.navigation, apiNode.context);
        }
        if (this.map.filteredMap.containsKey(apiNode)) {
            return (ApiFilteredNode)this.map.filteredMap.get(apiNode);
        }
        ApiFilteredNode filteredNode = new ApiFilteredNode(apiNode.navigation, apiNode.context, this.map);
        this.map.filteredMap.put(apiNode, filteredNode);
        return filteredNode;
    }

    private boolean isAccepted(Node node) {
        Filter f;
        ApiNode apiNode = (ApiNode)node;
        if (this.map == null) {
            return true;
        }
        if (this.map.acceptedMap.containsKey(apiNode)) {
            return (Boolean)this.map.acceptedMap.get(apiNode);
        }
        Boolean accepted = true;
        Iterator i$ = this.map.filters.iterator();
        while (i$.hasNext() && (accepted = Boolean.valueOf((f = (Filter)i$.next()).accept((Object)node))).booleanValue()) {
        }
        this.map.acceptedMap.put(apiNode, accepted);
        return accepted;
    }

    private static class PermissionFilter
    implements Filter<Node> {
        private User user;
        private boolean access;

        public PermissionFilter(User user, boolean access) {
            this.user = user;
            this.access = access;
        }

        public boolean accept(Node element) {
            Portal portal = PortalRequest.getInstance().getPortal();
            if (element.getPageId() == null) {
                return true;
            }
            Page page = portal.getPage(element.getPageId());
            Permission permission = this.access ? page.getAccessPermission() : page.getEditPermission();
            return portal.hasPermission(this.user, permission);
        }
    }

    private static class VisibleFilter
    implements Filter<Node> {
        private VisibleFilter() {
        }

        public boolean accept(Node element) {
            return element.isVisible();
        }
    }

    private static class FilteredNodeMap
    implements Serializable {
        private transient Map<ApiNode, Boolean> acceptedMap = new WeakHashMap<ApiNode, Boolean>();
        private List<Filter<Node>> filters;
        private transient Map<ApiNode, ApiFilteredNode> filteredMap = new WeakHashMap<ApiNode, ApiFilteredNode>();

        private FilteredNodeMap(List<Filter<Node>> filters) {
            this.filters = filters;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.acceptedMap = new WeakHashMap<ApiNode, Boolean>();
            this.filteredMap = new WeakHashMap<ApiNode, ApiFilteredNode>();
        }
    }

    private class FilteredNodeIterator
    implements Iterator<Node> {
        private Iterator<ApiNode> itr;
        private ApiNode last;
        private ApiNode next;

        private FilteredNodeIterator() {
            this.itr = ApiFilteredNode.this.context.iterator();
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.findNext();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.context.remove();
        }

        private ApiNode findNext() {
            while (this.itr.hasNext()) {
                ApiNode n = this.itr.next();
                if (!ApiFilteredNode.this.isAccepted(n)) continue;
                return ApiFilteredNode.this.getFiltered(n);
            }
            return null;
        }
    }
}

