/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.store.hibernate;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gatein.portal.idm.IdentityStoreSource;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreImpl;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

public class ExoHibernateIdentityStoreImpl
extends HibernateIdentityStoreImpl
implements IdentityStore,
IdentityStoreSource,
Serializable {
    private static Logger log = Logger.getLogger(ExoHibernateIdentityStoreImpl.class.getName());
    public static final String DEFAULT_REALM_NAME = ExoHibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    private boolean isRealmAware = false;

    public ExoHibernateIdentityStoreImpl(String id) {
        super(id);
    }

    private String getRealmName(IdentityStoreInvocationContext ctx) {
        if (this.isRealmAware()) {
            return ctx.getRealmId();
        }
        return DEFAULT_REALM_NAME;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        Session session = this.getHibernateSession(ctx);
        HibernateIdentityObjectCredentialType hibernateType = null;
        try {
            hibernateType = (HibernateIdentityObjectCredentialType)session.createCriteria(HibernateIdentityObjectCredentialType.class).add((Criterion)Restrictions.eq((String)"name", (Object)credentialType.getName())).setCacheable(true).uniqueResult();
        }
        catch (HibernateException e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObjectCredentialType[ " + credentialType.getName() + "] not present in the store.");
        }
        return hibernateType;
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            return (HibernateIdentityObject)io;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        HibernateIdentityObject hibernateObject = null;
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            hibernateObject = (HibernateIdentityObject)hibernateSession.createCriteria(HibernateIdentityObject.class).add((Criterion)Restrictions.eq((String)"name", (Object)io.getName()).ignoreCase()).createAlias("identityType", "type").add((Criterion)Restrictions.eq((String)"type.name", (Object)io.getIdentityType().getName())).createAlias("realm", "rm").add((Criterion)Restrictions.eq((String)"rm.name", (Object)this.getRealmName(ctx))).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Exception occurred: ", e);
            }
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + "] not present in the store.", (Throwable)e);
        }
        return hibernateObject;
    }

    @Override
    public boolean isFirstlyCreatedIn(IdentityStoreInvocationContext ctx, IdentityObject identityObject) throws Exception {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (hibernateObject != null && this.getSupportedFeatures().isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), (IdentityObjectCredentialType)PasswordCredential.TYPE)) {
            HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, (IdentityObjectCredentialType)PasswordCredential.TYPE);
            if (hibernateCredentialType == null) {
                throw new IllegalStateException("Credential type not present in this store: " + PasswordCredential.TYPE.getName());
            }
            HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential((IdentityObjectCredentialType)PasswordCredential.TYPE);
            return hibernateCredential != null;
        }
        return false;
    }
}

