/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.XPathUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.conf.RoleRulesPlugin;
import org.exoplatform.forum.common.jcr.JCRQueryUtils;
import org.exoplatform.forum.common.jcr.JCRSessionManager;
import org.exoplatform.forum.common.jcr.JCRTask;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.forum.service.BufferAttachment;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.EmailNotifyPlugin;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumAttachment;
import org.exoplatform.forum.service.ForumEventQuery;
import org.exoplatform.forum.service.ForumLinkData;
import org.exoplatform.forum.service.ForumNodeTypes;
import org.exoplatform.forum.service.ForumPageList;
import org.exoplatform.forum.service.ForumPrivateMessage;
import org.exoplatform.forum.service.ForumSearchResult;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.ForumStatistic;
import org.exoplatform.forum.service.ForumSubscription;
import org.exoplatform.forum.service.InitializeForumPlugin;
import org.exoplatform.forum.service.JCRPageList;
import org.exoplatform.forum.service.LazyPageList;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.PruneSetting;
import org.exoplatform.forum.service.SendMessageInfo;
import org.exoplatform.forum.service.SortSettings;
import org.exoplatform.forum.service.Tag;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.TopicListAccess;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.Watch;
import org.exoplatform.forum.service.cache.CachedDataStorage;
import org.exoplatform.forum.service.conf.CategoryData;
import org.exoplatform.forum.service.conf.ForumData;
import org.exoplatform.forum.service.conf.ForumInitialDataPlugin;
import org.exoplatform.forum.service.conf.PostData;
import org.exoplatform.forum.service.conf.TopicData;
import org.exoplatform.forum.service.conf.UpdateUserProfileJob;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.forum.service.impl.model.TopicFilter;
import org.exoplatform.forum.service.impl.model.UserProfileFilter;
import org.exoplatform.forum.service.jcr.listener.CalculateModeratorEventListener;
import org.exoplatform.forum.service.jcr.listener.DeletedUserCalculateEventListener;
import org.exoplatform.forum.service.jcr.listener.StatisticEventListener;
import org.exoplatform.forum.service.search.UnifiedSearchOrder;
import org.exoplatform.forum.service.task.AbstractForumTask;
import org.exoplatform.forum.service.task.QueryLastPostTaskManager;
import org.exoplatform.forum.service.task.SendNotificationTaskManager;
import org.exoplatform.forum.service.user.AutoPruneJob;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.quartz.JobDataMap;
import org.w3c.dom.Document;

@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="storage")})
@ManagedDescription(value="Data Storage for this forum")
public class JCRDataStorage
implements DataStorage,
ForumNodeTypes {
    private static final Log LOG = ExoLogger.getLogger(JCRDataStorage.class);
    private Map<String, String> serverConfig = new HashMap<String, String>();
    private Map<String, Object> infoMap = new HashMap<String, Object>();
    final Queue<SendMessageInfo> pendingMessagesQueue = new ConcurrentLinkedQueue<SendMessageInfo>();
    private List<RoleRulesPlugin> rulesPlugins = new ArrayList<RoleRulesPlugin>();
    private List<InitializeForumPlugin> defaultPlugins = new ArrayList<InitializeForumPlugin>();
    private List<ForumInitialDataPlugin> dataPlugins = new ArrayList<ForumInitialDataPlugin>();
    private Map<String, Integer> updatingView = new ConcurrentHashMap<String, Integer>();
    private Map<String, List<String>> updatingRead = new ConcurrentHashMap<String, List<String>>();
    private SessionManager sessionManager;
    private KSDataLocation dataLocator;
    private String repository;
    private String workspace;
    private static final Pattern HIGHLIHT_PATTERN = Pattern.compile("(.*)<strong>(.*)</strong>(.*)");
    private final ReentrantLock lock = new ReentrantLock();
    private DataStorage cachedStorage;
    private SendNotificationTaskManager sendNotificationManager;
    private QueryLastPostTaskManager queryLastPostManager;

    public JCRDataStorage() {
    }

    public JCRDataStorage(KSDataLocation dataLocator) {
        this.setDataLocator(dataLocator);
    }

    public DataStorage getCachedDataStorage() {
        if (this.cachedStorage == null) {
            this.cachedStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
        }
        return this.cachedStorage;
    }

    public SendNotificationTaskManager getSendNotificationTaskManager() {
        if (this.sendNotificationManager == null) {
            this.sendNotificationManager = (SendNotificationTaskManager)CommonsUtils.getService(SendNotificationTaskManager.class);
        }
        return this.sendNotificationManager;
    }

    public QueryLastPostTaskManager getQueryLastPostTaskManager() {
        if (this.queryLastPostManager == null) {
            this.queryLastPostManager = (QueryLastPostTaskManager)CommonsUtils.getService(QueryLastPostTaskManager.class);
        }
        return this.queryLastPostManager;
    }

    private void addQueryLastPostTask(String forumPath) {
        QueryLastPostTaskManager queryLastPostManager = this.getQueryLastPostTaskManager();
        if (queryLastPostManager != null) {
            queryLastPostManager.addTask(new AbstractForumTask.QueryLastPostTask(forumPath));
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="repository for forum storage")
    public String getRepository() {
        return this.repository;
    }

    @Override
    @Managed
    @ManagedDescription(value="workspace for the forum storage")
    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    @Managed
    @ManagedDescription(value="data path for forum storage")
    public String getPath() {
        return this.dataLocator.getForumHomeLocation();
    }

    protected Node getForumHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumHomeLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getForumSystemHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumSystemLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getBanIPHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getBanIPLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    protected Node getStatisticHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getStatisticsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getForumStatisticsNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumStatisticsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getAdminHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getAdministrationLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    protected Node getUserProfileHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getUserProfilesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    protected Node getUserProfileNode(SessionProvider sProvider, String userId) throws Exception {
        StringBuffer path = new StringBuffer(this.dataLocator.getUserProfilesLocation()).append("/").append(userId);
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path.toString());
    }

    private Node getUserProfileHome() throws Exception {
        return this.getNodeAt(this.dataLocator.getUserProfilesLocation());
    }

    private Node getCategoryHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumCategoriesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getTagHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getTagsLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getKSUserAvatarHomeNode() throws Exception {
        return this.getNodeAt(this.dataLocator.getAvatarsLocation());
    }

    private Node getForumBanNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumBanIPLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getBBCodesHome(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getBBCodesLocation();
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private Node getNodeAt(String relPath) throws Exception {
        return this.sessionManager.getCurrentSession().getRootNode().getNode(relPath);
    }

    private Node getNodeAt(SessionProvider sProvider, String relPath) throws Exception {
        if (relPath.indexOf("/") == 0) {
            relPath = relPath.substring(1);
        } else if (relPath.indexOf(Utils.CATEGORY) == 0) {
            relPath = this.dataLocator.getForumCategoriesLocation() + "/" + relPath;
        }
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(relPath);
    }

    @Override
    public void addPlugin(ComponentPlugin plugin) throws Exception {
        try {
            if (plugin instanceof EmailNotifyPlugin) {
                this.serverConfig = ((EmailNotifyPlugin)plugin).getServerConfiguration();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add plugin", (Throwable)e);
        }
    }

    @Override
    public void addRolePlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof RoleRulesPlugin) {
            this.rulesPlugins.add((RoleRulesPlugin)plugin);
        }
    }

    @Override
    public void addInitialDefaultDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof InitializeForumPlugin) {
            this.defaultPlugins.add((InitializeForumPlugin)plugin);
        }
    }

    @Override
    public void addInitialDataPlugin(ComponentPlugin plugin) throws Exception {
        if (plugin instanceof ForumInitialDataPlugin) {
            this.dataPlugins.add((ForumInitialDataPlugin)plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeletedUserCalculateListener() {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node profileHome = this.getUserProfileHome(sProvider);
            if (profileHome.hasNode(Utils.USER_PROFILE_DELETED)) {
                this.deletedUserCalculateListener(profileHome.getNode(Utils.USER_PROFILE_DELETED));
            }
        }
    }

    protected void deletedUserCalculateListener(Node node) throws Exception {
        try {
            ObservationManager observation = node.getSession().getWorkspace().getObservationManager();
            DeletedUserCalculateEventListener deleteUserListener = new DeletedUserCalculateEventListener();
            observation.addEventListener((EventListener)deleteUserListener, 3, node.getPath(), false, null, new String[]{Utils.USER_PROFILES_TYPE, "exo:userDeleted"}, false);
        }
        catch (Exception e) {
            LOG.error((Object)("Can not add listener for node " + node.getName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initCategoryListener() {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            ObservationManager observation = this.sessionManager.getSession(sProvider).getWorkspace().getObservationManager();
            CalculateModeratorEventListener moderatorListener = new CalculateModeratorEventListener();
            observation.addEventListener((EventListener)moderatorListener, 19, "/", true, null, new String[]{"exo:categoryHome", "exo:forumCategory", "exo:forum"}, false);
            StatisticEventListener sListener = new StatisticEventListener();
            observation.addEventListener((EventListener)sListener, 3, "/", true, null, new String[]{"exo:forum", "exo:topic"}, false);
        }
    }

    private NodeIterator getNodeIteratorAutoPruneSetting(SessionProvider sProvider, boolean isActive) throws Exception {
        StringBuilder pathQuery = new StringBuilder("SELECT * FROM ").append("exo:pruneSetting");
        if (isActive) {
            pathQuery.append(" WHERE ").append("exo:isActive").append("='true'");
        } else {
            pathQuery.append(" ORDER BY ").append("exo:id").append(" ASC");
        }
        return this.getNodeIteratorBySQLQuery(sProvider, pathQuery.toString(), 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initAutoPruneSchedules() {
        RepositoryService repositoryService = this.getDataLocation().getRepositoryService();
        List entries = repositoryService.getConfig().getRepositoryConfigurations();
        String currentRepo = null;
        try {
            currentRepo = repositoryService.getCurrentRepository().getConfiguration().getName();
            for (RepositoryEntry repositoryEntry : entries) {
                repositoryService.setCurrentRepositoryName(repositoryEntry.getName());
                try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
                    NodeIterator iter = this.getNodeIteratorAutoPruneSetting(sProvider, true);
                    while (iter.hasNext()) {
                        this.addOrRemoveSchedule(this.getPruneSetting(iter.nextNode()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Repository is error!", (Throwable)e);
        }
        if (currentRepo != null) {
            try {
                repositoryService.setCurrentRepositoryName(currentRepo);
            }
            catch (RepositoryConfigurationException e) {
                LOG.error((Object)"Could not reset current repository's name", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isAdminRole(String userName) throws Exception {
        return this.isAdminRole(CommonUtils.createSystemProvider(), userName);
    }

    private boolean isAdminRole(SessionProvider sProvider, String userName) throws Exception {
        if (Utils.isEmpty(userName) || "user_gest_uoom".equals(userName)) {
            return false;
        }
        if (this.isAdminRoleConfig(userName)) {
            return true;
        }
        Node userHome = this.getUserProfileHome(sProvider);
        if (userHome.hasNode(userName)) {
            return new PropertyReader(userHome.getNode(userName)).l("exo:userRole", 2L) == 0L;
        }
        return false;
    }

    @Override
    public boolean isAdminRoleConfig(String userName) throws Exception {
        if (Utils.isEmpty(userName)) {
            return false;
        }
        for (int i = 0; i < this.rulesPlugins.size(); ++i) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(this.rulesPlugins.get(i).getRules(Utils.ADMIN_ROLE));
            if (list.contains(userName)) {
                return true;
            }
            String[] adminrules = Utils.getStringsInList(list);
            if (!ForumServiceUtils.isModerator(adminrules, userName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultAvatar(String userName) {
        Boolean wasReset = (Boolean)this.sessionManager.executeAndSave((JCRTask)new ResetAvatarTask(userName));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Avatar for user " + userName + " was " + (wasReset != false ? "" : "not") + " reset"));
        }
    }

    @Override
    public ForumAttachment getUserAvatar(String userName) throws Exception {
        ForumAttachment avatar = (ForumAttachment)this.sessionManager.execute((JCRTask)new LoadAvatarTask(userName));
        return avatar;
    }

    @Override
    public void saveUserAvatar(String userId, ForumAttachment fileAttachment) throws Exception {
        Boolean wasNew = (Boolean)this.sessionManager.executeAndSave((JCRTask)new SaveAvatarTask(userId, fileAttachment));
        if (LOG.isDebugEnabled()) {
            LOG.error((Object)("avatar was " + (wasNew != false ? "added" : "updated") + " for user " + userId + ": " + fileAttachment));
        }
    }

    @Override
    public void saveForumAdministration(ForumAdministration forumAdministration) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumAdminNode;
            Node administrationHome = this.getAdminHome(sProvider);
            try {
                forumAdminNode = administrationHome.getNode(Utils.FORUMADMINISTRATION);
            }
            catch (PathNotFoundException e) {
                forumAdminNode = administrationHome.addNode(Utils.FORUMADMINISTRATION, "exo:administration");
            }
            forumAdminNode.setProperty("exo:forumSortBy", forumAdministration.getForumSortBy());
            forumAdminNode.setProperty("exo:forumSortByType", forumAdministration.getForumSortByType());
            forumAdminNode.setProperty("exo:topicSortBy", forumAdministration.getTopicSortBy());
            forumAdminNode.setProperty("exo:topicSortByType", forumAdministration.getTopicSortByType());
            forumAdminNode.setProperty("exo:censoredKeyword", forumAdministration.getCensoredKeyword());
            forumAdminNode.setProperty("exo:enableHeaderSubject", forumAdministration.getEnableHeaderSubject());
            forumAdminNode.setProperty("exo:headerSubject", forumAdministration.getHeaderSubject());
            forumAdminNode.setProperty("exo:notifyEmailContent", forumAdministration.getNotifyEmailContent());
            forumAdminNode.setProperty("exo:notifyEmailMoved", forumAdministration.getNotifyEmailMoved());
            if (forumAdminNode.isNew()) {
                forumAdminNode.getSession().save();
            } else {
                forumAdminNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save forum administration.", (Throwable)e);
        }
    }

    @Override
    public ForumAdministration getForumAdministration() throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ForumAdministration forumAdministration = new ForumAdministration();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            forumAdministration.setForumSortBy(reader.string("exo:forumSortBy"));
            forumAdministration.setForumSortByType(reader.string("exo:forumSortByType"));
            forumAdministration.setTopicSortBy(reader.string("exo:topicSortBy"));
            forumAdministration.setTopicSortByType(reader.string("exo:topicSortByType"));
            forumAdministration.setCensoredKeyword(reader.string("exo:censoredKeyword"));
            forumAdministration.setEnableHeaderSubject(reader.bool("exo:enableHeaderSubject"));
            forumAdministration.setHeaderSubject(reader.string("exo:headerSubject"));
            forumAdministration.setNotifyEmailContent(reader.string("exo:notifyEmailContent"));
            forumAdministration.setNotifyEmailMoved(reader.string("exo:notifyEmailMoved"));
            return forumAdministration;
        }
        catch (PathNotFoundException e) {
            return forumAdministration;
        }
    }

    @Override
    public SortSettings getForumSortSettings() {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node adminHome = this.getAdminHome(sProvider);
            if (adminHome.hasNode(Utils.FORUMADMINISTRATION)) {
                Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
                PropertyReader reader = new PropertyReader(forumAdminNode);
                return new SortSettings(reader.string("exo:forumSortBy", SortSettings.SortField.ORDER.toString()), reader.string("exo:forumSortByType", SortSettings.Direction.ASC.toString()));
            }
            Node forumAdminNode = this.getAdminHome(sProvider).addNode(Utils.FORUMADMINISTRATION, "exo:administration");
            forumAdminNode.setProperty("exo:forumSortBy", SortSettings.SortField.ORDER.toString());
            forumAdminNode.setProperty("exo:forumSortByType", SortSettings.Direction.ASC.toString());
            forumAdminNode.getSession().save();
            return new SortSettings(SortSettings.SortField.ORDER, SortSettings.Direction.ASC);
        }
        catch (Exception e) {
            return new SortSettings(SortSettings.SortField.ORDER, SortSettings.Direction.ASC);
        }
    }

    @Override
    public SortSettings getTopicSortSettings() throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            return new SortSettings(reader.string("exo:topicSortBy", SortSettings.SortField.LASTPOST.toString()), reader.string("exo:topicSortByType", SortSettings.Direction.DESC.toString()));
        }
        catch (Exception e) {
            Node forumAdminNode = this.getAdminHome(sProvider).addNode(Utils.FORUMADMINISTRATION, "exo:administration");
            forumAdminNode.getSession().save();
            return new SortSettings(SortSettings.SortField.LASTPOST, SortSettings.Direction.DESC);
        }
    }

    @Override
    public void initDataPlugin() throws Exception {
        for (ForumInitialDataPlugin pln : this.dataPlugins) {
            List<ByteArrayInputStream> arrayInputStreams = pln.importData();
            if (arrayInputStreams == null) continue;
            for (ByteArrayInputStream bis : arrayInputStreams) {
                this.importXML(this.dataLocator.getForumHomeLocation(), bis, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDefaultData() throws Exception {
        HashSet<String> set = new HashSet<String>();
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node categoryHome = this.getCategoryHome(sProvider);
            if (categoryHome.hasNodes()) {
                return;
            }
            String ct = "";
            for (InitializeForumPlugin pln : this.defaultPlugins) {
                List<CategoryData> categories = pln.getForumInitialData().getCategories();
                for (CategoryData categoryData : categories) {
                    Category category = new Category();
                    category.setCategoryName(categoryData.getName());
                    category.setDescription(categoryData.getDescription());
                    category.setOwner(categoryData.getOwner());
                    this.saveCategory(category, true);
                    List<ForumData> forums = categoryData.getForums();
                    for (ForumData forumData : forums) {
                        Forum forum = new Forum();
                        forum.setForumName(forumData.getName());
                        forum.setDescription(forumData.getDescription());
                        forum.setOwner(forumData.getOwner());
                        this.saveForum(category.getId(), forum, true);
                        List<TopicData> topics = forumData.getTopics();
                        for (TopicData topicData : topics) {
                            Topic topic = new Topic();
                            topic.setTopicName(topicData.getName());
                            ct = topicData.getContent();
                            ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                            ct = Utils.removeCharterStrange(ct);
                            topic.setDescription(ct);
                            topic.setOwner(topicData.getOwner());
                            topic.setIcon(topicData.getIcon());
                            this.saveTopic(category.getId(), forum.getId(), topic, true, false, new MessageBuilder());
                            set.add(topic.getOwner());
                            List<PostData> posts = topicData.getPosts();
                            for (PostData postData : posts) {
                                Post post = new Post();
                                post.setName(postData.getName());
                                ct = postData.getContent();
                                ct = StringUtils.replace((String)ct, (String)"\\n", (String)"<br/>");
                                ct = Utils.removeCharterStrange(ct);
                                post.setMessage(ct);
                                post.setOwner(postData.getOwner());
                                post.setIcon(postData.getIcon());
                                MessageBuilder messageBuilder = new MessageBuilder();
                                messageBuilder.setLink("link");
                                this.savePost(category.getId(), forum.getId(), topic.getId(), post, true, messageBuilder);
                                set.add(post.getOwner());
                            }
                        }
                    }
                }
            }
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            PropertyReader reader = new PropertyReader(forumStatisticNode);
            forumStatisticNode.setProperty("exo:membersCount", reader.l("exo:membersCount") + (long)set.size());
            forumStatisticNode.save();
        }
    }

    @Override
    public List<Category> getCategories() {
        return this.getCategories("");
    }

    private NodeIterator getCategories(SessionProvider sProvider, String strQuery) throws Exception {
        String categoryHomePath = "/" + this.dataLocator.getForumCategoriesLocation();
        StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:forumCategory", categoryHomePath);
        if (!Utils.isEmpty(strQuery)) {
            sqlQuery.append(" AND ").append(strQuery);
        }
        sqlQuery.append(" ORDER BY ").append("exo:categoryOrder").append(" ASC").append(", ").append("exo:createdDate").append(" ASC");
        return this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), 0, 0, false);
    }

    private List<Category> getCategories(String strQuery) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<Category> categories = new ArrayList<Category>();
        try {
            NodeIterator iter = this.getCategories(sProvider, strQuery);
            while (iter.hasNext()) {
                Node cateNode = iter.nextNode();
                try {
                    categories.add(this.getCategory(cateNode));
                }
                catch (RepositoryException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Failed to achieve category" + cateNode.getName()), (Throwable)e);
                }
            }
            return categories;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Can not get all categories.", (Throwable)e);
            }
            return categories;
        }
    }

    @Override
    public Category getCategory(String categoryId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            return this.getCategory(this.getCategoryHome(sProvider).getNode(categoryId));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to get category, categoryId: " + categoryId), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Category getCategoryIncludedSpace() {
        Category category = this.getCategory(Utils.CATEGORY_SPACE_ID_PREFIX);
        if (category == null) {
            List<Category> categories = this.getCategories(new StringBuffer("exo:includedSpace").append("='true'").toString());
            category = categories.size() >= 1 ? categories.get(0) : null;
        }
        return category;
    }

    @Override
    public String[] getPermissionTopicByCategory(String categoryId, String type) throws Exception {
        String[] canCreated = new String[]{" "};
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node cateNode = this.getCategoryHome(sProvider).getNode(categoryId);
            canCreated = new PropertyReader(cateNode).strings(type, new String[]{""});
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get permission topic by category", (Throwable)e);
        }
        return canCreated;
    }

    private Category getCategory(Node cateNode) throws RepositoryException {
        Category cat = new Category(cateNode.getName());
        cat.setPath(cateNode.getPath());
        PropertyReader reader = new PropertyReader(cateNode);
        cat.setOwner(reader.string("exo:owner"));
        cat.setCategoryName(reader.string("exo:name"));
        cat.setCategoryOrder(reader.l("exo:categoryOrder"));
        cat.setCreatedDate(reader.date("exo:createdDate"));
        cat.setDescription(reader.string("exo:description"));
        cat.setModifiedBy(reader.string("exo:modifiedBy"));
        cat.setModifiedDate(reader.date("exo:modifiedDate"));
        cat.setUserPrivate(reader.strings("exo:userPrivate"));
        cat.setModerators(reader.strings("exo:moderators"));
        cat.setForumCount(reader.l("exo:forumCount"));
        if (cateNode.isNodeType("exo:forumWatching")) {
            cat.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        cat.setViewer(reader.strings("exo:viewer"));
        cat.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        cat.setPoster(reader.strings("exo:poster"));
        cat.setIncludedSpace(reader.bool("exo:includedSpace"));
        if (!cateNode.hasProperty("exo:includedSpace")) {
            try {
                if (cateNode.canAddMixin("mix:forumCategory")) {
                    cateNode.addMixin("mix:forumCategory");
                }
                cateNode.setProperty("exo:includedSpace", false);
                cateNode.save();
            }
            catch (Exception e) {
                LOG.debug((Object)String.format("The category %s has not property exo:includedSpace. Please, excute the forum upgrade plugin.", cateNode.getName()));
            }
        }
        return cat;
    }

    @Override
    public void saveCategory(Category category, boolean isNew) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node catNode = null;
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Session session = categoryHome.getSession();
            if (isNew) {
                catNode = categoryHome.addNode(category.getId(), "exo:forumCategory");
                catNode.setProperty("exo:id", category.getId());
                catNode.setProperty("exo:owner", category.getOwner());
                catNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                boolean isIncludedSpace = category.isIncludedSpace() || category.getId().equals(Utils.CATEGORY_SPACE_ID_PREFIX);
                try {
                    catNode.setProperty("exo:includedSpace", isIncludedSpace);
                }
                catch (Exception e) {
                    catNode.addMixin("mix:forumCategory");
                    catNode.setProperty("exo:includedSpace", isIncludedSpace);
                }
                session.save();
            } else {
                catNode = categoryHome.getNode(category.getId());
                String[] oldcategoryMod = new PropertyReader(catNode).strings("exo:moderators", new String[]{""});
                catNode.setProperty("exo:tempModerators", oldcategoryMod);
            }
            catNode.setProperty("exo:name", category.getCategoryName());
            catNode.setProperty("exo:categoryOrder", category.getCategoryOrder());
            catNode.setProperty("exo:description", category.getDescription());
            catNode.setProperty("exo:modifiedBy", category.getModifiedBy());
            catNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            catNode.setProperty("exo:userPrivate", JCRDataStorage.convertArray(category.getUserPrivate()));
            catNode.setProperty("exo:createTopicRole", JCRDataStorage.convertArray(category.getCreateTopicRole()));
            catNode.setProperty("exo:poster", JCRDataStorage.convertArray(category.getPoster()));
            catNode.setProperty("exo:viewer", JCRDataStorage.convertArray(category.getViewer()));
            category.setPath(catNode.getPath());
            session.save();
            try {
                if (isNew && category.getModerators().length > 0 || !isNew) {
                    catNode.setProperty("exo:moderators", category.getModerators());
                    session.save();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Failed to save category moderators ", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save category", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void saveUserPrivateOfCategory(String categoryId, String priInfo) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node cateHome = this.getCategoryHome(sProvider);
            Node cateNode = cateHome.getNode(categoryId);
            HashSet<String> privates = new HashSet<String>(new PropertyReader(cateNode).list("exo:userPrivate", new ArrayList()));
            privates.add(priInfo);
            cateNode.setProperty("exo:userPrivate", privates.toArray(new String[privates.size()]));
            cateHome.getSession().save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save user private of category", (Throwable)e);
        }
    }

    @Override
    public void saveModOfCategory(List<String> moderatorCate, String userId, boolean isAdd) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node cateHome = this.getCategoryHome(sProvider);
            Node cateNode = null;
            for (String cateId : moderatorCate) {
                boolean isAddNew = true;
                try {
                    cateNode = cateHome.getNode(cateId);
                    List<String> listTemp = Utils.valuesToList(cateNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    list.addAll(listTemp);
                    if (isAdd) {
                        if (list.isEmpty() || list.size() == 1 && Utils.isEmpty((String)list.get(0))) {
                            list = new ArrayList();
                            list.add(userId);
                        } else if (!list.contains(userId)) {
                            list.add(userId);
                        } else {
                            isAddNew = false;
                        }
                        if (!isAddNew) continue;
                        cateNode.setProperty("exo:tempModerators", Utils.getStringsInList(listTemp));
                        cateNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                        continue;
                    }
                    if (list.isEmpty() || !list.contains(userId)) continue;
                    list.remove(userId);
                    if (list.isEmpty()) {
                        list.add("");
                    }
                    cateNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                    cateNode.setProperty("exo:tempModerators", Utils.getStringsInList(listTemp));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Failed to save moderater of categoryId: " + cateId), (Throwable)e);
                }
            }
            cateHome.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save moderator of category", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateModerator(String nodePath, boolean isNew) throws Exception {
        block12: {
            try {
                JCRSessionManager manager = new JCRSessionManager(this.workspace);
                Session session = manager.createSession();
                try {
                    Node node = (Node)session.getItem(nodePath);
                    if (!node.isNodeType("exo:forum") && !node.isNodeType("exo:forumCategory")) {
                        return;
                    }
                    PropertyReader reader = new PropertyReader(node);
                    String[] modTemp = reader.strings("exo:tempModerators", new String[0]);
                    if (node.isNodeType("exo:forumCategory")) {
                        Category category = new Category(node.getName());
                        category.setCategoryName(reader.string("exo:name"));
                        category.setModerators(reader.strings("exo:moderators", new String[0]));
                        if (isNew || Utils.arraysHaveDifferentContent(modTemp, category.getModerators())) {
                            this.updateModeratorInForums(node, category.getModerators());
                            this.updateUserProfileModInCategory(session, node, modTemp, category, isNew);
                        }
                    } else if (node.isNodeType("exo:forum")) {
                        Forum forum = new Forum();
                        forum.setId(node.getName());
                        forum.setForumName(reader.string("exo:name", ""));
                        forum.setModerators(reader.strings("exo:moderators", new String[0]));
                        if (isNew || Utils.arraysHaveDifferentContent(modTemp, forum.getModerators())) {
                            String categoryId = nodePath.substring(nodePath.indexOf(Utils.CATEGORY), nodePath.lastIndexOf("/"));
                            this.setModeratorForum(session, forum.getModerators(), modTemp, forum, categoryId, isNew);
                        }
                    }
                    node.setProperty("exo:tempModerators", new String[0]);
                    node.save();
                }
                finally {
                    session.logout();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug((Object)"PathNotFoundException  category node or forum node not found");
            }
        }
    }

    private void updateModeratorInForums(Node cateNode, String[] moderatorCat) throws RepositoryException {
        NodeIterator iter = cateNode.getNodes();
        while (iter.hasNext()) {
            ArrayList<String> list = new ArrayList<String>();
            Node node = iter.nextNode();
            if (!node.isNodeType("exo:forum")) continue;
            String[] oldModeratoForums = new PropertyReader(node).strings("exo:moderators", new String[0]);
            list.addAll(Arrays.asList(oldModeratoForums));
            for (int i = 0; i < moderatorCat.length; ++i) {
                if (list.contains(moderatorCat[i])) continue;
                list.add(moderatorCat[i]);
            }
            String[] strModerators = Utils.getStringsInList(list);
            node.setProperty("exo:moderators", strModerators);
            node.setProperty("exo:tempModerators", oldModeratoForums);
        }
        cateNode.save();
    }

    /*
     * WARNING - void declaration
     */
    private void updateUserProfileModInCategory(Session session, Node catNode, String[] oldcategoryMod, Category category, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation());
        String categoryId = category.getId();
        String cateName = category.getCategoryName();
        List<String> moderators = ForumServiceUtils.getUserPermission(category.getModerators());
        if (!moderators.isEmpty()) {
            for (String string : moderators) {
                try {
                    List<Object> moderateCategory;
                    boolean isAdd;
                    block21: {
                        isAdd = true;
                        userProfileNode = userProfileHomeNode.getNode(string);
                        moderateCategory = new ArrayList();
                        try {
                            moderateCategory = Utils.valuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block21;
                            LOG.debug((Object)"Failed to get list of moderated Category", (Throwable)e);
                        }
                    }
                    for (String string2 : moderateCategory) {
                        if (string2.indexOf(categoryId) <= 0) continue;
                        isAdd = false;
                        break;
                    }
                    if (!isAdd) continue;
                    moderateCategory.add(cateName + "(" + categoryId);
                    userProfileNode.setProperty("exo:moderateCategory", Utils.getStringsInList(moderateCategory));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Failed to get user profile ", (Throwable)e);
                }
            }
        }
        if (!isNew && oldcategoryMod != null && oldcategoryMod.length > 0 && !Utils.isEmpty(oldcategoryMod[0]) && Utils.arraysHaveDifferentContent(oldcategoryMod, category.getModerators())) {
            ArrayList<String> olds = new ArrayList<String>(Arrays.asList(oldcategoryMod));
            String[] mods = category.getModerators();
            for (int i = 0; i < mods.length; ++i) {
                if (!olds.contains(mods[i])) continue;
                olds.remove(mods[i]);
            }
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(olds.toArray(new String[olds.size()]));
            for (String oldUserId : oldmoderators) {
                void var16_24;
                block22: {
                    if (moderators.contains(oldUserId)) continue;
                    userProfileNode = userProfileHomeNode.getNode(oldUserId);
                    ArrayList arrayList = new ArrayList();
                    try {
                        List<String> list = Utils.valuesToList(userProfileNode.getProperty("exo:moderateCategory").getValues());
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug((Object)"Failed to get list of moderated Category", (Throwable)e);
                    }
                }
                for (String string : var16_24) {
                    if (string.indexOf(categoryId) <= 0) continue;
                    var16_24.remove(string);
                    userProfileNode.setProperty("exo:moderateCategory", Utils.getStringsInList((List<String>)var16_24));
                    break;
                }
                List<String> list = Utils.valuesToList(userProfileNode.getProperty("exo:moderateForums").getValues());
                NodeIterator iter = catNode.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.isNodeType("exo:forum")) continue;
                    for (String string : list) {
                        if (string.indexOf(node.getName()) < 0) continue;
                        list.remove(string);
                        break;
                    }
                    List<String> forumMode = Utils.valuesToList(node.getProperty("exo:moderators").getValues());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.addAll(forumMode);
                    for (String old : olds) {
                        if (!forumMode.contains(old)) continue;
                        forumMode.remove(old);
                    }
                    node.setProperty("exo:moderators", Utils.getStringsInList(forumMode));
                    node.setProperty("exo:tempModerators", Utils.getStringsInList(arrayList));
                }
                catNode.save();
                if (list.isEmpty() || list.size() == 1 && Utils.isEmpty(list.get(0))) {
                    if (!userProfileNode.hasProperty("exo:userRole") || userProfileNode.hasProperty("exo:userRole") && userProfileNode.getProperty("exo:userRole").getLong() == 1L) {
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                    }
                } else {
                    userProfileNode.setProperty("exo:userRole", 1L);
                    userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                }
                userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
            }
        }
        if (userProfileHomeNode.isNew()) {
            session.save();
        } else {
            userProfileHomeNode.save();
        }
    }

    @Override
    public Category removeCategory(String categoryId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            HashSet<String> users;
            Category category;
            Map<String, Long> userPostMap;
            Node categoryNode;
            Node categoryHome;
            block5: {
                categoryHome = this.getCategoryHome(sProvider);
                categoryNode = categoryHome.getNode(categoryId);
                userPostMap = this.getDeletePostByUser(sProvider, categoryNode);
                category = this.getCategory(categoryNode);
                users = new HashSet<String>();
                try {
                    PropertyReader reader = new PropertyReader(categoryNode);
                    users.addAll(reader.list("exo:moderators", new ArrayList()));
                    categoryNode.setProperty("exo:tempModerators", reader.strings("exo:moderators", new String[]{""}));
                    categoryNode.setProperty("exo:moderators", new String[]{""});
                    NodeIterator iter = categoryNode.getNodes();
                    while (iter.hasNext()) {
                        Node node = iter.nextNode();
                        if (!node.isNodeType("exo:forum")) continue;
                        reader = new PropertyReader(node);
                        users.addAll(reader.list("exo:moderators", new ArrayList()));
                        node.setProperty("exo:tempModerators", reader.strings("exo:moderators", new String[]{""}));
                        node.setProperty("exo:moderators", new String[]{""});
                    }
                    categoryNode.save();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)"Failed to get list of moderators", (Throwable)e);
                }
            }
            categoryNode.remove();
            categoryHome.save();
            this.addUpdateUserProfileJob(userPostMap);
            this.getTotalJobWatting(sProvider, users);
            return category;
        }
        catch (Exception e) {
            LOG.error((Object)("failed to remove category " + categoryId));
            return null;
        }
    }

    @Override
    @Deprecated
    public List<Forum> getForums(String categoryId, String strQuery) throws Exception {
        return this.getForums(new ForumFilter(categoryId, false).strQuery(strQuery));
    }

    @Override
    @Deprecated
    public List<Forum> getForumSummaries(String categoryId, String strQuery) throws Exception {
        return this.getForums(new ForumFilter(categoryId, true).strQuery(strQuery));
    }

    private List<Forum> getForumsPublic(ForumFilter filter) {
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append(Utils.getSQLQueryByProperty("", "exo:isClosed", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isLock", "false"));
        return this.getForums(filter, sqlQuery.toString());
    }

    private List<Forum> getForumsOfCategoryByUser(ForumFilter filter) {
        try {
            boolean isAdmin;
            StringBuilder sqlQuery = new StringBuilder();
            if (Utils.CATEGORY_SPACE_ID_PREFIX.equals(filter.categoryId())) {
                if ("user_gest_uoom".equals(filter.userId())) {
                    return new ArrayList<Forum>();
                }
                String querySpace = Utils.buildSQLQueryForumInSpaceOfUser(filter.userId());
                if (Utils.isEmpty(querySpace)) {
                    return new ArrayList<Forum>();
                }
                sqlQuery.append(querySpace);
            }
            if (!(isAdmin = this.getCachedDataStorage().isAdminRole(filter.userId()))) {
                sqlQuery.append(sqlQuery.length() == 0 ? "(" : " AND (").append(Utils.getSQLQueryByProperty("", "exo:isClosed", "false")).append(" OR (").append(Utils.buildSQLByUserInfo("exo:moderators", UserHelper.getAllGroupAndMembershipOfUser((String)filter.userId()))).append("))");
            }
            return this.getForums(filter, sqlQuery.toString());
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to get forums of category %s by user %s", filter.categoryId(), filter.userId()), (Throwable)e);
            return new ArrayList<Forum>();
        }
    }

    @Override
    public List<Forum> getForums(ForumFilter filter) {
        if (!Utils.isEmpty(filter.userId())) {
            return this.getForumsOfCategoryByUser(filter);
        }
        if (filter.isPublic()) {
            return this.getForumsPublic(filter);
        }
        return this.getForums(filter, filter.strQuery());
    }

    private List<Forum> getForums(ForumFilter filter, String strQuery) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            SortSettings sort = this.getForumSortSettings();
            SortSettings.SortField orderBy = sort.getField();
            SortSettings.Direction orderType = sort.getDirection();
            Node catNode = this.getCategoryHome(sProvider).getNode(filter.categoryId());
            StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:forum", catNode.getPath());
            if (!Utils.isEmpty(strQuery)) {
                sqlQuery.append(" AND ").append(strQuery);
            }
            sqlQuery.append(" ORDER BY exo:").append((Object)orderBy).append(" ").append((Object)orderType);
            if (orderBy != SortSettings.SortField.ORDER) {
                sqlQuery.append(", ").append("exo:forumOrder").append(" ASC");
                if (orderBy != SortSettings.SortField.CREATED) {
                    sqlQuery.append(", ").append("exo:createdDate").append(" ASC");
                }
            } else {
                sqlQuery.append(", ").append("exo:createdDate").append(" ASC");
            }
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), filter.offset(), filter.limit(), true);
            ArrayList<Forum> forums = new ArrayList<Forum>();
            DataStorage storage = this.getCachedDataStorage();
            while (iter.hasNext()) {
                Node forumNode = null;
                try {
                    forumNode = iter.nextNode();
                    forums.add(storage.getForum(filter.categoryId(), forumNode.getName()));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Failed to load forum node " + forumNode.getPath()), (Throwable)e);
                }
            }
            return forums;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to retrieving forums for category " + filter.categoryId()), (Throwable)e);
            }
            return new ArrayList<Forum>();
        }
    }

    private List<String> getCategoriesCanCreateTopics(SessionProvider sProvider, List<String> listOfUser, boolean isIgnoreSpace) throws Exception {
        HashSet<String> canCreateTopicIds = new HashSet<String>();
        StringBuilder cateBuilder = new StringBuilder();
        if (isIgnoreSpace) {
            cateBuilder.append("exo:id").append(" <> '").append(Utils.CATEGORY_SPACE_ID_PREFIX).append("'");
        }
        cateBuilder.append(isIgnoreSpace ? " AND " : "").append(this.getCanCreateTopicQuery(listOfUser, true));
        NodeIterator iter = this.getCategories(sProvider, cateBuilder.toString());
        while (iter.hasNext()) {
            canCreateTopicIds.add(iter.nextNode().getName());
        }
        return new ArrayList<String>(canCreateTopicIds);
    }

    private String getCanCreateTopicQuery(List<String> listOfUser, boolean isForCategory) {
        StringBuilder strQuery = new StringBuilder("( (").append(Utils.buildSQLByUserInfo("exo:createTopicRole", listOfUser)).append(") OR (").append(Utils.buildSQLByUserInfo("exo:moderators", listOfUser)).append(") OR (").append(Utils.buildSQLHasProperty("exo:createTopicRole"));
        strQuery.append(") )");
        if (isForCategory) {
            strQuery.append(" AND (").append(Utils.buildSQLByUserInfo("exo:userPrivate", listOfUser)).append(" OR ").append(Utils.buildSQLHasProperty("exo:userPrivate")).append(")");
        }
        return strQuery.toString();
    }

    @Override
    public List<CategoryFilter> filterForumByName(String forumNameFilter, String userName, int maxSize) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            List listOfUser = UserHelper.getAllGroupAndMembershipOfUser((String)userName);
            ArrayList<String> userListWithoutSpace = new ArrayList<String>();
            for (String group : listOfUser) {
                if (group == null || group.indexOf("spaces") != -1) continue;
                userListWithoutSpace.add(group);
            }
            List<String> categoriesCanCreateTopics = this.getCategoriesCanCreateTopics(sProvider, listOfUser, true);
            StringBuffer strQuery = new StringBuffer("SELECT * FROM ");
            strQuery.append("exo:forum").append(" WHERE ").append("jcr:path").append(" LIKE '").append(categoryHome.getPath()).append("/%' AND ");
            strQuery.append("( UPPER(").append("exo:name").append(") LIKE '").append(forumNameFilter.toUpperCase()).append("%' OR UPPER(").append("exo:name").append(") LIKE '% ").append(forumNameFilter.toUpperCase()).append("%')").append(Utils.getSQLQueryByProperty("AND", "exo:isClosed", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isLock", "false")).append(" AND ").append(this.getCanCreateTopicQuery(userListWithoutSpace, false)).append(" ORDER BY ").append("exo:name");
            LOG.debug((Object)("SQL statement: " + strQuery.toString()));
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(strQuery.toString(), "sql");
            QueryImpl queryImpl = (QueryImpl)query;
            queryImpl.setCaseInsensitiveOrder(true);
            LinkedHashMap<String, CategoryFilter> categoryFilters = new LinkedHashMap<String, CategoryFilter>();
            long gotItemNumber = 0L;
            NodeIterator iter = queryImpl.execute().getNodes();
            while (iter.hasNext()) {
                String forumName;
                CategoryFilter categoryFilter;
                Node node = iter.nextNode();
                String categoryId = node.getParent().getName();
                if (Utils.CATEGORY_SPACE_ID_PREFIX.equalsIgnoreCase(categoryId)) continue;
                String forumId = node.getName();
                if (!categoriesCanCreateTopics.contains(categoryId)) continue;
                if (categoryFilters.containsKey(categoryId)) {
                    categoryFilter = (CategoryFilter)categoryFilters.get(categoryId);
                } else {
                    String categoryName = node.getParent().getProperty("exo:name").getString();
                    categoryFilter = new CategoryFilter(categoryId, categoryName);
                    categoryFilters.put(categoryId, categoryFilter);
                }
                if (!categoryFilter.setForumFilter(forumId, forumName = node.getProperty("exo:name").getString()) || ++gotItemNumber != (long)maxSize) continue;
                break;
            }
            return Collections.unmodifiableList(new ArrayList(categoryFilters.values()));
        }
        catch (Exception e) {
            LOG.warn((Object)("\nCould not filter forum by name: " + forumNameFilter + "::" + e.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\nCould not filter forum by name: " + forumNameFilter + e.getCause()));
            }
            return Collections.emptyList();
        }
    }

    @Override
    public Forum getForum(String categoryId, String forumId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
            return this.getForum(forumNode);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\nCould not get " + forumId + " in " + categoryId + " fail: " + e.getCause()));
            }
            return null;
        }
    }

    @Override
    public void modifyForum(Forum forum, int type) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            String forumPath = forum.getPath();
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            switch (type) {
                case 1: {
                    forumNode.setProperty("exo:isClosed", forum.getIsClosed());
                    this.setActiveTopicByForum(sProvider, forumNode, forum.getIsClosed());
                    break;
                }
                case 2: {
                    forumNode.setProperty("exo:isLock", forum.getIsLock());
                    break;
                }
            }
            forumNode.getSession().save();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Failed to modify forum " + forum.getForumName()), (Throwable)e);
        }
    }

    String[] updateModeratorInForum(Node node, String[] mods) throws Exception {
        PropertyReader reader = new PropertyReader(node);
        Set set = reader.set("exo:moderators");
        if (set == null || set.contains("")) {
            return mods;
        }
        for (String mod : mods) {
            if (mod.isEmpty()) continue;
            set.add(mod);
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public void saveForum(String categoryId, Forum forum, boolean isNew) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node forumNode = null;
        String[] strModerators = forum.getModerators();
        try {
            boolean isNewModerateTopic;
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            boolean isModerateTopic = isNewModerateTopic = forum.getIsModerateTopic();
            String[] oldMod = new String[]{};
            if (isNew) {
                forumNode = catNode.addNode(forum.getId(), "exo:forum");
                forumNode.setProperty("exo:id", forum.getId());
                forumNode.setProperty("exo:owner", forum.getOwner());
                forumNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
                forumNode.setProperty("exo:lastTopicPath", forum.getLastTopicPath());
                forumNode.setProperty("exo:postCount", 0L);
                forumNode.setProperty("exo:topicCount", 0L);
                forumNode.setProperty("exo:banIPs", new String[0]);
                forum.setPath(forumNode.getPath());
                long forumCount = 1L;
                if (catNode.hasProperty("exo:forumCount")) {
                    forumCount = catNode.getProperty("exo:forumCount").getLong() + 1L;
                }
                catNode.setProperty("exo:forumCount", forumCount);
                forumNode.setProperty("exo:moderators", strModerators);
            } else {
                forumNode = catNode.getNode(forum.getId());
                oldMod = Utils.valuesToArray(forumNode.getProperty("exo:moderators").getValues());
                forumNode.setProperty("exo:moderators", strModerators);
                forumNode.setProperty("exo:tempModerators", oldMod);
                if (forumNode.hasProperty("exo:isModerateTopic")) {
                    isModerateTopic = forumNode.getProperty("exo:isModerateTopic").getBoolean();
                }
            }
            forumNode.setProperty("exo:name", forum.getForumName());
            forumNode.setProperty("exo:forumOrder", (long)forum.getForumOrder());
            forumNode.setProperty("exo:modifiedBy", forum.getModifiedBy());
            forumNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            forumNode.setProperty("exo:description", forum.getDescription());
            forumNode.setProperty("exo:isAutoAddEmailNotify", forum.getIsAutoAddEmailNotify());
            forumNode.setProperty("exo:notifyWhenAddPost", forum.getNotifyWhenAddPost());
            forumNode.setProperty("exo:notifyWhenAddTopic", forum.getNotifyWhenAddTopic());
            forumNode.setProperty("exo:isModerateTopic", isNewModerateTopic);
            forumNode.setProperty("exo:isModeratePost", forum.getIsModeratePost());
            forumNode.setProperty("exo:isClosed", forum.getIsClosed());
            forumNode.setProperty("exo:isLock", forum.getIsLock());
            forumNode.setProperty("exo:createTopicRole", JCRDataStorage.convertArray(forum.getCreateTopicRole()));
            forumNode.setProperty("exo:poster", JCRDataStorage.convertArray(forum.getPoster()));
            strModerators = this.updateModeratorInForum(catNode, strModerators);
            boolean isEditMod = isNew;
            if (!isNew && Utils.arraysHaveDifferentContent(oldMod, strModerators)) {
                isEditMod = true;
            }
            if (isEditMod && strModerators != null && strModerators.length > 0 && !Utils.isEmpty(strModerators[0]) && catNode.hasProperty("exo:userPrivate")) {
                ArrayList<String> listPrivate = new ArrayList<String>();
                listPrivate.addAll(Utils.valuesToList(catNode.getProperty("exo:userPrivate").getValues()));
                if (listPrivate.size() > 0 && !Utils.isEmpty((String)listPrivate.get(0))) {
                    for (int i = 0; i < strModerators.length; ++i) {
                        if (listPrivate.contains(strModerators[i])) continue;
                        listPrivate.add(strModerators[i]);
                    }
                    catNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[listPrivate.size()]));
                }
            }
            forumNode.setProperty("exo:viewer", JCRDataStorage.convertArray(forum.getViewer()));
            catNode.getSession().save();
            PropertyReader reader = new PropertyReader(forumNode);
            forum.setPath(forumNode.getPath());
            forum.setTopicCount(reader.l("exo:topicCount"));
            forum.setPostCount(reader.l("exo:postCount"));
            forum.setLastTopicPath(this.getLastTopicPath(reader, forum));
            forum.setModerators(strModerators);
            StringBuilder id = new StringBuilder();
            id.append(catNode.getProperty("exo:categoryOrder").getString());
            id.append(catNode.getProperty("exo:createdDate").getDate().getTimeInMillis());
            id.append(forum.getForumOrder());
            if (isNew) {
                id.append(this.getGreenwichMeanTime());
                PruneSetting pruneSetting = new PruneSetting();
                pruneSetting.setId(id.toString());
                pruneSetting.setForumPath(forum.getPath());
                this.savePruneSetting(pruneSetting);
            } else {
                id.append(forum.getCreatedDate().getTime());
                if (isModerateTopic != isNewModerateTopic) {
                    this.addQueryLastPostTask(forumNode.getPath());
                }
                Node pruneSetting = forumNode.getNode(Utils.PRUNESETTING);
                pruneSetting.setProperty("exo:id", id.toString());
                pruneSetting.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save forum " + forum.getForumName()), (Throwable)e);
        }
    }

    private static String[] convertArray(String[] strs) {
        if (Utils.isEmpty(strs)) {
            return new String[]{""};
        }
        return strs;
    }

    private void setModeratorForum(Session session, String[] strModerators, String[] oldModeratoForums, Forum forum, String categoryId, boolean isNew) throws Exception {
        Node userProfileNode;
        Node userProfileHomeNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation());
        List<String> moderators = ForumServiceUtils.getUserPermission(strModerators);
        if (moderators.size() > 0) {
            for (String string : moderators) {
                string = string.trim();
                ArrayList<String> list = new ArrayList<String>();
                try {
                    userProfileNode = userProfileHomeNode.getNode(string);
                    List moderatorForums = new ArrayList();
                    if (userProfileNode.hasProperty("exo:moderateForums")) {
                        moderatorForums = PropertyReader.valuesToList((Value[])userProfileNode.getProperty("exo:moderateForums").getValues());
                    }
                    boolean hasMod = false;
                    for (String string2 : moderatorForums) {
                        if (string2.indexOf(forum.getId()) > 0) {
                            hasMod = true;
                        }
                        if (Utils.isEmpty(string2)) continue;
                        list.add(string2);
                    }
                    if (userProfileNode.getProperty("exo:userRole").getLong() >= 2L) {
                        userProfileNode.setProperty("exo:userRole", 1L);
                        userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    }
                    if (hasMod) continue;
                    list.add(forum.getForumName() + "(" + categoryId + "/" + forum.getId());
                    userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
                    this.getTotalJobWaitingForModerator(session, string);
                }
                catch (PathNotFoundException e) {
                    userProfileNode = userProfileHomeNode.addNode(string, "exo:forumUserProfile");
                    String[] strings = new String[]{forum.getForumName() + "(" + categoryId + "/" + forum.getId()};
                    userProfileNode.setProperty("exo:moderateForums", strings);
                    userProfileNode.setProperty("exo:userRole", 1L);
                    userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                    if (userProfileNode.isNew()) {
                        userProfileNode.getSession().save();
                    } else {
                        userProfileNode.save();
                    }
                    this.getTotalJobWaitingForModerator(session, string);
                }
            }
        }
        if (!isNew) {
            List<String> oldmoderators = ForumServiceUtils.getUserPermission(oldModeratoForums);
            for (String string : oldmoderators) {
                boolean isDelete = true;
                if (moderators.contains(string)) {
                    isDelete = false;
                }
                if (!isDelete) continue;
                try {
                    String[] moderatorForums;
                    ArrayList<String> list = new ArrayList<String>();
                    userProfileNode = userProfileHomeNode.getNode(string);
                    for (String string2 : moderatorForums = PropertyReader.valuesToArray((Value[])userProfileNode.getProperty("exo:moderateForums").getValues())) {
                        if (string2.indexOf(forum.getId()) >= 0) continue;
                        list.add(string2);
                    }
                    userProfileNode.setProperty("exo:moderateForums", Utils.getStringsInList(list));
                    if (list.isEmpty()) {
                        if (userProfileNode.hasProperty("exo:userRole") && (!userProfileNode.hasProperty("exo:userRole") || userProfileNode.getProperty("exo:userRole").getLong() != 1L)) continue;
                        userProfileNode.setProperty("exo:userRole", 2L);
                        userProfileNode.setProperty("exo:userTitle", Utils.USER);
                        continue;
                    }
                    userProfileNode.setProperty("exo:userRole", 1L);
                    userProfileNode.setProperty("exo:userTitle", Utils.MODERATOR);
                }
                catch (Exception e) {
                    JCRDataStorage.logDebug("Failed to removing forumId storage in property moderator of user: " + string);
                }
            }
        }
        if (userProfileHomeNode.isNew()) {
            userProfileHomeNode.getSession().save();
        } else {
            userProfileHomeNode.save();
        }
    }

    @Override
    public void saveModerateOfForums(List<String> forumPaths, String userName, boolean isDelete) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node categoryHomeNode = this.getCategoryHome(sProvider);
        for (String path : forumPaths) {
            String forumPath = categoryHomeNode.getPath() + "/" + path;
            try {
                Node forumNode = (Node)categoryHomeNode.getSession().getItem(forumPath);
                Node cateNode = forumNode.getParent();
                if (isDelete) {
                    String[] cateMods = PropertyReader.valuesToArray((Value[])cateNode.getProperty("exo:moderators").getValues());
                    if (cateMods != null && cateMods.length > 0 && !Utils.isEmpty(cateMods[0]) && ForumServiceUtils.isModerator(cateMods, userName) || !forumNode.hasProperty("exo:moderators")) continue;
                    String[] oldUserNamesModerate = PropertyReader.valuesToArray((Value[])forumNode.getProperty("exo:moderators").getValues());
                    ArrayList<String> list = new ArrayList<String>();
                    for (String string : oldUserNamesModerate) {
                        if (string.equals(userName)) continue;
                        list.add(string);
                    }
                    forumNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                    forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                    continue;
                }
                String[] oldUserNamesModerate = new String[]{};
                if (forumNode.hasProperty("exo:moderators")) {
                    oldUserNamesModerate = PropertyReader.valuesToArray((Value[])forumNode.getProperty("exo:moderators").getValues());
                }
                List<String> list = new ArrayList<String>();
                for (String string : oldUserNamesModerate) {
                    if (string.equals(userName)) continue;
                    list.add(string);
                }
                list.add(userName);
                forumNode.setProperty("exo:moderators", Utils.getStringsInList(list));
                forumNode.setProperty("exo:tempModerators", oldUserNamesModerate);
                if (!cateNode.hasProperty("exo:userPrivate") || (list = Utils.valuesToList(cateNode.getProperty("exo:userPrivate").getValues())).size() <= 0 || Utils.isEmpty(list.get(0)) || list.contains(userName)) continue;
                String[] strings = new String[list.size() + 1];
                int i = 0;
                Iterator<String> i$ = list.iterator();
                while (i$.hasNext()) {
                    String string;
                    strings[i] = string = i$.next();
                    ++i;
                }
                strings[i] = userName;
                cateNode.setProperty("exo:userPrivate", strings);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to save moderate of forums", (Throwable)e);
            }
        }
        if (categoryHomeNode.isNew()) {
            categoryHomeNode.getSession().save();
        } else {
            categoryHomeNode.save();
        }
    }

    private Forum getForumSummary(Node forumNode) throws Exception {
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setForumName(reader.string("exo:name"));
        forum.setDescription(reader.string("exo:description"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        forum.setLastTopicPath(this.getLastTopicPath(reader, forum));
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        return forum;
    }

    private String getLastTopicPath(PropertyReader reader, Forum forum) {
        String lastTopic = reader.string("exo:lastTopicPath", "");
        if (!Utils.isEmpty(lastTopic)) {
            lastTopic = Utils.getTopicId(lastTopic);
            lastTopic = forum.getPath() + "/" + lastTopic;
        }
        return lastTopic;
    }

    private Forum getForum(Node forumNode) throws Exception {
        if (forumNode == null) {
            return null;
        }
        Forum forum = new Forum();
        PropertyReader reader = new PropertyReader(forumNode);
        forum.setId(forumNode.getName());
        forum.setPath(forumNode.getPath());
        forum.setOwner(reader.string("exo:owner"));
        forum.setForumName(reader.string("exo:name"));
        forum.setForumOrder(Integer.valueOf(reader.string("exo:forumOrder")));
        forum.setCreatedDate(reader.date("exo:createdDate"));
        forum.setModifiedBy(reader.string("exo:modifiedBy"));
        forum.setModifiedDate(reader.date("exo:modifiedDate"));
        forum.setLastTopicPath(this.getLastTopicPath(reader, forum));
        forum.setDescription(reader.string("exo:description"));
        forum.setPostCount(reader.l("exo:postCount"));
        forum.setTopicCount(reader.l("exo:topicCount"));
        forum.setIsModerateTopic(reader.bool("exo:isModerateTopic"));
        forum.setIsModeratePost(reader.bool("exo:isModeratePost"));
        forum.setIsClosed(reader.bool("exo:isClosed"));
        forum.setIsLock(reader.bool("exo:isLock"));
        forum.setIsAutoAddEmailNotify(reader.bool("exo:isAutoAddEmailNotify", false));
        forum.setNotifyWhenAddPost(reader.strings("exo:notifyWhenAddPost"));
        forum.setNotifyWhenAddTopic(reader.strings("exo:notifyWhenAddTopic"));
        forum.setViewer(reader.strings("exo:viewer"));
        forum.setCreateTopicRole(reader.strings("exo:createTopicRole"));
        forum.setPoster(reader.strings("exo:poster"));
        forum.setModerators(reader.strings("exo:moderators"));
        forum.setBanIP(reader.list("exo:banIPs"));
        if (forumNode.isNodeType("exo:forumWatching") && forumNode.hasProperty("exo:emailWatching")) {
            forum.setEmailNotification(reader.strings("exo:emailWatching"));
        }
        return forum;
    }

    @Override
    public Forum removeForum(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Forum forum = null;
        try {
            Node catNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = catNode.getNode(forumId);
            Map<String, Long> userPostMap = this.getDeletePostByUser(sProvider, forumNode);
            forum = this.getForum(forumNode);
            forumNode.setProperty("exo:tempModerators", forum.getModerators());
            forumNode.setProperty("exo:moderators", new String[]{" "});
            forumNode.save();
            forumNode.remove();
            catNode.setProperty("exo:forumCount", catNode.getProperty("exo:forumCount").getLong() - 1L);
            catNode.save();
            this.addUpdateUserProfileJob(userPostMap);
            this.getTotalJobWatting(sProvider, new HashSet<String>(Arrays.asList(forum.getModerators())));
        }
        catch (Exception e) {
            JCRDataStorage.logDebug("Failed to remove forum: " + forumId);
            return null;
        }
        return forum;
    }

    @Override
    public void moveForum(List<Forum> forums, String destCategoryPath) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String oldCatePath = "";
            if (forums.isEmpty()) {
                return;
            }
            String forumPath = forums.get(0).getPath();
            oldCatePath = Utils.getCategoryPath(forumPath);
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            Session session = forumHomeNode.getSession();
            Node oldCatNode = (Node)session.getItem(oldCatePath);
            Node newCatNode = (Node)session.getItem(destCategoryPath);
            PropertyReader reader = new PropertyReader(newCatNode);
            for (Forum forum : forums) {
                Set listPrivate;
                String newForumPath = destCategoryPath + "/" + forum.getId();
                session.getWorkspace().move(forum.getPath(), newForumPath);
                Node forumNode = (Node)session.getItem(newForumPath);
                forumNode.setProperty("exo:path", newForumPath);
                String[] strModerators = forum.getModerators();
                forumNode.setProperty("exo:moderators", strModerators);
                if (CommonUtils.isEmpty((String[])strModerators) || (listPrivate = reader.set("exo:userPrivate", new HashSet())).isEmpty()) continue;
                for (int i = 0; i < strModerators.length; ++i) {
                    listPrivate.add(strModerators[i]);
                }
                newCatNode.setProperty("exo:userPrivate", listPrivate.toArray(new String[listPrivate.size()]));
            }
            long forumCount = forums.size();
            oldCatNode.setProperty("exo:forumCount", new PropertyReader(oldCatNode).l("exo:forumCount") - forumCount);
            newCatNode.setProperty("exo:forumCount", forumCount += reader.l("exo:forumCount"));
            session.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to move forum", (Throwable)e);
        }
    }

    private void setActiveTopicByForum(SessionProvider sProvider, Node forumNode, boolean isClosed) throws Exception {
        NodeIterator iter = forumNode.getNodes();
        Node topicNode = null;
        boolean bl = isClosed = !isClosed;
        while (iter.hasNext()) {
            topicNode = iter.nextNode();
            if (!topicNode.isNodeType("exo:topic")) continue;
            topicNode.setProperty("exo:isActiveByForum", isClosed);
            this.setActivePostByTopic(sProvider, topicNode, isClosed);
        }
        if (forumNode.isNew()) {
            forumNode.getSession().save();
        } else {
            forumNode.save();
        }
    }

    private void setActivePostByTopic(SessionProvider sProvider, Node topicNode, boolean isActiveTopic) throws Exception {
        PropertyReader reader = new PropertyReader(topicNode);
        if (isActiveTopic) {
            isActiveTopic = reader.bool("exo:isApproved");
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = reader.bool("exo:isWaiting") == false;
        }
        if (isActiveTopic) {
            boolean bl = isActiveTopic = reader.bool("exo:isClosed") == false;
        }
        if (isActiveTopic) {
            isActiveTopic = reader.bool("exo:isActive");
        }
        Node postNode = null;
        NodeIterator iter = topicNode.getNodes();
        while (iter.hasNext()) {
            postNode = iter.nextNode();
            if (!postNode.isNodeType("exo:post")) continue;
            postNode.setProperty("exo:isActiveByTopic", isActiveTopic);
        }
        if (topicNode.isNew()) {
            topicNode.getSession().save();
        } else {
            topicNode.save();
        }
    }

    @Override
    public JCRPageList getPageTopic(String categoryId, String forumId, String strQuery, String strOrderBy) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            String pathQuery = Utils.buildTopicQuery(this.getForumSortSettings(), strQuery, strOrderBy, forumPath);
            QueryManager qm = categoryNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return pagelist;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public LazyPageList<Topic> getTopicList(String categoryId, String forumId, String xpathConditions, String strOrderBy, int pageSize) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String str;
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            String forumPath = forumNode.getPath();
            if (xpathConditions != null && xpathConditions.length() > 0 && xpathConditions.contains("topicPermission") && (str = this.buildXpath(sProvider, forumNode)).length() > 0) {
                xpathConditions = StringUtils.replace((String)xpathConditions, (String)"topicPermission", (String)("(" + str + "))"));
            }
            String topicQuery = Utils.buildTopicQuery(this.getForumSortSettings(), xpathConditions, strOrderBy, forumPath);
            TopicListAccess topicListAccess = new TopicListAccess(this.sessionManager, topicQuery);
            return new LazyPageList<Topic>((ListAccess<Topic>)topicListAccess, pageSize);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to retrieve topic list for forum " + forumId), (Throwable)e);
            }
            return null;
        }
    }

    private String buildXpath(SessionProvider sProvider, Node forumNode) throws Exception {
        QueryManager qm = this.getCategoryHome(sProvider).getSession().getWorkspace().getQueryManager();
        StringBuilder qrBuilder = new StringBuilder("/jcr:root");
        qrBuilder.append(forumNode.getPath()).append("/element(*,").append("exo:topic").append(")[@").append("exo:isWaiting").append("='false' and @").append("exo:isActive").append("='true' and @").append("exo:isClosed").append("='false' and (not(@").append("exo:canView").append(") or @").append("exo:canView").append("='' or @").append("exo:canView").append("=' ')]");
        Query query = qm.createQuery(qrBuilder.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        StringBuilder builder = new StringBuilder();
        boolean isOr = false;
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (isOr) {
                builder.append(" and ");
            }
            builder.append("@").append("exo:id").append("!='").append(node.getName()).append("'");
            isOr = true;
        }
        return builder.toString();
    }

    @Override
    public List<Topic> getTopics(TopicFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.buildTopicQuery(filter, true), offset, limit, true);
            ArrayList<Topic> topicList = new ArrayList<Topic>();
            if (iter != null && iter.getSize() > 0L) {
                while (iter.hasNext()) {
                    topicList.add(this.getTopicNode(iter.nextNode()));
                }
            }
            return topicList;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed to retrieve topic list for forum " + filter.forumId()), (Throwable)e);
            }
            return new ArrayList<Topic>();
        }
    }

    private String buildTopicQuery(TopicFilter filter, boolean hasOrder) throws Exception {
        SortSettings sortSettings = this.getTopicSortSettings();
        SortSettings.SortField orderBy = sortSettings.getField();
        SortSettings.Direction orderType = sortSettings.getDirection();
        String forumPath = "/" + this.dataLocator.getForumCategoriesLocation() + "/" + filter.categoryId() + "/" + filter.forumId();
        StringBuilder sqlBuilder = this.jcrPathLikeAndNotLike("exo:topic", forumPath);
        if (!filter.isAdmin()) {
            StringBuilder strQuery = new StringBuilder();
            strQuery.append(Utils.getSQLQueryByProperty("AND", "exo:isWaiting", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isActive", "true")).append(Utils.getSQLQueryByProperty("AND", "exo:isClosed", "false"));
            if (filter.isApproved()) {
                strQuery.append(Utils.getSQLQueryByProperty("AND", "exo:isApproved", "true"));
            }
            if (Utils.isEmpty(filter.viewers())) {
                strQuery.append(" AND (").append("exo:owner").append("='").append(filter.userLogin()).append("' OR ").append(Utils.buildSQLByUserInfo("exo:canView", UserHelper.getAllGroupAndMembershipOfUser(null))).append(" OR ").append(Utils.buildSQLHasProperty("exo:canView")).append(")");
            } else if (!ForumServiceUtils.hasPermission(filter.viewers(), filter.userLogin())) {
                strQuery.append(" AND (").append("exo:owner").append("='").append(filter.userLogin()).append("' OR ").append(Utils.buildSQLByUserInfo("exo:canView", UserHelper.getAllGroupAndMembershipOfUser(null))).append(")");
            }
            sqlBuilder.append((CharSequence)strQuery);
        }
        if (hasOrder) {
            sqlBuilder.append(" ORDER BY ").append("exo:isSticky").append(" DESC");
            String strOrderBy = filter.orderBy();
            if (strOrderBy == null || Utils.isEmpty(strOrderBy)) {
                if (orderBy != null) {
                    sqlBuilder.append(", exo:").append(orderBy.toString()).append(" ").append((Object)orderType);
                    if (!orderBy.equals((Object)SortSettings.SortField.LASTPOST)) {
                        sqlBuilder.append(", ").append("exo:lastPostDate").append(" DESC");
                    }
                } else {
                    sqlBuilder.append(", ").append("exo:lastPostDate").append(" DESC");
                }
            } else {
                sqlBuilder.append(", exo:").append(strOrderBy);
                if (strOrderBy.indexOf(SortSettings.SortField.LASTPOST.toString()) < 0) {
                    sqlBuilder.append(", ").append("exo:lastPostDate").append(" DESC");
                }
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    public int getTopicsCount(TopicFilter filter) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = null;
            iter = !Utils.isEmpty(filter.userName()) ? this.getNodeIteratorBySQLQuery(sProvider, this.buildQueryTopicsByUser(filter, false), 0, 0, false) : this.getNodeIteratorBySQLQuery(sProvider, this.buildTopicQuery(filter, false), 0, 0, false);
            return (int)(iter != null ? iter.getSize() : 0L);
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public List<Topic> getTopics(String categoryId, String forumId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<Topic> topics = new ArrayList<Topic>();
        DataStorage storage = this.getCachedDataStorage();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId).getNode(forumId);
            NodeIterator iter = forumNode.getNodes();
            while (iter.hasNext()) {
                try {
                    Node topicNode = iter.nextNode();
                    if (!topicNode.isNodeType("exo:topic")) continue;
                    topics.add(storage.getTopicByPath(topicNode.getPath(), false));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Can not get topic", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return topics;
    }

    @Override
    public void setViewCountTopic(String path, String userRead) {
        if (userRead != null && userRead.length() > 0 && !userRead.equals("user_gest_uoom")) {
            if (this.updatingView.containsKey(path)) {
                int value = this.updatingView.get(path);
                this.updatingView.put(path, value + 1);
            } else {
                this.updatingView.put(path, 1);
            }
        }
    }

    @Override
    public void writeViews() {
        Map<String, Integer> map = this.updatingView;
        this.updatingView = new ConcurrentHashMap<String, Integer>();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            try {
                Node topicNode = this.getCategoryHome(sProvider).getNode(entry.getKey());
                long newViewCount = new PropertyReader(topicNode).l("exo:viewCount") + (long)entry.getValue().intValue();
                topicNode.setProperty("exo:viewCount", newViewCount);
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                    continue;
                }
                topicNode.save();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("Failed to set view number for topic with path %s", entry.getKey()), (Throwable)e);
            }
        }
    }

    @Override
    public Topic getTopic(String categoryId, String forumId, String topicId, String userRead) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        String topicPath = topicId;
        try {
            if (!Utils.isEmpty(categoryId)) {
                topicPath = categoryId + "/" + forumId + "/" + topicId;
            }
            Node topicNode = this.getCategoryHome(sProvider).getNode(topicPath);
            return this.getTopicNode(topicNode);
        }
        catch (Exception e) {
            JCRDataStorage.logDebug("Getting the topic " + topicPath + " is unsuccessfully.", e);
            return null;
        }
    }

    @Override
    public Topic getTopicSummary(String topicPath) {
        try {
            return this.getTopicSummary(topicPath, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean topicHasPoll(String topicPath) {
        try {
            return new PropertyReader(this.getTopicNodeByPath(topicPath, false)).bool("exo:isPoll", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Topic getTopicSummary(String topicPath, boolean isLastPost) throws Exception {
        return this.getTopicNodeSummary(this.getTopicNodeByPath(topicPath, isLastPost));
    }

    @Override
    public Topic getTopicByPath(String topicPath, boolean isLastPost) throws Exception {
        return this.getTopicNode(this.getTopicNodeByPath(topicPath, isLastPost));
    }

    private Node getTopicNodeByPath(String topicPath, boolean isLastPost) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node topicNode;
            Node catogoryHome = this.getCategoryHome(sProvider);
            if (topicPath == null || topicPath.length() <= 0) {
                return null;
            }
            if (topicPath.indexOf(catogoryHome.getName()) < 0) {
                topicPath = catogoryHome.getPath() + "/" + topicPath;
            }
            if ((topicNode = (Node)catogoryHome.getSession().getItem(topicPath)) == null && isLastPost) {
                String forumPath = Utils.getForumPath(topicPath);
                topicNode = this.queryLastTopic(sProvider, forumPath);
            }
            return topicNode;
        }
        catch (RepositoryException e) {
            if (topicPath != null && topicPath.length() > 0 && isLastPost) {
                String forumPath = Utils.getForumPath(topicPath);
                return this.queryLastTopic(sProvider, forumPath);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryLastPostForum(String forumPath) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            this.queryLastTopic(sProvider, forumPath);
        }
    }

    private Node queryLastTopic(SessionProvider sProvider, String forumPath) throws Exception {
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
            StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:topic", forumPath);
            sqlQuery.append(Utils.getSQLQueryByProperty("AND", "exo:isWaiting", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isClosed", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isActive", "true")).append(" ORDER BY ").append("exo:lastPostDate").append(" DESC");
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), 0, 0, false);
            String lastTopicPath = "";
            boolean isModerateTopic = new PropertyReader(forumNode).bool("exo:isModerateTopic");
            Node topicNode = null;
            while (iter.hasNext()) {
                topicNode = iter.nextNode();
                if (isModerateTopic && !topicNode.getProperty("exo:isApproved").getBoolean()) continue;
                lastTopicPath = topicNode.getName();
                break;
            }
            forumNode.setProperty("exo:lastTopicPath", lastTopicPath);
            forumNode.getSession().save();
            return topicNode;
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to query last topic", (Throwable)e);
            }
            return null;
        }
    }

    private Topic getTopicNodeSummary(Node topicNode) throws RepositoryException {
        if (topicNode == null) {
            return null;
        }
        Topic topicNew = new Topic();
        PropertyReader reader = new PropertyReader(topicNode);
        topicNew.setId(topicNode.getName());
        topicNew.setPath(topicNode.getPath());
        topicNew.setIcon(reader.string("exo:icon"));
        topicNew.setOwner(reader.string("exo:owner"));
        topicNew.setTopicName(reader.string("exo:name"));
        topicNew.setLastPostBy(reader.string("exo:lastPostBy"));
        topicNew.setLastPostDate(reader.date("exo:lastPostDate"));
        topicNew.setIsClosed(reader.bool("exo:isClosed"));
        topicNew.setIsApproved(reader.bool("exo:isApproved"));
        topicNew.setIsActive(reader.bool("exo:isActive"));
        topicNew.setIsPoll(reader.bool("exo:isPoll"));
        topicNew.setCanView(reader.strings("exo:canView", new String[0]));
        return topicNew;
    }

    private Topic getTopicUpdate(Node topicNode, Topic topic, boolean isSummary) throws Exception {
        block7: {
            PropertyReader reader = new PropertyReader(topicNode);
            if (isSummary) {
                topic.setLastPostDate(reader.date("exo:lastPostDate"));
                topic.setLastPostBy(reader.string("exo:lastPostBy"));
                topic.setOwner(reader.string("exo:owner"));
                topic.setTopicName(reader.string("exo:name"));
                topic.setDescription(reader.string("exo:description"));
                topic.setPostCount(reader.l("exo:postCount"));
                topic.setViewCount(reader.l("exo:viewCount"));
                topic.setNumberAttachment(reader.l("exo:numberAttachments"));
                topic.setIsSticky(reader.bool("exo:isSticky"));
                topic.setUserVoteRating(reader.strings("exo:userVoteRating"));
                topic.setVoteRating(reader.d("exo:voteRating"));
            }
            topic.setIsWaiting(reader.bool("exo:isWaiting"));
            topic.setIsActive(reader.bool("exo:isActive"));
            topic.setIsActiveByForum(reader.bool("exo:isActiveByForum"));
            if (topicNode.getParent().getProperty("exo:isLock").getBoolean()) {
                topic.setIsLock(true);
            } else {
                topic.setIsLock(reader.bool("exo:isLock"));
            }
            topic.setIsClosed(reader.bool("exo:isClosed"));
            topic.setCreatedDate(reader.date("exo:createdDate"));
            topic.setModifiedBy(reader.string("exo:modifiedBy"));
            topic.setModifiedDate(reader.date("exo:modifiedDate"));
            topic.setIsModeratePost(reader.bool("exo:isModeratePost"));
            topic.setIsNotifyWhenAddPost(reader.string("exo:isNotifyWhenAddPost", null));
            topic.setLink(reader.string("exo:link"));
            topic.setTagId(reader.strings("exo:tagId"));
            topic.setCanView(reader.strings("exo:canView", new String[0]));
            topic.setCanPost(reader.strings("exo:canPost", new String[0]));
            if (topicNode.isNodeType("exo:forumWatching")) {
                topic.setEmailNotification(reader.strings("exo:emailWatching", new String[0]));
            }
            try {
                if (reader.l("exo:numberAttachments") > 0L) {
                    String idFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST);
                    Node FirstPostNode = topicNode.getNode(idFirstPost);
                    topic.setAttachments(JCRDataStorage.getAttachmentsByNode(FirstPostNode));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)"Failed to set attachments in topic.", (Throwable)e);
            }
        }
        return topic;
    }

    @Override
    public Topic getTopicUpdate(Topic topic, boolean isSummary) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            Node topicNode = (Node)forumHomeNode.getSession().getItem(topic.getPath());
            return this.getTopicUpdate(topicNode, topic, isSummary);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get topic", (Throwable)e);
            }
            return topic;
        }
    }

    public Topic getTopicNode(Node topicNode) throws Exception {
        if (topicNode == null) {
            return null;
        }
        Topic topic = this.getTopicNodeSummary(topicNode);
        return this.getTopicUpdate(topicNode, topic, true);
    }

    @Override
    public JCRPageList getPageTopicOld(long date, String forumPatch) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String sqlQuery = this.buildSQLQueryGetTopicByDate(date, forumPatch);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery, 0, 0, false);
            return new ForumPageList(iter, 10, sqlQuery, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<Topic> getTopicsByDate(long date, String forumPath, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            ArrayList<Topic> topics = new ArrayList<Topic>();
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.buildSQLQueryGetTopicByDate(date, forumPath), offset, limit, false);
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                topics.add(this.getTopicNode(node));
            }
            return topics;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildSQLQueryGetTopicByDate(long date, String forumPath) throws Exception {
        StringBuilder sqlBuilder = new StringBuilder("SELECT * FROM ").append("exo:topic");
        sqlBuilder.append(" WHERE ").append("jcr:path").append(" LIKE '");
        if (!Utils.isEmpty(forumPath)) {
            sqlBuilder.append(forumPath).append("/%' AND NOT ").append("jcr:path").append(" LIKE '").append(forumPath).append("/%/%'");
        } else {
            sqlBuilder.append("/").append(this.dataLocator.getForumCategoriesLocation()).append("/%'");
        }
        Calendar newDate = this.getGreenwichMeanTime();
        newDate.setTimeInMillis(newDate.getTimeInMillis() - date * 86400000L);
        sqlBuilder.append(" AND (").append("exo:lastPostDate").append(" <= TIMESTAMP '").append(ISO8601.format((Calendar)newDate)).append("') ORDER BY ").append("exo:createdDate").append(" ASC");
        return sqlBuilder.toString();
    }

    @Override
    public List<Topic> getAllTopicsOld(long date, String forumPath) throws Exception {
        ArrayList<Topic> topics;
        block3: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            topics = new ArrayList<Topic>();
            try {
                NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.buildSQLQueryGetTopicByDate(date, forumPath), 0, 0, false);
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    Topic topic = new Topic();
                    topic.setId(node.getName());
                    topic.setPath(node.getPath());
                    topic.setIsActive(node.getProperty("exo:isActive").getBoolean());
                    topic.setPostCount(node.getProperty("exo:postCount").getLong());
                    topics.add(topic);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Failed to get all topic old", (Throwable)e);
            }
        }
        return topics;
    }

    @Override
    public long getTotalTopicOld(long date, String forumPath) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.buildSQLQueryGetTopicByDate(date, forumPath), 0, 0, false);
            return iter.getSize();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public JCRPageList getPageTopicByUser(String userName, boolean isMod, String strOrderBy) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            TopicFilter filter = new TopicFilter(userName, isMod, strOrderBy);
            String sqlQuery = this.buildQueryTopicsByUser(filter, true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery, 0, 0, false);
            return new ForumPageList(iter, 10, sqlQuery, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildQueryTopicsByUser(TopicFilter filter, boolean hasOrder) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append("exo:topic");
        sqlQuery.append(" WHERE ").append(Utils.getSQLQueryByProperty("", "exo:owner", filter.userName()));
        if (!filter.isAdmin()) {
            sqlQuery.append(Utils.getSQLQueryByProperty("AND", "exo:isClosed", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isWaiting", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isActive", "true")).append(Utils.getSQLQueryByProperty("AND", "exo:isActiveByForum", "true")).append(Utils.getSQLQueryByProperty("AND", "exo:isApproved", "true"));
        }
        if (hasOrder) {
            sqlQuery.append(" ORDER BY ").append("exo:isSticky").append(" DESC");
            if (!Utils.isEmpty(filter.orderBy())) {
                sqlQuery.append(",exo:").append(filter.orderBy());
                if ("exo:createdDate".indexOf(filter.orderBy()) < 0) {
                    sqlQuery.append(", ").append("exo:createdDate").append(" ASC");
                }
            } else {
                sqlQuery.append(", ").append("exo:createdDate").append(" ASC");
            }
        }
        return sqlQuery.toString();
    }

    @Override
    public List<Topic> getTopicsByUser(TopicFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.buildQueryTopicsByUser(filter, true), offset, limit, true);
            ArrayList<Topic> topics = new ArrayList<Topic>();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                topics.add(this.getTopicNode(node));
            }
            return topics;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void modifyTopic(List<Topic> topics, int type) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumNode;
            long postCount;
            long topicCount;
            Node forumHomeNode;
            block24: {
                forumHomeNode = this.getForumHomeNode(sProvider);
                topicCount = 0L;
                postCount = 0L;
                forumNode = null;
                try {
                    String topicPath = topics.get(0).getPath();
                    forumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
                    topicCount = forumNode.getProperty("exo:topicCount").getLong();
                    postCount = forumNode.getProperty("exo:postCount").getLong();
                }
                catch (PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block24;
                    LOG.debug((Object)"Failed to get node by path", (Throwable)e);
                }
            }
            HashSet<String> userIdsp = new HashSet<String>(new PropertyReader(forumNode).list("exo:moderators", new ArrayList()));
            for (Topic topic : topics) {
                try {
                    String topicPath = topic.getPath();
                    Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                    switch (type) {
                        case 1: {
                            topicNode.setProperty("exo:isClosed", topic.getIsClosed());
                            this.setActivePostByTopic(sProvider, topicNode, !topic.getIsClosed());
                            break;
                        }
                        case 2: {
                            topicNode.setProperty("exo:isLock", topic.getIsLock());
                            break;
                        }
                        case 3: {
                            topicNode.setProperty("exo:isApproved", topic.getIsApproved());
                            this.addNotificationTask(topicNode.getParent().getPath(), topic, null, new MessageBuilder(), true);
                            this.setActivePostByTopic(sProvider, topicNode, topic.getIsApproved());
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 4: {
                            topicNode.setProperty("exo:isSticky", topic.getIsSticky());
                            break;
                        }
                        case 5: {
                            boolean isWaiting = topic.getIsWaiting();
                            topicNode.setProperty("exo:isWaiting", isWaiting);
                            this.setActivePostByTopic(sProvider, topicNode, !isWaiting);
                            if (!isWaiting) {
                                this.addNotificationTask(topicNode.getParent().getPath(), topic, null, new MessageBuilder(), true);
                            }
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 6: {
                            topicNode.setProperty("exo:isActive", topic.getIsActive());
                            this.setActivePostByTopic(sProvider, topicNode, topic.getIsActive());
                            this.getTotalJobWatting(sProvider, userIdsp);
                            break;
                        }
                        case 7: {
                            topicNode.setProperty("exo:name", topic.getTopicName());
                            try {
                                Node nodeFirstPost = topicNode.getNode(topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST));
                                nodeFirstPost.setProperty("exo:name", topic.getTopicName());
                            }
                            catch (PathNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break;
                                LOG.debug((Object)"Failed to get node by path", (Throwable)e);
                            }
                            break;
                        }
                        case 8: {
                            topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
                            topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
                            break;
                        }
                    }
                    if ((type == 3 || type == 5) && !topic.getIsWaiting() && topic.getIsApproved()) {
                        ++topicCount;
                        postCount += topicNode.getProperty("exo:postCount").getLong() + 1L;
                    }
                    if (type != 3 && type != 5 && type != 6 && type != 1 && !forumNode.hasProperty("exo:lastTopicPath") && !forumNode.getProperty("exo:lastTopicPath").getString().equals(topicNode.getName()) && !Utils.isEmpty(forumNode.getProperty("exo:lastTopicPath").getString())) continue;
                    this.addQueryLastPostTask(forumNode.getPath());
                }
                catch (PathNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Failed to get node by path", (Throwable)e);
                }
            }
            if (type == 3 || type == 5) {
                forumNode.setProperty("exo:topicCount", topicCount);
                forumNode.setProperty("exo:postCount", postCount);
            }
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to modify topic.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProfileAddTopic(String owner) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node profileHomeNode = this.getUserProfileHome(sProvider);
            if (profileHomeNode.hasNode(owner)) {
                Node profileNode = profileHomeNode.getNode(owner);
                long totalTopicByUser = profileNode.getProperty("exo:totalTopic").getLong();
                profileNode.setProperty("exo:totalTopic", totalTopicByUser + 1L);
            } else if (!Utils.isEmpty(owner)) {
                Node newProfileNode = profileHomeNode.addNode(owner, "exo:forumUserProfile");
                newProfileNode.setProperty("exo:userId", owner);
                newProfileNode.setProperty("exo:userTitle", Utils.USER);
                if (this.isAdminRole(sProvider, owner)) {
                    newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                }
                newProfileNode.setProperty("exo:totalTopic", 1L);
            }
            profileHomeNode.getSession().save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOwner(String path) {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node node = this.getNodeAt(sProvider, path);
            String string = new PropertyReader(node).string("exo:owner", "");
            return string;
        }
    }

    @Override
    public void saveTopic(String categoryId, String forumId, Topic topic, boolean isNew, boolean isMove, MessageBuilder messageBuilder) throws Exception {
        block14: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node topicNode;
                Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
                boolean isChangeClose = false;
                if (isNew) {
                    topicNode = forumNode.addNode(topic.getId(), "exo:topic");
                    topicNode.setProperty("exo:id", topic.getId());
                    topicNode.setProperty("exo:owner", topic.getOwner());
                    Calendar calendar = this.getGreenwichMeanTime();
                    topic.setCreatedDate(calendar.getTime());
                    topicNode.setProperty("exo:createdDate", calendar);
                    topicNode.setProperty("exo:lastPostBy", topic.getOwner());
                    if (isMove && topic.getLastPostDate() != null) {
                        calendar.setTime(topic.getLastPostDate());
                    }
                    topicNode.setProperty("exo:lastPostDate", calendar);
                    topicNode.setProperty("exo:postCount", -1L);
                    topicNode.setProperty("exo:viewCount", 0L);
                    topicNode.setProperty("exo:tagId", topic.getTagId());
                    topicNode.setProperty("exo:isActiveByForum", true);
                    topicNode.setProperty("exo:isPoll", topic.getIsPoll());
                    topicNode.setProperty("exo:link", CommonUtils.getURI((String)topic.getLink()));
                    topicNode.setProperty("exo:path", forumId);
                    if (!forumNode.getProperty("exo:isModerateTopic").getBoolean() && !topic.getIsWaiting()) {
                        long newTopicCount = forumNode.getProperty("exo:topicCount").getLong() + 1L;
                        forumNode.setProperty("exo:topicCount", newTopicCount);
                    }
                } else {
                    topicNode = forumNode.getNode(topic.getId());
                    isChangeClose = topic.getIsClosed() != topicNode.getProperty("exo:isClosed").getBoolean();
                }
                topicNode.setProperty("exo:name", topic.getTopicName());
                topicNode.setProperty("exo:modifiedBy", topic.getModifiedBy());
                topicNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
                topicNode.setProperty("exo:description", topic.getDescription());
                topicNode.setProperty("exo:icon", topic.getIcon());
                topicNode.setProperty("exo:isModeratePost", topic.getIsModeratePost());
                topicNode.setProperty("exo:isNotifyWhenAddPost", topic.getIsNotifyWhenAddPost());
                topicNode.setProperty("exo:isClosed", topic.getIsClosed());
                topicNode.setProperty("exo:isLock", topic.getIsLock());
                topicNode.setProperty("exo:isApproved", topic.getIsApproved());
                topicNode.setProperty("exo:isSticky", topic.getIsSticky());
                topicNode.setProperty("exo:isWaiting", topic.getIsWaiting());
                topicNode.setProperty("exo:isActive", topic.getIsActive());
                topicNode.setProperty("exo:userVoteRating", topic.getUserVoteRating());
                topicNode.setProperty("exo:voteRating", topic.getVoteRating().doubleValue());
                topicNode.setProperty("exo:numberAttachments", topic.getNumberAttachment());
                topicNode.setProperty("exo:canPost", JCRDataStorage.convertArray(topic.getCanPost()));
                topicNode.setProperty("exo:canView", JCRDataStorage.convertArray(topic.getCanView()));
                topic.setPath(topicNode.getPath());
                if (isNew) {
                    forumNode.getSession().save();
                    this.addNotificationTask(forumNode.getPath(), topic, null, messageBuilder, true);
                } else {
                    forumNode.save();
                }
                if (topic.getIsWaiting() || !topic.getIsApproved()) {
                    this.getTotalJobWatting(sProvider, new HashSet<String>(new PropertyReader(forumNode).list("exo:moderators", new ArrayList())));
                }
                if (isNew || isChangeClose) {
                    this.addQueryLastPostTask(forumNode.getPath());
                }
                if (!isMove) {
                    String id;
                    if (isNew) {
                        id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                        Post post = new Post();
                        post.setId(id);
                        post.setOwner(topic.getOwner());
                        post.setCreatedDate(new Date());
                        post.setName(topic.getTopicName());
                        post.setMessage(topic.getDescription());
                        post.setRemoteAddr("");
                        post.setIcon(topic.getIcon());
                        post.setIsApproved(true);
                        post.setAttachments(topic.getAttachments());
                        post.setUserPrivate(new String[]{"exoUserPri"});
                        post.setLink(topic.getLink());
                        post.setRemoteAddr(topic.getRemoteAddr());
                        this.savePost(categoryId, forumId, topic.getId(), post, true, messageBuilder);
                    } else {
                        id = topic.getId().replaceFirst(Utils.TOPIC, Utils.POST);
                        if (topicNode.hasNode(id)) {
                            Node fistPostNode = topicNode.getNode(id);
                            Post post = this.getPost(fistPostNode);
                            post.setModifiedBy(topic.getModifiedBy());
                            post.setModifiedDate(new Date());
                            post.setEditReason(topic.getEditReason());
                            post.setName(topic.getTopicName());
                            post.setMessage(topic.getDescription());
                            post.setIcon(topic.getIcon());
                            post.setAttachments(topic.getAttachments());
                            this.savePost(categoryId, forumId, topic.getId(), post, false, messageBuilder);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to save topic", (Throwable)e);
                if (!isNew) break block14;
                topic = null;
            }
        }
    }

    private Map<String, Long> getDeletePostByUser(SessionProvider sProvider, Node node) throws Exception {
        HashMap<String, Long> userPostMap = new HashMap<String, Long>();
        StringBuilder sqlQuery = new StringBuilder();
        if (node.isNodeType("exo:topic")) {
            sqlQuery = this.jcrPathLikeAndNotLike("exo:post", node.getPath());
        } else if (node.isNodeType("exo:forum") || node.isNodeType("exo:forumCategory")) {
            sqlQuery.append("SELECT * FROM ").append("exo:post").append(" WHERE ").append("jcr:path").append(" LIKE '").append(node.getPath()).append("/%'");
        }
        NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), 0, 0, false);
        Node post = null;
        String owner = null;
        while (iter.hasNext()) {
            post = iter.nextNode();
            try {
                owner = post.getProperty("exo:owner").getString();
                userPostMap.put(owner, (userPostMap.get(owner) != null ? (Long)userPostMap.get(owner) : 0L) + 1L);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to get deleted post by user.", (Throwable)e);
            }
        }
        return userPostMap;
    }

    @Override
    public void updateUserProfileInfo(String name) throws Exception {
        block5: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node userProfileHome = this.getUserProfileHome(sProvider);
                Node userNode = null;
                HashMap userPostMap = (HashMap)this.infoMap.get(name);
                for (Map.Entry entry : userPostMap.entrySet()) {
                    String user = (String)entry.getKey();
                    try {
                        userNode = userProfileHome.getNode(user);
                        long totalPost = userNode.getProperty("exo:totalPost").getLong();
                        userNode.setProperty("exo:totalPost", totalPost - (Long)userPostMap.get(user));
                        userNode.save();
                    }
                    catch (PathNotFoundException e) {
                        LOG.debug((Object)("UserProfile of user: " + user + " not existing."));
                    }
                }
                this.infoMap.remove(name);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)"Failed to update user profile info", (Throwable)e);
            }
        }
    }

    private void addUpdateUserProfileJob(Map<String, Long> userPostMap) {
        block2: {
            try {
                GregorianCalendar cal = new GregorianCalendar();
                PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, 1, 86400000L);
                String name = String.valueOf(cal.getTime().getTime());
                JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", UpdateUserProfileJob.class);
                JobSchedulerService schedulerService = (JobSchedulerService)CommonsUtils.getService(JobSchedulerService.class);
                String repoName = CommonsUtils.getRepository().getConfiguration().getName();
                JobDataMap jdatamap = new JobDataMap();
                jdatamap.put(Utils.CACHE_REPO_NAME, repoName);
                this.infoMap.put(name, userPostMap);
                schedulerService.addPeriodJob(info, periodInfo, jdatamap);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Failed to add job for update user profile ", (Throwable)e);
            }
        }
    }

    @Override
    public Topic removeTopic(String categoryId, String forumId, String topicId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Map<String, Long> userPostMap;
            Topic topic;
            block6: {
                Node forumNode = this.getCategoryHome(sProvider).getNode(categoryId + "/" + forumId);
                topic = this.getTopic(categoryId, forumId, topicId, "user_gest_uoom");
                Node topicNode = forumNode.getNode(topicId);
                PropertyReader readerFor = new PropertyReader(forumNode);
                userPostMap = this.getDeletePostByUser(sProvider, topicNode);
                if (topic.getIsApproved() && !topic.getIsWaiting()) {
                    forumNode.setProperty("exo:topicCount", readerFor.l("exo:topicCount") - 1L);
                    long newPostCount = readerFor.l("exo:postCount") - (topic.getPostCount() + 1L);
                    forumNode.setProperty("exo:postCount", newPostCount > 0L ? newPostCount : 0L);
                }
                topicNode.remove();
                forumNode.save();
                if (!topic.getIsActive() || !topic.getIsApproved() || topic.getIsWaiting()) {
                    this.getTotalJobWatting(sProvider, new HashSet<String>(readerFor.list("exo:moderators", new ArrayList())));
                }
                this.addQueryLastPostTask(forumNode.getPath());
                try {
                    this.calculateLastRead(sProvider, null, forumId, topicId);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)"Failed to update last read topic", (Throwable)e);
                }
            }
            this.addUpdateUserProfileJob(userPostMap);
            return topic;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove topic", (Throwable)e);
            return null;
        }
    }

    private String getEmailUser(SessionProvider sProvider, String userId) throws Exception {
        return new PropertyReader(this.getUserProfileNode(sProvider, userId)).string("exo:email", "");
    }

    @Override
    public void moveTopic(List<Topic> topics, String destForumPath, String mailContent, String link) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        long tmp = 0L;
        String forumName = null;
        Node destForumNode = (Node)forumHomeNode.getSession().getItem(destForumPath);
        PropertyReader destForumReader = new PropertyReader(destForumNode);
        forumName = destForumReader.string("exo:name");
        String owner = destForumReader.string("exo:owner");
        if (!Utils.isEmpty(owner) && owner.indexOf(":") > 0) {
            owner = ForumServiceUtils.getUserPermission(new String[]{owner}).get(0);
        }
        if (Utils.isEmpty(owner)) {
            owner = topics.get(0).getEditReason();
        }
        String categoryName = new PropertyReader(destForumNode.getParent()).string("exo:name", "");
        String headerSubject = "[" + categoryName + "][" + forumName + "] ";
        MessageBuilder messageBuilder = this.getInfoMessageMove(sProvider, mailContent, headerSubject, true);
        messageBuilder.setCatName(categoryName);
        messageBuilder.setForumName(forumName);
        messageBuilder.setTopicName("");
        messageBuilder.setOwner(CommonUtils.decodeSpecialCharToHTMLnumber((String)this.getScreenName(sProvider, owner)));
        messageBuilder.setAddType(forumName);
        messageBuilder.setTypes(Utils.FORUM, Utils.TOPIC, "", "");
        String destForumId = destForumNode.getName();
        String srcForumId = "";
        for (Topic topic : topics) {
            String topicPath = topic.getPath();
            String newTopicPath = destForumPath + "/" + topic.getId();
            Node srcForumNode = forumHomeNode.getSession().getItem(topicPath).getParent();
            srcForumId = srcForumNode.getName();
            forumHomeNode.getSession().getWorkspace().move(topicPath, newTopicPath);
            tmp = srcForumNode.getProperty("exo:topicCount").getLong();
            tmp = tmp > 0L ? --tmp : 0L;
            srcForumNode.setProperty("exo:topicCount", tmp);
            this.addQueryLastPostTask(srcForumNode.getPath());
            Node topicNode = (Node)forumHomeNode.getSession().getItem(newTopicPath);
            topicNode.setProperty("exo:path", destForumNode.getName());
            long topicPostCount = topicNode.getProperty("exo:postCount").getLong() + 1L;
            destForumNode.setProperty("exo:topicCount", destForumReader.l("exo:topicCount") + 1L);
            this.addQueryLastPostTask(destForumNode.getPath());
            tmp = srcForumNode.getProperty("exo:postCount").getLong();
            tmp = tmp > topicPostCount ? (tmp -= topicPostCount) : 0L;
            srcForumNode.setProperty("exo:postCount", tmp);
            destForumNode.setProperty("exo:postCount", destForumReader.l("exo:postCount") + topicPostCount);
            messageBuilder.setObjName(topic.getTopicName());
            messageBuilder.setHeaderSubject(messageBuilder.getHeaderSubject() + topic.getTopicName());
            messageBuilder.setLink(link.replaceFirst("pathId", topic.getId()));
            HashSet<String> set = new HashSet<String>();
            set.add(this.getEmailUser(sProvider, topic.getOwner()));
            set.addAll(this.calculateMoveEmail(topicNode));
            set.addAll(this.calculateMoveEmail(srcForumNode));
            if (!Utils.isEmpty(set.toArray(new String[set.size()]))) {
                this.sendEmailNotification(new ArrayList<String>(set), messageBuilder.getContentEmailMoved());
            }
            try {
                this.calculateLastRead(sProvider, destForumId, srcForumId, topic.getId());
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Failed to calculate last read", (Throwable)e);
            }
        }
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
    }

    private Set<String> calculateMoveEmail(Node node) throws Exception {
        HashSet<String> set = new HashSet<String>();
        while (!node.getName().equals("CategoryHome")) {
            if (node.isNodeType("exo:forumWatching")) {
                set.addAll(new PropertyReader(node).list("exo:emailWatching", new ArrayList()));
            }
            node = node.getParent();
        }
        return set;
    }

    private void calculateLastRead(SessionProvider sProvider, String destForumId, String srcForumId, String topicId) throws Exception {
        Node profileHome = this.getUserProfileHome(sProvider);
        StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:forumUserProfile", profileHome.getPath());
        sqlQuery.append(" AND ").append("exo:lastReadPostOfForum").append(" LIKE '%").append(topicId).append("%'");
        NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), 0, 0, false);
        while (iter.hasNext()) {
            List list = new ArrayList();
            ArrayList<String> list2 = new ArrayList<String>();
            Node profileNode = iter.nextNode();
            PropertyReader reader = new PropertyReader(profileNode);
            list = reader.list("exo:lastReadPostOfForum", new ArrayList());
            list2 = new ArrayList(list);
            boolean isRead = false;
            for (String string : list) {
                if (destForumId != null && string.indexOf(destForumId) >= 0) {
                    isRead = true;
                    try {
                        long lastAccessTopicTime = 0L;
                        long lastAccessForumTime = 0L;
                        List readTopics = reader.list("exo:readTopic", new ArrayList());
                        for (String tpId : readTopics) {
                            String[] info = tpId.split(":");
                            if (tpId.indexOf(topicId) < 0 || info.length <= 1) continue;
                            lastAccessTopicTime = Long.parseLong(info[1]);
                            if (lastAccessTopicTime > 0L) {
                                List values = reader.list("exo:readForum", new ArrayList());
                                for (String str : values) {
                                    if (str.indexOf(destForumId) < 0 || str.indexOf(":") <= 0) continue;
                                    lastAccessForumTime = Long.parseLong(str.split(":")[1]);
                                    break;
                                }
                            }
                            if (lastAccessTopicTime > lastAccessForumTime) {
                                list2.remove(string);
                                list2.add(destForumId + "," + info[0] + "/" + info[1]);
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Can not calculate last read of user: " + profileNode.getName()));
                    }
                }
                if (string.indexOf(srcForumId) < 0) continue;
                list2.remove(string);
            }
            if (!isRead && destForumId != null) {
                list2.add(destForumId + "," + topicId + "/" + topicId.replace(Utils.TOPIC, Utils.POST));
            }
            profileNode.setProperty("exo:lastReadPostOfForum", list2.toArray(new String[list2.size()]));
        }
        profileHome.save();
    }

    @Override
    public long getLastReadIndex(String path, String isApproved, String isHidden, String userLogin) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node catNode = this.getCategoryHome(sProvider);
            Node postNode = catNode.getNode(path);
            if (postNode != null) {
                String topicPath = postNode.getParent().getPath();
                StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:post", topicPath);
                String query = Utils.getSQLQuery(isApproved, isHidden, isHidden, userLogin).toString();
                if (!query.isEmpty()) {
                    sqlQuery.append(" AND (").append(query).append(")");
                }
                Calendar cal = postNode.getProperty("exo:createdDate").getDate();
                sqlQuery.append(" AND (").append("exo:createdDate").append(" <= TIMESTAMP '").append(ISO8601.format((Calendar)cal)).append("')");
                NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery.toString(), 0, 0, false);
                long size = iter.getSize();
                boolean isView = false;
                while (iter.hasNext()) {
                    if (!iter.nextNode().getName().equals(postNode.getName())) continue;
                    isView = true;
                    break;
                }
                if (!isView) {
                    size = 1L;
                }
                return size;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception occurs when getting last read index", (Throwable)e);
        }
        return 0L;
    }

    @Override
    public JCRPageList getPostForSplitTopic(String topicPath) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            PostFilter filter = new PostFilter(topicPath);
            String sqlQuery = this.makePostsSplitSQLQuery(filter, true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery, 0, 0, false);
            return new ForumPageList(iter, 10, sqlQuery.toString(), true);
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get post for split topic.", (Throwable)e);
            }
            return null;
        }
    }

    private String makePostsSplitSQLQuery(PostFilter filter, boolean hasOrder) throws Exception {
        StringBuilder topicPath = new StringBuilder();
        if (filter.getTopicPath().indexOf(this.dataLocator.getForumCategoriesLocation()) > 0) {
            topicPath.append(filter.getTopicPath());
        } else {
            topicPath.append("/").append(this.dataLocator.getForumCategoriesLocation()).append("/").append(filter.getTopicPath());
        }
        StringBuilder sqlQuery = this.jcrPathLikeAndNotLike("exo:post", topicPath.toString());
        sqlQuery.append(Utils.getSQLQueryByProperty("AND", "exo:userPrivate", "exoUserPri")).append(Utils.getSQLQueryByProperty("AND", "exo:isFirstPost", "false"));
        if (hasOrder) {
            sqlQuery.append(" ORDER BY ").append("exo:createdDate").append(" ASC");
        }
        return sqlQuery.toString();
    }

    public List<Post> getPostsSplitTopic(PostFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String sqlQuery = this.makePostsSplitSQLQuery(filter, true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery, 0, 0, false);
            return this.getPosts(iter);
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get post for split topic.", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public JCRPageList getPosts(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String strQuery, String userLogin) throws Exception {
        try {
            String isWaiting = strQuery.equals("true") || strQuery.equals("false") ? strQuery : "";
            PostFilter filter = new PostFilter(categoryId, forumId, topicId, isApproved, isHidden, isWaiting, userLogin);
            if (!Utils.isEmpty(strQuery)) {
                LOG.warn((Object)"This method doesn't support to add more query.");
            }
            return new ForumPageList(null, 10, this.makePostsSQLQuery(filter, true), true);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private String makePostsSQLQuery(PostFilter filter, boolean hasOrder) throws Exception {
        String topicPath = filter.getTopicPath();
        if (Utils.isEmpty(topicPath)) {
            topicPath = new StringBuffer("/").append(this.dataLocator.getForumCategoriesLocation()).append("/").append(filter.getCategoryId()).append("/").append(filter.getForumId()).append("/").append(filter.getTopicId()).toString();
        }
        StringBuilder strBuilder = this.jcrPathLikeAndNotLike("exo:post", topicPath);
        String sqlQuery = Utils.getSQLQuery(filter.getIsApproved(), filter.getIsHidden(), filter.getIsWaiting(), filter.getUserLogin()).toString();
        if (!sqlQuery.isEmpty()) {
            strBuilder.append(" AND (").append(sqlQuery).append(")");
        }
        if (hasOrder) {
            strBuilder.append(" ORDER BY ").append("exo:createdDate").append(" ASC");
        }
        return strBuilder.toString();
    }

    @Override
    public List<Post> getPosts(PostFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.makePostsSQLQuery(filter, true), offset, limit, false);
            return this.getPosts(iter);
        }
        catch (Exception e) {
            JCRDataStorage.logDebug("Failed to get posts by filter of topic " + filter.getTopicId(), e);
            return new ArrayList<Post>();
        }
    }

    private List<Post> getPosts(NodeIterator iter) throws Exception {
        Node currentNode = null;
        ArrayList<Post> posts = new ArrayList<Post>((int)iter.getSize());
        DataStorage dataStorage = this.getCachedDataStorage();
        boolean hasCache = dataStorage instanceof CachedDataStorage;
        while (iter.hasNext()) {
            currentNode = iter.nextNode();
            if (hasCache) {
                String topicId;
                String forumId;
                CachedDataStorage storage = (CachedDataStorage)dataStorage;
                String path = currentNode.getPath();
                String categoryId = Utils.getCategoryId(path);
                Post post = storage.getPostFromCache(categoryId, forumId = Utils.getForumId(path), topicId = Utils.getTopicId(path), currentNode.getName());
                if (post == null) {
                    post = this.getPost(currentNode);
                    storage.putPost(post);
                }
                posts.add(post);
                continue;
            }
            posts.add(this.getPost(currentNode));
        }
        return posts;
    }

    @Override
    public int getPostsCount(PostFilter filter) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            if (filter.isSplit()) {
                return (int)this.getNodeIteratorBySQLQuery(sProvider, this.makePostsSplitSQLQuery(filter, false), 0, 0, false).getSize();
            }
            if (!Utils.isEmpty(filter.userName())) {
                return (int)this.getNodeIteratorBySQLQuery(sProvider, this.queryPostsByUser(filter, false), 0, 0, false).getSize();
            }
            if (!Utils.isEmpty(filter.getIP())) {
                return (int)this.getNodeIteratorBySQLQuery(sProvider, this.queryPostsByIP(filter, false), 0, 0, false).getSize();
            }
            return (int)this.getNodeIteratorBySQLQuery(sProvider, this.makePostsSQLQuery(filter, false), 0, 0, false).getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public long getAvailablePost(String categoryId, String forumId, String topicId, String isApproved, String isHidden, String userLogin) throws Exception {
        PostFilter filter = new PostFilter(categoryId, forumId, topicId, isApproved, isHidden, isHidden, userLogin);
        return this.getPostsCount(filter);
    }

    @Override
    public JCRPageList getPagePostByUser(String userName, String userId, boolean isMod, String strOrderBy) throws Exception {
        if (Utils.isEmpty(userName)) {
            throw new NullPointerException("userName");
        }
        if (Utils.isEmpty(userId)) {
            throw new NullPointerException("userLogin");
        }
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String query = this.queryPostsByUser(new PostFilter(userName, userId, isMod, strOrderBy), true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, query, 0, 0, false);
            return new ForumPageList(iter, 10, query, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String queryPostsByUser(PostFilter filter, boolean hasOrder) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append("exo:post");
        sqlQuery.append(" WHERE ").append(Utils.getSQLQueryByProperty("", "exo:isFirstPost", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:owner", filter.userName()));
        if (!filter.isAdmin()) {
            sqlQuery.append(Utils.getSQLQueryByProperty("AND", "exo:isApproved", "true")).append(Utils.getSQLQueryByProperty("AND", "exo:isHidden", "false")).append(Utils.getSQLQueryByProperty("AND", "exo:isActiveByTopic", "true")).append(Utils.getSQLQueryByProperty("AND", "exo:isWaiting", "false"));
        }
        sqlQuery.append(" AND (").append(Utils.getSQLQueryByProperty("", "exo:userPrivate", filter.getUserLogin())).append(Utils.getSQLQueryByProperty("OR", "exo:userPrivate", "exoUserPri")).append(")");
        if (hasOrder) {
            sqlQuery.append(" ORDER BY ");
            if (!Utils.isEmpty(filter.orderBy())) {
                sqlQuery.append(filter.orderBy());
                if (filter.orderBy().indexOf("exo:createdDate") < 0) {
                    sqlQuery.append(", ").append("exo:createdDate").append(" DESC");
                }
            } else {
                sqlQuery.append("exo:createdDate").append(" DESC");
            }
        }
        return sqlQuery.toString();
    }

    public List<Post> getPostsByUser(PostFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String sqlQuery = this.queryPostsByUser(filter, true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, sqlQuery, offset, limit, false);
            return this.getPosts(iter);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Post getPost(String categoryId, String forumId, String topicId, String postId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node postNode;
            Node categoryHome = this.getCategoryHome(sProvider);
            if (postId.lastIndexOf("/") > 0) {
                if (postId.indexOf(categoryHome.getName()) < 0) {
                    postId = categoryHome.getPath() + "/" + postId;
                }
                postNode = (Node)categoryHome.getSession().getItem(postId);
            } else {
                postNode = categoryHome.getNode(categoryId + "/" + forumId + "/" + topicId + "/" + postId);
            }
            return this.getPost(postNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public JCRPageList getListPostsByIP(String ip, String strOrderBy) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String pathQuery = this.queryPostsByIP(new PostFilter(ip, strOrderBy), true);
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, pathQuery, 0, 0, false);
            return new ForumPageList(iter, 5, pathQuery, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String queryPostsByIP(PostFilter filter, boolean hasOrder) {
        StringBuilder sqlQuery = new StringBuilder("SELECT ").append("exo:remoteAddr").append(" FROM ").append("exo:post");
        sqlQuery.append(" WHERE ").append(Utils.getSQLQueryByProperty("", "exo:remoteAddr", filter.getIP()));
        if (hasOrder) {
            if (Utils.isEmpty(filter.orderBy())) {
                sqlQuery.append("  ORDER BY ").append("exo:lastPostDate").append(" DESC");
            } else {
                sqlQuery.append(" ORDER BY exo:").append(filter.orderBy());
                if ("exo:lastPostDate".indexOf(filter.orderBy()) < 0) {
                    sqlQuery.append(", ").append("exo:lastPostDate").append(" DESC");
                }
            }
        }
        return sqlQuery.toString();
    }

    public List<Post> getPostsByIP(PostFilter filter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            NodeIterator iter = this.getNodeIteratorBySQLQuery(sProvider, this.queryPostsByIP(filter, true), offset, limit, false);
            ArrayList<Post> posts = new ArrayList<Post>((int)iter.getSize());
            while (iter.hasNext()) {
                Node currentNode = iter.nextNode();
                posts.add(this.getPost(currentNode));
            }
            return posts;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Post getPost(Node postNode) throws Exception {
        Post postNew = new Post();
        PropertyReader reader = new PropertyReader(postNode);
        postNew.setId(postNode.getName());
        postNew.setPath(postNode.getPath());
        postNew.setOwner(reader.string("exo:owner"));
        postNew.setCreatedDate(reader.date("exo:createdDate"));
        postNew.setModifiedBy(reader.string("exo:modifiedBy"));
        postNew.setModifiedDate(reader.date("exo:modifiedDate"));
        postNew.setEditReason(reader.string("exo:editReason"));
        postNew.setName(reader.string("exo:name"));
        postNew.setMessage(reader.string("exo:message"));
        postNew.setRemoteAddr(reader.string("exo:remoteAddr"));
        postNew.setIcon(reader.string("exo:icon"));
        postNew.setLink(reader.string("exo:link"));
        postNew.setIsApproved(reader.bool("exo:isApproved"));
        postNew.setIsHidden(reader.bool("exo:isHidden"));
        postNew.setIsWaiting(reader.bool("exo:isWaiting"));
        postNew.setFirstPost(reader.bool("exo:isFirstPost"));
        postNew.setIsActiveByTopic(reader.bool("exo:isActiveByTopic"));
        postNew.setUserPrivate(reader.strings("exo:userPrivate"));
        postNew.setNumberAttach(reader.l("exo:numberAttach"));
        if (postNew.getNumberAttach() > 0L) {
            postNew.setAttachments(JCRDataStorage.getAttachmentsByNode(postNode));
        }
        return postNew;
    }

    private static ForumAttachment getAttachment(Node nodeContent) throws Exception {
        try {
            if (nodeContent.isNodeType("exo:forumAttachment") || nodeContent.isNodeType("nt:file")) {
                BufferAttachment attachment = new BufferAttachment();
                PropertyReader readerContent = new PropertyReader(nodeContent.getNode("jcr:content"));
                attachment.setId(nodeContent.getName());
                attachment.setPathNode(nodeContent.getPath());
                attachment.setMimeType(readerContent.string("jcr:mimeType", ""));
                attachment.setSize(readerContent.stream("jcr:data").available());
                String workspace = nodeContent.getSession().getWorkspace().getName();
                attachment.setWorkspace(workspace);
                attachment.setPath("/" + workspace + nodeContent.getPath());
                String fileName = readerContent.string("exo:fileName");
                if (CommonUtils.isEmpty((String)fileName)) {
                    String type = attachment.getMimeType();
                    if (type.indexOf("/") > 0) {
                        type = type.substring(type.indexOf("/") + 1);
                    }
                    fileName = "avatar." + type;
                }
                attachment.setName(fileName);
                return attachment;
            }
        }
        catch (Exception e) {
            JCRDataStorage.logDebug("Failed to get attachment in node: " + nodeContent.getName());
        }
        return null;
    }

    public static List<ForumAttachment> getAttachmentsByNode(Node node) throws Exception {
        ArrayList<ForumAttachment> attachments = new ArrayList<ForumAttachment>();
        NodeIterator postAttachments = node.getNodes();
        while (postAttachments.hasNext()) {
            Node nodeAttatch = postAttachments.nextNode();
            ForumAttachment attachment = JCRDataStorage.getAttachment(nodeAttatch);
            if (attachment == null) continue;
            attachments.add(attachment);
        }
        return attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProfileAddPost(String owner, String postPath) {
        ReentrantLock lock = this.lock;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            lock.lock();
            Node profileHomeNode = this.getUserProfileHome(sProvider);
            Calendar lastPost = this.getGreenwichMeanTime();
            Node postNode = (Node)profileHomeNode.getSession().getItem(postPath);
            PropertyReader reader = new PropertyReader(postNode);
            lastPost.setTime(reader.date("exo:createdDate", lastPost.getTime()));
            if (profileHomeNode.hasNode(owner)) {
                Node profileNode = profileHomeNode.getNode(owner);
                long totalPostByUser = 0L;
                totalPostByUser = profileNode.getProperty("exo:totalPost").getLong();
                profileNode.setProperty("exo:totalPost", totalPostByUser + 1L);
                profileNode.setProperty("exo:lastPostDate", lastPost);
            } else if (!Utils.isEmpty(owner)) {
                Node profileNode = profileHomeNode.addNode(owner, "exo:forumUserProfile");
                profileNode.setProperty("exo:userId", owner);
                profileNode.setProperty("exo:userTitle", Utils.USER);
                if (this.isAdminRole(sProvider, owner)) {
                    profileNode.setProperty("exo:userTitle", Utils.ADMIN);
                }
                profileNode.setProperty("exo:totalPost", 1L);
                profileNode.setProperty("exo:lastPostDate", lastPost);
            }
            profileHomeNode.getSession().save();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to save user profile of user: " + owner), (Throwable)e);
        }
        finally {
            lock.unlock();
            sProvider.close();
        }
    }

    private void postSaveProperties(Node postNode, Post post) throws Exception {
        if (post.getModifiedBy() != null && post.getModifiedBy().length() > 0) {
            postNode.setProperty("exo:modifiedBy", post.getModifiedBy());
            postNode.setProperty("exo:modifiedDate", this.getGreenwichMeanTime());
            postNode.setProperty("exo:editReason", post.getEditReason());
        }
        postNode.setProperty("exo:name", post.getName());
        postNode.setProperty("exo:message", post.getMessage());
        postNode.setProperty("exo:remoteAddr", post.getRemoteAddr());
        postNode.setProperty("exo:icon", post.getIcon());
        postNode.setProperty("exo:isApproved", post.getIsApproved());
        postNode.setProperty("exo:isHidden", post.getIsHidden());
        postNode.setProperty("exo:isWaiting", post.getIsWaiting());
        postNode.setProperty("exo:numberAttach", post.getNumberAttach());
    }

    private List<String> postAttachment(Node postNode, Post post) {
        ArrayList<String> listFileName = new ArrayList<String>();
        List<ForumAttachment> attachments = post.getAttachments();
        if (attachments != null) {
            Iterator<ForumAttachment> it = attachments.iterator();
            for (ForumAttachment attachment : attachments) {
                BufferAttachment file = null;
                listFileName.add(attachment.getId());
                try {
                    file = (BufferAttachment)it.next();
                    Node nodeFile = null;
                    nodeFile = !postNode.hasNode(file.getId()) ? postNode.addNode(file.getId(), "exo:forumAttachment") : postNode.getNode(file.getId());
                    ForumServiceUtils.reparePermissions(nodeFile, "any");
                    Node nodeContent = null;
                    if (nodeFile.hasNode("jcr:content")) continue;
                    nodeContent = nodeFile.addNode("jcr:content", "exo:forumResource");
                    nodeContent.setProperty("jcr:mimeType", file.getMimeType());
                    nodeContent.setProperty("jcr:data", file.getInputStream());
                    nodeContent.setProperty("jcr:lastModified", this.getGreenwichMeanTime().getTimeInMillis());
                    nodeContent.setProperty("exo:fileName", file.getName());
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to save attachment", (Throwable)e);
                }
            }
        }
        return listFileName;
    }

    @Override
    public void savePost(String categoryId, String forumId, String topicId, Post post, boolean isNew, MessageBuilder messageBuilder) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            boolean sendAlertJob;
            Node categoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Node forumNode = categoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Node postNode = isNew ? this.addPost(sProvider, categoryNode, forumNode, topicNode, post) : this.updatePost(sProvider, topicNode, post);
            try {
                forumNode.getSession().save();
            }
            catch (InvalidItemStateException e) {
                LOG.warn((Object)"Probably was save post by another session");
                post = null;
                return;
            }
            if (isNew) {
                this.addQueryLastPostTask(forumNode.getPath());
            }
            post.setPath(postNode.getPath());
            boolean bl = sendAlertJob = !messageBuilder.getLink().equals("link") && post.getUserPrivate().length != 2 && (!post.getIsApproved() || post.getIsHidden() || post.getIsWaiting());
            if (!topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId()) && isNew) {
                this.addNotificationTask(topicNode.getPath(), null, post, messageBuilder, !sendAlertJob);
            }
            if (sendAlertJob) {
                this.getTotalJobWatting(sProvider, new HashSet<String>(new PropertyReader(forumNode).list("exo:moderators", new ArrayList())));
            }
            if (post != null && post.getUserPrivate().length > 1) {
                ForumPrivateMessage message = new ForumPrivateMessage();
                message.setFrom(post.getOwner());
                message.setSendTo(post.getUserPrivate()[0] + "," + post.getUserPrivate()[1]);
                message.setType("PrivatePost");
                message.setName(post.getName());
                message.setMessage(post.getMessage());
                message.setId(topicId + "/" + post.getId());
                this.sendNotificationMessage(message);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to save post " + post.getName()), (Throwable)e);
            post = null;
        }
    }

    private Node addPost(SessionProvider sProvider, Node categoryNode, Node forumNode, Node topicNode, Post post) throws Exception {
        Node postNode = topicNode.addNode(post.getId(), "exo:post");
        Calendar calendar = this.getGreenwichMeanTime();
        postNode.setProperty("exo:id", post.getId());
        postNode.setProperty("exo:path", forumNode.getName());
        postNode.setProperty("exo:owner", post.getOwner());
        post.setCreatedDate(calendar.getTime());
        postNode.setProperty("exo:createdDate", calendar);
        postNode.setProperty("exo:userPrivate", post.getUserPrivate());
        postNode.setProperty("exo:link", CommonUtils.getURI((String)post.getLink()));
        boolean isFistPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId());
        postNode.setProperty("exo:isFirstPost", isFistPost);
        this.postSaveProperties(postNode, post);
        this.postAttachment(postNode, post);
        return postNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePostCount(String postPath, String owner) throws Exception {
        ReentrantLock localLock = this.lock;
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            localLock.lock();
            Session session = this.sessionManager.getSession(sProvider);
            Node postNode = (Node)session.getItem(postPath);
            Node topicNode = postNode.getParent();
            Node forumNode = topicNode.getParent();
            boolean isFirstPost = topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(postNode.getName());
            PropertyReader postRead = new PropertyReader(postNode);
            PropertyReader topicRead = new PropertyReader(topicNode);
            PropertyReader forumRead = new PropertyReader(forumNode);
            long topicPostCount = topicRead.l("exo:postCount") + 1L;
            long newNumberAttach = topicRead.l("exo:numberAttachments") + postRead.l("exo:numberAttach");
            boolean topicActive = topicRead.bool("exo:isClosed") == false && topicRead.bool("exo:isWaiting") == false && topicRead.bool("exo:isApproved") != false && topicRead.bool("exo:isActive") != false && topicRead.bool("exo:isActiveByForum") != false;
            boolean postActive = postRead.bool("exo:isApproved") != false && postRead.bool("exo:isHidden") == false && postRead.bool("exo:isWaiting") == false && postRead.list("exo:userPrivate").size() != 2;
            postNode.setProperty("exo:isActiveByTopic", topicActive || isFirstPost);
            if (isFirstPost && !forumRead.bool("exo:isModerateTopic").booleanValue() || !isFirstPost && topicActive) {
                long forumPostCount = forumRead.l("exo:postCount") + 1L;
                forumNode.setProperty("exo:postCount", Math.max(forumPostCount, 1L));
            }
            if (postActive) {
                topicNode.setProperty("exo:postCount", Math.max(topicPostCount, 0L));
                topicNode.setProperty("exo:lastPostDate", this.getGreenwichMeanTime());
                topicNode.setProperty("exo:lastPostBy", owner);
                topicNode.setProperty("exo:numberAttachments", newNumberAttach);
            }
            session.save();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to update forum post count when save post");
        }
        finally {
            sProvider.close();
            localLock.unlock();
        }
    }

    private Node updatePost(SessionProvider sProvider, Node topicNode, Post post) throws Exception {
        Node postNode = topicNode.getNode(post.getId());
        long oldNumberAttachments = postNode.getProperty("exo:numberAttach").getLong();
        this.postSaveProperties(postNode, post);
        List<String> listFileName = this.postAttachment(postNode, post);
        NodeIterator postAttachments = postNode.getNodes();
        Node postAttachmentNode = null;
        while (postAttachments.hasNext()) {
            postAttachmentNode = postAttachments.nextNode();
            if (listFileName.contains(postAttachmentNode.getName())) continue;
            postAttachmentNode.remove();
        }
        long temp = topicNode.getProperty("exo:numberAttachments").getLong() - oldNumberAttachments;
        topicNode.setProperty("exo:numberAttachments", temp + post.getNumberAttach());
        return postNode;
    }

    private boolean hasProperty(Node node, String property) throws Exception {
        String[] strs = new PropertyReader(node).strings(property, new String[0]);
        return strs.length > 0;
    }

    private void addNotificationTask(String nodePath, Topic topic, Post post, MessageBuilder messageBuilder, boolean isApprovePost) throws Exception {
        SendNotificationTaskManager sendNotificationManager = this.getSendNotificationTaskManager();
        if (sendNotificationManager != null) {
            sendNotificationManager.addTask(new AbstractForumTask.SendNotificationTask(nodePath, topic, post, messageBuilder, isApprovePost));
        }
    }

    private boolean canReceiveNotification(Node topicNode, String user) throws Exception {
        Node forumNode = topicNode.getParent();
        PropertyReader reader = new PropertyReader(forumNode);
        Set viewers = new PropertyReader(topicNode).set("exo:canView", new HashSet());
        viewers.addAll(reader.set("exo:viewer", new HashSet()));
        String[] moderators = reader.strings("exo:moderateForums", new String[0]);
        if (forumNode.getParent().getName().equals(Utils.CATEGORY_SPACE_ID_PREFIX)) {
            if (!CommonUtils.isEmpty((String[])moderators) && ForumServiceUtils.hasPermission(moderators, user)) {
                return true;
            }
        } else {
            if (this.isAdminRole(user) || !CommonUtils.isEmpty((String[])moderators) && ForumServiceUtils.hasPermission(moderators, user)) {
                return true;
            }
            String[] userPrivates = new PropertyReader(forumNode.getParent()).strings("exo:userPrivate", new String[0]);
            if (!ForumServiceUtils.hasPermission(userPrivates, user)) {
                return false;
            }
            viewers.addAll(new PropertyReader(forumNode.getParent()).list("exo:viewer", new ArrayList()));
        }
        return ForumServiceUtils.hasPermission(viewers.toArray(new String[viewers.size()]), user);
    }

    private void sendNotificationWhenCreateTopic(SessionProvider sProvider, Node forumNode, Topic topic, MessageBuilder messageBuilder) throws Exception {
        messageBuilder.setForumName(forumNode.getProperty("exo:name").getString());
        Node categoryNode = forumNode.getParent();
        messageBuilder.setCatName(categoryNode.getProperty("exo:name").getString());
        messageBuilder.setTopicName(topic.getTopicName());
        ArrayList<String> emailList = new ArrayList<String>();
        ArrayList<String> emailListCate = new ArrayList<String>();
        Node node = categoryNode;
        Node topicNode = forumNode.getNode(topic.getId());
        while (true) {
            emailListCate.addAll(emailList);
            emailList = new ArrayList();
            if (node.isNodeType("exo:forumWatching") && topic.getIsActive() && topic.getIsApproved() && topic.getIsActiveByForum() && !topic.getIsClosed() && !topic.getIsLock() && !topic.getIsWaiting()) {
                PropertyReader reader = new PropertyReader(node);
                List users = reader.list("exo:userWatching", new ArrayList());
                if (!users.isEmpty()) {
                    int i = 0;
                    String[] emails = reader.strings("exo:emailWatching", new String[0]);
                    for (String user : users) {
                        if (user.equals(topic.getOwner()) || this.canReceiveNotification(topicNode, user)) {
                            emailList.add(emails[i]);
                        }
                        ++i;
                    }
                }
                emailList.addAll(reader.list("exo:notifyWhenAddTopic", new ArrayList()));
            }
            emailList.removeAll(emailListCate);
            if (emailList.size() > 0) {
                String owner = this.getScreenName(sProvider, topic.getOwner());
                messageBuilder.setObjName(node.getProperty("exo:name").getString());
                if (node.isNodeType("exo:forum")) {
                    messageBuilder.setWatchType(Utils.FORUM);
                } else {
                    messageBuilder.setWatchType(Utils.CATEGORY);
                }
                messageBuilder.setId(topic.getId().replaceFirst(Utils.TOPIC, Utils.POST));
                messageBuilder.setAddType(Utils.TOPIC);
                messageBuilder.setAddName(topic.getTopicName());
                messageBuilder.setMessage(topic.getDescription());
                messageBuilder.setCreatedDate(topic.getCreatedDate());
                messageBuilder.setOwner(CommonUtils.decodeSpecialCharToHTMLnumber((String)owner));
                if (Utils.isEmpty(messageBuilder.getLink())) {
                    messageBuilder.setLink(topic.getLink());
                }
                this.sendEmailNotification(emailList, messageBuilder.getContentEmail());
            }
            if (node.isNodeType("exo:forum")) break;
            node = forumNode;
        }
    }

    private void sendNotificationWhenCreatePost(SessionProvider sProvider, Node topicNode, Post post, MessageBuilder messageBuilder, boolean isApprovePost) throws Exception {
        if (!topicNode.getName().replaceFirst(Utils.TOPIC, Utils.POST).equals(post.getId())) {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            Node forumNode = topicNode.getParent();
            Node categoryNode = forumNode.getParent();
            messageBuilder.setCatName(categoryNode.getProperty("exo:name").getString());
            messageBuilder.setForumName(forumNode.getProperty("exo:name").getString());
            messageBuilder.setTopicName(topicNode.getProperty("exo:name").getString());
            if (post.getIsApproved() && post.getIsActiveByTopic() && !post.getIsHidden() && !post.getIsWaiting()) {
                ArrayList<String> userPrivates = new ArrayList<String>();
                if (!CommonUtils.isEmpty((String[])post.getUserPrivate()) && post.getUserPrivate().length == 2) {
                    userPrivates.addAll(Arrays.asList(post.getUserPrivate()));
                }
                PropertyReader catReader = new PropertyReader(categoryNode);
                PropertyReader forumReader = new PropertyReader(forumNode);
                PropertyReader topicReader = new PropertyReader(topicNode);
                List emailListCategory = catReader.list("exo:emailWatching", new ArrayList());
                List emailListForum = forumReader.list("exo:emailWatching", new ArrayList());
                List emailListTopic = topicReader.list("exo:emailWatching", new ArrayList());
                List userListCategory = catReader.list("exo:userWatching", new ArrayList());
                List userListForum = forumReader.list("exo:userWatching", new ArrayList());
                List userListTopic = topicReader.list("exo:userWatching", new ArrayList());
                int i = 0;
                ArrayList removeEmail = new ArrayList();
                for (String user : userListCategory) {
                    if (!this.canReceiveNotification(topicNode, user)) {
                        removeEmail.add(emailListCategory.get(i));
                    }
                    ++i;
                }
                emailListCategory.removeAll(removeEmail);
                removeEmail.clear();
                i = 0;
                for (String user : userListForum) {
                    if (userListCategory.contains(user) || !this.canReceiveNotification(topicNode, user)) {
                        removeEmail.add(emailListForum.get(i));
                    }
                    ++i;
                }
                emailListForum.removeAll(removeEmail);
                removeEmail.clear();
                i = 0;
                for (String user : userListTopic) {
                    if (userListCategory.contains(user) || userListForum.contains(user) || !this.canReceiveNotification(topicNode, user)) {
                        removeEmail.add(emailListTopic.get(i));
                    }
                    ++i;
                }
                emailListTopic.removeAll(removeEmail);
                if (isApprovePost) {
                    String owner = topicReader.string("exo:owner");
                    String ownerTopicEmail = topicReader.string("exo:isNotifyWhenAddPost", "");
                    if (!CommonUtils.isEmpty((String)ownerTopicEmail)) {
                        try {
                            Node userOwner = userProfileHome.getNode(owner);
                            PropertyReader userReader = new PropertyReader(userOwner);
                            String email = userReader.string("exo:email", "");
                            if (userReader.bool("exo:isBanned").booleanValue()) {
                                ownerTopicEmail = "";
                            } else if (!Utils.isEmpty(email)) {
                                ownerTopicEmail = email;
                            }
                        }
                        catch (PathNotFoundException e) {
                            ownerTopicEmail = "";
                        }
                    }
                    if (!CommonUtils.isEmpty((String)ownerTopicEmail)) {
                        emailListTopic.add(ownerTopicEmail);
                    }
                }
                emailListForum.addAll(forumReader.list("exo:notifyWhenAddPost", new ArrayList()));
                String fullName = this.getScreenName(sProvider, post.getOwner());
                messageBuilder.setOwner(CommonUtils.decodeSpecialCharToHTMLnumber((String)fullName));
                messageBuilder.setId(post.getId());
                messageBuilder.setAddType(Utils.POST);
                messageBuilder.setAddName(post.getName());
                messageBuilder.setMessage(post.getMessage());
                messageBuilder.setCreatedDate(post.getCreatedDate());
                if (Utils.isEmpty(messageBuilder.getLink())) {
                    messageBuilder.setLink(post.getLink());
                }
                if (emailListCategory.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getCatName());
                    messageBuilder.setWatchType(Utils.CATEGORY);
                    this.sendEmailNotification(emailListCategory, messageBuilder.getContentEmail());
                }
                if (emailListForum.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getForumName());
                    messageBuilder.setWatchType(Utils.FORUM);
                    this.sendEmailNotification(emailListForum, messageBuilder.getContentEmail());
                }
                if (emailListTopic.size() > 0) {
                    messageBuilder.setObjName(messageBuilder.getTopicName());
                    messageBuilder.setWatchType(Utils.TOPIC);
                    this.sendEmailNotification(emailListTopic, messageBuilder.getContentEmail());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(String nodePath, Topic topic, Post post, MessageBuilder messageBuilder, boolean isApprovePost) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Session session = this.sessionManager.getSession(sProvider);
            if (!session.itemExists(nodePath)) {
                return;
            }
            Node node = (Node)session.getItem(nodePath);
            messageBuilder = this.getInfoMessageMove(sProvider, messageBuilder.getContent(), messageBuilder.getHeaderSubject(), false);
            if (post == null) {
                this.sendNotificationWhenCreateTopic(sProvider, node, topic, messageBuilder);
            } else {
                this.sendNotificationWhenCreatePost(sProvider, node, post, messageBuilder, isApprovePost);
            }
        }
    }

    @Override
    public void modifyPost(List<Post> posts, int type) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumHomeNode = this.getForumHomeNode(sProvider);
            for (Post post : posts) {
                try {
                    String postPath = post.getPath();
                    String topicPath = postPath.substring(0, postPath.lastIndexOf("/"));
                    String forumPath = postPath.substring(0, topicPath.lastIndexOf("/"));
                    Node postNode = (Node)forumHomeNode.getSession().getItem(postPath);
                    PropertyReader postReader = new PropertyReader(postNode);
                    Node topicNode = (Node)forumHomeNode.getSession().getItem(topicPath);
                    Node forumNode = (Node)forumHomeNode.getSession().getItem(forumPath);
                    Calendar lastPostDate = topicNode.getProperty("exo:lastPostDate").getDate();
                    Calendar postDate = postReader.calendar("exo:createdDate");
                    long topicPostCount = topicNode.getProperty("exo:postCount").getLong();
                    long newNumberAttach = topicNode.getProperty("exo:numberAttachments").getLong();
                    long forumPostCount = forumNode.getProperty("exo:postCount").getLong();
                    switch (type) {
                        case 3: {
                            postNode.setProperty("exo:isApproved", true);
                            post.setIsApproved(true);
                            this.addNotificationTask(topicNode.getPath(), null, post, new MessageBuilder(), true);
                            break;
                        }
                        case 5: {
                            PropertyReader postLastNodeReader;
                            Node postLastNode;
                            if (post.getIsWaiting()) {
                                postNode.setProperty("exo:isWaiting", true);
                                postLastNode = this.getLastDatePost(forumHomeNode, topicNode, postNode);
                                postLastNodeReader = new PropertyReader(postLastNode);
                                if (postLastNode != null) {
                                    topicNode.setProperty("exo:lastPostDate", postLastNodeReader.calendar("exo:createdDate"));
                                    topicNode.setProperty("exo:lastPostBy", postLastNodeReader.string("exo:owner"));
                                }
                                if ((newNumberAttach -= postReader.l("exo:numberAttach")) < 0L) {
                                    newNumberAttach = 0L;
                                }
                                topicNode.setProperty("exo:numberAttachments", newNumberAttach);
                                topicNode.setProperty("exo:postCount", topicPostCount - 1L);
                                forumNode.setProperty("exo:postCount", forumPostCount - 1L);
                                break;
                            }
                            postNode.setProperty("exo:isWaiting", false);
                            topicNode.setProperty("exo:lastPostDate", postReader.calendar("exo:createdDate"));
                            topicNode.setProperty("exo:lastPostBy", postReader.string("exo:owner"));
                            topicNode.setProperty("exo:numberAttachments", newNumberAttach += postReader.l("exo:numberAttach"));
                            topicNode.setProperty("exo:postCount", topicPostCount + 1L);
                            this.addNotificationTask(topicNode.getPath(), null, post, new MessageBuilder(), false);
                            break;
                        }
                        case 9: {
                            PropertyReader postLastNodeReader;
                            Node postLastNode;
                            if (post.getIsHidden()) {
                                postNode.setProperty("exo:isHidden", true);
                                postLastNode = this.getLastDatePost(forumHomeNode, topicNode, postNode);
                                postLastNodeReader = new PropertyReader(postLastNode);
                                if (postLastNode != null) {
                                    topicNode.setProperty("exo:lastPostDate", postLastNodeReader.calendar("exo:createdDate"));
                                    topicNode.setProperty("exo:lastPostBy", postLastNodeReader.string("exo:owner"));
                                }
                                topicNode.setProperty("exo:numberAttachments", Math.max(newNumberAttach -= postReader.l("exo:numberAttach"), 0L));
                                topicNode.setProperty("exo:postCount", topicPostCount - 1L);
                                forumNode.setProperty("exo:postCount", forumPostCount - 1L);
                                break;
                            }
                            postNode.setProperty("exo:isHidden", false);
                            this.addNotificationTask(topicNode.getPath(), null, post, new MessageBuilder(), false);
                            break;
                        }
                    }
                    if (!post.getIsHidden() && post.getIsApproved() && 5 != type) {
                        if (postDate.getTimeInMillis() > lastPostDate.getTimeInMillis()) {
                            topicNode.setProperty("exo:lastPostDate", postDate);
                            topicNode.setProperty("exo:lastPostBy", post.getOwner());
                        }
                        topicNode.setProperty("exo:numberAttachments", newNumberAttach += postReader.l("exo:numberAttach"));
                        topicNode.setProperty("exo:postCount", topicPostCount + 1L);
                        forumNode.setProperty("exo:postCount", forumPostCount + 1L);
                    }
                    if (forumNode.isNew()) {
                        forumNode.getSession().save();
                    } else {
                        forumNode.save();
                    }
                    this.getTotalJobWatting(sProvider, new HashSet<String>(new PropertyReader(forumNode).list("exo:moderators", new ArrayList())));
                }
                catch (PathNotFoundException e) {
                    LOG.error((Object)("Failed to modify post" + post.getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to modify posts", (Throwable)e);
        }
    }

    private Node getLastDatePost(Node forumHomeNode, Node node, Node postNode_) throws Exception {
        QueryManager qm = forumHomeNode.getSession().getWorkspace().getQueryManager();
        StringBuffer pathQuery = new StringBuffer();
        pathQuery.append("/jcr:root").append(node.getPath()).append("/element(*,exo:post)[@exo:isHidden='false' and @exo:isApproved='true'] order by @exo:createdDate descending");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node postNode = null;
        while (iter.hasNext() && (postNode = iter.nextNode()).getName().equals(postNode_.getName())) {
        }
        return postNode;
    }

    @Override
    public Post removePost(String categoryId, String forumId, String topicId, String postId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node CategoryNode = this.getCategoryHome(sProvider).getNode(categoryId);
            Post post = this.getPost(categoryId, forumId, topicId, postId);
            Node forumNode = CategoryNode.getNode(forumId);
            Node topicNode = forumNode.getNode(topicId);
            Node postNode = topicNode.getNode(postId);
            long numberAttachs = postNode.getProperty("exo:numberAttach").getLong();
            String owner = postNode.getProperty("exo:owner").getString();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                Node newProfileNode = userProfileNode.getNode(owner);
                newProfileNode.setProperty("exo:totalPost", newProfileNode.getProperty("exo:totalPost").getLong() - 1L);
                newProfileNode.save();
            }
            catch (PathNotFoundException e) {
                LOG.debug((Object)"Failed to save category moderators ", (Throwable)e);
            }
            postNode.remove();
            if (!(post.getIsHidden() || !post.getIsApproved() || post.getIsWaiting() || post.getUserPrivate() != null && post.getUserPrivate().length != 1)) {
                long topicPostCount = topicNode.getProperty("exo:postCount").getLong() - 1L;
                topicNode.setProperty("exo:postCount", topicPostCount);
                long newNumberAttachs = topicNode.getProperty("exo:numberAttachments").getLong();
                newNumberAttachs = newNumberAttachs > numberAttachs ? (newNumberAttachs -= numberAttachs) : 0L;
                topicNode.setProperty("exo:numberAttachments", newNumberAttachs);
            }
            NodeIterator nodeIterator = topicNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.isNodeType("exo:post")) continue;
                postNode = node;
            }
            topicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
            topicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
            forumNode.save();
            if (!post.getIsHidden() && post.getIsApproved() && (post.getUserPrivate() == null || post.getUserPrivate().length == 1)) {
                long forumPostCount = forumNode.getProperty("exo:postCount").getLong() - 1L;
                forumNode.setProperty("exo:postCount", forumPostCount);
                forumNode.save();
            } else if (post.getUserPrivate() == null || post.getUserPrivate().length == 1) {
                this.getTotalJobWatting(sProvider, new HashSet<String>(new PropertyReader(forumNode).list("exo:moderators", new ArrayList())));
            }
            return post;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove post in topic.");
            return null;
        }
    }

    @Override
    public void movePost(String[] postPaths, String destTopicPath, boolean isCreatNewTopic, String mailContent, String link) throws Exception {
        PropertyReader destTopicReader;
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node forumHomeNode = this.getForumHomeNode(sProvider);
        String srcTopicPath = postPaths[0];
        srcTopicPath = srcTopicPath.substring(0, srcTopicPath.lastIndexOf("/"));
        Node srcTopicNode = (Node)forumHomeNode.getSession().getItem(srcTopicPath);
        Node srcForumNode = srcTopicNode.getParent();
        Node destTopicNode = (Node)forumHomeNode.getSession().getItem(destTopicPath);
        Node destForumNode = destTopicNode.getParent();
        long totalAtt = 0L;
        long totalpost = postPaths.length;
        Node postNode = null;
        boolean destModeratePost = false;
        if (destTopicNode.hasProperty("exo:isModeratePost")) {
            destModeratePost = destTopicNode.getProperty("exo:isModeratePost").getBoolean();
        }
        boolean srcModeratePost = false;
        if (srcTopicNode.hasProperty("exo:isModeratePost")) {
            srcModeratePost = srcTopicNode.getProperty("exo:isModeratePost").getBoolean();
        }
        boolean isActiveByTopic = (destTopicReader = new PropertyReader(destTopicNode)).bool("exo:isApproved") != false && destTopicReader.bool("exo:isActive") != false && destTopicReader.bool("exo:isActiveByForum") != false && destTopicReader.bool("exo:isClosed") == false && destTopicReader.bool("exo:isWaiting") == false;
        boolean unAproved = false;
        int i = 0;
        while ((long)i < totalpost) {
            String path = postPaths[i];
            String newPostPath = destTopicPath + path.substring(path.lastIndexOf("/"));
            forumHomeNode.getSession().getWorkspace().move(path, newPostPath);
            postPaths[i] = newPostPath;
            postNode = (Node)forumHomeNode.getSession().getItem(newPostPath);
            postNode.setProperty("exo:path", destForumNode.getName());
            postNode.setProperty("exo:createdDate", this.getGreenwichMeanTime());
            postNode.setProperty("exo:link", CommonUtils.getURI((String)link.replace("pathId", destTopicNode.getName())));
            if (isCreatNewTopic && i == 0) {
                postNode.setProperty("exo:isFirstPost", true);
            } else {
                postNode.setProperty("exo:isFirstPost", false);
            }
            if (!destModeratePost) {
                postNode.setProperty("exo:isApproved", true);
            } else if (!postNode.getProperty("exo:isApproved").getBoolean()) {
                unAproved = true;
            }
            postNode.setProperty("exo:isActiveByTopic", isActiveByTopic);
            ++i;
        }
        destTopicNode.setProperty("exo:numberAttachments", destTopicNode.getProperty("exo:numberAttachments").getLong() + totalAtt);
        destTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
        destTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
        long temp = srcTopicNode.getProperty("exo:postCount").getLong();
        srcTopicNode.setProperty("exo:postCount", Math.max(temp -= totalpost, -1L));
        temp = srcTopicNode.getProperty("exo:numberAttachments").getLong();
        srcTopicNode.setProperty("exo:numberAttachments", Math.max(temp -= totalAtt, 0L));
        NodeIterator nodeIterator = srcTopicNode.getNodes();
        long posLast = nodeIterator.getSize() - 1L;
        nodeIterator.skip(posLast);
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            if (!node.isNodeType("exo:post")) continue;
            postNode = node;
        }
        srcTopicNode.setProperty("exo:lastPostBy", postNode.getProperty("exo:owner").getValue().getString());
        srcTopicNode.setProperty("exo:lastPostDate", postNode.getProperty("exo:createdDate").getValue().getDate());
        temp = srcForumNode.getProperty("exo:postCount").getLong();
        srcForumNode.setProperty("exo:postCount", Math.max(temp -= totalpost, 0L));
        if (forumHomeNode.isNew()) {
            forumHomeNode.getSession().save();
        } else {
            forumHomeNode.save();
        }
        String categoryName = destForumNode.getParent().getProperty("exo:name").getString();
        String forumName = destForumNode.getProperty("exo:name").getString();
        String objectName = "[" + categoryName + "][" + forumName + "] ";
        MessageBuilder messageBuilder = this.getInfoMessageMove(sProvider, mailContent, objectName, true);
        String topicName = destTopicNode.getProperty("exo:name").getString();
        String ownerTopic = destTopicNode.getProperty("exo:owner").getString();
        messageBuilder.setCatName(categoryName);
        messageBuilder.setForumName(forumName);
        messageBuilder.setTopicName("");
        messageBuilder.setOwner(CommonUtils.decodeSpecialCharToHTMLnumber((String)this.getScreenName(sProvider, ownerTopic)));
        messageBuilder.setHeaderSubject(messageBuilder.getHeaderSubject() + topicName);
        messageBuilder.setAddType(topicName);
        link = link.replaceFirst("pathId", destTopicNode.getName());
        messageBuilder.setTypes(Utils.TOPIC, Utils.POST, "", "");
        int i2 = 0;
        while ((long)i2 < totalpost) {
            postNode = (Node)forumHomeNode.getSession().getItem(postPaths[i2]);
            messageBuilder.setObjName(postNode.getProperty("exo:name").getString());
            messageBuilder.setLink(link + "/" + postNode.getName());
            HashSet<String> set = new HashSet<String>();
            set.add(this.getEmailUser(sProvider, postNode.getProperty("exo:owner").getString()));
            set.addAll(this.calculateMoveEmail(destTopicNode));
            set.addAll(this.calculateMoveEmail(srcTopicNode));
            if (!Utils.isEmpty(set.toArray(new String[set.size()]))) {
                this.sendEmailNotification(new ArrayList<String>(set), messageBuilder.getContentEmailMoved());
            }
            ++i2;
        }
        HashSet<String> userIdsp = new HashSet<String>();
        if (destModeratePost && srcModeratePost) {
            if (srcForumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(Utils.valuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
            }
            if (unAproved && destForumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(Utils.valuesToList(destForumNode.getProperty("exo:moderators").getValues()));
            }
        } else if (srcModeratePost && !destModeratePost) {
            if (srcForumNode.hasProperty("exo:moderators")) {
                userIdsp.addAll(Utils.valuesToList(srcForumNode.getProperty("exo:moderators").getValues()));
            }
        } else if (!srcModeratePost && destModeratePost && unAproved && destForumNode.hasProperty("exo:moderators")) {
            userIdsp.addAll(Utils.valuesToList(destForumNode.getProperty("exo:moderators").getValues()));
        }
        if (!userIdsp.isEmpty()) {
            this.getTotalJobWatting(sProvider, userIdsp);
        }
    }

    private MessageBuilder getInfoMessageMove(SessionProvider sProvider, String defaultContent, String defaultSubject, boolean isMove) throws Exception {
        MessageBuilder messageBuilder = new MessageBuilder();
        try {
            Node forumAdminNode = this.getAdminHome(sProvider).getNode(Utils.FORUMADMINISTRATION);
            PropertyReader reader = new PropertyReader(forumAdminNode);
            String property = isMove ? "exo:notifyEmailMoved" : "exo:notifyEmailContent";
            messageBuilder.setContent(reader.string(property, defaultContent));
            if (reader.bool("exo:enableHeaderSubject").booleanValue()) {
                messageBuilder.setHeaderSubject(reader.string("exo:headerSubject", defaultSubject));
            } else {
                messageBuilder.setHeaderSubject(defaultSubject);
            }
        }
        catch (Exception e) {
            messageBuilder.setContent(defaultContent);
            messageBuilder.setHeaderSubject(defaultSubject);
        }
        return messageBuilder;
    }

    @Override
    public void mergeTopic(String srcTopicPath, String destTopicPath, String mailContent, String link) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node srcTopicNode = this.getCategoryHome(sProvider).getNode(srcTopicPath);
        NodeIterator iter = srcTopicNode.getNodes();
        ArrayList<Post> posts = new ArrayList<Post>();
        boolean isTopicWaiting = new PropertyReader(srcTopicNode).bool("exo:isWaiting");
        while (iter.hasNext()) {
            Post post = new Post();
            Node node = iter.nextNode();
            if (!node.isNodeType("exo:post")) continue;
            if (new PropertyReader(node).bool("exo:isFirstPost").booleanValue()) {
                node.setProperty("exo:isWaiting", isTopicWaiting);
                node.save();
            }
            post.setPath(node.getPath());
            post.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
            posts.add(post);
        }
        if (posts.size() > 0) {
            Collections.sort(posts, new Utils.DatetimeComparatorPostDESC());
            String[] postPaths = new String[posts.size()];
            int i = 0;
            for (Post p : posts) {
                postPaths[i] = p.getPath();
                ++i;
            }
            this.movePost(postPaths, destTopicPath, false, mailContent, link);
            String[] ids = srcTopicPath.split("/");
            this.removeTopic(ids[0], ids[1], srcTopicNode.getName());
        }
    }

    @Override
    public void splitTopic(Topic newTopic, Post fistPost, List<String> postPathMove, String mailContent, String link) throws Exception {
        this.saveTopic(newTopic.getCategoryId(), newTopic.getForumId(), newTopic, true, true, new MessageBuilder());
        this.savePost(fistPost.getCategoryId(), fistPost.getForumId(), fistPost.getTopicId(), fistPost, false, new MessageBuilder());
        this.movePost(postPathMove.toArray(new String[postPathMove.size()]), newTopic.getPath(), true, mailContent, link);
    }

    @Override
    public void addTag(List<Tag> tags, String userName, String topicPath) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node topicNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(topicPath);
            List<Object> listId = new ArrayList();
            ArrayList<String> list = new ArrayList<String>();
            if (topicNode.hasProperty("exo:tagId")) {
                listId = Utils.valuesToList(topicNode.getProperty("exo:tagId").getValues());
            }
            list.addAll(listId);
            for (Tag tag : tags) {
                boolean isAdd = true;
                String userIdAndTagId = userName + ":" + tag.getId();
                for (String string : listId) {
                    if (!userIdAndTagId.equals(string)) continue;
                    isAdd = false;
                    break;
                }
                if (!isAdd) continue;
                list.add(userIdAndTagId);
                this.saveTag(tag);
            }
            topicNode.setProperty("exo:tagId", Utils.getStringsInList(list));
            if (topicNode.isNew()) {
                topicNode.getSession().save();
            } else {
                topicNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add tags", (Throwable)e);
        }
    }

    @Override
    public void unTag(String tagId, String userName, String topicPath) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            Node topicNode = (Node)categoryHome.getSession().getItem(topicPath);
            List<String> oldTagsId = Utils.valuesToList(topicNode.getProperty("exo:tagId").getValues());
            String userIdTagId = userName + ":" + tagId;
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[@exo:tagId='").append(userIdTagId).append("']");
            Query query = qm.createQuery(builder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (oldTagsId.contains(userIdTagId)) {
                oldTagsId.remove(userIdTagId);
                topicNode.setProperty("exo:tagId", oldTagsId.toArray(new String[oldTagsId.size()]));
                if (topicNode.isNew()) {
                    topicNode.getSession().save();
                } else {
                    topicNode.save();
                }
            }
            Tag tag = this.getTag(tagId);
            ArrayList<String> userTags = new ArrayList<String>();
            userTags.addAll(Arrays.asList(tag.getUserTag()));
            if (iter.getSize() == 1L && userTags.size() > 1) {
                if (userTags.contains(userName)) {
                    userTags.remove(userName);
                    tag.setUserTag(userTags.toArray(new String[userTags.size()]));
                    Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                    long count = tagNode.getProperty("exo:useCount").getLong();
                    if (count > 1L) {
                        tagNode.setProperty("exo:useCount", count - 1L);
                    }
                    tagNode.setProperty("exo:userTag", userTags.toArray(new String[userTags.size()]));
                    tagNode.save();
                }
            } else if (iter.getSize() == 1L && userTags.size() == 1) {
                Node tagHomNode = this.getTagHome(sProvider);
                tagHomNode.getNode(tagId).remove();
                tagHomNode.save();
            } else if (iter.getSize() > 1L) {
                Node tagNode = this.getTagHome(sProvider).getNode(tagId);
                long count = tagNode.getProperty("exo:useCount").getLong();
                if (count > 1L) {
                    tagNode.setProperty("exo:useCount", count - 1L);
                }
                tagNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to untag.", (Throwable)e);
        }
    }

    @Override
    public Tag getTag(String tagId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node tagNode = this.getTagHome(sProvider).getNode(tagId);
            return this.getTagNode(tagNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<String> getTagNameInTopic(String userAndTopicId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Node node;
            Node tagHome = this.getTagHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            NodeIterator iter = this.getTopicNodeIteratorByTag(sProvider, qm, userAndTopicId);
            StringBuilder builder = new StringBuilder();
            StringBuilder builder1 = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                boolean b = true;
                t = 0;
                ArrayList<String> list = new ArrayList<String>();
                for (String string : Utils.valuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2) continue;
                    if (temp[0].equals(userId)) {
                        if (t == 0) {
                            builder.append("(@exo:id != '").append(temp[1]).append("'");
                        } else {
                            builder.append(" and @exo:id != '").append(temp[1]).append("'");
                        }
                        list.add(temp[1]);
                        t = 1;
                        continue;
                    }
                    if (list.contains(temp[1])) continue;
                    if (b) {
                        builder1.append(" (@exo:id='").append(temp[1]).append("'");
                    } else {
                        builder1.append(" or @exo:id='").append(temp[1]).append("'");
                    }
                    b = false;
                }
                if (!b) {
                    builder1.append(")");
                }
                if (t == 1) {
                    builder.append(")");
                }
            }
            if (builder1.length() == 0) {
                return tagNames;
            }
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)");
            boolean isQr = false;
            if (builder.length() > 0) {
                queryString.append("[").append((CharSequence)builder);
                isQr = true;
            }
            if (builder1.length() > 0) {
                if (isQr) {
                    queryString.append(" and ").append((CharSequence)builder1);
                } else {
                    queryString.append("[").append((CharSequence)builder1);
                    isQr = true;
                }
            }
            if (isQr) {
                queryString.append("]");
            }
            queryString.append("order by @exo:useCount descending, @exo:name ascending ");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            iter = query.execute().getNodes();
            return this.getTagName(iter, tagNames);
        }
        catch (Exception e) {
            return tagNames;
        }
    }

    private List<String> getTagName(NodeIterator iter, List<String> tagNames) {
        while (iter.hasNext()) {
            PropertyReader reader = new PropertyReader(iter.nextNode());
            StringBuilder str = new StringBuilder(reader.string("exo:name"));
            str.append(Utils.SPACE).append("<font color=\"Salmon\">(").append(reader.string("exo:useCount")).append(")</font>");
            tagNames.add(str.toString());
            if (tagNames.size() != 5) continue;
            break;
        }
        return tagNames;
    }

    private NodeIterator getTopicNodeIteratorByTag(SessionProvider sProvider, QueryManager qm, String userAndTopicId) throws Exception {
        Node categoryHome = this.getCategoryHome(sProvider);
        StringBuffer queryString = new StringBuffer();
        String topicId = userAndTopicId.substring(userAndTopicId.indexOf(",") + 1);
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)[exo:id='").append(topicId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        return query.execute().getNodes();
    }

    @Override
    public List<String> getAllTagName(String keyValue, String userAndTopicId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<String> tagNames = new ArrayList<String>();
        try {
            Node node;
            Node tagHome = this.getTagHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            int t = userAndTopicId.indexOf(",");
            String userId = userAndTopicId.substring(0, t);
            NodeIterator iter = this.getTopicNodeIteratorByTag(sProvider, qm, userAndTopicId);
            StringBuilder builder = new StringBuilder();
            if (iter.getSize() > 0L && (node = iter.nextNode()).hasProperty("exo:tagId")) {
                t = 0;
                for (String string : Utils.valuesToList(node.getProperty("exo:tagId").getValues())) {
                    String[] temp = string.split(":");
                    if (temp.length != 2 || !temp[0].equals(userId)) continue;
                    if (t == 0) {
                        builder.append("@exo:id != '").append(temp[1]).append("'");
                    } else {
                        builder.append(" and @exo:id != '").append(temp[1]).append("'");
                    }
                    t = 1;
                }
            }
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(tagHome.getPath()).append("//element(*,exo:forumTag)[(jcr:contains(@exo:name, '").append(keyValue).append("*'))");
            if (builder.length() > 0) {
                queryString.append(" and (").append((CharSequence)builder).append(")");
            }
            queryString.append("]order by @exo:useCount descending, @exo:name ascending ");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            iter = query.execute().getNodes();
            return this.getTagName(iter, tagNames);
        }
        catch (Exception e) {
            return tagNames;
        }
    }

    @Override
    public List<Tag> getAllTags() throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            QueryManager qm = tagHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root" + tagHome.getPath() + "/element(*,exo:forumTag)");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                tags.add(this.getTagNode(iter.nextNode()));
            }
            return tags;
        }
        catch (Exception e) {
            return tags;
        }
    }

    private Tag getTagNode(Node tagNode) throws RepositoryException {
        Tag newTag = new Tag();
        newTag.setId(tagNode.getName());
        PropertyReader reader = new PropertyReader(tagNode);
        newTag.setUserTag(reader.strings("exo:userTag", new String[0]));
        newTag.setName(reader.string("exo:name", ""));
        newTag.setUseCount(reader.l("exo:useCount"));
        return newTag;
    }

    @Override
    public List<Tag> getMyTagInTopic(String[] tagIds) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        try {
            Node tagHome = this.getTagHome(sProvider);
            for (String id : tagIds) {
                try {
                    tags.add(this.getTagNode(tagHome.getNode(id)));
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("Failed to get tag node with id %s", id), (Throwable)e);
                }
            }
            return tags;
        }
        catch (Exception e) {
            return tags;
        }
    }

    @Override
    public JCRPageList getTopicByMyTag(String userIdAndtagId, String strOrderBy) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            builder.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:topic)");
            if (userIdAndtagId.indexOf(":") > 0) {
                builder.append("[@exo:tagId='").append(userIdAndtagId).append("']");
            } else {
                builder.append("[jcr:contains(@exo:tagId,'").append(userIdAndtagId).append("')]");
            }
            builder.append(" order by @exo:isSticky descending");
            if (Utils.isEmpty(strOrderBy)) {
                builder.append(", @exo:lastPostDate descending");
            } else {
                builder.append(", @exo:").append(strOrderBy);
                if (strOrderBy.indexOf("lastPostDate") < 0) {
                    builder.append(", @exo:lastPostDate descending");
                }
            }
            String pathQuery = builder.toString();
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return pagelist;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void saveTag(Tag newTag) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node newTagNode;
            Node tagHome = this.getTagHome(sProvider);
            boolean isNew = false;
            try {
                newTagNode = tagHome.getNode(newTag.getId());
            }
            catch (PathNotFoundException e) {
                isNew = true;
                String id = Utils.TAG + newTag.getName();
                newTagNode = tagHome.addNode(id, "exo:forumTag");
                newTagNode.setProperty("exo:id", id);
            }
            if (isNew) {
                newTagNode.setProperty("exo:userTag", newTag.getUserTag());
                newTagNode.setProperty("exo:name", newTag.getName());
                newTagNode.setProperty("exo:useCount", 1L);
            } else {
                List<String> userTags = Utils.valuesToList(newTagNode.getProperty("exo:userTag").getValues());
                if (!userTags.contains(newTag.getUserTag()[0])) {
                    userTags.add(newTag.getUserTag()[0]);
                    newTagNode.setProperty("exo:userTag", userTags.toArray(new String[userTags.size()]));
                }
                long count = newTagNode.getProperty("exo:useCount").getLong();
                newTagNode.setProperty("exo:useCount", count + 1L);
            }
            if (tagHome.isNew()) {
                tagHome.getSession().save();
            } else {
                tagHome.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save tag.", (Throwable)e);
        }
    }

    @Override
    public JCRPageList getPageListUserProfile() throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileHome.getSession().getWorkspace().getQueryManager();
            StringBuilder strQuery = this.jcrPathLikeAndNotLike("exo:forumUserProfile", userProfileHome.getPath());
            strQuery.append(" AND (").append("exo:isDisabled").append(" IS NULL OR ").append("exo:isDisabled").append("<>'true')");
            Query query = qm.createQuery(strQuery.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            return new ForumPageList(iter, 10, strQuery.toString(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public JCRPageList searchUserProfile(String userSearch) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node userProfileHome = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileHome.getSession().getWorkspace().getQueryManager();
            StringBuilder strQuery = this.jcrPathLikeAndNotLike("exo:forumUserProfile", userProfileHome.getPath());
            strQuery.append(" AND (").append("exo:userId").append(" LIKE '%").append(userSearch).append("%'").append(" OR ").append("exo:firstName").append(" LIKE '%").append(userSearch).append("%'").append(" OR ").append("exo:lastName").append(" LIKE '%").append(userSearch).append("%'").append(" OR ").append("exo:fullName").append(" LIKE '%").append(userSearch).append("%'").append(" OR ").append("exo:email").append(" LIKE '%").append(userSearch).append("%'").append(" OR ").append("exo:userTitle").append(" LIKE '%").append(userSearch).append("%'").append(") AND (").append("exo:isDisabled").append(" IS NULL OR ").append("exo:isDisabled").append("<>'true')");
            Query query = qm.createQuery(strQuery.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            return new ForumPageList(iter, 10, strQuery.toString(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public UserProfile getDefaultUserProfile(String userName, String ip) throws Exception {
        UserProfile userProfile;
        block12: {
            userProfile = new UserProfile();
            if (userName == null || userName.length() <= 0) {
                return userProfile;
            }
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                String[] array;
                Node profileNode = this.getUserProfileNode(sProvider, userName);
                PropertyReader reader = new PropertyReader(profileNode);
                userProfile.setUserId(userName);
                if (this.isAdminRole(userName)) {
                    userProfile.setUserRole(0L);
                } else {
                    userProfile.setUserRole(reader.l("exo:userRole", 2L));
                }
                userProfile.setModerateForums(reader.strings("exo:moderateForums", new String[0]));
                userProfile.setModerateCategory(reader.strings("exo:moderateCategory", new String[0]));
                userProfile.setScreenName(this.getScreenName(userName, profileNode));
                userProfile.setNewMessage(reader.l("exo:newMessage"));
                userProfile.setTimeZone(reader.d("exo:timeZone"));
                userProfile.setShortDateFormat(reader.string("exo:shortDateformat", userProfile.getShortDateFormat()));
                userProfile.setLongDateFormat(reader.string("exo:longDateformat", userProfile.getLongDateFormat()));
                userProfile.setTimeFormat(reader.string("exo:timeFormat", userProfile.getTimeFormat()));
                userProfile.setMaxPostInPage(reader.l("exo:maxPost", 10L));
                userProfile.setMaxTopicInPage(reader.l("exo:maxTopic", 10L));
                userProfile.setIsAutoWatchMyTopics(reader.bool("exo:isAutoWatchMyTopics"));
                userProfile.setIsAutoWatchTopicIPost(reader.bool("exo:isAutoWatchTopicIPost"));
                userProfile.setLastReadPostOfForum(reader.strings("exo:lastReadPostOfForum", new String[0]));
                userProfile.setLastReadPostOfTopic(reader.strings("exo:lastReadPostOfTopic", new String[0]));
                userProfile.setIsBanned(reader.bool("exo:isBanned"));
                userProfile.setCollapCategories(reader.strings("exo:collapCategories", new String[0]));
                userProfile.setEmail(reader.string("exo:email", ""));
                List values = reader.list("exo:readTopic", new ArrayList());
                String s = ":";
                for (String str : values) {
                    if (str.indexOf(s) <= 0) continue;
                    array = str.split(s);
                    userProfile.setLastTimeAccessTopic(array[0], Long.parseLong(array[1]));
                }
                values = reader.list("exo:readForum", new ArrayList());
                for (String str : values) {
                    if (str.indexOf(s) <= 0) continue;
                    array = str.split(s);
                    userProfile.setLastTimeAccessForum(array[0], Long.parseLong(array[1]));
                }
                if (userProfile.getIsBanned()) {
                    if (profileNode.hasProperty("exo:banUntil")) {
                        userProfile.setBanUntil(reader.l("exo:banUntil"));
                        if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                            profileNode.setProperty("exo:isBanned", false);
                            profileNode.save();
                            userProfile.setIsBanned(false);
                        }
                    }
                } else if (ip != null) {
                    userProfile.setIsBanned(this.isBanIp(ip));
                }
            }
            catch (Exception e) {
                userProfile.setUserId(userName);
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug((Object)("Failed to get default userprofile of user: " + userName), (Throwable)e);
            }
        }
        return userProfile;
    }

    @Override
    public UserProfile updateUserProfileSetting(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node profileNode = this.getUserProfileNode(sProvider, userProfile.getUserId());
        PropertyReader reader = new PropertyReader(profileNode);
        if (userProfile.getIsBanned()) {
            userProfile.setBanUntil(reader.l("exo:banUntil"));
            if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                profileNode.setProperty("exo:isBanned", false);
                profileNode.save();
                userProfile.setIsBanned(false);
            }
        }
        userProfile.setTimeZone(reader.d("exo:timeZone"));
        userProfile.setShortDateFormat(reader.string("exo:shortDateformat", userProfile.getShortDateFormat()));
        userProfile.setLongDateFormat(reader.string("exo:longDateformat", userProfile.getLongDateFormat()));
        userProfile.setModerateForums(reader.strings("exo:moderateForums", new String[0]));
        userProfile.setModerateCategory(reader.strings("exo:moderateCategory", new String[0]));
        userProfile.setMaxTopicInPage(reader.l("exo:maxTopic", 10L));
        userProfile.setMaxPostInPage(reader.l("exo:maxPost", 10L));
        userProfile.setBanReason(reader.string("exo:banReason", ""));
        userProfile.setBanCounter(Integer.parseInt(reader.string("exo:banCounter", "0")));
        userProfile.setBanReasonSummary(reader.strings("exo:banReasonSummary", new String[0]));
        userProfile.setCreatedDateBan(reader.date("exo:createdDateBan"));
        return userProfile;
    }

    @Override
    public String getScreenName(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            return this.getScreenName(sProvider, userName);
        }
        catch (Exception e) {
            return userName;
        }
    }

    private String getScreenName(SessionProvider sProvider, String userName) throws Exception {
        try {
            Node userProfile = this.getUserProfileNode(this.getUserProfileHome(sProvider), userName);
            return this.getScreenName(userName, userProfile);
        }
        catch (Exception e) {
            return this.getScreenName(userName, null);
        }
    }

    private String getScreenName(String userName, Node userProfile) throws Exception {
        String userTemp = userName;
        if (userProfile != null) {
            PropertyReader reader = new PropertyReader(userProfile);
            userName = reader.string("exo:screenName", reader.string("exo:fullName", userName));
        }
        return userTemp.contains(Utils.DELETED) ? "<s>" + (userName.contains(Utils.DELETED) ? userName.substring(0, userName.indexOf(Utils.DELETED)) : userName) + "</s>" : userName;
    }

    @Override
    public boolean isBanIp(String ip) throws Exception {
        return this.getBanList().contains(ip);
    }

    @Override
    public UserProfile getUserSettingProfile(String userName) throws Exception {
        UserProfile userProfile;
        block3: {
            userProfile = new UserProfile();
            if (userName == null || userName.length() <= 0) {
                return userProfile;
            }
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            Session session = this.sessionManager.getSession(sProvider);
            try {
                userProfile = this.getCachedDataStorage().getQuickProfile(userName);
                Node profileNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation() + "/" + userName);
                PropertyReader reader = new PropertyReader(profileNode);
                userProfile.setScreenName(this.getScreenName(userName, profileNode));
                userProfile.setSignature(reader.string("exo:signature", ""));
                userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature", true));
                userProfile.setIsAutoWatchMyTopics(reader.bool("exo:isAutoWatchMyTopics"));
                userProfile.setIsAutoWatchTopicIPost(reader.bool("exo:isAutoWatchTopicIPost"));
                userProfile.setUserRole(reader.l("exo:userRole"));
                userProfile.setTimeZone(reader.d("exo:timeZone"));
                userProfile.setShortDateFormat(reader.string("exo:shortDateformat", ""));
                userProfile.setLongDateFormat(reader.string("exo:longDateformat", ""));
                userProfile.setTimeFormat(reader.string("exo:timeFormat", ""));
                userProfile.setMaxPostInPage(reader.l("exo:maxPost"));
                userProfile.setMaxTopicInPage(reader.l("exo:maxTopic"));
            }
            catch (Exception e) {
                userProfile.setUserId(userName);
                userProfile.setUserTitle(Utils.USER);
                userProfile.setUserRole(2L);
                if (!this.isAdminRole(userName)) break block3;
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(userProfile, false, false);
            }
        }
        return userProfile;
    }

    @Override
    public void saveUserSettingProfile(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node profileNode = this.getUserProfileNode(sProvider, userProfile.getUserId());
        try {
            profileNode.setProperty("exo:userTitle", userProfile.getUserTitle());
            profileNode.setProperty("exo:screenName", userProfile.getScreenName());
            profileNode.setProperty("exo:signature", userProfile.getSignature());
            profileNode.setProperty("exo:isDisplaySignature", userProfile.getIsDisplaySignature());
            profileNode.setProperty("exo:isDisplayAvatar", userProfile.getIsDisplayAvatar());
            profileNode.setProperty("exo:userRole", userProfile.getUserRole());
            profileNode.setProperty("exo:timeZone", userProfile.getTimeZone());
            profileNode.setProperty("exo:shortDateformat", userProfile.getShortDateFormat());
            profileNode.setProperty("exo:longDateformat", userProfile.getLongDateFormat());
            profileNode.setProperty("exo:timeFormat", userProfile.getTimeFormat());
            profileNode.setProperty("exo:maxPost", userProfile.getMaxPostInPage());
            profileNode.setProperty("exo:maxTopic", userProfile.getMaxTopicInPage());
            profileNode.setProperty("exo:isAutoWatchMyTopics", userProfile.getIsAutoWatchMyTopics());
            profileNode.setProperty("exo:isAutoWatchTopicIPost", userProfile.getIsAutoWatchTopicIPost());
            profileNode.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save setting profile.", (Throwable)e);
        }
    }

    @Override
    public UserProfile getLastPostIdRead(UserProfile userProfile, String isOfForum) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node profileNode = this.getUserProfileNode(sProvider, userProfile.getUserId());
        PropertyReader reader = new PropertyReader(profileNode);
        if (isOfForum.equals("true")) {
            userProfile.setLastReadPostOfForum(reader.strings("exo:lastReadPostOfForum", new String[0]));
        } else if (isOfForum.equals("false")) {
            userProfile.setLastReadPostOfTopic(reader.strings("exo:lastReadPostOfTopic", new String[0]));
        } else {
            userProfile.setLastReadPostOfForum(reader.strings("exo:lastReadPostOfForum", new String[0]));
            userProfile.setLastReadPostOfTopic(reader.strings("exo:lastReadPostOfTopic", new String[0]));
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLastPostIdRead(String userId, String[] lastReadPostOfForum, String[] lastReadPostOfTopic) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ReentrantLock localLock = this.lock;
        try {
            localLock.lock();
            Node profileNode = this.getUserProfileNode(sProvider, userId);
            profileNode.setProperty("exo:lastReadPostOfForum", lastReadPostOfForum);
            profileNode.setProperty("exo:lastReadPostOfTopic", lastReadPostOfTopic);
            profileNode.getSession().save();
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to save last post id read.", (Throwable)e);
        }
        finally {
            localLock.unlock();
        }
    }

    @Override
    public List<String> getUserModerator(String userName, boolean isModeCate) throws Exception {
        ArrayList<String> list;
        block7: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            list = new ArrayList<String>();
            try {
                Node profileNode = userProfileNode.getNode(userName);
                if (isModeCate) {
                    try {
                        list.addAll(Utils.valuesToList(profileNode.getProperty("exo:moderateCategory").getValues()));
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Failed to get moderators of categories", (Throwable)e);
                        }
                    }
                } else {
                    list.addAll(Utils.valuesToList(profileNode.getProperty("exo:moderateForums").getValues()));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)"Failed to get moderators of forums", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public void saveUserModerator(String userName, List<String> ids, boolean isModeCate) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (isModeCate) {
                profileNode.setProperty("exo:moderateCategory", Utils.getStringsInList(ids));
            } else {
                profileNode.setProperty("exo:moderateForums", Utils.getStringsInList(ids));
            }
            profileNode.save();
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to set %s as moderator", userName));
        }
    }

    private Node getUserProfileNode(Node profileHome, String userName) throws Exception {
        try {
            return profileHome.getNode(userName);
        }
        catch (PathNotFoundException e) {
            if (profileHome.hasNode(Utils.USER_PROFILE_DELETED)) {
                Node deletedHome = profileHome.getNode(Utils.USER_PROFILE_DELETED);
                return deletedHome.getNode(userName);
            }
            throw e;
        }
    }

    @Override
    public UserProfile getUserInfo(String userName) throws Exception {
        UserProfile userProfile;
        block5: {
            userProfile = new UserProfile();
            if (userName == null || userName.length() <= 0) {
                return userProfile;
            }
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            try {
                Node newProfileNode = this.getUserProfileNode(userProfileNode, userName);
                PropertyReader reader = new PropertyReader(newProfileNode);
                userProfile.setUserId(userName);
                userProfile.setScreenName(this.getScreenName(userName, newProfileNode));
                userProfile.setFullName(reader.string("exo:fullName"));
                userProfile.setFirstName(reader.string("exo:firstName"));
                userProfile.setLastName(reader.string("exo:lastName"));
                userProfile.setEmail(reader.string("exo:email"));
                if (this.isAdminRole(userName)) {
                    userProfile.setUserRole(0L);
                } else {
                    userProfile.setUserRole(reader.l("exo:userRole"));
                }
                userProfile.setUserTitle(reader.string("exo:userTitle", ""));
                userProfile.setSignature(reader.string("exo:signature"));
                userProfile.setTotalPost(reader.l("exo:totalPost"));
                userProfile.setTotalTopic(reader.l("exo:totalTopic"));
                userProfile.setBookmark(reader.strings("exo:bookmark"));
                userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
                userProfile.setJoinedDate(reader.date("exo:joinedDate"));
                userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
                userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature"));
                userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar"));
                userProfile.setDisabled(reader.bool("exo:isDisabled", false));
            }
            catch (PathNotFoundException e) {
                userProfile.setUserId(userName);
                userProfile.setUserTitle(Utils.USER);
                userProfile.setUserRole(2L);
                if (!this.isAdminRole(userName)) break block5;
                userProfile.setUserRole(0L);
                userProfile.setUserTitle(Utils.ADMIN);
                this.saveUserProfile(userProfile, false, false);
            }
        }
        return userProfile;
    }

    @Override
    public List<UserProfile> getQuickProfiles(List<String> userList) throws Exception {
        ArrayList<UserProfile> profiles = new ArrayList<UserProfile>();
        try {
            DataStorage storage = this.getCachedDataStorage();
            for (String userName : userList) {
                profiles.add(storage.getQuickProfile(userName));
            }
        }
        catch (Exception e) {
            LOG.trace((Object)("\nUser Name must exist: " + e.getMessage() + "\n" + e.getCause()));
        }
        return profiles;
    }

    @Override
    public UserProfile getQuickProfile(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        return this.getUserProfile(this.getUserProfileNode(userProfileHome, userName));
    }

    @Override
    public UserProfile getUserInformations(UserProfile userProfile) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = this.getUserProfileNode(userProfileHome, userProfile.getUserId());
        PropertyReader reader = new PropertyReader(profileNode);
        userProfile.setFirstName(reader.string("exo:firstName", ""));
        userProfile.setLastName(reader.string("exo:lastName", ""));
        userProfile.setFullName(reader.string("exo:fullName", ""));
        userProfile.setEmail(reader.string("exo:email", ""));
        userProfile.setDisabled(reader.bool("exo:isDisabled", false));
        return userProfile;
    }

    @Override
    public void saveUserProfile(UserProfile newUserProfile, boolean isOption, boolean isBan) throws Exception {
        Node newProfileNode;
        long role;
        Node userProfileHome;
        String userName;
        block14: {
            userName = newUserProfile.getUserId();
            if (userName == null || userName.length() <= 0) {
                return;
            }
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            userProfileHome = this.getUserProfileHome(sProvider);
            role = 2L;
            try {
                newProfileNode = userProfileHome.getNode(userName);
                if (newProfileNode.hasProperty("exo:userRole")) {
                    role = new PropertyReader(newProfileNode).l("exo:userRole");
                }
            }
            catch (PathNotFoundException e) {
                newProfileNode = userProfileHome.addNode(userName, "exo:forumUserProfile");
                newProfileNode.setProperty("exo:userId", userName);
                newProfileNode.setProperty("exo:totalPost", 0L);
                newProfileNode.setProperty("exo:totalTopic", 0L);
                newProfileNode.setProperty("exo:readTopic", new String[0]);
                newProfileNode.setProperty("exo:readForum", new String[0]);
                if (newUserProfile.getUserRole() >= 2L) {
                    newUserProfile.setUserRole(2L);
                }
                if (!this.isAdminRole(userName)) break block14;
                newUserProfile.setUserTitle(Utils.ADMIN);
            }
        }
        newProfileNode.setProperty("exo:userRole", newUserProfile.getUserRole());
        newProfileNode.setProperty("exo:userTitle", newUserProfile.getUserTitle());
        newProfileNode.setProperty("exo:screenName", newUserProfile.getScreenName());
        newProfileNode.setProperty("exo:signature", newUserProfile.getSignature());
        newProfileNode.setProperty("exo:isAutoWatchMyTopics", newUserProfile.getIsAutoWatchMyTopics());
        newProfileNode.setProperty("exo:isAutoWatchTopicIPost", newUserProfile.getIsAutoWatchTopicIPost());
        newProfileNode.setProperty("exo:moderateCategory", newUserProfile.getModerateCategory());
        Calendar calendar = this.getGreenwichMeanTime();
        if (newUserProfile.getLastLoginDate() != null) {
            calendar.setTime(newUserProfile.getLastLoginDate());
        }
        newProfileNode.setProperty("exo:lastLoginDate", calendar);
        newProfileNode.setProperty("exo:isDisplaySignature", newUserProfile.getIsDisplaySignature());
        newProfileNode.setProperty("exo:isDisplayAvatar", newUserProfile.getIsDisplayAvatar());
        if (isOption) {
            newProfileNode.setProperty("exo:timeZone", newUserProfile.getTimeZone());
            newProfileNode.setProperty("exo:shortDateformat", newUserProfile.getShortDateFormat());
            newProfileNode.setProperty("exo:longDateformat", newUserProfile.getLongDateFormat());
            newProfileNode.setProperty("exo:timeFormat", newUserProfile.getTimeFormat());
            newProfileNode.setProperty("exo:maxPost", newUserProfile.getMaxPostInPage());
            newProfileNode.setProperty("exo:maxTopic", newUserProfile.getMaxTopicInPage());
        }
        if (isBan) {
            if (newProfileNode.hasProperty("exo:isBanned")) {
                if (!newProfileNode.getProperty("exo:isBanned").getBoolean() && newUserProfile.getIsBanned()) {
                    newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
                }
            } else {
                newProfileNode.setProperty("exo:createdDateBan", this.getGreenwichMeanTime());
            }
            newProfileNode.setProperty("exo:isBanned", newUserProfile.getIsBanned());
            newProfileNode.setProperty("exo:banUntil", newUserProfile.getBanUntil());
            newProfileNode.setProperty("exo:banReason", newUserProfile.getBanReason());
            newProfileNode.setProperty("exo:banCounter", "" + newUserProfile.getBanCounter());
            newProfileNode.setProperty("exo:banReasonSummary", newUserProfile.getBanReasonSummary());
        }
        if (userProfileHome.isNew()) {
            userProfileHome.getSession().save();
        } else {
            userProfileHome.save();
        }
        if (role >= 2L && newUserProfile.getUserRole() < 2L && !this.isAdminRole(userName)) {
            this.getTotalJobWaitingForModerator(userProfileHome.getSession(), userName);
        }
    }

    @Override
    public UserProfile getUserProfileManagement(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node userProfileNode = this.getUserProfileNode(this.getUserProfileHome(sProvider), userName);
            return this.getUserProfile(userProfileNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private UserProfile getUserProfile(Node userProfileNode) throws Exception {
        UserProfile userProfile = new UserProfile();
        String userName = userProfileNode.getName();
        PropertyReader reader = new PropertyReader(userProfileNode);
        userProfile.setUserId(userName);
        userProfile.setUserTitle(reader.string("exo:userTitle", ""));
        userProfile.setUserRole(userName.contains(Utils.DELETED) ? 4L : reader.l("exo:userRole", 2L));
        userProfile.setScreenName(this.getScreenName(userName, userProfileNode));
        userProfile.setJoinedDate(reader.date("exo:joinedDate", new Date()));
        userProfile.setIsDisplayAvatar(reader.bool("exo:isDisplayAvatar"));
        userProfile.setNewMessage(reader.l("exo:newMessage"));
        userProfile.setTimeZone(reader.d("exo:timeZone"));
        userProfile.setShortDateFormat(reader.string("exo:shortDateformat", ""));
        userProfile.setLongDateFormat(reader.string("exo:longDateformat", ""));
        userProfile.setTimeFormat(reader.string("exo:timeFormat", ""));
        userProfile.setMaxPostInPage(reader.l("exo:maxPost"));
        userProfile.setMaxTopicInPage(reader.l("exo:maxTopic"));
        userProfile.setIsBanned(reader.bool("exo:isBanned"));
        userProfile.setDisabled(reader.bool("exo:isDisabled", false));
        if (userProfile.getIsBanned() && userProfileNode.hasProperty("exo:banUntil")) {
            userProfile.setBanUntil(reader.l("exo:banUntil"));
            if (userProfile.getBanUntil() <= this.getGreenwichMeanTime().getTimeInMillis()) {
                userProfileNode.setProperty("exo:isBanned", false);
                userProfileNode.save();
                userProfile.setIsBanned(false);
            }
        }
        userProfile.setTotalPost(reader.l("exo:totalPost"));
        if (userProfile.getTotalPost() > 0L) {
            userProfile.setLastPostDate(reader.date("exo:lastPostDate"));
        }
        userProfile.setLastLoginDate(reader.date("exo:lastLoginDate"));
        userProfile.setIsDisplaySignature(reader.bool("exo:isDisplaySignature", false));
        if (userProfile.getIsDisplaySignature()) {
            userProfile.setSignature(reader.string("exo:signature", ""));
        }
        return userProfile;
    }

    @Override
    public void saveUserBookmark(String userName, String bookMark, boolean isNew) throws Exception {
        block14: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node userProfileNode = this.getUserProfileHome(sProvider);
                try {
                    Node newProfileNode = userProfileNode.getNode(userName);
                    if (newProfileNode.hasProperty("exo:bookmark")) {
                        List<String> listOld = Utils.valuesToList(newProfileNode.getProperty("exo:bookmark").getValues());
                        ArrayList<String> listNew = new ArrayList<String>();
                        String pathNew = bookMark.substring(bookMark.lastIndexOf("//") + 1);
                        String pathOld = "";
                        boolean isAdd = true;
                        for (String string : listOld) {
                            pathOld = string.substring(string.lastIndexOf("//") + 1);
                            if (pathNew.equals(pathOld)) {
                                if (isNew) {
                                    listNew.add(bookMark);
                                }
                                isAdd = false;
                                continue;
                            }
                            listNew.add(string);
                        }
                        if (isAdd) {
                            listNew.add(bookMark);
                        }
                        String[] bookMarks = listNew.toArray(new String[listNew.size()]);
                        newProfileNode.setProperty("exo:bookmark", bookMarks);
                        if (newProfileNode.isNew()) {
                            newProfileNode.getSession().save();
                        } else {
                            newProfileNode.save();
                        }
                        break block14;
                    }
                    newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
                    if (newProfileNode.isNew()) {
                        newProfileNode.getSession().save();
                        break block14;
                    }
                    newProfileNode.save();
                }
                catch (PathNotFoundException e) {
                    Node newProfileNode = userProfileNode.addNode(userName, "exo:forumUserProfile");
                    newProfileNode.setProperty("exo:userId", userName);
                    newProfileNode.setProperty("exo:userTitle", Utils.USER);
                    if (this.isAdminRole(userName)) {
                        newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                    }
                    newProfileNode.setProperty("exo:userRole", 2L);
                    newProfileNode.setProperty("exo:bookmark", new String[]{bookMark});
                    if (newProfileNode.isNew()) {
                        newProfileNode.getSession().save();
                        break block14;
                    }
                    newProfileNode.save();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to save UserBookmark.", (Throwable)e);
            }
        }
    }

    @Override
    public void saveCollapsedCategories(String userName, String categoryId, boolean isAdd) throws Exception {
        block17: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            Node userProfileHome = this.getUserProfileHome(sProvider);
            try {
                Node newProfileNode = userProfileHome.getNode(userName);
                if (newProfileNode.hasProperty("exo:collapCategories")) {
                    List<String> listCategoryId = Utils.valuesToList(newProfileNode.getProperty("exo:collapCategories").getValues());
                    if (listCategoryId.contains(categoryId)) {
                        if (!isAdd) {
                            listCategoryId.remove(categoryId);
                            isAdd = true;
                        }
                    } else if (isAdd) {
                        listCategoryId.add(categoryId);
                    }
                    if (isAdd) {
                        String[] categoryIds = listCategoryId.toArray(new String[listCategoryId.size()]);
                        newProfileNode.setProperty("exo:collapCategories", categoryIds);
                        if (newProfileNode.isNew()) {
                            newProfileNode.getSession().save();
                        } else {
                            newProfileNode.save();
                        }
                    }
                } else {
                    newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
                    if (newProfileNode.isNew()) {
                        newProfileNode.getSession().save();
                    } else {
                        newProfileNode.save();
                    }
                }
            }
            catch (PathNotFoundException e) {
                Node newProfileNode = userProfileHome.addNode(userName, "exo:forumUserProfile");
                newProfileNode.setProperty("exo:userId", userName);
                newProfileNode.setProperty("exo:userTitle", Utils.USER);
                if (this.isAdminRole(userName)) {
                    newProfileNode.setProperty("exo:userTitle", Utils.ADMIN);
                }
                newProfileNode.setProperty("exo:userRole", 2L);
                newProfileNode.setProperty("exo:collapCategories", new String[]{categoryId});
                if (newProfileNode.isNew()) {
                    newProfileNode.getSession().save();
                } else {
                    newProfileNode.save();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug((Object)"Failed to save collapsed categories.", (Throwable)e);
            }
        }
    }

    @Override
    public void saveReadMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            long totalNewMessage = 0L;
            boolean isNew = false;
            try {
                Node messageNode = profileNode.getNode(messageId);
                if (messageNode.hasProperty("exo:isUnread")) {
                    isNew = messageNode.getProperty("exo:isUnread").getBoolean();
                }
                if (isNew) {
                    messageNode.setProperty("exo:isUnread", false);
                }
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)"Failed to save read massage", (Throwable)e);
            }
            if (type.equals(Utils.RECEIVE_MESSAGE) && isNew && profileNode.hasProperty("exo:newMessage") && (totalNewMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalNewMessage - 1L);
            }
            if (isNew) {
                if (userProfileNode.isNew()) {
                    userProfileNode.getSession().save();
                } else {
                    userProfileNode.save();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save read message.");
        }
    }

    @Override
    public JCRPageList getPrivateMessage(String userName, String type) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            QueryManager qm = profileNode.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + XPathUtils.escapeIllegalXPathName((String)profileNode.getPath()) + "/element(*,exo:privateMessage)[@exo:type='" + type + "'] order by @exo:receivedDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            ForumPageList pagelist = new ForumPageList(iter, 10, pathQuery, true);
            return pagelist;
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to get private message.", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getNewPrivateMessage(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            Node profileNode = userProfileNode.getNode(userName);
            if (!profileNode.getProperty("exo:isBanned").getBoolean()) {
                return profileNode.getProperty("exo:newMessage").getLong();
            }
        }
        catch (PathNotFoundException e) {
            return -1L;
        }
        return -1L;
    }

    @Override
    public void savePrivateMessage(ForumPrivateMessage privateMessage) throws Exception {
        String id;
        List<String> userNames;
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        Node profileNode = null;
        Node profileNodeFirst = null;
        Node messageNode = null;
        String sendTo = privateMessage.getSendTo();
        sendTo = sendTo.replaceAll(";", ",");
        String[] strUserNames = sendTo.split(",");
        try {
            userNames = ForumServiceUtils.getUserPermission(strUserNames);
        }
        catch (Exception e) {
            userNames = Arrays.asList(strUserNames);
        }
        String userNameFirst = privateMessage.getFrom();
        try {
            profileNodeFirst = userProfileNode.getNode(userNameFirst);
        }
        catch (PathNotFoundException e) {
            profileNodeFirst = this.addNodeUserProfile(sProvider, userNameFirst);
        }
        long totalMessage = 0L;
        if (profileNodeFirst != null) {
            id = userNameFirst + IdGenerator.generate();
            messageNode = profileNodeFirst.addNode(id, "exo:privateMessage");
            messageNode.setProperty("exo:from", privateMessage.getFrom());
            messageNode.setProperty("exo:sendTo", privateMessage.getSendTo());
            messageNode.setProperty("exo:name", privateMessage.getName());
            messageNode.setProperty("exo:message", privateMessage.getMessage());
            messageNode.setProperty("exo:receivedDate", this.getGreenwichMeanTime());
            messageNode.setProperty("exo:isUnread", true);
            messageNode.setProperty("exo:type", Utils.RECEIVE_MESSAGE);
        }
        StringBuilder sent = new StringBuilder();
        for (String userName : userNames) {
            if (userName.equals(userNameFirst)) continue;
            try {
                profileNode = userProfileNode.getNode(userName);
                totalMessage = profileNode.getProperty("exo:newMessage").getLong() + 1L;
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", totalMessage);
            }
            catch (Exception e) {
                profileNode = this.addNodeUserProfile(sProvider, userName);
                id = profileNode.getPath() + "/" + userName + IdGenerator.generate();
                userProfileNode.getSession().getWorkspace().copy(messageNode.getPath(), id);
                profileNode.setProperty("exo:newMessage", 1L);
            }
            if (sent.length() > 0) {
                sent.append(",");
            }
            sent.append(userName);
        }
        privateMessage.setType("PrivateMessage");
        privateMessage.setSendTo(sent.toString());
        this.sendNotificationMessage(privateMessage);
        if (messageNode != null) {
            messageNode.setProperty("exo:type", Utils.SEND_MESSAGE);
        }
        if (userProfileNode.isNew()) {
            userProfileNode.getSession().save();
        } else {
            userProfileNode.save();
        }
    }

    private Node addNodeUserProfile(SessionProvider sProvider, String userName) throws Exception {
        Node userProfileHome = this.getUserProfileHome(sProvider);
        Node profileNode = userProfileHome.addNode(userName, "exo:forumUserProfile");
        profileNode.setProperty("exo:userId", userName);
        profileNode.setProperty("exo:userTitle", Utils.USER);
        if (this.isAdminRole(userName)) {
            profileNode.setProperty("exo:userRole", 0L);
            profileNode.setProperty("exo:userTitle", Utils.ADMIN);
        }
        profileNode.setProperty("exo:userRole", 2L);
        if (userProfileHome.isNew()) {
            userProfileHome.getSession().save();
        } else {
            userProfileHome.save();
        }
        return profileNode;
    }

    @Override
    public void removePrivateMessage(String messageId, String userName, String type) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node userProfileNode = this.getUserProfileHome(sProvider);
        try {
            long totalMessage;
            Node profileNode = userProfileNode.getNode(userName);
            Node messageNode = profileNode.getNode(messageId);
            if (type.equals(Utils.RECEIVE_MESSAGE) && messageNode.hasProperty("exo:isUnread") && messageNode.getProperty("exo:isUnread").getBoolean() && (totalMessage = profileNode.getProperty("exo:newMessage").getLong()) > 0L) {
                profileNode.setProperty("exo:newMessage", totalMessage - 1L);
            }
            messageNode.remove();
            profileNode.save();
        }
        catch (PathNotFoundException e) {
            LOG.error((Object)"Failed to remove private message", (Throwable)e);
        }
    }

    @Override
    public ForumSubscription getForumSubscription(String userId) {
        ForumSubscription forumSubscription;
        block2: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            forumSubscription = new ForumSubscription();
            try {
                Node subscriptionNode = this.getUserProfileHome(sProvider).getNode(userId + "/" + Utils.FORUM_SUBSCRIOTION + userId);
                PropertyReader reader = new PropertyReader(subscriptionNode);
                forumSubscription.setCategoryIds(reader.strings("exo:categoryIds", new String[0]));
                forumSubscription.setForumIds(reader.strings("exo:forumIds", new String[0]));
                forumSubscription.setTopicIds(reader.strings("exo:topicIds", new String[0]));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)String.format("Failed to get forum subscription for user %s", userId), (Throwable)e);
            }
        }
        return forumSubscription;
    }

    @Override
    public void saveForumSubscription(ForumSubscription forumSubscription, String userId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node subscriptionNode;
            Node profileNode = this.getUserProfileHome(sProvider).getNode(userId);
            String id = Utils.FORUM_SUBSCRIOTION + userId;
            try {
                subscriptionNode = profileNode.getNode(id);
            }
            catch (PathNotFoundException e) {
                subscriptionNode = profileNode.addNode(id, "exo:forumSubscription");
            }
            subscriptionNode.setProperty("exo:categoryIds", forumSubscription.getCategoryIds());
            subscriptionNode.setProperty("exo:forumIds", forumSubscription.getForumIds());
            subscriptionNode.setProperty("exo:topicIds", forumSubscription.getTopicIds());
            if (profileNode.isNew()) {
                profileNode.getSession().save();
            } else {
                profileNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save forum subscription.", (Throwable)e);
        }
    }

    private String[] getValueProperty(Node node, String property, String objectId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (node.hasProperty(property)) {
            list.addAll(Utils.valuesToList(node.getProperty(property).getValues()));
            if (!list.contains(objectId)) {
                list.add(objectId);
            }
        } else {
            list.add(objectId);
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForumStatistic getForumStatistic() throws Exception {
        ForumStatistic forumStatistic = new ForumStatistic();
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            PropertyReader reader = new PropertyReader(forumStatisticNode);
            forumStatistic.setPostCount(reader.l("exo:postCount", 0L));
            forumStatistic.setTopicCount(reader.l("exo:topicCount", 0L));
            forumStatistic.setMembersCount(reader.l("exo:membersCount", 0L));
            forumStatistic.setActiveUsers(reader.l("exo:activeUsers", 0L));
            forumStatistic.setNewMembers(reader.string("exo:newMembers", ""));
            forumStatistic.setMostUsersOnline(reader.string("exo:mostUsersOnline", ""));
        }
        return forumStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForumStatistic(ForumStatistic forumStatistic) throws Exception {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            forumStatisticNode.setProperty("exo:postCount", forumStatistic.getPostCount());
            forumStatisticNode.setProperty("exo:topicCount", forumStatistic.getTopicCount());
            forumStatisticNode.setProperty("exo:membersCount", forumStatistic.getMembersCount());
            forumStatisticNode.setProperty("exo:activeUsers", forumStatistic.getActiveUsers());
            forumStatisticNode.setProperty("exo:mostUsersOnline", forumStatistic.getMostUsersOnline());
            if (!Utils.isEmpty(forumStatistic.getNewMembers())) {
                forumStatisticNode.setProperty("exo:newMembers", forumStatistic.getNewMembers());
            }
            if (forumStatisticNode.isNew()) {
                forumStatisticNode.getSession().save();
            } else {
                forumStatisticNode.save();
            }
        }
    }

    @Override
    public Object getObjectNameByPath(String path) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Object object;
            if (path.indexOf("CategoryHome") < 0 && path.indexOf(Utils.CATEGORY) >= 0) {
                path = this.getCategoryHome(sProvider).getPath() + "/" + path;
            } else if (path.indexOf(Utils.TAG) == 0) {
                path = this.getTagHome(sProvider).getPath() + "/" + path;
            }
            Node myNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            if (path.indexOf(Utils.POST) > 0) {
                Post post = new Post();
                post.setId(myNode.getName());
                post.setPath(path);
                post.setName(myNode.getProperty("exo:name").getString());
                object = post;
            } else if (path.indexOf(Utils.TOPIC) > 0) {
                Topic topic = new Topic();
                topic.setId(myNode.getName());
                topic.setPath(path);
                topic.setTopicName(myNode.getProperty("exo:name").getString());
                object = topic;
            } else if (path.indexOf(Utils.FORUM) > 0 && path.lastIndexOf(Utils.FORUM) > path.indexOf(Utils.CATEGORY)) {
                Forum forum = new Forum();
                forum.setId(myNode.getName());
                forum.setPath(path);
                forum.setForumName(myNode.getProperty("exo:name").getString());
                object = forum;
            } else if (path.indexOf(Utils.CATEGORY) > 0) {
                Category category = new Category();
                category.setId(myNode.getName());
                category.setPath(path);
                category.setCategoryName(myNode.getProperty("exo:name").getString());
                object = category;
            } else if (path.indexOf(Utils.TAG) > 0) {
                Tag tag = new Tag();
                tag.setId(myNode.getName());
                tag.setName(myNode.getProperty("exo:name").getString());
                object = tag;
            } else {
                return null;
            }
            return object;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public Object getObjectNameById(String id, String type) throws Exception {
        Object object;
        block8: {
            object = null;
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node node = this.getNodeById(sProvider, id, type);
                if (type.equals(Utils.CATEGORY)) {
                    Category category = this.getCategory(node);
                    object = category;
                } else if (type.equals(Utils.FORUM)) {
                    Forum forum = this.getForum(node);
                    object = forum;
                } else if (type.equals(Utils.TOPIC)) {
                    Topic topic = this.getTopicNode(node);
                    object = topic;
                } else {
                    Post post = this.getPost(node);
                    object = post;
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)("Can not get " + type + " by Id: " + id), (Throwable)e);
            }
        }
        return object;
    }

    private Node getNodeById(SessionProvider sProvider, String id, String type) {
        block4: {
            try {
                StringBuffer stringBuffer;
                Node categoryHome = this.getCategoryHome(sProvider);
                if (type.equals(Utils.CATEGORY)) {
                    return categoryHome.getNode(id);
                }
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery((stringBuffer = new StringBuffer("/jcr:root").append(categoryHome.getPath()).append("//element(*,exo:").append(type).append(")[(@").append("exo:id").append("='").append(id).append("') or (fn:name()='").append(id).append("')]")).toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                if (iter.getSize() > 0L) {
                    return iter.nextNode();
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Can not get Node by Id: " + id), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public List<ForumLinkData> getAllLink(String strQueryCate, String strQueryForum) throws Exception {
        ArrayList<ForumLinkData> forumLinks = new ArrayList<ForumLinkData>();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer();
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("/element(*,exo:forumCategory)").append(strQueryCate).append(" order by @exo:categoryOrder ascending, @exo:createdDate ascending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            ForumLinkData linkData = new ForumLinkData();
            Node cateNode = iter.nextNode();
            linkData.setId(cateNode.getName());
            linkData.setName(cateNode.getProperty("exo:name").getString());
            linkData.setType(Utils.CATEGORY);
            linkData.setPath(cateNode.getName());
            forumLinks.add(linkData);
            queryString = new StringBuffer();
            queryString.append("/jcr:root").append(cateNode.getPath()).append("/element(*,exo:forum)").append(strQueryForum).append(" order by @exo:forumOrder ascending,@exo:createdDate ascending");
            query = qm.createQuery(queryString.toString(), "xpath");
            result = query.execute();
            NodeIterator iterForum = result.getNodes();
            while (iterForum.hasNext()) {
                linkData = new ForumLinkData();
                Node forumNode = iterForum.nextNode();
                linkData.setId(forumNode.getName());
                linkData.setName(forumNode.getProperty("exo:name").getString());
                linkData.setType(Utils.FORUM);
                linkData.setPath(cateNode.getName() + "/" + forumNode.getName());
                if (forumNode.hasProperty("exo:isLock")) {
                    linkData.setIsLock(forumNode.getProperty("exo:isLock").getBoolean());
                }
                if (forumNode.hasProperty("exo:isClosed")) {
                    linkData.setIsClosed(forumNode.getProperty("exo:isClosed").getBoolean());
                }
                forumLinks.add(linkData);
            }
        }
        return forumLinks;
    }

    @Override
    public List<ForumSearchResult> getQuickSearch(String textQuery, String type_, String pathQuery, String userId, List<String> listCateIds, List<String> listForumIds, List<String> forumIdsOfModerator) throws Exception {
        List<ForumSearchResult> listSearchEvent = new ArrayList<ForumSearchResult>();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        if (pathQuery == null || pathQuery.length() <= 0) {
            pathQuery = categoryHome.getPath();
        }
        textQuery = StringUtils.replace((String)textQuery, (String)"'", (String)"&apos;");
        String[] values = type_.split(",");
        boolean isAdmin = false;
        if (values[0].equals("true")) {
            isAdmin = true;
        }
        String[] types = new String[]{Utils.CATEGORY, Utils.FORUM, Utils.TOPIC, Utils.POST};
        if (!values[1].equals("all")) {
            types = values[1].split("/");
        }
        boolean isAnd = false;
        String searchBy = null;
        ArrayList<String> listOfUser = new ArrayList();
        if (!isAdmin) {
            listOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
            Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "exo:userPrivate");
            listCateIds = mapList.get(Utils.CATEGORY);
            listForumIds = mapList.get(Utils.FORUM);
        }
        for (String type : types) {
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(pathQuery).append("//element(*,exo:").append(type).append(")");
            queryString.append("[");
            if (type.equals(Utils.CATEGORY)) {
                if (listCateIds != null && listCateIds.size() > 0) {
                    queryString.append("(");
                    for (int i = 0; i < listCateIds.size(); ++i) {
                        queryString.append("fn:name() = '").append(listCateIds.get(i)).append("'");
                        if (i >= listCateIds.size() - 1) continue;
                        queryString.append(" or ");
                    }
                    queryString.append(") and ");
                }
            } else if (listForumIds != null && listForumIds.size() > 0) {
                searchBy = type.equals(Utils.FORUM) ? "fn:name()" : "@exo:path";
                queryString.append("(");
                for (int i = 0; i < listForumIds.size(); ++i) {
                    queryString.append(searchBy).append("='").append(listForumIds.get(i)).append("'");
                    if (i >= listForumIds.size() - 1) continue;
                    queryString.append(" or ");
                }
                queryString.append(") and ");
            }
            if (textQuery != null && textQuery.length() > 0 && !textQuery.equals("null")) {
                queryString.append("(jcr:contains(., '").append(textQuery).append("'))");
                isAnd = true;
            }
            if (!isAdmin) {
                StringBuilder builder = new StringBuilder();
                if (forumIdsOfModerator != null && !forumIdsOfModerator.isEmpty()) {
                    for (String string : forumIdsOfModerator) {
                        builder.append(" or (@exo:path='").append(string).append("')");
                    }
                }
                if (type.equals(Utils.FORUM)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("(@exo:isClosed='false'");
                    for (String forumId : forumIdsOfModerator) {
                        queryString.append(" or fn:name()='").append(forumId).append("'");
                    }
                    queryString.append(")");
                } else if (type.equals(Utils.TOPIC)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("((@exo:isClosed='false' and @exo:isWaiting='false' and @exo:isApproved='true' and @exo:isActive='true' and @exo:isActiveByForum='true')");
                    if (builder.length() > 0) {
                        queryString.append((CharSequence)builder);
                    }
                    queryString.append(")");
                    String str = Utils.buildXpathByUserInfo("exo:canView", listOfUser);
                    if (!Utils.isEmpty(str)) {
                        if (isAnd) {
                            queryString.append(" and ");
                        }
                        queryString.append("(@").append("exo:owner").append("='").append(userId).append("' or ").append(Utils.buildXpathHasProperty("exo:canView")).append(" or ").append(str).append(")");
                    }
                } else if (type.equals(Utils.POST)) {
                    if (isAnd) {
                        queryString.append(" and ");
                    }
                    queryString.append("((@exo:isApproved='true' and @exo:isHidden='false' and @exo:isActiveByTopic='true')");
                    if (builder.length() > 0) {
                        queryString.append((CharSequence)builder);
                    }
                    queryString.append(") and (@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
                }
            } else if (type.equals(Utils.POST)) {
                if (isAnd) {
                    queryString.append(" and ");
                }
                queryString.append("(@exo:userPrivate='exoUserPri'").append(" or @exo:userPrivate='").append(userId).append("') and @exo:isFirstPost='false'");
            }
            queryString.append("]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node nodeObj = iter.nextNode();
                listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
            }
            if (!type.equals(Utils.POST)) continue;
            listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, pathQuery, textQuery, listForumIds, listOfUser, isAdmin, ""));
        }
        if (!isAdmin && listSearchEvent.size() > 0) {
            List<Object> categoryCanView = new ArrayList();
            ArrayList<String> forumCanView = new ArrayList<String>();
            Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, new ArrayList<String>(), "exo:viewer");
            categoryCanView = mapList.get(Utils.CATEGORY);
            forumCanView.addAll(this.getCachedDataStorage().getForumUserCanView(listOfUser, listForumIds));
            if (categoryCanView.size() > 0 || forumCanView.size() > 0) {
                listSearchEvent = this.removeItemInList(listSearchEvent, forumCanView, categoryCanView);
            }
        }
        return listSearchEvent;
    }

    @Override
    public List<ForumSearchResult> getUnifiedSearch(String textQuery, String userId, Integer offset, Integer limit, String sort, String order) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<ForumSearchResult> list = new ArrayList<ForumSearchResult>();
        Node categoryHome = this.getCategoryHome(sProvider);
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        textQuery = CommonUtils.processUnifiedSearchSearchCondition((String)textQuery);
        String asteriskQuery = CommonUtils.normalizeUnifiedSearchInput((String)textQuery);
        if (Utils.isEmpty(asteriskQuery)) {
            return list;
        }
        boolean isAdmin = this.isAdminRole(userId);
        List listOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
        List<String> listForumIds = this.getCachedDataStorage().getForumUserCanView(listOfUser, new ArrayList<String>());
        StringBuilder queryString = this.buildSQLQueryUnifiedSearch(listForumIds, asteriskQuery, textQuery, isAdmin, sort, order, userId, listOfUser);
        LOG.debug((Object)("UnifiedSearch statement query: " + queryString.toString()));
        QueryImpl query = (QueryImpl)qm.createQuery(queryString.toString(), "sql");
        query.setLimit(30L);
        query.setOffset((long)offset.intValue());
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext() && limit > 0) {
            Node nodeObj = iter.nextNode();
            if (!this.hasPermssionViewerPost(nodeObj, listOfUser)) continue;
            list.add(this.setPropertyUnifiedSearch(nodeObj, textQuery));
            Integer n = limit;
            Integer n2 = limit = Integer.valueOf(limit - 1);
        }
        return UnifiedSearchOrder.processOrder(list, sort, order);
    }

    private StringBuilder buildSQLQueryUnifiedSearch(List<String> listForumIds, String asteriskQuery, String textQuery, boolean isAdmin, String sort, String order, String userId, List<String> listOfUser) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("select exo:name, exo:message, rep:excerpt() from exo:post where ");
        if (listForumIds != null && listForumIds.size() > 0) {
            queryString.append("(");
            for (int i = 0; i < listForumIds.size(); ++i) {
                queryString.append("exo:path").append("='").append(listForumIds.get(i)).append("'");
                if (i >= listForumIds.size() - 1) continue;
                queryString.append(" or ");
            }
            queryString.append(") and ");
        }
        queryString.append("(").append("CONTAINS (exo:message, '").append(asteriskQuery).append("')").append(" or (exo:isFirstPost='true' and ").append("CONTAINS (exo:name, '").append(asteriskQuery).append("'))").append(")");
        if (!isAdmin) {
            queryString.append(" and ");
            queryString.append("(exo:isApproved='true' and exo:isHidden='false' and exo:isActiveByTopic='true')");
            queryString.append(" and (exo:userPrivate='exoUserPri'").append(" or exo:userPrivate='").append(userId).append("')");
        } else {
            queryString.append(" and ");
            queryString.append("(exo:userPrivate='exoUserPri'").append(" or exo:userPrivate='").append(userId).append("')");
        }
        if ("date".equalsIgnoreCase(sort)) {
            queryString.append(" order by ").append("exo:createdDate");
        } else if ("title".equalsIgnoreCase(sort) || Utils.isEmpty(sort)) {
            queryString.append(" order by ").append("exo:name");
        }
        if ("relevancy".equalsIgnoreCase(sort)) {
            queryString.append(" order by ").append("jcr:score");
        }
        queryString.append(" ").append(order);
        return queryString;
    }

    private boolean hasPermssionViewerPost(Node postNode, List<String> listOfUser) throws Exception {
        Node topicNode = postNode.getParent();
        PropertyReader reader = new PropertyReader(topicNode);
        List listOfCanviewrs = reader.list("exo:canView", new ArrayList());
        if (listOfUser != null && listOfUser.size() > 0 && reader.string("exo:owner", "").equals(listOfUser.get(0))) {
            return true;
        }
        return listOfCanviewrs.isEmpty() || Utils.hasPermission(listOfCanviewrs, listOfUser);
    }

    private ForumSearchResult setPropertyUnifiedSearch(Node nodeObj, String originQuery) throws Exception {
        ForumSearchResult forumSearch = this.setPropertyForForumSearch(nodeObj, Utils.POST);
        try {
            forumSearch.setRelevancy(1L);
            originQuery = CommonUtils.removeSpecialCharacterForUnifiedSearch((String)originQuery);
            String excerpt = this.highlightText(nodeObj.getProperty("exo:message").getString(), originQuery);
            if (!HIGHLIHT_PATTERN.matcher(excerpt).find() && excerpt.toLowerCase().indexOf(originQuery) < 0) {
                excerpt = this.highlightText(nodeObj.getProperty("exo:name").getString(), originQuery);
            }
            forumSearch.setExcerpt(excerpt);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to set property for unified search.", (Throwable)e);
        }
        return forumSearch;
    }

    private String highlightText(String message, String termToHighlight) {
        for (String term : termToHighlight.split(" ")) {
            message = message.replace(term, "<strong>" + term + "</strong>");
        }
        return message;
    }

    private List<ForumSearchResult> removeItemInList(List<ForumSearchResult> listSearchEvent, List<String> forumCanView, List<String> categoryCanView) {
        ArrayList<ForumSearchResult> tempListSearchEvent = new ArrayList<ForumSearchResult>();
        String path = null;
        for (ForumSearchResult forumSearch : listSearchEvent) {
            path = forumSearch.getPath();
            if (!path.contains(Utils.TOPIC)) {
                tempListSearchEvent.add(forumSearch);
                continue;
            }
            String[] strs = path.split("/");
            if (!categoryCanView.contains(strs[5]) && !forumCanView.contains(strs[6])) continue;
            tempListSearchEvent.add(forumSearch);
        }
        return tempListSearchEvent;
    }

    @Override
    public List<String> getForumUserCanView(List<String> listOfUser, List<String> listForumIds) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        List<String> listForum = new ArrayList<String>();
        Node categoryHome = this.getCategoryHome(sProvider);
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder();
        if (listOfUser == null || listOfUser.isEmpty()) {
            listOfUser = new ArrayList<String>();
            listOfUser.add("user_gest_uoom");
        }
        queryString.append("SELECT * FROM ").append("exo:forum").append(" WHERE (").append(Utils.buildSQLHasProperty("exo:viewer")).append(" OR ").append(Utils.buildSQLByUserInfo("exo:viewer", listOfUser)).append(")").append(" OR (").append(Utils.buildSQLByUserInfo("exo:moderators", listOfUser)).append(")");
        Query query = qm.createQuery(queryString.toString(), "sql");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        Node forumNode = null;
        String forumId = null;
        while (iter.hasNext()) {
            forumNode = iter.nextNode();
            forumId = forumNode.getName();
            if (listForumIds != null && !listForumIds.isEmpty()) {
                if (!listForumIds.contains(forumId)) continue;
                listForum.add(forumId);
                continue;
            }
            listForum.add(forumId);
        }
        if (!this.isAdminRole(listOfUser.get(0))) {
            Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, new ArrayList<String>(), listForum, "exo:userPrivate");
            listForum = mapList.get(Utils.FORUM);
        }
        return listForum;
    }

    @Override
    public List<ForumSearchResult> getAdvancedSearch(ForumEventQuery eventQuery, List<String> listCateIds, List<String> listForumIds) {
        List<ForumSearchResult> listSearchEvent;
        block9: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            listSearchEvent = new ArrayList<ForumSearchResult>();
            try {
                Node categoryHome = this.getCategoryHome(sProvider);
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                String path = eventQuery.getPath();
                if (path == null || path.length() <= 0) {
                    path = categoryHome.getPath();
                }
                eventQuery.setPath(path);
                String type = eventQuery.getType();
                String queryString = null;
                List<String> listOfUser = eventQuery.getListOfUser();
                if (eventQuery.getUserPermission() > 0L) {
                    Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "exo:userPrivate");
                    listCateIds = mapList.get(Utils.CATEGORY);
                    listForumIds = mapList.get(Utils.FORUM);
                }
                queryString = type.equals(Utils.CATEGORY) ? eventQuery.getPathQuery(listCateIds) : eventQuery.getPathQuery(listForumIds);
                Query query = qm.createQuery(queryString, "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                while (iter.hasNext()) {
                    Node nodeObj = iter.nextNode();
                    listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type));
                }
                if ((type.equals(Utils.POST) || type.equals(Utils.TOPIC)) && !Utils.isEmpty(eventQuery.getKeyValue())) {
                    boolean isAdmin = false;
                    if (eventQuery.getUserPermission() == 0L) {
                        isAdmin = true;
                    }
                    listSearchEvent.addAll(this.getSearchByAttachment(categoryHome, eventQuery.getPath(), eventQuery.getKeyValue(), listForumIds, eventQuery.getListOfUser(), isAdmin, type));
                }
                if (eventQuery.getUserPermission() > 0L) {
                    List<Object> categoryCanView = new ArrayList();
                    ArrayList<String> forumCanView = new ArrayList<String>();
                    Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, listCateIds, listForumIds, "@exo:viewer");
                    categoryCanView = mapList.get(Utils.CATEGORY);
                    forumCanView.addAll((Collection)mapList.get(Utils.FORUM));
                    forumCanView.addAll(this.getCachedDataStorage().getForumUserCanView(listOfUser, listForumIds));
                    if (categoryCanView.size() > 0 || forumCanView.size() > 0) {
                        listSearchEvent = this.removeItemInList(listSearchEvent, forumCanView, categoryCanView);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)"Failed to do advanced search", (Throwable)e);
            }
        }
        return listSearchEvent;
    }

    private List<ForumSearchResult> getSearchByAttachment(Node categoryHome, String path, String key, List<String> listForumIds, List<String> listOfUser, boolean isAdmin, String type) throws Exception {
        ArrayList<ForumSearchResult> listSearchEvent = new ArrayList<ForumSearchResult>();
        try {
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder strQuery = new StringBuilder();
            strQuery.append("/jcr:root").append(path).append("//element(*,nt:resource) [");
            strQuery.append("(jcr:contains(., '").append(key).append("*'))]");
            Query query = qm.createQuery(strQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            boolean isAdd = true;
            String type_ = type;
            while (iter.hasNext()) {
                Node nodeObj = iter.nextNode().getParent().getParent();
                if (!nodeObj.isNodeType("exo:post")) continue;
                if (type == null || type.length() == 0) {
                    type_ = nodeObj.getProperty("exo:isFirstPost").getBoolean() ? Utils.TOPIC : Utils.POST;
                } else if (!nodeObj.getProperty("exo:isFirstPost").getBoolean() ? type.equals(Utils.TOPIC) : !type.equals(Utils.TOPIC)) continue;
                if (!isAdmin && !listForumIds.isEmpty()) {
                    String path_ = nodeObj.getPath();
                    isAdd = listForumIds.contains(path_ = path_.substring(path_.lastIndexOf(Utils.FORUM), path_.lastIndexOf("/" + Utils.TOPIC)));
                }
                if (isAdd) {
                    List<String> list = Utils.valuesToList(nodeObj.getProperty("exo:userPrivate").getValues());
                    if (!list.get(0).equals("exoUserPri") && !Utils.isListContentItemList(listOfUser, list)) {
                        isAdd = false;
                    }
                    if (isAdd && !isAdmin && !Utils.hasPermission(listOfUser, list = Utils.valuesToList(nodeObj.getParent().getParent().getProperty("exo:moderators").getValues()))) {
                        Post post;
                        list = Utils.valuesToList(nodeObj.getParent().getProperty("exo:canView").getValues());
                        if (list != null && list.size() > 0 && !Utils.isEmpty(list.get(0)) && !Utils.hasPermission(listOfUser, list)) {
                            isAdd = false;
                        }
                        if (isAdd && (!(post = this.getPost(nodeObj)).getIsActiveByTopic() || !post.getIsApproved() || post.getIsHidden() || post.getIsWaiting())) {
                            isAdd = false;
                        }
                    }
                }
                if (!isAdd) continue;
                if (type_.equals(Utils.TOPIC)) {
                    nodeObj = nodeObj.getParent();
                }
                listSearchEvent.add(this.setPropertyForForumSearch(nodeObj, type_));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Search by attachment has failed", (Throwable)e);
        }
        return listSearchEvent;
    }

    private ForumSearchResult setPropertyForForumSearch(Node nodeObj, String type) throws Exception {
        ForumSearchResult forumSearch = new ForumSearchResult();
        forumSearch.setId(nodeObj.getName());
        forumSearch.setPath(nodeObj.getPath());
        PropertyReader reader = new PropertyReader(nodeObj);
        forumSearch.setName(reader.string("exo:name", ""));
        forumSearch.setType(type);
        forumSearch.setCreatedDate(reader.date("exo:createdDate"));
        if (type.equals(Utils.FORUM)) {
            if (reader.bool("exo:isClosed").booleanValue()) {
                forumSearch.setIcon("ForumCloseIcon");
            } else if (reader.bool("exo:isLock").booleanValue()) {
                forumSearch.setIcon("ForumLockedIcon");
            } else {
                forumSearch.setIcon("ForumNormalIcon");
            }
        } else if (type.equals(Utils.TOPIC)) {
            forumSearch.setContent(reader.string("exo:description"));
            if (reader.bool("exo:isClosed").booleanValue()) {
                forumSearch.setIcon("HotThreadNoNewClosePost");
            } else if (reader.bool("exo:isLock").booleanValue()) {
                forumSearch.setIcon("HotThreadNoNewLockPost");
            } else {
                forumSearch.setIcon("HotThreadNoNewPost");
            }
        } else if (type.equals(Utils.CATEGORY)) {
            forumSearch.setIcon("CategoryIcon");
        } else {
            forumSearch.setIcon(reader.string("exo:icon", ""));
            forumSearch.setContent(reader.string("exo:message"));
        }
        return forumSearch;
    }

    private Map<String, List<String>> getCategoryViewer(Node categoryHome, List<String> listOfUser, List<String> listCateIds, List<String> listForumIds, String property) throws Exception {
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>();
        if (listOfUser == null || listOfUser.isEmpty()) {
            listOfUser = new ArrayList<String>();
            listOfUser.add("user_gest_uoom");
        }
        QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder();
        queryString.append("/jcr:root").append(categoryHome.getPath()).append("/element(*,").append("exo:forumCategory").append(")[").append("(").append(Utils.buildXpathHasProperty(property)).append(" or ").append(Utils.buildXpathByUserInfo(property, listOfUser)).append(")").append(" or (").append(Utils.buildXpathByUserInfo("exo:moderators", listOfUser)).append(")").append("]");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        NodeIterator iter1 = null;
        if (iter.getSize() > 0L && iter.getSize() != categoryHome.getNodes().getSize()) {
            ArrayList<String> listForumId = new ArrayList<String>();
            ArrayList<String> listCateId = new ArrayList<String>();
            while (iter.hasNext()) {
                Node catNode = iter.nextNode();
                String cateId = catNode.getName();
                if (listCateIds != null && !listCateIds.isEmpty()) {
                    if (listCateIds.contains(cateId)) {
                        listCateId.add(cateId);
                    }
                } else {
                    listCateId.add(cateId);
                }
                iter1 = catNode.getNodes();
                while (iter1.hasNext()) {
                    Node forumNode = iter1.nextNode();
                    if (!forumNode.isNodeType("exo:forum")) continue;
                    String forumId = forumNode.getName();
                    if (listForumIds != null && !listForumIds.isEmpty()) {
                        if (!listForumIds.contains(forumId)) continue;
                        listForumId.add(forumId);
                        continue;
                    }
                    listForumId.add(forumId);
                }
            }
            mapList.put(Utils.FORUM, listForumId);
            mapList.put(Utils.CATEGORY, listCateId);
        } else if (iter.getSize() == 0L) {
            if (!property.equals("exo:viewer")) {
                listForumIds = new ArrayList<String>();
                listForumIds.add("forumId");
                mapList.put(Utils.FORUM, listForumIds);
                listCateIds = new ArrayList<String>();
                listCateIds.add("cateId");
                mapList.put(Utils.CATEGORY, listCateIds);
            } else {
                mapList.put(Utils.FORUM, new ArrayList());
                mapList.put(Utils.CATEGORY, new ArrayList());
            }
        } else {
            mapList.put(Utils.FORUM, listForumIds);
            mapList.put(Utils.CATEGORY, listCateIds);
        }
        return mapList;
    }

    @Override
    public void addWatch(int watchType, String path, List<String> values, String currentUser) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            if (watchType == -1) {
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer queryString = new StringBuffer();
                queryString.append("/jcr:root").append(categoryHome.getPath()).append("//*[@exo:id='").append(path).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iterator = result.getNodes();
                path = iterator.nextNode().getPath();
            }
            if (path.indexOf(categoryHome.getName()) < 0) {
                path = categoryHome.getPath() + "/" + path;
            }
            Node watchingNode = (Node)categoryHome.getSession().getItem(path);
            ArrayList<String> listUsers = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching")) {
                if (watchType == 1) {
                    ArrayList<String> listEmail = new ArrayList<String>();
                    if (watchingNode.hasProperty("exo:emailWatching")) {
                        listEmail.addAll(Utils.valuesToList(watchingNode.getProperty("exo:emailWatching").getValues()));
                    }
                    if (watchingNode.hasProperty("exo:userWatching")) {
                        listUsers.addAll(Utils.valuesToList(watchingNode.getProperty("exo:userWatching").getValues()));
                    }
                    for (String str : values) {
                        if (listEmail.contains(str)) continue;
                        listEmail.add(0, str);
                        listUsers.add(0, currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(listEmail));
                    watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listUsers));
                } else {
                    watchingNode.setProperty("exo:rssWatching", this.getValueProperty(watchingNode, "exo:rssWatching", currentUser));
                }
            } else {
                watchingNode.addMixin("exo:forumWatching");
                if (watchType == 1) {
                    for (int i = 0; i < values.size(); ++i) {
                        listUsers.add(currentUser);
                    }
                    watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(values));
                    watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listUsers));
                } else {
                    watchingNode.setProperty("exo:rssWatching", new String[]{currentUser});
                }
            }
            if (watchingNode.isNew()) {
                watchingNode.getSession().save();
            } else {
                watchingNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not add Watch for user: " + currentUser), (Throwable)e);
        }
    }

    @Override
    public void removeWatch(int watchType, String path, String values) throws Exception {
        if (Utils.isEmpty(values)) {
            return;
        }
        Node watchingNode = null;
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node categoryHome = this.getCategoryHome(sProvider);
        String string = categoryHome.getPath();
        if (path.indexOf(categoryHome.getName()) < 0) {
            path = string + "/" + path;
        }
        try {
            watchingNode = (Node)categoryHome.getSession().getItem(path);
            ArrayList<String> newValues = new ArrayList<String>();
            ArrayList<String> listNewUsers = new ArrayList<String>();
            ArrayList<String> userRSS = new ArrayList<String>();
            if (watchingNode.isNodeType("exo:forumWatching") && watchType == 1) {
                String[] emails = new String[]{};
                String[] listOldUsers = new String[]{};
                String[] listRss = new String[]{};
                PropertyReader reader = new PropertyReader(watchingNode);
                emails = reader.strings("exo:emailWatching", new String[0]);
                listOldUsers = reader.strings("exo:userWatching", new String[0]);
                listRss = reader.strings("exo:rssWatching", new String[0]);
                int n = listRss.length > listOldUsers.length ? listRss.length : listOldUsers.length;
                for (int i = 0; i < n; ++i) {
                    if (listOldUsers.length > i && !values.contains("/" + emails[i])) {
                        newValues.add(emails[i]);
                        listNewUsers.add(listOldUsers[i]);
                    }
                    if (listRss.length <= i || values.contains(listRss[i] + "/")) continue;
                    userRSS.add(listRss[i]);
                }
                watchingNode.setProperty("exo:emailWatching", Utils.getStringsInList(newValues));
                watchingNode.setProperty("exo:userWatching", Utils.getStringsInList(listNewUsers));
                watchingNode.setProperty("exo:rssWatching", Utils.getStringsInList(userRSS));
                if (watchingNode.isNew()) {
                    watchingNode.getSession().save();
                } else {
                    watchingNode.save();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove watch.", (Throwable)e);
        }
    }

    @Override
    public void updateEmailWatch(List<String> listNodeId, String newEmailAdd, String userId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node parentNode = this.getForumHomeNode(sProvider);
            QueryManager qm = parentNode.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer("/jcr:root").append(parentNode.getPath()).append("//element(*,exo:forumWatching)[(");
            for (int i = 0; i < listNodeId.size(); ++i) {
                if (i > 0) {
                    queryString.append(" or ");
                }
                queryString.append("@exo:id='").append(listNodeId.get(i)).append("'");
            }
            queryString.append(")]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            Node watchingNode = null;
            List listEmail = null;
            List listUsers = null;
            while (iterator.hasNext()) {
                watchingNode = iterator.nextNode();
                PropertyReader reader = new PropertyReader(watchingNode);
                listEmail = reader.list("exo:emailWatching", new ArrayList());
                listUsers = reader.list("exo:userWatching", new ArrayList());
                if (listUsers.contains(userId)) {
                    for (int i = 0; i < listUsers.size(); ++i) {
                        if (!((String)listUsers.get(i)).equals(userId)) continue;
                        listEmail.set(i, newEmailAdd);
                    }
                } else {
                    listUsers.add(userId);
                    listEmail.add(newEmailAdd);
                }
                watchingNode.setProperty("exo:emailWatching", listEmail.toArray(new String[listEmail.size()]));
                watchingNode.setProperty("exo:userWatching", listUsers.toArray(new String[listUsers.size()]));
                watchingNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to update email watch.", (Throwable)e);
        }
    }

    @Override
    public List<Watch> getWatchByUser(String userId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<Watch> listWatches = new ArrayList<Watch>();
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            StringBuffer rootPath = new StringBuffer(categoryHome.getPath());
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuffer queryString = new StringBuffer();
            queryString.append("/jcr:root").append(rootPath.toString()).append("//element(*,").append("exo:forumWatching").append(")[(@").append("exo:userWatching").append("='").append(userId).append("') or (@").append("exo:rssWatching").append("='").append(userId).append("')]");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            StringBuffer pathName = new StringBuffer();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                PropertyReader reader = new PropertyReader(node);
                List users = reader.list("exo:userWatching", new ArrayList());
                String[] emails = reader.strings("exo:emailWatching", new String[0]);
                List RSSUsers = reader.list("exo:rssWatching", new ArrayList());
                rootPath.setLength(0);
                rootPath.append(categoryHome.getPath());
                String path = node.getPath();
                pathName.setLength(0);
                String typeNode = node.isNodeType(Utils.TYPE_CATEGORY) ? Utils.TYPE_CATEGORY : (node.isNodeType(Utils.TYPE_FORUM) ? Utils.TYPE_FORUM : Utils.TYPE_TOPIC);
                for (String str : path.replace(rootPath.toString() + "/", "").split("/")) {
                    rootPath.append("/");
                    rootPath.append(str);
                    if (!Utils.isEmpty(pathName.toString())) {
                        pathName.append(" > ");
                    }
                    pathName.append(((Node)categoryHome.getSession().getItem(rootPath.toString())).getProperty("exo:name").getString());
                }
                Watch watch = new Watch();
                watch.setId(node.getName());
                watch.setNodePath(path);
                watch.setUserId(userId);
                watch.setPath(pathName.toString());
                watch.setTypeNode(typeNode);
                if (users.contains(userId)) {
                    watch.setEmail(emails[users.indexOf(userId)]);
                    watch.setIsAddWatchByEmail(true);
                } else {
                    watch.setIsAddWatchByEmail(false);
                }
                watch.setIsAddWatchByRSS(RSSUsers.contains(userId));
                listWatches.add(watch);
            }
            return listWatches;
        }
        catch (Exception e) {
            return listWatches;
        }
    }

    private void sendEmailNotification(List<String> addresses, Message message) throws Exception {
        this.pendingMessagesQueue.add(new SendMessageInfo(addresses, message));
    }

    @Override
    public Iterator<SendMessageInfo> getPendingMessages() throws Exception {
        Iterator<SendMessageInfo> pending = new ArrayList<SendMessageInfo>(this.pendingMessagesQueue).iterator();
        this.pendingMessagesQueue.clear();
        return pending;
    }

    @Override
    public void updateForum(String path) throws Exception {
        if (path == null || path.length() <= 0 || path.equals("/" + this.dataLocator.getForumHomeLocation())) {
            path = this.dataLocator.getForumHomeLocation();
            this.updateForum(path, true);
        } else {
            this.updateForum(path, false);
        }
    }

    private void updateForum(String path, boolean isReset) throws Exception {
        HashMap<String, Long> topicMap = new HashMap<String, Long>();
        HashMap<String, Long> postMap = new HashMap<String, Long>();
        if (path.indexOf("/") > 0) {
            path = "/" + path;
        }
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            String userId;
            long l;
            String owner;
            Node node;
            Node forumStatisticNode = this.getStatisticHome(sProvider).getNode("forumStatistic");
            QueryManager qm = forumStatisticNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery("/jcr:root" + path + "//element(*,exo:topic)", "xpath");
            QueryResult result = query.execute();
            NodeIterator topicIter = result.getNodes();
            query = qm.createQuery("/jcr:root" + path + "//element(*,exo:post)", "xpath");
            result = query.execute();
            NodeIterator postIter = result.getNodes();
            if (isReset) {
                forumStatisticNode.setProperty("exo:postCount", postIter.getSize());
                forumStatisticNode.setProperty("exo:topicCount", topicIter.getSize());
            } else if (path.indexOf(Utils.FORUM) == path.lastIndexOf(Utils.FORUM)) {
                PropertyReader statisticReader = new PropertyReader(forumStatisticNode);
                forumStatisticNode.setProperty("exo:postCount", statisticReader.l("exo:postCount", 0L) + postIter.getSize());
                forumStatisticNode.setProperty("exo:topicCount", statisticReader.l("exo:topicCount", 0L) + topicIter.getSize());
            }
            forumStatisticNode.save();
            while (topicIter.hasNext()) {
                node = topicIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (topicMap.containsKey(owner)) {
                    l = (Long)topicMap.get(owner) + 1L;
                    topicMap.put(owner, l);
                    continue;
                }
                l = 1L;
                topicMap.put(owner, l);
            }
            while (postIter.hasNext()) {
                node = postIter.nextNode();
                owner = node.getProperty("exo:owner").getString();
                if (postMap.containsKey(owner)) {
                    l = (Long)postMap.get(owner) + 1L;
                    postMap.put(owner, l);
                    continue;
                }
                l = 1L;
                postMap.put(owner, l);
            }
            Node profileHome = this.getUserProfileHome(sProvider);
            Iterator it = topicMap.entrySet().iterator();
            Calendar cal = this.getGreenwichMeanTime();
            while (it.hasNext()) {
                Node profile;
                userId = (String)it.next().getKey();
                if (userId.indexOf(Utils.DELETED) >= 0) continue;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, "exo:forumUserProfile");
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                    profile.setProperty("exo:lastPostDate", cal);
                }
                long l2 = isReset ? (Long)topicMap.get(userId) : profile.getProperty("exo:totalTopic").getLong() + (Long)topicMap.get(userId);
                profile.setProperty("exo:totalTopic", l2);
                if (!postMap.containsKey(userId)) continue;
                long t = isReset ? (Long)postMap.get(userId) : profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                profile.setProperty("exo:lastPostDate", cal);
                postMap.remove(userId);
            }
            it = postMap.entrySet().iterator();
            while (it.hasNext()) {
                Node profile;
                userId = (String)it.next().getKey();
                if (userId.indexOf(Utils.DELETED) >= 0) continue;
                if (profileHome.hasNode(userId)) {
                    profile = profileHome.getNode(userId);
                } else {
                    profile = profileHome.addNode(userId, "exo:forumUserProfile");
                    profile.setProperty("exo:userId", userId);
                    profile.setProperty("exo:lastLoginDate", cal);
                    profile.setProperty("exo:joinedDate", cal);
                }
                long t = isReset ? (Long)postMap.get(userId) : profile.getProperty("exo:totalPost").getLong() + (Long)postMap.get(userId);
                profile.setProperty("exo:totalPost", t);
                profile.setProperty("exo:lastPostDate", cal);
            }
            if (profileHome.isNew()) {
                profileHome.getSession().save();
            } else {
                profileHome.save();
            }
            int t = profileHome.hasNode(Utils.USER_PROFILE_DELETED) ? 1 : 0;
            forumStatisticNode.setProperty("exo:membersCount", profileHome.getNodes().getSize() - (long)t);
            forumStatisticNode.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to update forum", (Throwable)e);
        }
    }

    @Override
    public SendMessageInfo getMessageInfo(String name) throws Exception {
        SendMessageInfo messageInfo = (SendMessageInfo)this.infoMap.get(name);
        this.infoMap.remove(name);
        return messageInfo;
    }

    private String getPath(String index, String path) throws Exception {
        int t = path.lastIndexOf(index);
        if (t > 0) {
            path = path.substring(t + 1);
        }
        return path;
    }

    @Override
    public List<ForumSearchResult> getJobWattingForModerator(String[] paths) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<ForumSearchResult> list = new ArrayList<ForumSearchResult>();
        try {
            Node node;
            ForumSearchResult forumSearch;
            Node categoryHome = this.getCategoryHome(sProvider);
            String string = categoryHome.getPath();
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder builder = new StringBuilder();
            int l = paths.length;
            if (l > 0) {
                builder.append(" and (");
                for (int i = 0; i < l; ++i) {
                    if (i > 0) {
                        builder.append(" or ");
                    }
                    String str = this.getPath("/" + Utils.FORUM, paths[i]);
                    builder.append("@exo:path='").append(str).append("'");
                }
                builder.append(")");
            }
            StringBuilder stringBuilder = new StringBuilder("/jcr:root").append(string).append("//element(*,").append("exo:topic").append(")").append("[(@").append("exo:isApproved").append("='false' or @").append("exo:isWaiting").append("='true')").append((CharSequence)builder).append("] order by @exo:modifiedDate descending");
            Query query = qm.createQuery(stringBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearchResult();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.TOPIC);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:description").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
            stringBuilder = new StringBuilder("/jcr:root").append(string).append("//element(*,").append("exo:post").append(")").append("[(@").append("exo:isApproved").append("='false' or @").append("exo:isHidden").append("='true' or @").append("exo:isWaiting").append("='true')").append((CharSequence)builder).append("] order by @exo:modifiedDate descending");
            query = qm.createQuery(stringBuilder.toString(), "xpath");
            result = query.execute();
            iter = result.getNodes();
            while (iter.hasNext()) {
                forumSearch = new ForumSearchResult();
                node = iter.nextNode();
                forumSearch.setId(node.getName());
                forumSearch.setPath(node.getPath());
                forumSearch.setType(Utils.POST);
                forumSearch.setName(node.getProperty("exo:name").getString());
                forumSearch.setContent(node.getProperty("exo:message").getString());
                forumSearch.setCreatedDate(node.getProperty("exo:createdDate").getDate().getTime());
                list.add(forumSearch);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get waiting jobs for moderator", (Throwable)e);
        }
        return list;
    }

    @Override
    public int getJobWattingForModeratorByUser(String userId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        int job = 0;
        Node newProfileNode = this.getUserProfileHome(sProvider).getNode(userId);
        long t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
        if (t < 2L) {
            try {
                job = (int)newProfileNode.getProperty("exo:jobWattingForModerator").getLong();
            }
            catch (Exception e) {
                job = 0;
            }
        }
        return job;
    }

    private int getTotalJobWaitingForModerator(Session session, String userId) throws Exception {
        int totalJob = 0;
        try {
            Node newProfileNode = session.getRootNode().getNode(this.dataLocator.getUserProfilesLocation()).getNode(userId);
            long t = this.isAdminRole(userId) ? 0L : newProfileNode.getProperty("exo:userRole").getLong();
            if (t < 2L) {
                String[] paths;
                int l;
                Node categoryHome = session.getRootNode().getNode(this.dataLocator.getForumCategoriesLocation());
                String string = categoryHome.getPath();
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer buffer = new StringBuffer();
                if (t > 0L && (l = (paths = Utils.valuesToArray(newProfileNode.getProperty("exo:moderateForums").getValues())).length) > 0) {
                    buffer.append(" and (");
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            buffer.append(" or ");
                        }
                        String str = this.getPath("/" + Utils.FORUM, paths[i]);
                        buffer.append("@exo:path='").append(str).append("'");
                    }
                    buffer.append(")");
                }
                StringBuffer stringBuffer = new StringBuffer("/jcr:root").append(string).append("//element(*,").append("exo:topic").append(")").append("[(@").append("exo:isApproved").append("='false' or @").append("exo:isWaiting").append("='true')").append(buffer).append("]");
                Query query = qm.createQuery(stringBuffer.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                totalJob = (int)iter.getSize();
                stringBuffer = new StringBuffer("/jcr:root").append(string).append("//element(*,").append("exo:post").append(")").append("[(@").append("exo:isApproved").append("='false' or @").append("exo:isHidden").append("='true' or @").append("exo:isWaiting").append("='true')").append(buffer).append("]");
                query = qm.createQuery(stringBuffer.toString(), "xpath");
                result = query.execute();
                iter = result.getNodes();
                newProfileNode.setProperty("exo:jobWattingForModerator", (long)(totalJob += (int)iter.getSize()));
                newProfileNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get total job watting for moderator", (Throwable)e);
        }
        return totalJob;
    }

    private void getTotalJobWatting(SessionProvider sProvider, Set<String> userIds) {
        try {
            ContinuationService continuation = (ContinuationService)CommonUtils.getComponent(ContinuationService.class);
            if (continuation != null) {
                HashSet<String> set = new HashSet<String>(ForumServiceUtils.getUserPermission(userIds.toArray(new String[userIds.size()])));
                set.addAll(this.getAllAdministrator(sProvider));
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                Category cat = new Category();
                for (String userId : set) {
                    int job;
                    if (Utils.isEmpty(userId) || userId.indexOf("/") > 0 || userId.indexOf(":") > 0 || (job = this.getTotalJobWaitingForModerator(this.getForumHomeNode(sProvider).getSession(), userId)) < 0) continue;
                    cat.setCategoryName(String.valueOf(job));
                    JsonValue json = generatorImpl.createJsonObject((Object)cat);
                    continuation.sendMessage(userId, "/eXo/Application/Forum/messages", (Object)json, cat.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get total job waiting for moderator", (Throwable)e);
        }
    }

    public void sendNotificationMessage(ForumPrivateMessage message) {
        try {
            if (message != null) {
                ContinuationService continuation = (ContinuationService)CommonUtils.getComponent(ContinuationService.class);
                String[] sendTo = message.getSendTo().replaceAll(";", ",").split(",");
                String from = message.getFrom();
                message.setFrom(this.getScreenName(from));
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                JsonValue json = generatorImpl.createJsonObject((Object)message);
                for (int i = 0; i < sendTo.length; ++i) {
                    String to = sendTo[i].trim();
                    if (to.equals(from)) continue;
                    continuation.sendMessage(to, "/eXo/Application/Forum/NotificationMessage", (Object)json, message.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to send notification message:" + e.getMessage()));
        }
    }

    @Override
    public NodeIterator search(String queryString) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryString, "xpath");
            QueryResult result = query.execute();
            return result.getNodes();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to search", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateActiveUsers(String strQuery) {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            String path = this.getUserProfileHome(sProvider).getPath();
            StringBuilder stringBuilder = new StringBuilder();
            if (strQuery == null || strQuery.length() == 0) {
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(calendar.getTimeInMillis() - 864000000L);
                stringBuilder.append("/jcr:root").append(path).append("//element(*,").append("exo:forumUserProfile").append(")[").append("@exo:lastPostDate >= xs:dateTime('").append(ISO8601.format((Calendar)calendar)).append("')]");
            } else {
                stringBuilder.append("/jcr:root").append(path).append(strQuery);
            }
            QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(stringBuilder.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            Node statisticHome = this.getStatisticHome(sProvider);
            if (statisticHome.hasNode("forumStatistic")) {
                statisticHome.getNode("forumStatistic").setProperty("exo:activeUsers", iter.getSize());
                statisticHome.save();
            } else {
                ForumStatistic forumStatistic = new ForumStatistic();
                forumStatistic.setActiveUsers(iter.getSize());
                this.saveForumStatistic(forumStatistic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createCategoryFiles(List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        ByteArrayOutputStream outputStream = null;
        Node categoryHome = this.getCategoryHome(sessionProvider);
        Node cateNode = null;
        for (String categoryId : objectIds) {
            try {
                cateNode = categoryHome.getNode(categoryId);
                outputStream = new ByteArrayOutputStream();
                GregorianCalendar date = new GregorianCalendar();
                categoryHome.getSession().exportSystemView(cateNode.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(CommonUtils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)"Category", (Date)date.getTime(), (String)cateNode.getName()));
            }
            finally {
                outputStream.close();
            }
        }
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createForumFiles(String categoryId, List<String> objectIds, SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        List<Forum> forums = this.getCachedDataStorage().getForums(new ForumFilter(categoryId, true));
        for (Forum forum : forums) {
            if (objectIds.size() > 0 && !objectIds.contains(forum.getId())) continue;
            try (ByteArrayOutputStream outputStream = null;){
                outputStream = new ByteArrayOutputStream();
                Calendar calendar = GregorianCalendar.getInstance();
                this.getCategoryHome(sessionProvider).getSession().exportSystemView(forum.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(CommonUtils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)"Forum", (Date)calendar.getTime(), (String)forum.getId()));
            }
        }
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<File> createFilesFromNode(Node node, String type) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        if (node != null) {
            try (ByteArrayOutputStream outputStream = null;){
                outputStream = new ByteArrayOutputStream();
                Calendar calendar = GregorianCalendar.getInstance();
                node.getSession().exportSystemView(node.getPath(), (OutputStream)outputStream, false, false);
                listFiles.add(CommonUtils.getXMLFile((ByteArrayOutputStream)outputStream, (String)"eXo Knowledge Suite - Forum", (String)type, (Date)calendar.getTime(), (String)node.getName()));
            }
        }
        return listFiles;
    }

    protected List<File> createAllForumFiles(SessionProvider sessionProvider) throws Exception {
        ArrayList<File> listFiles = new ArrayList<File>();
        listFiles.addAll(this.createFilesFromNode(this.getAdminHome(sessionProvider), "AdministrationHome"));
        listFiles.addAll(this.createFilesFromNode(this.getUserProfileHome(sessionProvider), "UserProfileHome"));
        listFiles.addAll(this.createFilesFromNode(this.getTagHome(sessionProvider), "TagHome"));
        listFiles.addAll(this.createFilesFromNode(this.getBBCodesHome(sessionProvider), "forumBBCode"));
        listFiles.addAll(this.createFilesFromNode(this.getBanIPHome(sessionProvider), "BanIPHome"));
        listFiles.addAll(this.createFilesFromNode(this.getCategoryHome(sessionProvider), "CategoryHome"));
        return listFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object exportXML(String categoryId, String forumId, List<String> objectIds, String nodePath, ByteArrayOutputStream bos, boolean isExportAll) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            ArrayList<File> listFiles = new ArrayList<File>();
            if (!isExportAll) {
                if (categoryId != null) {
                    if (!Utils.isEmpty(forumId)) {
                        Node categoryHome = this.getCategoryHome(sProvider);
                        categoryHome.getSession().exportSystemView(nodePath, (OutputStream)bos, false, false);
                        return null;
                    }
                    listFiles.addAll(this.createForumFiles(categoryId, objectIds, sProvider));
                } else {
                    listFiles.addAll(this.createCategoryFiles(objectIds, sProvider));
                }
            } else {
                listFiles.addAll(this.createAllForumFiles(sProvider));
            }
            try (ZipOutputStream zipOutputStream = null;){
                zipOutputStream = new ZipOutputStream(new FileOutputStream("exportCategory.zip"));
                byte[] buffer = new byte[4096];
                FileInputStream inputStream = null;
                ZipEntry zipEntry = null;
                for (File f : listFiles) {
                    inputStream = new FileInputStream(f);
                    try {
                        int byteReads;
                        zipEntry = new ZipEntry(f.getPath());
                        zipOutputStream.putNextEntry(zipEntry);
                        while ((byteReads = inputStream.read(buffer)) != -1) {
                            zipOutputStream.write(buffer, 0, byteReads);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            File file = new File("exportCategory.zip");
            Iterator i$ = listFiles.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return file;
                }
                File f = (File)i$.next();
                f.deleteOnExit();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void importXML(String nodePath, ByteArrayInputStream bis, int typeImport) throws Exception {
        String nodeName = "";
        byte[] bdata = new byte[bis.available()];
        bis.read(bdata);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(bdata);
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        String typeNodeExport = doc.getFirstChild().getChildNodes().item(0).getChildNodes().item(0).getTextContent();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<String> patchNodeImport = new ArrayList<String>();
        try {
            Node forumHome = this.getForumHomeNode(sProvider);
            is = new ByteArrayInputStream(bdata);
            if (!typeNodeExport.equals("exo:forumCategory") && !typeNodeExport.equals("exo:forum")) {
                Session session;
                Node node;
                if (typeNodeExport.equals("exo:categoryHome")) {
                    nodePath = this.getCategoryHome(sProvider).getPath();
                    Node categoryHome = this.getCategoryHome(sProvider);
                    nodeName = "CategoryHome";
                    this.addDataFromXML(categoryHome, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:userProfileHome")) {
                    Node userProfile = this.getUserProfileHome(sProvider);
                    nodeName = "UserProfileHome";
                    nodePath = this.getUserProfileHome(sProvider).getPath();
                    this.addDataFromXML(userProfile, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:tagHome")) {
                    Node tagHome = this.getTagHome(sProvider);
                    nodePath = this.getTagHome(sProvider).getPath();
                    nodeName = "TagHome";
                    this.addDataFromXML(tagHome, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:forumBBCodeHome")) {
                    nodePath = this.dataLocator.getBBCodesLocation();
                    Node bbcodeNode = this.getBBCodesHome(sProvider);
                    nodeName = "forumBBCode";
                    this.addDataFromXML(bbcodeNode, nodePath, sProvider, is, nodeName);
                } else if (typeNodeExport.equals("exo:administrationHome")) {
                    nodePath = this.getForumSystemHome(sProvider).getPath();
                    node = this.getAdminHome(sProvider);
                    node.remove();
                    this.getForumSystemHome(sProvider).save();
                    typeImport = 2;
                    session = forumHome.getSession();
                    session.importXML(nodePath, (InputStream)is, typeImport);
                    session.save();
                } else {
                    if (!typeNodeExport.equals("exo:banIPHome")) throw new RuntimeException("unknown type of node to export :" + typeNodeExport);
                    nodePath = this.getForumSystemHome(sProvider).getPath();
                    node = this.getBanIPHome(sProvider);
                    node.remove();
                    this.getForumSystemHome(sProvider).save();
                    typeImport = 2;
                    session = forumHome.getSession();
                    session.importXML(nodePath, (InputStream)is, typeImport);
                    session.save();
                }
            } else {
                if (typeNodeExport.equals("exo:forumCategory")) {
                    if (nodePath.split("/").length == 6) {
                        throw new ConstraintViolationException();
                    }
                    nodePath = this.getCategoryHome(sProvider).getPath();
                }
                Session session = forumHome.getSession();
                NodeIterator iter = ((Node)session.getItem(nodePath)).getNodes();
                while (iter.hasNext()) {
                    patchNodeImport.add(iter.nextNode().getName());
                }
                session.importXML(nodePath, (InputStream)is, typeImport);
                session.save();
                NodeIterator newIter = ((Node)session.getItem(nodePath)).getNodes();
                while (newIter.hasNext()) {
                    Node node = newIter.nextNode();
                    if (patchNodeImport.contains(node.getName())) {
                        patchNodeImport.remove(node.getName());
                        continue;
                    }
                    patchNodeImport.add(node.getName());
                }
            }
            if (typeNodeExport.equals("exo:forumCategory") || typeNodeExport.equals("exo:forum")) {
                for (String string : patchNodeImport) {
                    this.updateForum(nodePath + "/" + string, false);
                }
                return;
            } else {
                if (!typeNodeExport.equals("exo:categoryHome")) return;
                this.updateForum(null);
            }
            return;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataFromXML(Node sourceNode, String nodePath, SessionProvider sessionProvider, InputStream is, String nodeName) throws Exception {
        Node forumHomeNode = this.getForumHomeNode(sessionProvider);
        Session session = forumHomeNode.getSession();
        Node tempNode = forumHomeNode.getParent().addNode("DataTemp");
        session.importXML(tempNode.getPath(), is, 0);
        session.save();
        Node importNode = tempNode.getNode(nodeName);
        try {
            this.copyFullNodes(sourceNode, importNode, session);
        }
        finally {
            tempNode.remove();
            forumHomeNode.getParent().save();
        }
    }

    private void copyFullNodes(Node sourceNode, Node importNode, Session session) throws Exception {
        NodeIterator sourceIter = sourceNode.getNodes();
        NodeIterator importIter = importNode.getNodes();
        Node srcTemp = null;
        Node importTemp = null;
        boolean flag = false;
        while (importIter.hasNext()) {
            flag = true;
            importTemp = importIter.nextNode();
            while (sourceIter.hasNext()) {
                srcTemp = sourceIter.nextNode();
                if (!importTemp.getName().equals(srcTemp.getName())) continue;
                this.copyFullNodes(srcTemp, importTemp, session);
                flag = false;
                break;
            }
            if (!flag) continue;
            String path = sourceNode.getPath() + "/" + importTemp.getName();
            try {
                session.getWorkspace().copy(importTemp.getPath(), path);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)(path + " or " + importTemp.getPath() + " does not exist: " + e.getMessage() + "\n" + e.getCause()));
            }
        }
    }

    @Override
    public void updateTopicAccess(String userId, String topicId) {
        if (this.updatingRead.containsKey(userId)) {
            this.updatingRead.get(userId).add(topicId);
        } else {
            ArrayList<String> value = new ArrayList<String>();
            value.add(topicId);
            this.updatingRead.put(userId, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeReads() {
        Map<String, List<String>> map = this.updatingRead;
        this.updatingRead = new ConcurrentHashMap<String, List<String>>();
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            Node userHome = this.getUserProfileHome(sProvider);
            long currentTime = this.getGreenwichMeanTime().getTimeInMillis();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                block14: {
                    if (userHome.hasNode(entry.getKey())) break block14;
                    return;
                }
                try {
                    Node profile = userHome.getNode(entry.getKey());
                    List values = new PropertyReader(profile).list("exo:readTopic", new ArrayList());
                    for (String topicId : entry.getValue()) {
                        int i = 0;
                        boolean isUpdated = false;
                        for (String vl : values) {
                            if (vl.indexOf(topicId) == 0) {
                                values.set(i, topicId + ":" + currentTime);
                                isUpdated = true;
                                break;
                            }
                            ++i;
                        }
                        if (!isUpdated) {
                            values.add(topicId + ":" + currentTime);
                        }
                        profile.setProperty("exo:readTopic", values.toArray(new String[values.size()]));
                    }
                }
                catch (Exception e) {
                    JCRDataStorage.logDebug(String.format("Failed to update user %s acess for topics %s", entry.getKey(), entry.getValue().toString()), e);
                }
            }
            userHome.getSession().save();
        }
    }

    @Override
    public void updateForumAccess(String userId, String forumId) {
        SessionProvider sysSession = CommonUtils.createSystemProvider();
        try {
            Node profile = this.getUserProfileHome(sysSession).getNode(userId);
            List<Object> values = new ArrayList();
            if (profile.hasProperty("exo:readForum")) {
                values = Utils.valuesToList(profile.getProperty("exo:readForum").getValues());
            }
            int i = 0;
            boolean isUpdated = false;
            for (String string : values) {
                if (string.indexOf(forumId) == 0) {
                    values.set(i, forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
                    isUpdated = true;
                    break;
                }
                ++i;
            }
            if (!isUpdated) {
                values.add(forumId + ":" + this.getGreenwichMeanTime().getTimeInMillis());
            }
            if (values.size() == 2 && Utils.isEmpty((String)values.get(0))) {
                values.remove(0);
            }
            profile.setProperty("exo:readForum", values.toArray(new String[values.size()]));
            profile.save();
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to update user %s acess for forum %s", userId, forumId));
        }
    }

    @Override
    public List<String> getBookmarks(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Node profile = this.getUserProfileHome(sProvider).getNode(userName);
        if (profile.hasProperty("exo:bookmark")) {
            return Utils.valuesToList(profile.getProperty("exo:bookmark").getValues());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getBanList() throws Exception {
        block3: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node banNode = this.getForumBanNode(sProvider);
                if (banNode.hasProperty("exo:ips")) {
                    return Utils.valuesToList(banNode.getProperty("exo:ips").getValues());
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Failed to get ban list", (Throwable)e);
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean addBanIP(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            return false;
        }
        ips.add(ip);
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node banNode = this.getForumBanNode(sProvider);
            banNode.setProperty("exo:ips", ips.toArray(new String[ips.size()]));
            if (banNode.isNew()) {
                banNode.getSession().save();
            } else {
                banNode.save();
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to add ban ip: " + ip), (Throwable)e);
            return false;
        }
    }

    @Override
    public void removeBan(String ip) throws Exception {
        List<String> ips = this.getBanList();
        if (ips.contains(ip)) {
            ips.remove(ip);
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node banNode = this.getForumBanNode(sProvider);
                banNode.setProperty("exo:ips", Utils.getStringsInList(ips));
                banNode.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove ban, ip: " + ip), (Throwable)e);
            }
        }
    }

    @Override
    public List<String> getForumBanList(String forumId) throws Exception {
        ArrayList<String> list;
        block4: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            list = new ArrayList<String>();
            try {
                Node forumNode;
                if (forumId.indexOf(".") > 0) {
                    forumId = StringUtils.replace((String)forumId, (String)".", (String)"/");
                }
                if ((forumNode = this.getCategoryHome(sProvider).getNode(forumId)).hasProperty("exo:banIPs")) {
                    list.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Failed to get forum ban list.", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public boolean addBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                return false;
            }
            ips.add(ip);
            forumNode.setProperty("exo:banIPs", Utils.getStringsInList(ips));
            if (forumNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to add ban ip forum.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void removeBanIPForum(String ip, String forumId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Node forumNode = this.getCategoryHome(sProvider).getNode(forumId);
            if (forumNode.hasProperty("exo:banIPs")) {
                ips.addAll(Utils.valuesToList(forumNode.getProperty("exo:banIPs").getValues()));
            }
            if (ips.contains(ip)) {
                ips.remove(ip);
                forumNode.setProperty("exo:banIPs", Utils.getStringsInList(ips));
                if (forumNode.isNew()) {
                    forumNode.getSession().save();
                } else {
                    forumNode.save();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to remove ban IP from forum", (Throwable)e);
        }
    }

    private List<String> getAllAdministrator(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getForumHomeNode(sProvider).getSession().getWorkspace().getQueryManager();
        StringBuilder pathQuery = new StringBuilder();
        pathQuery.append("/jcr:root").append(this.getUserProfileHome(sProvider).getPath()).append("//element(*,").append("exo:forumUserProfile").append(")[@exo:userRole=0]");
        Query query = qm.createQuery(pathQuery.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            Node userNode = iter.nextNode();
            list.add(userNode.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStatisticCounts(long topicCount, long postCount) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ReentrantLock lock = this.lock;
        try {
            long count;
            lock.lock();
            Node forumStatisticNode = this.getForumStatisticsNode(sProvider);
            PropertyReader reader = new PropertyReader(forumStatisticNode);
            if (topicCount != 0L) {
                count = reader.l("exo:topicCount");
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:topicCount", count + topicCount);
            }
            if (postCount != 0L) {
                count = reader.l("exo:postCount");
                if (count < 0L) {
                    count = 0L;
                }
                forumStatisticNode.setProperty("exo:postCount", count + postCount);
            }
            forumStatisticNode.save();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to update statistic counts", (Throwable)e);
            }
        }
        finally {
            lock.unlock();
            sProvider.close();
        }
    }

    private PruneSetting getPruneSetting(Node prunNode) throws Exception {
        PruneSetting pruneSetting = new PruneSetting();
        pruneSetting.setId(prunNode.getName());
        pruneSetting.setForumPath(prunNode.getParent().getPath());
        pruneSetting.setActive(prunNode.getProperty("exo:isActive").getBoolean());
        pruneSetting.setCategoryName(prunNode.getParent().getParent().getProperty("exo:name").getString());
        pruneSetting.setForumName(prunNode.getParent().getProperty("exo:name").getString());
        pruneSetting.setInActiveDay(prunNode.getProperty("exo:inActiveDay").getLong());
        pruneSetting.setPeriodTime(prunNode.getProperty("exo:periodTime").getLong());
        if (prunNode.hasProperty("exo:lastRunDate")) {
            pruneSetting.setLastRunDate(prunNode.getProperty("exo:lastRunDate").getDate().getTime());
        }
        return pruneSetting;
    }

    @Override
    public PruneSetting getPruneSetting(String forumPath) throws Exception {
        PruneSetting pruneSetting;
        block2: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            pruneSetting = new PruneSetting();
            try {
                Node forumNode = (Node)this.getCategoryHome(sProvider).getSession().getItem(forumPath);
                pruneSetting = this.getPruneSetting(forumNode.getNode(Utils.PRUNESETTING));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)("Failed to get Prune Settings: " + e.getMessage() + "\n" + e.getCause()));
            }
        }
        return pruneSetting;
    }

    @Override
    public List<PruneSetting> getAllPruneSetting() throws Exception {
        ArrayList<PruneSetting> prunList = new ArrayList<PruneSetting>();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        NodeIterator iter = this.getNodeIteratorAutoPruneSetting(sProvider, false);
        while (iter.hasNext()) {
            Node prunNode = iter.nextNode();
            prunList.add(this.getPruneSetting(prunNode));
        }
        return prunList;
    }

    @Override
    public void savePruneSetting(PruneSetting pruneSetting) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node pruneNode;
            String path = pruneSetting.getForumPath();
            Node forumNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(path);
            try {
                pruneNode = forumNode.getNode(Utils.PRUNESETTING);
            }
            catch (Exception e) {
                pruneNode = forumNode.addNode(Utils.PRUNESETTING, "exo:pruneSetting");
                pruneNode.setProperty("exo:id", pruneSetting.getId());
            }
            pruneNode.setProperty("exo:inActiveDay", pruneSetting.getInActiveDay());
            pruneNode.setProperty("exo:periodTime", pruneSetting.getPeriodTime());
            pruneNode.setProperty("exo:isActive", pruneSetting.isActive());
            if (pruneSetting.getLastRunDate() != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(pruneSetting.getLastRunDate());
                pruneNode.setProperty("exo:lastRunDate", calendar);
            }
            if (pruneNode.isNew()) {
                forumNode.getSession().save();
            } else {
                forumNode.save();
            }
            try {
                this.addOrRemoveSchedule(pruneSetting);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Failed to add or remove prune jobs", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save prune setting.", (Throwable)e);
        }
    }

    private void addOrRemoveSchedule(PruneSetting pSetting) throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        PeriodInfo periodInfo = new PeriodInfo(cal.getTime(), null, -1, pSetting.getPeriodTime() * 86400000L);
        JobInfo info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", AutoPruneJob.class);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        schedulerService.removeJob(info);
        if (pSetting.isActive()) {
            info = new JobInfo(pSetting.getId(), "KnowledgeSuite-forum", AutoPruneJob.class);
            info.setDescription(pSetting.getForumPath());
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            String repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
            JobDataMap jdatamap = new JobDataMap();
            jdatamap.put(Utils.CACHE_REPO_NAME, repoName);
            schedulerService.addPeriodJob(info, periodInfo, jdatamap);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("\n\nActivated " + info.getJobName()));
            }
        }
    }

    @Override
    public void runPrune(String forumPath) throws Exception {
        this.runPrune(this.getPruneSetting(forumPath));
    }

    @Override
    public void runPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node forumNode = (Node)this.getForumHomeNode(sProvider).getSession().getItem(pSetting.getForumPath());
            NodeIterator iter = this.getIteratorPrune(sProvider, pSetting);
            ArrayList<String> topicPruned = new ArrayList<String>();
            while (iter.hasNext()) {
                Node topic = iter.nextNode();
                topic.setProperty("exo:isActive", false);
                topic.save();
                topicPruned.add(topic.getPath());
                try {
                    Node forumN = topic.getParent();
                    if (new PropertyReader(forumN).string("exo:lastTopicPath", "").indexOf(topic.getName()) < 0) continue;
                    this.queryLastTopic(sProvider, forumN.getPath());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Failed to save new value last post date in forum", (Throwable)e);
                }
            }
            Node setting = forumNode.getNode(pSetting.getId());
            setting.setProperty("exo:lastRunDate", this.getGreenwichMeanTime());
            forumNode.save();
            DataStorage storage = this.getCachedDataStorage();
            if (storage instanceof CachedDataStorage) {
                for (String topicPath : topicPruned) {
                    ((CachedDataStorage)storage).clearTopicCache(storage.getTopicByPath(topicPath, false));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to run prune", (Throwable)e);
        }
    }

    private NodeIterator getIteratorPrune(SessionProvider sProvider, PruneSetting pSetting) throws Exception {
        Node forumHome = this.getForumHomeNode(sProvider);
        Node forumNode = (Node)forumHome.getSession().getItem(pSetting.getForumPath());
        Calendar newDate = this.getGreenwichMeanTime();
        newDate.setTimeInMillis(newDate.getTimeInMillis() - pSetting.getInActiveDay() * 86400000L);
        QueryManager qm = forumHome.getSession().getWorkspace().getQueryManager();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/jcr:root").append(forumNode.getPath()).append("/element(*,").append("exo:topic").append(")[ @").append("exo:isActive").append("='true' and @").append("exo:lastPostDate").append(" <= xs:dateTime('").append(ISO8601.format((Calendar)newDate)).append("')]");
        Query query = qm.createQuery(stringBuffer.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    @Override
    public long checkPrune(PruneSetting pSetting) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            return this.getIteratorPrune(sProvider, pSetting).getSize();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to check prune", (Throwable)e);
            }
            return 0L;
        }
    }

    @Override
    public InputStream createForumRss(String objectId, String link) throws Exception {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node node_ = null;
            if (objectId.indexOf(Utils.CATEGORY) == 0) {
                node_ = this.getNodeById(sProvider, objectId, Utils.CATEGORY);
                entries.addAll(this.categoryUpdated(node_));
            } else if (objectId.indexOf(Utils.FORUM) == 0) {
                node_ = this.getNodeById(sProvider, objectId, Utils.FORUM);
                entries.addAll(this.forumUpdated(node_));
            } else {
                node_ = this.getNodeById(sProvider, objectId, Utils.TOPIC);
                String link_ = node_.getProperty("exo:link").getString();
                link = Utils.isEmpty(link_) ? link : link_;
                entries.addAll(this.topicUpdated(node_));
            }
            SyndFeed feed = this.createNewFeed(node_, link);
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String s = output.outputString(feed);
            s = StringUtils.replace((String)s, (String)"&amp;", (String)"&");
            s = s.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            s = StringUtils.replace((String)s, (String)"ST[CDATA[", (String)"<![CDATA[");
            s = StringUtils.replace((String)s, (String)"END]]", (String)"]]>");
            return new ByteArrayInputStream(s.getBytes());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to create forum rss", (Throwable)e);
            }
            return null;
        }
    }

    private List<SyndEntry> categoryUpdated(Node cateNode) throws Exception {
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        NodeIterator iterator = cateNode.getNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            if (!node.isNodeType("exo:forum") || node.getProperty("exo:isClosed").getBoolean()) continue;
            entries.addAll(this.forumUpdated(node));
        }
        return entries;
    }

    private List<SyndEntry> forumUpdated(Node forumNode) throws Exception {
        ArrayList<SyndEntry> entries;
        block3: {
            entries = new ArrayList<SyndEntry>();
            try {
                QueryManager qm = forumNode.getSession().getWorkspace().getQueryManager();
                StringBuilder queryString = new StringBuilder("/jcr:root").append(forumNode.getPath()).append("//element(*,exo:topic)[@exo:isWaiting='false' and @exo:isActive='true' and @exo:isClosed='false' and (not(@exo:canView) or @exo:canView='' or @exo:canView=' ')]").append(" order by @exo:isSticky descending, @exo:lastPostDate descending");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                while (iter.hasNext()) {
                    entries.addAll(this.topicUpdated(iter.nextNode()));
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Failed to update syndEntry by forum.", (Throwable)e);
            }
        }
        return entries;
    }

    private List<SyndEntry> topicUpdated(Node topicNode) {
        ArrayList<SyndEntry> entries;
        block7: {
            entries = new ArrayList<SyndEntry>();
            try {
                Node forumNode = topicNode.getParent();
                Node categoryNode = forumNode.getParent();
                boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
                boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
                String topicName = topicNode.getName();
                if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Post" + topicName + " was not added to feed because category or forum has restricted audience"));
                    }
                    return null;
                }
                QueryManager qm = topicNode.getSession().getWorkspace().getQueryManager();
                StringBuffer stringBuffer = new StringBuffer("/jcr:root").append(topicNode.getPath()).append("//element(*,").append("exo:post").append(")").append((CharSequence)Utils.getPathQuery("true", "false", "false", "exoUserPri")).append(" order by @exo:createdDate ascending");
                Query query = qm.createQuery(stringBuffer.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator iter = result.getNodes();
                Node postNode = null;
                while (iter.hasNext()) {
                    postNode = iter.nextNode();
                    try {
                        entries.add(this.postUpdated(postNode));
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Failed to generate feed for post " + postNode.getPath()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)"Failed to update sundEntry by topic.", (Throwable)e);
            }
        }
        return entries;
    }

    private SyndEntry postUpdated(Node postNode) throws Exception {
        Node topicNode = postNode.getParent();
        String postName = postNode.getName();
        PropertyReader post = new PropertyReader(postNode);
        boolean notApproved = post.bool("exo:isApproved") == false;
        boolean isPrivatePost = !post.list("exo:userPrivate", new ArrayList()).contains("exoUserPri");
        boolean topicHasLimitedViewers = this.hasProperty(topicNode, "exo:canView");
        if (notApproved || isPrivatePost || topicHasLimitedViewers) {
            JCRDataStorage.logDebug("Post" + postName + " was not added to feed because it is private or topic has restricted audience or it is waiting for approval");
            return null;
        }
        Node forumNode = topicNode.getParent();
        Node categoryNode = forumNode.getParent();
        boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
        boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
        if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
            JCRDataStorage.logDebug("Post" + postName + " was not added to feed because category or forum has restricted audience");
            return null;
        }
        ArrayList<String> listContent = new ArrayList<String>();
        String message = post.string("exo:message");
        listContent.add(message);
        SyndContentImpl description = new SyndContentImpl();
        description.setType("text/html");
        description.setValue(this.getTitleRSS(message));
        String title = post.string("exo:name");
        Date created = post.date("exo:createdDate");
        String owner = post.string("exo:owner");
        String linkItem = post.string("exo:link");
        SyndEntry entry = this.createNewEntry(postName, title, linkItem, listContent, (SyndContent)description, created, owner);
        return entry;
    }

    private SyndFeed createNewFeed(Node node, String link) throws Exception {
        PropertyReader reader = new PropertyReader(node);
        String desc = reader.string("exo:description", " ");
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(this.getTitleRSS(reader.string("exo:name")));
        feed.setPublishedDate(reader.date("exo:createdDate", new Date()));
        feed.setLink(link);
        feed.setDescription(this.getTitleRSS(desc));
        feed.setEncoding("UTF-8");
        return feed;
    }

    private SyndEntry createNewEntry(String uri, String title, String link, List<String> listContent, SyndContent description, Date pubDate, String author) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setUri(uri);
        entry.setTitle(this.getTitleRSS(title));
        entry.setLink(link);
        entry.setContributors(listContent);
        entry.setDescription(description);
        entry.setPublishedDate(pubDate);
        entry.setAuthor(author);
        return entry;
    }

    private String getTitleRSS(String title) {
        title = CommonUtils.decodeSpecialCharToHTMLnumber((String)TransformHTML.getPlainText((String)title));
        return "ST[CDATA[" + StringEscapeUtils.unescapeHtml((String)TransformHTML.getTitleInHTMLCode((String)title, null)) + "END]]";
    }

    @Override
    public InputStream createUserRss(String userId, String link) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        try {
            Node node;
            Node subscriptionNode = this.getUserProfileHome(sProvider).getNode(userId + "/" + Utils.FORUM_SUBSCRIOTION + userId);
            PropertyReader reader = new PropertyReader(subscriptionNode);
            List cateIds = reader.list("exo:categoryIds", new ArrayList());
            for (String id : cateIds) {
                node = this.getNodeById(sProvider, id, Utils.CATEGORY);
                if (node == null) continue;
                entries.addAll(this.categoryUpdated(node));
            }
            List forumIds = reader.list("exo:forumIds", new ArrayList());
            for (String id : forumIds) {
                node = this.getNodeById(sProvider, id, Utils.FORUM);
                if (node == null || cateIds.contains(node.getParent().getName())) continue;
                entries.addAll(this.forumUpdated(node));
            }
            List topicIds = reader.list("exo:topicIds", new ArrayList());
            for (String id : topicIds) {
                node = this.getNodeById(sProvider, id, Utils.TOPIC);
                if (node == null || forumIds.contains(node.getParent().getName())) continue;
                entries.addAll(this.topicUpdated(node));
            }
        }
        catch (PathNotFoundException e) {
            LOG.info((Object)String.format("User %s doesn't subscribe anything.", userId));
        }
        catch (RepositoryException e) {
            JCRDataStorage.logDebug("Can not create feed data for user: " + userId, e);
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType("rss_2.0");
            feed.setTitle("Forum subscriptions for " + userId);
            feed.setPublishedDate(new Date());
            feed.setLink(link);
            feed.setDescription(" ");
            feed.setEncoding("UTF-8");
            feed.setEntries(entries);
            SyndFeedOutput output = new SyndFeedOutput();
            String s = output.outputString((SyndFeed)feed);
            s = StringUtils.replace((String)s, (String)"&amp;", (String)"&");
            s = s.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            s = StringUtils.replace((String)s, (String)"ST[CDATA[", (String)"<![CDATA[");
            s = StringUtils.replace((String)s, (String)"END]]", (String)"]]>");
            return new ByteArrayInputStream(s.getBytes());
        }
        catch (FeedException e) {
            LOG.error((Object)("Can not create RSS for user: " + userId), (Throwable)e);
            return new ByteArrayInputStream(("Can not create RSS for user: " + userId + "<br/>" + (Object)((Object)e)).getBytes());
        }
    }

    @Override
    public boolean populateUserProfile(User user, UserProfile profileTemplate, boolean isNew) throws Exception {
        boolean added = false;
        this.sessionManager.openSession();
        try {
            Node profile = null;
            Node profileHome = this.getUserProfileHome();
            String userName = user.getUserName();
            if (profileHome.hasNode(userName)) {
                if (isNew) {
                    LOG.warn((Object)("Request to add user " + userName + " was ignored because it already exists."));
                }
                profile = profileHome.getNode(userName);
                added = false;
            } else {
                profile = profileHome.addNode(userName, "exo:forumUserProfile");
                added = true;
            }
            Calendar cal = this.getGreenwichMeanTime();
            profile.setProperty("exo:userId", userName);
            profile.setProperty("exo:lastLoginDate", cal);
            profile.setProperty("exo:email", user.getEmail());
            profile.setProperty("exo:fullName", user.getDisplayName());
            profile.setProperty("exo:joinedDate", cal);
            if (this.isAdminRole(userName)) {
                profile.setProperty("exo:userTitle", "Administrator");
                profile.setProperty("exo:userRole", 0L);
            } else {
                profile.setProperty("exo:userRole", 2L);
            }
            if (profileTemplate != null) {
                profile.setProperty("exo:timeZone", profileTemplate.getTimeZone());
                profile.setProperty("exo:shortDateformat", profileTemplate.getShortDateFormat());
                profile.setProperty("exo:longDateformat", profileTemplate.getLongDateFormat());
                profile.setProperty("exo:timeFormat", profileTemplate.getTimeFormat());
                profile.setProperty("exo:maxTopic", profileTemplate.getMaxTopicInPage());
                profile.setProperty("exo:maxPost", profileTemplate.getMaxPostInPage());
            }
            if (profileHome.isNew()) {
                profileHome.getSession().save();
            } else {
                profileHome.save();
            }
            boolean bl = added;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)("Error while populating user profile: " + e.getMessage()));
            throw e;
        }
        finally {
            this.sessionManager.closeSession(true);
        }
    }

    @Override
    public String getLatestUser() throws Exception {
        block4: {
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node profileHome = this.getUserProfileHome(sProvider);
                if (profileHome.hasNodes()) {
                    QueryManager qm = profileHome.getSession().getWorkspace().getQueryManager();
                    StringBuilder pathQuery = new StringBuilder();
                    pathQuery.append("/jcr:root").append(profileHome.getPath()).append("/element(*,exo:forumUserProfile) order by @exo:joinedDate descending");
                    Query query = qm.createQuery(pathQuery.toString(), "xpath");
                    QueryResult result = query.execute();
                    NodeIterator iter = result.getNodes();
                    if (iter.getSize() > 0L) {
                        Node node = iter.nextNode();
                        return node.getName();
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Failed to get latest user login.", (Throwable)e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastLoginDate(String userId) throws Exception {
        this.sessionManager.openSession();
        try {
            Node userProfileHome = this.getUserProfileHome();
            if (userProfileHome.hasNode(userId)) {
                userProfileHome.getNode(userId).setProperty("exo:lastLoginDate", this.getGreenwichMeanTime());
                userProfileHome.save();
            }
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private List<String> getCategoriesUserCanview(Node categoryHome, List<String> listOfUser) throws Exception {
        ArrayList<String> categoryCanView = new ArrayList<String>();
        Map<String, List<String>> mapPrivate = this.getCategoryViewer(categoryHome, listOfUser, new ArrayList<String>(), new ArrayList<String>(), "exo:userPrivate");
        List<String> categoryIds = mapPrivate.get(Utils.CATEGORY);
        Map<String, List<String>> mapList = this.getCategoryViewer(categoryHome, listOfUser, null, new ArrayList<String>(), "exo:viewer");
        ArrayList categoryView = mapList.get(Utils.CATEGORY);
        if (categoryIds.contains("cateId") || categoryView != null && categoryView.isEmpty()) {
            return null;
        }
        if (categoryIds.isEmpty()) {
            categoryCanView.addAll(categoryView == null ? new ArrayList() : categoryView);
        } else {
            for (String string : categoryIds) {
                if (categoryView != null && !categoryView.contains(string)) continue;
                categoryCanView.add(string);
            }
        }
        return categoryCanView;
    }

    private boolean postIsPublicByParent(Node postNode) throws Exception {
        Node node = postNode.getParent();
        if (!new PropertyReader(node).list("exo:canView", Collections.EMPTY_LIST).isEmpty()) {
            return false;
        }
        if (!new PropertyReader(node = node.getParent()).list("exo:viewer", Collections.EMPTY_LIST).isEmpty()) {
            return false;
        }
        if (!new PropertyReader(node = node.getParent()).list("exo:viewer", Collections.EMPTY_LIST).isEmpty()) {
            return false;
        }
        return new PropertyReader(node).list("exo:userPrivate", Collections.EMPTY_LIST).isEmpty();
    }

    private boolean checkPermssionCanView(Node postNode, boolean isUserLogin, List<String> categoryCanView, List<String> forumCanView) throws Exception {
        if (isUserLogin) {
            String[] path = postNode.getPath().split("/");
            return !(!categoryCanView.isEmpty() && !categoryCanView.contains(path[path.length - 4]) || !forumCanView.isEmpty() && !forumCanView.contains(path[path.length - 3]));
        }
        return this.postIsPublicByParent(postNode);
    }

    private List<Post> getPostByQuery(Node categoryHome, QueryImpl impl, int number, String userName, boolean isAdmin) throws Exception {
        ArrayList<Post> list = new ArrayList<Post>();
        List<Object> categoryCanView = new ArrayList();
        ArrayList<String> forumCanView = new ArrayList<String>();
        boolean isUserLogin = false;
        if (!Utils.isEmpty(userName) && !"user_gest_uoom".equals(userName)) {
            isUserLogin = true;
            if (!isAdmin) {
                List listOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
                categoryCanView = this.getCategoriesUserCanview(categoryHome, listOfUser);
                if (categoryCanView == null) {
                    return list;
                }
                forumCanView.addAll(this.getCachedDataStorage().getForumUserCanView(listOfUser, new ArrayList<String>()));
            }
        }
        int offset = 0;
        int count = 0;
        while (count < number) {
            impl.setOffset((long)offset);
            int limit = number + offset;
            impl.setLimit((long)limit);
            QueryResult qr = impl.execute();
            NodeIterator iter = qr.getNodes();
            if (iter.getSize() <= 0L) {
                return list;
            }
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!isAdmin && !this.checkPermssionCanView(node, isUserLogin, categoryCanView, forumCanView)) continue;
                list.add(this.getPost(node));
                if (++count != number) continue;
            }
            offset = limit;
        }
        return list;
    }

    @Override
    public List<Post> getRecentPostsForUser(String userName, int number) throws Exception {
        List<Post> list;
        block7: {
            if (number <= 0) {
                return new ArrayList<Post>();
            }
            if (Utils.isEmpty(userName) || "user_gest_uoom".equals(userName)) {
                return this.getNewPosts(number);
            }
            list = new ArrayList<Post>();
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                boolean isAdmin = this.isAdminRole(userName);
                if (!isAdmin) {
                    isAdmin = new PropertyReader(this.getUserProfileNode(this.getUserProfileHome(sProvider), userName)).l("exo:userRole", 3L) == 0L;
                }
                Node categoryHome = this.getCategoryHome(sProvider);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,").append("exo:post").append(")[(");
                if (!isAdmin) {
                    stringBuffer.append("(@").append("exo:isApproved").append("='true') and (@").append("exo:isHidden").append("='false') and (@").append("exo:isWaiting").append("='false') and (@").append("exo:isActiveByTopic").append("='true') and ");
                }
                stringBuffer.append("(@").append("exo:userPrivate").append("='exoUserPri' or @").append("exo:userPrivate").append("='").append(userName).append("'))]").append(" order by @").append("exo:createdDate").append(" descending");
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery(stringBuffer.toString(), "xpath");
                if (query instanceof QueryImpl) {
                    list = this.getPostByQuery(categoryHome, (QueryImpl)query, number, userName, isAdmin);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)"Failed to get new post.", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public List<Post> getNewPosts(int number) throws Exception {
        List<Post> list;
        block3: {
            list = new ArrayList<Post>();
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            try {
                Node categoryHome = this.getCategoryHome(sProvider);
                QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("/jcr:root").append(categoryHome.getPath()).append("//element(*,").append("exo:post").append(") [((@").append("exo:isApproved").append("='true') and (@").append("exo:isHidden").append("='false') and (@").append("exo:isWaiting").append("='false') and (@").append("exo:isActiveByTopic").append("='true') and (@").append("exo:userPrivate").append("='exoUserPri'))] order by @").append("exo:createdDate").append(" descending");
                Query query = qm.createQuery(stringBuffer.toString(), "xpath");
                if (query instanceof QueryImpl) {
                    list = this.getPostByQuery(categoryHome, (QueryImpl)query, number, "", false);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Failed to get new post.", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public boolean deleteUserProfile(String userId) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node profileDeleted;
            Node profileHome = this.getUserProfileHome(sProvider);
            Node profile = profileHome.getNode(userId);
            Session session = profileHome.getSession();
            profile.setProperty("exo:userRole", 4L);
            profile.setProperty("exo:userTitle", "User deleted");
            profile.setProperty("exo:moderateCategory", new String[0]);
            profile.setProperty("exo:moderateForums", new String[0]);
            profile.save();
            StringBuilder id = new StringBuilder(userId).append(Utils.DELETED);
            try {
                profileDeleted = profileHome.getNode(Utils.USER_PROFILE_DELETED);
                long index = profileDeleted.getNodes().getSize();
                if (index > 0L) {
                    id.append(index);
                }
            }
            catch (Exception e) {
                profileDeleted = profileHome.addNode(Utils.USER_PROFILE_DELETED, "exo:userDeleted");
                session.save();
                this.deletedUserCalculateListener(profileDeleted);
            }
            session.getWorkspace().move(profile.getPath(), profileDeleted.getPath() + "/" + id);
            try {
                Node avatarHome = session.getRootNode().getNode(this.dataLocator.getAvatarsLocation());
                if (avatarHome.hasNode(userId)) {
                    avatarHome.getNode(userId).remove();
                }
            }
            catch (Exception e) {
                LOG.info((Object)"User deleted has not avatar !!!");
            }
            session.save();
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public void processEnabledUser(String userName, String email, boolean isEnabled) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        if (!isEnabled && !CommonUtils.isEmpty((String)userName)) {
            this.processWatched(sProvider, userName);
        }
        if (!isEnabled && !CommonUtils.isEmpty((String)email)) {
            this.processForumNotifyEmail(sProvider, email);
        }
        if (!CommonUtils.isEmpty((String)userName)) {
            this.processUserProfile(sProvider, userName, isEnabled);
        }
    }

    private void processUserProfile(SessionProvider sProvider, String userName, boolean isEnabled) {
        try {
            Node profileHome = this.getUserProfileHome(sProvider);
            if (profileHome.hasNode(userName)) {
                Node profileNode = profileHome.getNode(userName);
                if (!profileNode.isNodeType("exo:disabled")) {
                    profileNode.addMixin("exo:disabled");
                }
                profileNode.setProperty("exo:isDisabled", !isEnabled);
                profileHome.getSession().save();
            } else {
                LOG.warn((Object)String.format("Forum's profile(%s) not found!", userName));
            }
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Process to to update status disabled/enabled of used %s is unsuccessfully.", userName), e);
        }
    }

    private void processWatched(SessionProvider sProvider, String userName) {
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append("exo:forumWatching");
            sqlQuery.append(" WHERE ").append("exo:userWatching").append("='").append(userName).append("'");
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            NodeIterator iter = query.execute().getNodes();
            while (iter.hasNext()) {
                Node watchedNode = iter.nextNode();
                this.updateWatchedProperty(watchedNode, userName);
            }
            categoryHome.getSession().save();
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Removes UserName %s is unsuccessfully.", userName), e);
        }
    }

    private void processForumNotifyEmail(SessionProvider sProvider, String email) {
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append("exo:forum");
            sqlQuery.append(" WHERE (").append("exo:notifyWhenAddTopic").append("='").append(email).append("' OR ").append("exo:notifyWhenAddPost").append("='").append(email).append("')");
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            NodeIterator iter = query.execute().getNodes();
            while (iter.hasNext()) {
                Node forumNode = iter.nextNode();
                this.updateForumNotifyEmail(forumNode, email);
            }
            categoryHome.getSession().save();
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Removes email %s is unsuccessfully.", email), e);
        }
    }

    private void updateForumNotifyEmail(Node forumNode, String email) {
        try {
            this.removeValueProperty(forumNode, "exo:notifyWhenAddTopic", email);
            this.removeValueProperty(forumNode, "exo:notifyWhenAddPost", email);
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Updated forum notify of email %s is unsuccessfully.", email), e);
        }
    }

    private int removeValueProperty(Node node, String property, String removeValue) throws Exception {
        Object[] values = new PropertyReader(node).strings(property, new String[0]);
        int index = ArrayUtils.indexOf((Object[])values, (Object)removeValue);
        if (index >= 0) {
            node.setProperty(property, (String[])ArrayUtils.remove((Object[])values, (int)index));
        }
        return index;
    }

    private void updateWatchedProperty(Node watchedNode, String userName) {
        try {
            int index = this.removeValueProperty(watchedNode, "exo:userWatching", userName);
            if (index >= 0) {
                Object[] emails = new PropertyReader(watchedNode).strings("exo:emailWatching", new String[0]);
                watchedNode.setProperty("exo:emailWatching", (String[])ArrayUtils.remove((Object[])emails, (int)index));
            }
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Updated watched user %s is unsuccessfully.", userName), e);
        }
    }

    @Override
    public void calculateDeletedUser(String userName) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        String tempUserName = userName;
        userName = tempUserName.substring(0, tempUserName.indexOf(Utils.DELETED));
        try {
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String[] strs = new String[]{"exo:owner", "exo:modifiedBy", "exo:lastPostBy", "exo:userPrivate", "exo:moderators", "exo:createTopicRole", "exo:poster", "exo:viewer", "exo:canPost", "exo:canView", "exo:userWatching", "exo:rssWatching"};
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < strs.length; ++i) {
                if (i > 0) {
                    builder.append(" or ");
                }
                builder.append("(@").append(strs[i]).append("='").append(JCRQueryUtils.escapeSimpleQuoteCharacter((String)userName)).append("')");
            }
            StringBuilder pathQuery = new StringBuilder();
            pathQuery.append("/jcr:root").append(categoryHome.getPath()).append("//*[").append((CharSequence)builder).append("]");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:forumCategory") && !node.isNodeType("exo:forum") && !node.isNodeType("exo:topic") && !node.isNodeType("exo:post")) continue;
                for (int i = 0; i < strs.length; ++i) {
                    if (i < 3) {
                        if (!new PropertyReader(node).string(strs[i], "").equals(userName)) continue;
                        node.setProperty(strs[i], tempUserName);
                        continue;
                    }
                    if (strs[i].equals("exo:userWatching")) {
                        this.updateWatchedProperty(node, userName);
                        continue;
                    }
                    this.removeValueProperty(node, strs[i], userName);
                }
            }
            if (categoryHome.isNew()) {
                categoryHome.getSession().save();
            } else {
                categoryHome.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to calculate deleting user.", (Throwable)e);
        }
    }

    @Override
    public void calculateDeletedGroup(String groupId, String groupName) throws Exception {
        try {
            Node forumSpaceNode = this.getNodeById(CommonUtils.createSystemProvider(), Utils.FORUM_SPACE_ID_PREFIX + groupName, Utils.FORUM);
            if (forumSpaceNode != null) {
                LOG.info((Object)("\nINFO: Delete forum in space: " + forumSpaceNode.getName()));
                this.removeForum(forumSpaceNode.getParent().getName(), forumSpaceNode.getName());
            }
            SessionProvider sProvider = CommonUtils.createSystemProvider();
            Node categoryHome = this.getCategoryHome(sProvider);
            QueryManager qm = categoryHome.getSession().getWorkspace().getQueryManager();
            String[] strs = new String[]{"exo:userPrivate", "exo:createTopicRole", "exo:poster", "exo:viewer", "exo:canPost", "exo:canView", "exo:moderators"};
            StringBuilder pathQuery = new StringBuilder("/jcr:root").append(categoryHome.getPath()).append("//*[");
            for (int i = 0; i < strs.length; ++i) {
                if (i > 0) {
                    pathQuery.append(" or ");
                }
                pathQuery.append("(@").append(strs[i]).append("='").append(groupId).append("') or (jcr:contains(@").append(strs[i]).append(", '").append(groupId).append("'))");
            }
            pathQuery.append("]");
            Query query = qm.createQuery(pathQuery.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:forumCategory") && !node.isNodeType("exo:forum") && !node.isNodeType("exo:topic")) continue;
                boolean isSave = false;
                PropertyReader reader = new PropertyReader(node);
                for (int i = 0; i < strs.length; ++i) {
                    int oldSize;
                    List<String> list = reader.list(strs[i], new ArrayList());
                    if (list.isEmpty() || (oldSize = list.size()) <= (list = JCRDataStorage.containsGroup(list, groupId)).size() && !list.get(0).equals("")) continue;
                    if (strs[i].equals("exo:moderators")) {
                        node.setProperty("exo:tempModerators", reader.strings("exo:moderators", new String[]{""}));
                        node.save();
                    }
                    node.setProperty(strs[i], list.toArray(new String[list.size()]));
                    isSave = true;
                }
                if (!isSave) continue;
                node.save();
            }
        }
        catch (Exception e) {
            JCRDataStorage.logDebug("Failed to calculate deleted Group.", e);
        }
    }

    public static List<String> containsGroup(List<String> list, String groupId) {
        ArrayList<String> ls = new ArrayList<String>();
        for (String string : list) {
            if (string.indexOf(groupId) >= 0) continue;
            ls.add(string);
        }
        if (ls.isEmpty()) {
            ls.add("");
        }
        return ls;
    }

    @Override
    public List<InitializeForumPlugin> getDefaultPlugins() {
        return this.defaultPlugins;
    }

    @Override
    public List<RoleRulesPlugin> getRulesPlugins() {
        return this.rulesPlugins;
    }

    @Override
    public Map<String, String> getServerConfig() {
        return this.serverConfig;
    }

    @Override
    public KSDataLocation getDataLocation() {
        return this.dataLocator;
    }

    public void setDataLocator(KSDataLocation dataLocator) {
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
        this.repository = dataLocator.getRepository();
        this.workspace = dataLocator.getWorkspace();
        LOG.info((Object)("JCR Data Storage for forum initialized to " + dataLocator));
    }

    private static void logDebug(String message, Throwable e) {
        LOG.warn((Object)message);
        if (LOG.isDebugEnabled() && e != null) {
            LOG.debug((Object)e.getMessage(), e);
        }
    }

    private static void logDebug(String message) {
        JCRDataStorage.logDebug(message, null);
    }

    private Calendar getGreenwichMeanTime() {
        return CommonUtils.getGreenwichMeanTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveActivityIdForOwner(String ownerId, String type, String activityId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ReentrantLock localLock = this.lock;
        try {
            localLock.lock();
            Node ownerNode = this.getNodeById(sProvider, ownerId, type);
            ActivityTypeUtils.attachActivityId((Node)ownerNode, (String)activityId);
            ownerNode.save();
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Failed to attach activityId %s for node %s ", activityId, ownerId), e);
        }
        finally {
            localLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveActivityIdForOwner(String ownerPath, String activityId) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ReentrantLock localLock = this.lock;
        try {
            localLock.lock();
            Node ownerNode = this.getNodeAt(sProvider, ownerPath);
            if (ownerNode != null) {
                ActivityTypeUtils.attachActivityId((Node)ownerNode, (String)activityId);
                ownerNode.save();
            }
        }
        catch (Exception e) {
            JCRDataStorage.logDebug(String.format("Failed to save attach activityId %s for node %s ", activityId, ownerPath), e);
        }
        finally {
            localLock.unlock();
        }
    }

    @Override
    public String getActivityIdForOwner(String ownerId, String type) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node ownerNode = this.getNodeById(sProvider, ownerId, type);
            if (ownerNode != null) {
                return ActivityTypeUtils.getActivityId((Node)ownerNode);
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get attach activityId for %s: %s ", type, ownerId), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getActivityIdForOwner(String ownerPath) {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node ownerNode = this.getNodeAt(sProvider, ownerPath);
            if (ownerNode != null) {
                return ActivityTypeUtils.getActivityId((Node)ownerNode);
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to get attach activityId for %s ", ownerPath), (Throwable)e);
        }
        return null;
    }

    private StringBuilder jcrPathLikeAndNotLike(String nodeType, String fullPath) {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append(nodeType).append(" WHERE (").append("jcr:path LIKE '").append(fullPath).append("/%' AND NOT jcr:path LIKE '").append(fullPath).append("/%/%'").append(")");
        return sqlQuery;
    }

    @Override
    public List<UserProfile> searchUserProfileByFilter(UserProfileFilter userProfileFilter, int offset, int limit) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        ArrayList<UserProfile> list = new ArrayList<UserProfile>();
        try {
            DataStorage storage = this.getCachedDataStorage();
            Node userProfileNode = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileNode.getSession().getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)qm.createQuery(this.buildSearchUserProfileQuery(userProfileFilter.getSearchKey()), "sql");
            query.setOffset((long)offset);
            query.setLimit((long)limit);
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                list.add(storage.getQuickProfile(node.getName()));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Get UserProfile by filter failed.", (Throwable)e);
        }
        return list;
    }

    @Override
    public int getUserProfileByFilterCount(UserProfileFilter userProfileFilter) throws Exception {
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        try {
            Node userProfileNode = this.getUserProfileHome(sProvider);
            QueryManager qm = userProfileNode.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(this.buildSearchUserProfileQuery(userProfileFilter.getSearchKey()), "sql");
            QueryResult result = query.execute();
            NodeIterator iterator = result.getNodes();
            return (int)iterator.getSize();
        }
        catch (Exception e) {
            LOG.warn((Object)"Get count of UserProfile by filter failed.", (Throwable)e);
            return 0;
        }
    }

    private String buildSearchUserProfileQuery(String searchKey) {
        String fullPath = "/" + this.dataLocator.getUserProfilesLocation();
        StringBuilder sqlQuery = this.jcrPathLikeAndNotLike(Utils.USER_PROFILES_TYPE, fullPath);
        if (!Utils.isEmpty(searchKey)) {
            searchKey = searchKey.replace("*", "%");
            sqlQuery.append(" AND (").append("exo:userId").append(" LIKE '%").append(searchKey).append("%' OR ").append("exo:fullName").append(" LIKE '%").append(searchKey).append("%' OR ").append("exo:screenName").append(" LIKE '%").append(searchKey).append("%'").append(")");
        }
        sqlQuery.append(" AND (").append("exo:isDisabled").append(" IS NULL OR ").append("exo:isDisabled").append("<>'true')");
        return sqlQuery.toString();
    }

    @Override
    public void removeCacheUserProfile(String userName) {
    }

    private NodeIterator getNodeIteratorBySQLQuery(SessionProvider sProvider, String sqlQuery, int offset, int limit, boolean caseInsensitiveOrder) throws Exception {
        QueryManager qm = this.sessionManager.getSession(sProvider).getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(sqlQuery, "sql");
        if (limit > 0) {
            query.setOffset((long)offset);
            query.setLimit((long)limit);
        }
        if (caseInsensitiveOrder) {
            query.setCaseInsensitiveOrder(true);
        }
        QueryResult result = query.execute();
        return result.getNodes();
    }

    class SaveAvatarTask
    implements JCRTask<Boolean> {
        String userId;
        ForumAttachment fileAttachment;

        public SaveAvatarTask(String userId, ForumAttachment fileAttachment) {
            this.userId = userId;
            this.fileAttachment = fileAttachment;
        }

        public Boolean execute(Session session) throws Exception {
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            Node avatarNode = null;
            Boolean wasNew = false;
            if (ksAvatarHomnode.hasNode(this.userId)) {
                avatarNode = ksAvatarHomnode.getNode(this.userId);
            } else {
                avatarNode = ksAvatarHomnode.addNode(this.userId, "nt:file");
                wasNew = true;
            }
            ForumServiceUtils.reparePermissions(avatarNode, "any");
            Node nodeContent = null;
            nodeContent = avatarNode.hasNode("jcr:content") ? avatarNode.getNode("jcr:content") : avatarNode.addNode("jcr:content", "nt:resource");
            nodeContent.setProperty("jcr:mimeType", this.fileAttachment.getMimeType());
            nodeContent.setProperty("jcr:data", this.fileAttachment.getInputStream());
            nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
            return wasNew;
        }
    }

    class LoadAvatarTask
    implements JCRTask<ForumAttachment> {
        String username;

        public LoadAvatarTask(String username) {
            this.username = username;
        }

        public ForumAttachment execute(Session session) throws Exception {
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            if (ksAvatarHomnode.hasNode(this.username)) {
                return JCRDataStorage.getAttachment(ksAvatarHomnode.getNode(this.username));
            }
            return null;
        }
    }

    public class ResetAvatarTask
    implements JCRTask<Boolean> {
        String username;

        public ResetAvatarTask(String username) {
            this.username = username;
        }

        public Boolean execute(Session session) throws Exception {
            Node node;
            Boolean wasReset = false;
            Node ksAvatarHomnode = JCRDataStorage.this.getKSUserAvatarHomeNode();
            if (ksAvatarHomnode.hasNode(this.username) && (node = ksAvatarHomnode.getNode(this.username)).isNodeType("nt:file")) {
                node.remove();
                ksAvatarHomnode.save();
                wasReset = true;
            }
            return wasReset;
        }
    }
}

