/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gatein.pc.portlet.container.PortletApplication;
import org.gatein.pc.portlet.container.PortletApplicationContext;
import org.gatein.pc.portlet.container.PortletContainerContext;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectAddedEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedObjectRemovedEvent;
import org.gatein.pc.portlet.container.managed.ManagedPortletApplication;
import org.gatein.pc.portlet.container.object.PortletApplicationObject;
import org.gatein.pc.portlet.container.object.PortletContainerObject;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.NullManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletFilterLifeCycle;

public class PortletApplicationLifeCycle
extends LifeCycle
implements ManagedPortletApplication {
    private final PortletApplicationContext portletApplicationContext;
    private final PortletApplicationObject portletApplication;
    private final ArrayList<LifeCycle> lifeCycles;
    private final LinkedHashMap<String, PortletContainerLifeCycle> portletContainerLifeCycles;
    private final LinkedHashMap<String, PortletFilterLifeCycle> portletFilterLifeCycles;
    private final LinkedHashMap<PortletFilterLifeCycle, Set<PortletContainerLifeCycle>> filterToContainerDependencies;
    private boolean created;
    private ManagedObjectRegistryEventListener listener;

    public PortletApplicationLifeCycle(ManagedObjectRegistryEventListener listener, PortletApplicationContext portletApplicationContext, PortletApplicationObject portletApplication) {
        this.listener = listener;
        this.portletApplicationContext = portletApplicationContext;
        this.portletApplication = portletApplication;
        this.lifeCycles = new ArrayList();
        this.portletContainerLifeCycles = new LinkedHashMap();
        this.portletFilterLifeCycles = new LinkedHashMap();
        this.filterToContainerDependencies = new LinkedHashMap();
    }

    public PortletApplicationLifeCycle(PortletApplicationContext portletApplicationContext, PortletApplicationObject portletApplication) {
        this(NullManagedObjectRegistryEventListener.getInstance(), portletApplicationContext, portletApplication);
    }

    public void create() {
        if (this.created) {
            throw new IllegalStateException();
        }
        this.portletApplication.setContext(this.portletApplicationContext);
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletFilterLifeCycles.values()) {
            portletFilterLifeCycle.portletFilter.setContext(portletFilterLifeCycle.portletFilterContext);
            portletFilterLifeCycle.portletFilter.setPortletApplication(this.portletApplication);
            this.portletApplication.addPortletFilter(portletFilterLifeCycle.portletFilter);
            this.listener.onEvent(new ManagedObjectAddedEvent(portletFilterLifeCycle));
        }
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletContainerLifeCycles.values()) {
            portletContainerLifeCycle.portletContainer.setContext(portletContainerLifeCycle.portletContainerContext);
            portletContainerLifeCycle.portletContainer.setPortletApplication(this.portletApplication);
            this.portletApplication.addPortletContainer(portletContainerLifeCycle.portletContainer);
            this.listener.onEvent(new ManagedObjectAddedEvent(portletContainerLifeCycle));
        }
        for (Map.Entry entry : this.filterToContainerDependencies.entrySet()) {
            for (PortletContainerLifeCycle portletContainerLifeCycle : (Set)entry.getValue()) {
                portletContainerLifeCycle.portletContainer.addPortletFilter(((PortletFilterLifeCycle)entry.getKey()).portletFilter);
            }
        }
        this.created = true;
    }

    public void destroy() {
        if (this.getStatus() == LifeCycleStatus.STARTED) {
            this.managedDestroy();
        }
        if (this.created) {
            for (Map.Entry<PortletFilterLifeCycle, Set<PortletContainerLifeCycle>> entry : this.filterToContainerDependencies.entrySet()) {
                for (PortletContainerLifeCycle portletContainerLifeCycle : entry.getValue()) {
                    portletContainerLifeCycle.portletContainer.removePortletFilter(entry.getKey().portletFilter);
                }
            }
            for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletContainerLifeCycles.values()) {
                this.listener.onEvent(new ManagedObjectRemovedEvent(portletContainerLifeCycle));
                this.portletApplication.removePortletContainer(portletContainerLifeCycle.portletContainer);
                portletContainerLifeCycle.portletContainer.setPortletApplication(null);
                portletContainerLifeCycle.portletContainer.setContext(null);
            }
            for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletFilterLifeCycles.values()) {
                this.listener.onEvent(new ManagedObjectRemovedEvent(portletFilterLifeCycle));
                this.portletApplication.removePortletFilter(portletFilterLifeCycle.portletFilter);
                portletFilterLifeCycle.portletFilter.setPortletApplication(null);
                portletFilterLifeCycle.portletFilter.setContext(null);
            }
        }
        this.created = false;
    }

    public PortletContainerLifeCycle addPortletContainer(PortletContainerContext portletContainerContext, PortletContainerObject portletContainer) {
        if (this.getStatus() != LifeCycleStatus.INITIALIZED) {
            throw new IllegalStateException("Cannot add portlet container because not stopped");
        }
        if (portletContainer == null) {
            throw new IllegalArgumentException("No null portlet container can be added");
        }
        if (this.portletContainerLifeCycles.containsKey(portletContainer.getId())) {
            throw new IllegalStateException();
        }
        PortletContainerLifeCycle lifeCycle = new PortletContainerLifeCycle(this, portletContainerContext, portletContainer);
        this.portletContainerLifeCycles.put(portletContainer.getId(), lifeCycle);
        this.lifeCycles.add(lifeCycle);
        return lifeCycle;
    }

    public PortletFilterLifeCycle addPortletFilter(PortletFilterContext portletFilterContext, PortletFilterObject portletFilter) {
        if (this.getStatus() != LifeCycleStatus.INITIALIZED) {
            throw new IllegalStateException("Cannot add portlet container because not stopped");
        }
        if (portletFilter == null) {
            throw new IllegalArgumentException("No null portlet filter can be added");
        }
        if (this.portletFilterLifeCycles.containsKey(portletFilter.getId())) {
            throw new IllegalStateException();
        }
        PortletFilterLifeCycle lifeCycle = new PortletFilterLifeCycle(this, portletFilterContext, portletFilter);
        this.portletFilterLifeCycles.put(portletFilter.getId(), lifeCycle);
        this.lifeCycles.add(lifeCycle);
        return lifeCycle;
    }

    public void addDependency(PortletFilterLifeCycle portletFilterLifeCycle, PortletContainerLifeCycle portletContainerLifeCycle) {
        if (portletFilterLifeCycle == null) {
            throw new IllegalArgumentException();
        }
        if (portletContainerLifeCycle == null) {
            throw new IllegalArgumentException();
        }
        if (!this.portletFilterLifeCycles.containsValue(portletFilterLifeCycle)) {
            throw new IllegalStateException();
        }
        if (!this.portletContainerLifeCycles.containsValue(portletContainerLifeCycle)) {
            throw new IllegalStateException();
        }
        Set<PortletContainerLifeCycle> containerDependencies = this.filterToContainerDependencies.get(portletFilterLifeCycle);
        if (containerDependencies == null) {
            containerDependencies = new HashSet<PortletContainerLifeCycle>();
            this.filterToContainerDependencies.put(portletFilterLifeCycle, containerDependencies);
        }
        if (containerDependencies.contains(portletContainerLifeCycle)) {
            throw new IllegalStateException();
        }
        containerDependencies.add(portletContainerLifeCycle);
    }

    public Set<PortletFilterLifeCycle> getDependencies(PortletContainerLifeCycle portletContainerLifeCycle) {
        if (portletContainerLifeCycle == null) {
            throw new IllegalArgumentException();
        }
        HashSet<PortletFilterLifeCycle> dependencies = new HashSet<PortletFilterLifeCycle>();
        for (Map.Entry<PortletFilterLifeCycle, Set<PortletContainerLifeCycle>> entry : this.filterToContainerDependencies.entrySet()) {
            if (!entry.getValue().contains(portletContainerLifeCycle)) continue;
            dependencies.add(entry.getKey());
        }
        return dependencies;
    }

    public Set<PortletContainerLifeCycle> getDependencies(PortletFilterLifeCycle portletFilterLifeCycle) {
        if (portletFilterLifeCycle == null) {
            throw new IllegalArgumentException();
        }
        Set<PortletContainerLifeCycle> dependencies = this.filterToContainerDependencies.get(portletFilterLifeCycle);
        dependencies = dependencies == null ? new HashSet<PortletContainerLifeCycle>() : new HashSet<PortletContainerLifeCycle>(dependencies);
        return dependencies;
    }

    @Override
    protected void invokeCreate() throws Exception {
    }

    @Override
    protected void invokeStart() throws Exception {
        if (!this.created) {
            throw new DependencyNotResolvedException("Application is not wired");
        }
        this.portletApplication.start();
    }

    @Override
    protected void promoteDependents(LifeCycleStatus to) {
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletFilterLifeCycles.values()) {
            try {
                portletFilterLifeCycle.promote(to);
            }
            catch (IllegalStateException ignore) {}
        }
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletContainerLifeCycles.values()) {
            try {
                portletContainerLifeCycle.promote(to);
            }
            catch (IllegalStateException ignore) {}
        }
    }

    @Override
    protected void demoteDependents(LifeCycleStatus to) {
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletContainerLifeCycles.values()) {
            portletContainerLifeCycle.demote(to);
        }
        for (PortletFilterLifeCycle portletFilterLifeCycle : this.portletFilterLifeCycles.values()) {
            portletFilterLifeCycle.demote(to);
        }
    }

    @Override
    protected void invokeStop() {
        this.portletApplication.stop();
    }

    @Override
    protected void invokeDestroy() throws Exception {
    }

    @Override
    public String getId() {
        return this.portletApplication.getId();
    }

    @Override
    public Iterable<? extends ManagedObject> getDependencies() {
        return this.lifeCycles;
    }

    public Iterable<? extends PortletContainerLifeCycle> getManagedPortletContainers() {
        return this.portletContainerLifeCycles.values();
    }

    @Override
    public PortletContainerLifeCycle getManagedPortletContainer(String portletContainerId) {
        return this.portletContainerLifeCycles.get(portletContainerId);
    }

    public Iterable<? extends PortletFilterLifeCycle> getManagedPortletFilters() {
        return this.portletFilterLifeCycles.values();
    }

    @Override
    public PortletFilterLifeCycle getManagedPortletFilter(String portletFilterId) {
        return this.portletFilterLifeCycles.get(portletFilterId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.portletApplication.getId() + "]";
    }

    @Override
    public PortletApplication getPortletApplication() {
        return this.portletApplication;
    }

    @Override
    protected ManagedObjectRegistryEventListener getListener() {
        return this.listener;
    }
}

