/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.jcr.webdav.MimeTypeRecognizer;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutCommand {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.command.PutCommand");
    private final NullResourceLocksHolder nullResourceLocks;
    private final UriBuilder uriBuilder;
    private final MimeTypeRecognizer mimeTypeRecognizer;
    private final String CHECKOUT_CHECKIN = "checkout-checkin";
    private final String CHECKIN_CHECKOUT = "checkin-checkout";
    private final String CHECKOUT = "checkout";

    public PutCommand(NullResourceLocksHolder nullResourceLocks, UriBuilder uriBuilder, MimeTypeRecognizer mimeTypeRecognizer) {
        this.nullResourceLocks = nullResourceLocks;
        this.uriBuilder = uriBuilder;
        this.mimeTypeRecognizer = mimeTypeRecognizer;
    }

    public Response put(Session session, String path, InputStream inputStream, String fileNodeType, String contentNodeType, List<String> mixins, String updatePolicyType, String autoVersion, List<String> tokens) {
        try {
            Node node = null;
            try {
                node = (Node)session.getItem(path);
            }
            catch (PathNotFoundException pexc) {
                this.nullResourceLocks.checkLock(session, path, tokens);
            }
            if (node == null) {
                node = session.getRootNode().addNode(TextUtil.relativizePath(path, false), fileNodeType);
                path = node.getPath();
                node.addNode("jcr:content", contentNodeType);
                this.updateContent(node, inputStream, mixins);
            } else if ("add".equals(updatePolicyType)) {
                node = session.getRootNode().getNode(TextUtil.relativizePath(path));
                if (!node.isNodeType("mix:versionable")) {
                    node = session.getRootNode().addNode(TextUtil.relativizePath(path, false), fileNodeType);
                    path = node.getPath();
                    node.addNode("jcr:content", contentNodeType);
                    this.updateContent(node, inputStream, mixins);
                } else {
                    this.updateVersion(node, inputStream, autoVersion, mixins);
                }
            } else if ("create-version".equals(updatePolicyType)) {
                this.createVersion(node, inputStream, autoVersion, mixins);
            } else if (!node.isNodeType("mix:versionable")) {
                this.updateContent(node, inputStream, mixins);
            } else {
                this.updateVersion(node, inputStream, autoVersion, mixins);
            }
            session.save();
        }
        catch (LockException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (AccessDeniedException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        if (this.uriBuilder != null) {
            return Response.created((URI)this.uriBuilder.path(session.getWorkspace().getName()).path(path).build(new Object[0])).build();
        }
        return Response.status((int)201).build();
    }

    public Response put(Session session, String path, InputStream inputStream, String fileNodeType, String contentNodeType, List<String> mixins, List<String> tokens, MultivaluedMap<String, String> allowedAutoVersionPath) {
        try {
            Node node = null;
            try {
                node = (Node)session.getItem(path);
            }
            catch (PathNotFoundException pexc) {
                this.nullResourceLocks.checkLock(session, path, tokens);
            }
            if (node == null) {
                node = session.getRootNode().addNode(TextUtil.relativizePath(path, false), fileNodeType);
                path = node.getPath();
                node.addNode("jcr:content", contentNodeType);
                this.updateContent(node, inputStream, mixins);
                boolean isVersioned = this.isVersionSupported(node.getPath(), session.getWorkspace().getName(), allowedAutoVersionPath);
                if (isVersioned && node.canAddMixin("mix:versionable")) {
                    node.addMixin("mix:versionable");
                }
                node.getSession().save();
            } else {
                boolean isVersioned = this.isVersionSupported(node.getPath(), session.getWorkspace().getName(), allowedAutoVersionPath);
                if (isVersioned) {
                    VersionHistoryUtils.createVersion((Node)node);
                    this.updateContent(node, inputStream, mixins);
                } else {
                    this.updateContent(node, inputStream, mixins);
                }
            }
            session.save();
        }
        catch (LockException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (AccessDeniedException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            if (log.isDebugEnabled()) {
                log.debug((Object)exc.getMessage(), (Throwable)exc);
            }
            return Response.status((int)409).entity((Object)exc.getMessage()).build();
        }
        if (this.uriBuilder != null) {
            return Response.created((URI)this.uriBuilder.path(session.getWorkspace().getName()).path(path).build(new Object[0])).build();
        }
        return Response.status((int)201).build();
    }

    private void createVersion(Node fileNode, InputStream inputStream, String autoVersion, List<String> mixins) throws RepositoryException {
        if (!fileNode.isNodeType("mix:versionable")) {
            if (fileNode.canAddMixin("mix:versionable")) {
                fileNode.addMixin("mix:versionable");
                fileNode.getSession().save();
            }
            if (!"checkin-checkout".equals(autoVersion)) {
                fileNode.checkin();
                fileNode.getSession().save();
            }
        }
        if ("checkin-checkout".equals(autoVersion)) {
            fileNode.checkin();
            fileNode.checkout();
            fileNode.getSession().save();
            this.updateContent(fileNode, inputStream, mixins);
            fileNode.getSession().save();
        } else {
            this.createVersion(fileNode, inputStream, mixins);
        }
    }

    private void createVersion(Node fileNode, InputStream inputStream, List<String> mixins) throws RepositoryException {
        if (!fileNode.isCheckedOut()) {
            fileNode.checkout();
            fileNode.getSession().save();
        }
        this.updateContent(fileNode, inputStream, mixins);
        fileNode.getSession().save();
        fileNode.checkin();
        fileNode.getSession().save();
    }

    private void updateContent(Node node, InputStream inputStream, List<String> mixins) throws RepositoryException {
        Node content = node.getNode("jcr:content");
        if (this.mimeTypeRecognizer.isMimeTypeRecognized() || !content.hasProperty("jcr:mimeType")) {
            content.setProperty("jcr:mimeType", this.mimeTypeRecognizer.getMimeType());
        }
        if (this.mimeTypeRecognizer.isEncodingSet()) {
            content.setProperty("jcr:encoding", this.mimeTypeRecognizer.getEncoding());
        }
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", inputStream);
        for (String mixinName : mixins) {
            if (!content.canAddMixin(mixinName)) continue;
            content.addMixin(mixinName);
        }
    }

    private void updateVersion(Node fileNode, InputStream inputStream, String autoVersion, List<String> mixins) throws RepositoryException {
        if (!fileNode.isCheckedOut()) {
            fileNode.checkout();
            fileNode.getSession().save();
        }
        if ("checkout".equals(autoVersion)) {
            this.updateContent(fileNode, inputStream, mixins);
        } else if ("checkout-checkin".equals(autoVersion)) {
            this.updateContent(fileNode, inputStream, mixins);
            fileNode.getSession().save();
            fileNode.checkin();
        }
        fileNode.getSession().save();
    }

    private boolean isVersionSupported(String nodePath, String workspaceName, MultivaluedMap<String, String> allowedAutoVersionPath) {
        if (StringUtils.isEmpty((String)nodePath) || allowedAutoVersionPath.isEmpty()) {
            return false;
        }
        List paths = (List)allowedAutoVersionPath.get((Object)workspaceName);
        if (paths == null) {
            return false;
        }
        for (String p : paths) {
            if (StringUtils.isEmpty((String)p) || !nodePath.startsWith(p)) continue;
            return true;
        }
        return false;
    }
}

