/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.cache.concurrent.ObjectRef;
import org.exoplatform.services.cache.concurrent.Queue;
import org.exoplatform.services.cache.concurrent.SimpleObjectRef;
import org.exoplatform.services.cache.concurrent.SynchronizedQueue;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheState<K extends Serializable, V> {
    private final Log log;
    private final ConcurrentFIFOExoCache<K, V> config;
    final ConcurrentHashMap<K, ObjectRef<K, V>> map;
    final Queue<ObjectRef<K, V>> queue;

    CacheState(ConcurrentFIFOExoCache<K, V> config, Log log) {
        this.log = log;
        this.config = config;
        this.map = new ConcurrentHashMap();
        this.queue = new SynchronizedQueue<ObjectRef<K, V>>(log);
    }

    public void assertConsistency() {
        if (this.queue instanceof SynchronizedQueue) {
            ((SynchronizedQueue)this.queue).assertConsistency();
        }
        int mapSize = this.map.size();
        int effectiveQueueSize = this.queue.size();
        if (effectiveQueueSize != mapSize) {
            throw new AssertionError((Object)("The map size is " + mapSize + " is different from the queue size " + effectiveQueueSize));
        }
    }

    public V get(Serializable name) {
        ObjectRef<K, V> entry = this.map.get(name);
        if (entry != null) {
            V o = entry.getObject();
            if (entry.isValid()) {
                this.config.hits.incrementAndGet();
                this.config.onGet(entry.name, o);
                return o;
            }
            this.config.misses.incrementAndGet();
            if (this.map.remove(name, entry)) {
                this.queue.remove(entry);
            }
            this.config.onExpire(entry.name, o);
        } else {
            this.config.misses.incrementAndGet();
        }
        return null;
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        this.log.trace((Object)(message + " [" + Thread.currentThread().getName() + "]"));
    }

    void put(long expirationTime, K name, V obj) {
        boolean trace = this.isTraceEnabled();
        SimpleObjectRef<K, V> nextRef = new SimpleObjectRef<K, V>(expirationTime, name, obj);
        ObjectRef previousRef = this.map.put(name, nextRef);
        if (previousRef != null) {
            this.queue.remove(previousRef);
            if (trace) {
                this.trace("Replaced item=" + previousRef.serial + " with item=" + nextRef.serial + " in the map");
            }
        } else if (trace) {
            this.trace("Added item=" + nextRef.serial + " to map");
        }
        this.queue.add(nextRef);
        ArrayList<ObjectRef<K, V>> evictedRefs = this.queue.trim(this.config.maxSize);
        if (evictedRefs != null) {
            for (ObjectRef<K, V> evictedRef : evictedRefs) {
                this.map.remove(evictedRef.name, evictedRef);
                this.config.onExpire(evictedRef.name, evictedRef.getObject());
            }
        }
        this.config.onPut(name, obj);
    }

    public V remove(Serializable name) {
        boolean trace = this.isTraceEnabled();
        ObjectRef<K, V> item = this.map.remove(name);
        if (item != null) {
            boolean removed;
            if (trace) {
                this.trace("Removed item=" + item.serial + " from the map going to remove it");
            }
            boolean valid = (removed = this.queue.remove(item)) && item.isValid();
            V object = item.getObject();
            if (valid) {
                this.config.onRemove(item.name, object);
                return object;
            }
            this.config.onExpire(item.name, object);
            return null;
        }
        return null;
    }
}

