/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.hibernate;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeEventListenerHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.hibernate.MembershipDAOImpl;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.security.PermissionConstants;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MembershipTypeDAOImpl
implements MembershipTypeHandler,
MembershipTypeEventListenerHandler {
    private static final String queryFindMembershipType = "from m in class org.exoplatform.services.organization.impl.MembershipTypeImpl where m.name = :id ";
    private static final String queryFindAllMembershipType = "from m in class org.exoplatform.services.organization.impl.MembershipTypeImpl";
    protected final List<MembershipTypeEventListener> listeners = new ArrayList<MembershipTypeEventListener>();
    private final HibernateService service_;
    protected final OrganizationService orgService;

    public MembershipTypeDAOImpl(HibernateService service, OrganizationService orgService) {
        this.service_ = service;
        this.orgService = orgService;
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        Date now = new Date();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        if (broadcast) {
            this.preSave(mt, true);
        }
        session.save((Object)mt);
        session.flush();
        if (broadcast) {
            this.postSave(mt, true);
        }
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        Date now = new Date();
        mt.setModifiedDate(now);
        if (broadcast) {
            this.preSave(mt, false);
        }
        session.update((Object)mt);
        session.flush();
        if (broadcast) {
            this.postSave(mt, false);
        }
        return mt;
    }

    public MembershipType findMembershipType(String name) throws Exception {
        Session session = this.service_.openSession();
        MembershipType m = (MembershipType)this.service_.findOne(session, queryFindMembershipType, name);
        return m;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        Session session = this.service_.openSession();
        MembershipTypeImpl mt = (MembershipTypeImpl)session.get(MembershipTypeImpl.class, (Serializable)((Object)name));
        if (mt == null) {
            throw new InvalidNameException("Can not remove membership type" + name + "record, because membership type does not exist.");
        }
        if (broadcast) {
            this.preDelete((MembershipType)mt);
        }
        session.delete((Object)mt);
        MembershipDAOImpl membershipHanler = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        membershipHanler.removeMembershipEntriesOfMembershipType((MembershipType)mt, session);
        session.flush();
        if (broadcast) {
            this.postDelete((MembershipType)mt);
        }
        return mt;
    }

    public Collection<MembershipType> findMembershipTypes() throws Exception {
        Session session = this.service_.openSession();
        List result = session.createQuery(queryFindAllMembershipType).list();
        ArrayList<MembershipType> l = new ArrayList<MembershipType>(result);
        Collections.sort(l, MembershipTypeHandler.COMPARATOR);
        return l;
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    private void preSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preSave(type, isNew);
        }
    }

    private void postSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postSave(type, isNew);
        }
    }

    private void preDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preDelete(type);
        }
    }

    private void postDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postDelete(type);
        }
    }

    public List<MembershipTypeEventListener> getMembershipTypeListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

