/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml.portal.redirects;

import org.exoplatform.portal.config.model.NodeMap;
import org.exoplatform.portal.config.model.RedirectMappings;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.NodeMapXmlHandler;
import org.gatein.common.xml.stax.XmlHandler;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterUtils;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public class RedirectMappingsXmlHandler
implements XmlHandler<RedirectMappings, Element> {
    private static final ValueType<RedirectMappings.UnknownNodeMapping> UNKNOWN_NODE_MAPPING_VALUE_TYPE = ValueType.get(RedirectMappings.UnknownNodeMapping.class);
    private final NodeMapXmlHandler nodeMapXmlHandler;

    public RedirectMappingsXmlHandler() {
        this(new NodeMapXmlHandler());
    }

    public RedirectMappingsXmlHandler(NodeMapXmlHandler nodeMapXmlHandler) {
        this.nodeMapXmlHandler = nodeMapXmlHandler;
    }

    public RedirectMappings read(StaxNavigator<Element> navigator) {
        if (navigator.getName() != Element.NODE_MAPPING) {
            throw Exceptions.unexpectedElement(navigator);
        }
        RedirectMappings mappings = new RedirectMappings();
        boolean unresolvedNodes = false;
        boolean nodeMap = false;
        Element element = (Element)((Object)navigator.child());
        while (element != null) {
            switch (element) {
                case USER_NODE_NAME_MATCHING: {
                    if (unresolvedNodes || nodeMap) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    mappings.setUseNodeNameMatching((Boolean)StaxNavUtils.parseRequiredContent(navigator, (ValueType)ValueType.BOOLEAN));
                    break;
                }
                case UNRESOLVED_NODES: {
                    unresolvedNodes = true;
                    if (nodeMap) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    mappings.setUnresolvedNode((RedirectMappings.UnknownNodeMapping)((Object)StaxNavUtils.parseRequiredContent(navigator, UNKNOWN_NODE_MAPPING_VALUE_TYPE)));
                    break;
                }
                case NODE_MAP: {
                    nodeMap = true;
                    mappings.getMappings().add((NodeMap)this.nodeMapXmlHandler.read(navigator.fork()));
                    break;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
                default: {
                    throw Exceptions.unexpectedElement(navigator);
                }
            }
            element = (Element)((Object)navigator.sibling());
        }
        return mappings;
    }

    public void write(StaxWriter<Element> writer, RedirectMappings redirectMappings) {
        if (redirectMappings == null) {
            return;
        }
        writer.writeStartElement((Object)Element.NODE_MAPPING);
        writer.writeElement((Object)Element.USER_NODE_NAME_MATCHING, WritableValueTypes.BOOLEAN, (Object)redirectMappings.isUseNodeNameMatching());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.UNRESOLVED_NODES), (WritableValueType)WritableValueTypes.getEnumType(), (Object)((Object)redirectMappings.getUnresolvedNode()));
        if (redirectMappings.getMappings() != null) {
            for (NodeMap nodeMap : redirectMappings.getMappings()) {
                this.nodeMapXmlHandler.write(writer, nodeMap);
            }
        }
        writer.writeEndElement();
    }
}

