/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.util.List;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;

public class PageContext {
    final PageKey key;
    PageState state;
    PageData data;

    PageContext(PageData data) {
        this.key = data.key;
        this.state = null;
        this.data = data;
    }

    public PageContext(PageKey key, PageState state) {
        this.key = key;
        this.state = state;
        this.data = null;
    }

    public PageKey getKey() {
        return this.key;
    }

    public PageState getState() {
        if (this.state != null) {
            return this.state;
        }
        if (this.data != null) {
            return this.data.state;
        }
        return null;
    }

    public void setState(PageState state) throws IllegalStateException {
        if (this.data == null && state == null) {
            throw new IllegalStateException("Cannot clear state on a transient page");
        }
        this.state = state;
    }

    public void update(Page page) throws NullPointerException {
        if (page == null) {
            throw new NullPointerException();
        }
        PageState s = this.getState();
        page.setTitle(s.displayName);
        page.setDescription(s.description);
        page.setFactoryId(s.factoryId);
        page.setShowMaxWindow(s.showMaxWindow);
        List<String> permisssions = s.accessPermissions;
        page.setAccessPermissions(permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null);
        page.setEditPermission(this.getState().editPermission);
        permisssions = s.moveAppsPermissions;
        page.setMoveAppsPermissions(permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null);
        permisssions = s.moveContainersPermissions;
        page.setMoveContainersPermissions(permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null);
    }
}

