/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.QueryResult;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.chromattic.SynchronizationListener;
import org.exoplatform.commons.chromattic.SynchronizationStatus;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.pom.config.MOPChromatticLifeCycle;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.Utils;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.api.Model;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.core.api.ModelImpl;
import org.gatein.mop.core.api.workspace.NavigationImpl;
import org.gatein.mop.core.api.workspace.PageImpl;

public final class POMSession {
    private static final Logger log = LoggerFactory.getLogger(POMSession.class);
    private static final Map<ObjectType<?>, Class> mapping = new HashMap();
    final POMSessionManager mgr;
    private ModelImpl model;
    private boolean isInTask;
    private boolean markedForRollback;
    private List<Serializable> staleKeys;
    private boolean modified;
    private SessionContext context;
    private MOPChromatticLifeCycle configurator;
    private static final BaseEncodingObjectFormatter formatter;
    private final SynchronizationListener listener = new SynchronizationListener(){

        public void beforeSynchronization() {
        }

        public void afterSynchronization(SynchronizationStatus status) {
            if (status == SynchronizationStatus.SAVED) {
                POMSession.this.reset();
            }
        }
    };

    public POMSession(POMSessionManager mgr, MOPChromatticLifeCycle configurator, SessionContext context) {
        context.addSynchronizationListener(this.listener);
        this.mgr = mgr;
        this.isInTask = false;
        this.markedForRollback = false;
        this.staleKeys = null;
        this.configurator = configurator;
        this.context = context;
    }

    public Object getFromCache(Serializable key) {
        if (this.isModified()) {
            throw new IllegalStateException("Cannot read object in shared cache from a modified session");
        }
        return this.mgr.cacheGet(key);
    }

    public void putInCache(Serializable key, Object value) {
        if (this.isModified()) {
            throw new IllegalStateException("Cannot put object in shared cache from a modified session");
        }
        this.mgr.cachePut(key, value);
    }

    public void scheduleForEviction(Serializable key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.staleKeys == null) {
            this.staleKeys = new LinkedList<Serializable>();
        }
        this.staleKeys.add(key);
    }

    private Model getModel() {
        if (this.model == null) {
            this.model = this.mgr.getPOMService().getModel();
        }
        return this.model;
    }

    public boolean isModified() {
        if (this.modified) {
            return true;
        }
        try {
            ChromatticSession session = this.getSession();
            Session jcrSession = session.getJCRSession();
            this.modified = jcrSession.hasPendingChanges();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
        return this.modified;
    }

    protected ChromatticSession getSession() {
        return this.context.getSession();
    }

    public Workspace getWorkspace() {
        return this.getModel().getWorkspace();
    }

    public boolean isMarkedForRollback() {
        return this.markedForRollback;
    }

    public String pathOf(WorkspaceObject o) {
        return this.getModel().pathOf(o);
    }

    public <O extends WorkspaceObject> Iterator<O> findObject(ObjectType<O> ownerType, String statement) {
        this.save();
        return this.getModel().findObject(ownerType, statement);
    }

    public <O extends WorkspaceObject> O findObjectById(ObjectType<O> ownerType, String id) {
        return (O)this.getModel().findObjectById(ownerType, id);
    }

    public WorkspaceObject findObjectById(String id) {
        return this.findObjectById(ObjectType.ANY, id);
    }

    public Customization<?> findCustomizationById(String id) {
        Customization customization = this.getModel().findCustomizationById(id);
        if (customization == null) {
            throw new NoSuchDataException("Can not find " + id);
        }
        return customization;
    }

    public POMSessionManager getManager() {
        return this.mgr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <O extends WorkspaceObject> QueryResult<O> findObjects(ObjectType<O> type, ObjectType<Site> siteType, String ownerId, String title, int offset, int limit) {
        String statement;
        this.save();
        String ownerIdChunk = "%";
        if (ownerId != null && !(ownerId = ownerId.trim()).isEmpty()) {
            ownerIdChunk = "mop:" + formatter.encodeNodeName(null, ownerId);
        }
        String ownerTypeChunk = siteType != null ? (siteType == ObjectType.PORTAL_SITE ? "mop:portalsites" : (siteType == ObjectType.GROUP_SITE ? "mop:groupsites" : "mop:usersites")) : "%";
        Workspace workspace = this.getWorkspace();
        String workspaceChunk = this.model.pathOf((WorkspaceObject)workspace);
        try {
            if (title != null) {
                title = Utils.queryEscape(title);
                if (type != ObjectType.PAGE) throw new UnsupportedOperationException();
                statement = "jcr:path LIKE '" + workspaceChunk + "/" + ownerTypeChunk + "/" + ownerIdChunk + "/mop:rootpage/mop:children/mop:pages/mop:children/%' AND " + "(" + "LOWER(gtn:name) LIKE '%" + title.trim().toLowerCase() + "%' ESCAPE '\\')";
            } else {
                statement = type == ObjectType.PAGE ? "jcr:path LIKE '" + workspaceChunk + "/" + ownerTypeChunk + "/" + ownerIdChunk + "/mop:rootpage/mop:children/mop:pages/mop:children/%'" : "jcr:path LIKE '" + workspaceChunk + "/" + ownerTypeChunk + "/" + ownerIdChunk + "/mop:rootnavigation/mop:children/mop:default'";
            }
        }
        catch (IllegalArgumentException e) {
            statement = type == ObjectType.PAGE ? "jcr:path LIKE ''" : "jcr:path LIKE ''";
        }
        ChromatticSession session = this.context.getSession();
        Class mappedClass = mapping.get(type);
        return session.createQueryBuilder(mappedClass).where(statement).get().objects(Long.valueOf(offset), Long.valueOf(limit));
    }

    private void reset() {
        if (this.staleKeys != null && this.staleKeys.size() > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("About to evict entries " + this.staleKeys));
            }
            for (Serializable key : this.staleKeys) {
                this.mgr.cacheRemove(key);
            }
            this.staleKeys.clear();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting modified flag to false");
        }
        this.modified = false;
    }

    public <V> V execute(POMTask<V> task) throws Exception {
        if (this.isInTask) {
            throw new IllegalStateException();
        }
        boolean needRollback = true;
        try {
            this.isInTask = true;
            V v = task.run(this);
            needRollback = false;
            V v2 = v;
            return v2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.isInTask = false;
            this.markedForRollback = needRollback;
        }
    }

    public void save() {
        if (this.model != null) {
            if (!this.markedForRollback) {
                this.model.save();
                this.reset();
            } else {
                log.debug((Object)"Will not save session that is marked for rollback");
            }
        }
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean save) {
        if (save) {
            this.save();
        }
        if (this.model != null) {
            this.model.close();
        }
        this.configurator.closeContext(save & this.markedForRollback);
    }

    static {
        mapping.put(ObjectType.PAGE, PageImpl.class);
        mapping.put(ObjectType.NAVIGATION, NavigationImpl.class);
        formatter = new BaseEncodingObjectFormatter();
    }
}

