/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.installer;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.jcr.Session;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.gatein.portal.installer.PBEUtils;
import org.picocontainer.Startable;

public class PortalSetupService
implements Startable {
    private static Log log = ExoLogger.getLogger(PortalSetupService.class);
    public static final String GATEIN_SETUP_ENABLE = "gatein.portal.setup.enable";
    public static final String ROOT_PASSWORD_PROPERTY = "gatein.portal.setup.initialpassword.root";
    private static String SALT = "unodostrescuatro";
    private static int COUNT = 9;
    private static String KEY = "somearbitrarycrazystringthatdoesnotmatter";
    private static final String SETUP_FLAG = "gatein-setup-flag";
    private String jcrWS;
    private String jcrRepo;
    private ManageableRepository repository;
    private Map<String, Boolean> setup = new ConcurrentHashMap<String, Boolean>();
    private OrganizationService orgService;
    private RepositoryService jcrService;

    public PortalSetupService(InitParams params, OrganizationService orgService, RepositoryService jcrService) throws Exception {
        ValueParam ws;
        ValueParam repoConfig = params.getValueParam("repository");
        if (repoConfig != null) {
            this.jcrRepo = repoConfig.getValue().trim();
        }
        if ((ws = params.getValueParam("workspace")) != null) {
            this.jcrWS = ws.getValue().trim();
        }
        this.orgService = orgService;
        this.jcrService = jcrService;
    }

    public void start() {
        try {
            this.repository = this.jcrRepo != null ? this.jcrService.getRepository(this.jcrRepo) : this.jcrService.getCurrentRepository();
            if (this.jcrWS == null) {
                this.jcrWS = this.repository.getConfiguration().getDefaultWorkspaceName();
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't get JCR repository", (Throwable)e);
        }
        if (this.isEnable()) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.checkJcrFlag();
            try {
                if (!this.isSetup()) {
                    User root = this.getRootUser();
                    root.setPassword(this.rootPassword());
                    this.orgService.getUserHandler().saveUser(root, true);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public User getRootUser() throws Exception {
        User root = this.orgService.getUserHandler().findUserByName("root", UserStatus.ANY);
        if (root == null) {
            root = this.orgService.getUserHandler().createUserInstance("root");
            root.setFirstName("Root");
            root.setLastName("Root");
            root.setEmail("root@localhost");
            root.setDisplayName("root");
            this.orgService.getUserHandler().createUser(root, true);
            MembershipType manager = this.orgService.getMembershipTypeHandler().findMembershipType("manager");
            MembershipType member = this.orgService.getMembershipTypeHandler().findMembershipType("member");
            Group administrators = this.orgService.getGroupHandler().findGroupById("/platform/administrators");
            Group users = this.orgService.getGroupHandler().findGroupById("/platform/users");
            Group executive_board = this.orgService.getGroupHandler().findGroupById("/organization/management/executive-board");
            this.orgService.getMembershipHandler().linkMembership(root, administrators, manager, true);
            this.orgService.getMembershipHandler().linkMembership(root, users, member, true);
            this.orgService.getMembershipHandler().linkMembership(root, executive_board, member, true);
        }
        return root;
    }

    private String getPCName() {
        return ExoContainerContext.getCurrentContainer().getContext().getPortalContainerName();
    }

    private void checkJcrFlag() {
        this.setup.put(this.getPCName(), false);
        try {
            Session session = this.getJcrSession();
            if (session.itemExists("/gatein-setup-flag")) {
                this.setup.put(this.getPCName(), true);
            }
            session.logout();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setJcrFlag() {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            Session session = this.getJcrSession();
            session.getRootNode().addNode(SETUP_FLAG);
            session.save();
            session.logout();
            this.setup.put(this.getPCName(), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private String rootPassword() {
        String password = null;
        try {
            password = this.decodePassword(System.getProperty(ROOT_PASSWORD_PROPERTY));
            if (password == null) {
                password = this.randomPassword();
                this.setup.put(this.getPCName(), false);
            } else {
                this.setup.put(this.getPCName(), true);
                this.setJcrFlag();
            }
            return password;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String decodePassword(String encodedPassword) throws Exception {
        if (encodedPassword == null) {
            return null;
        }
        byte[] salt = SALT.substring(0, 8).getBytes();
        int count = COUNT;
        char[] password = KEY.toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        return PBEUtils.decode64(encodedPassword, "PBEwithMD5andDES", cipherKey, cipherSpec);
    }

    public static String encodePassword(String plainTextPassword) throws Exception {
        if (plainTextPassword == null) {
            return null;
        }
        String encodedPassword = null;
        byte[] salt = SALT.substring(0, 8).getBytes();
        int count = COUNT;
        char[] password = KEY.toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        encodedPassword = PBEUtils.encode64(plainTextPassword.getBytes("UTF-8"), "PBEwithMD5andDES", cipherKey, cipherSpec);
        return encodedPassword;
    }

    public boolean isSetup(String context) {
        return this.setup.get(context) != null ? this.setup.get(context) : false;
    }

    public boolean isSetup() {
        return this.isSetup(this.getPCName());
    }

    public boolean isEnable() {
        String config = PropertyManager.getProperty((String)GATEIN_SETUP_ENABLE);
        return Boolean.parseBoolean(config);
    }

    public void setFlag() {
        this.setup.put(this.getPCName(), true);
    }

    private String randomPassword() {
        return new BigInteger(130, new SecureRandom()).toString(8);
    }

    public void stop() {
    }

    private Session getJcrSession() throws Exception {
        if (this.repository == null) {
            throw new IllegalStateException("repository is null, jcrSession can only be retrieved after PortalSetupService has started");
        }
        return this.repository.getSystemSession(this.jcrWS);
    }
}

