/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class CommentAddedActivityListener
extends Listener<Node, Node> {
    public void onEvent(Event<Node, Node> event) throws Exception {
        Node currentNode = (Node)event.getSource();
        Node commentNode = (Node)event.getData();
        String commentContent = "";
        if (commentNode.hasProperty("exo:commentContent")) {
            try {
                commentContent = commentNode.getProperty("exo:commentContent").getValue().getString();
            }
            catch (Exception e) {
                commentContent = null;
            }
        }
        if (commentContent == null) {
            return;
        }
        ExoSocialActivity commentActivity = currentNode.isNodeType("nt:file") ? Utils.postFileActivity(currentNode, "{0}", false, true, commentContent) : Utils.postActivity(currentNode, "{0}", false, true, commentContent);
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        List links = linkManager.getAllLinks(currentNode, "exo:symlink");
        for (Node link : links) {
            if (!link.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO)) continue;
            ExoSocialActivity linkCommentActivity = Utils.postActivity(link, "{0}", false, true, commentContent);
            if (commentActivity == null) continue;
            ActivityTypeUtils.attachActivityId((Node)link, (String)linkCommentActivity.getId());
        }
        if (commentActivity != null) {
            ActivityTypeUtils.attachActivityId((Node)commentNode, (String)commentActivity.getId());
            commentNode.getSession().save();
        }
    }
}

