/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity.listener;

import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.wcm.ext.component.activity.listener.Utils;

public class ContentUpdateActivityListener
extends Listener<Node, String> {
    private String[] editedField = new String[]{"exo:title", "exo:summary", "dc:title", "dc:description", "exo:text"};
    private String[] bundleMessage = new String[]{"SocialIntegration.messages.editTitle", "SocialIntegration.messages.editSummary", "SocialIntegration.messages.editTitle", "SocialIntegration.messages.editSummary", "SocialIntegration.messages.editContent"};
    private String[] bundleMessageEmpty = new String[]{"SocialIntegration.messages.emptyTitle", "SocialIntegration.messages.emptySummary", "SocialIntegration.messages.emptyTitle", "SocialIntegration.messages.emptySummary", "SocialIntegration.messages.emptyContent"};
    private boolean[] needUpdate = new boolean[]{true, true, true, true, false};
    private int CONTENT_BUNDLE_INDEX = this.bundleMessage.length - 1;
    private int consideredFieldCount = this.editedField.length;

    public void onEvent(Event<Node, String> event) throws Exception {
        String newValue;
        Node currentNode = (Node)event.getSource();
        String propertyName = (String)event.getData();
        try {
            if (!currentNode.hasProperty(propertyName)) {
                return;
            }
            if (currentNode.getProperty(propertyName).getDefinition().isMultiple()) {
                StringBuffer sb = new StringBuffer();
                Value[] values = currentNode.getProperty(propertyName).getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (i == 0) {
                        sb.append(values[i].getString());
                        continue;
                    }
                    sb.append(", ").append(values[i].getString());
                }
                newValue = sb.toString();
            } else {
                newValue = currentNode.getProperty(propertyName).getString();
                if (newValue == null) {
                    newValue = "";
                }
            }
        }
        catch (Exception e) {
            newValue = "";
        }
        for (int i = 0; i < this.consideredFieldCount; ++i) {
            if (!propertyName.equals(this.editedField[i])) continue;
            if (propertyName.equals("exo:summary")) {
                newValue = Utils.getFirstSummaryLines(newValue);
            }
            if (StringUtils.isEmpty((String)newValue)) {
                Utils.postActivity(currentNode, this.bundleMessageEmpty[i], this.needUpdate[i], true, "");
            } else {
                Utils.postActivity(currentNode, this.bundleMessage[i], this.needUpdate[i], true, newValue);
            }
            return;
        }
        if (propertyName.endsWith("jcr:data")) {
            String _resourceBundleKey = "";
            _resourceBundleKey = StringUtils.isEmpty((String)newValue) ? this.bundleMessageEmpty[this.CONTENT_BUNDLE_INDEX] : this.bundleMessage[this.CONTENT_BUNDLE_INDEX];
            Utils.postActivity(currentNode, _resourceBundleKey, this.needUpdate[this.CONTENT_BUNDLE_INDEX], true, "");
        }
        if (propertyName.endsWith("dc:description")) {
            try {
                if (currentNode.hasProperty("exo:summary")) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            newValue = Utils.getFirstSummaryLines(newValue);
            if (StringUtils.isEmpty((String)newValue)) {
                Utils.postActivity(currentNode, "SocialIntegration.messages.emptySummary", true, true, "");
            } else {
                Utils.postActivity(currentNode, "SocialIntegration.messages.editSummary", true, true, newValue);
            }
        }
    }
}

