/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public class ObjectPropertyStringPreprocess
implements CompilerPass {
    static final String OBJECT_PROPERTY_STRING = "goog.testing.ObjectPropertyString";
    public static final String EXTERN_OBJECT_PROPERTY_STRING = "JSCompiler_ObjectPropertyString";
    static final DiagnosticType INVALID_NUM_ARGUMENTS_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_NUM_ARGS", "goog.testing.ObjectPropertyString instantiated with \"{0}\" arguments, expected 2.");
    static final DiagnosticType QUALIFIED_NAME_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_QUALIFIED_NAME_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, qualified name expected. Was \"{0}\".");
    static final DiagnosticType STRING_LITERAL_EXPECTED_ERROR = DiagnosticType.error("JSC_OBJECT_PROPERTY_STRING_STRING_LITERAL_EXPECTED", "goog.testing.ObjectPropertyString instantiated with invalid argument, string literal expected. Was \"{0}\".");
    private final AbstractCompiler compiler;

    ObjectPropertyStringPreprocess(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.addExternDeclaration(externs, new Node(118, Node.newString(38, EXTERN_OBJECT_PROPERTY_STRING)));
        NodeTraversal.traverse(this.compiler, root, new Callback());
    }

    private void addExternDeclaration(Node externs, Node declarationStmt) {
        Node script = externs.getLastChild();
        if (script == null || script.getType() != 132) {
            script = new Node(132);
            script.setIsSyntheticBlock(true);
            externs.addChildToBack(script);
        }
        script.addChildToBack(declarationStmt);
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (ObjectPropertyStringPreprocess.OBJECT_PROPERTY_STRING.equals(n.getQualifiedName())) {
                Node newName = Node.newString(38, ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING);
                newName.copyInformationFrom(n);
                parent.replaceChild(n, newName);
                ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
                return;
            }
            if (n.getType() != 30) {
                return;
            }
            Node objectName = n.getFirstChild();
            if (!ObjectPropertyStringPreprocess.EXTERN_OBJECT_PROPERTY_STRING.equals(objectName.getQualifiedName())) {
                return;
            }
            if (n.getChildCount() != 3) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(n, INVALID_NUM_ARGUMENTS_ERROR, "" + n.getChildCount()));
                return;
            }
            Node firstArgument = objectName.getNext();
            if (!firstArgument.isQualifiedName()) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(firstArgument, QUALIFIED_NAME_EXPECTED_ERROR, Token.name(firstArgument.getType())));
                return;
            }
            Node secondArgument = firstArgument.getNext();
            if (secondArgument.getType() != 40) {
                ObjectPropertyStringPreprocess.this.compiler.report(t.makeError(secondArgument, STRING_LITERAL_EXPECTED_ERROR, Token.name(secondArgument.getType())));
                return;
            }
            Node newFirstArgument = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), ObjectPropertyStringPreprocess.this.compiler.getCodingConvention().getGlobalObject(), firstArgument.getLineno(), firstArgument.getCharno());
            Node newSecondArgument = NodeUtil.newQualifiedNameNode(ObjectPropertyStringPreprocess.this.compiler.getCodingConvention(), firstArgument.getQualifiedName() + "." + firstArgument.getNext().getString(), secondArgument.getLineno(), secondArgument.getCharno());
            n.replaceChild(firstArgument, newFirstArgument);
            n.replaceChild(secondArgument, newSecondArgument);
            ObjectPropertyStringPreprocess.this.compiler.reportCodeChange();
        }
    }
}

