/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.chromattic.utils;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.exoplatform.social.core.chromattic.entity.ActivityRef;
import org.exoplatform.social.core.chromattic.entity.ActivityRefDayEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRefListEntity;
import org.exoplatform.social.core.chromattic.utils.ActivityRefIterator;

public class ActivityRefList
implements Collection<ActivityRef> {
    protected String[] MONTH_NAME = new DateFormatSymbols(Locale.ENGLISH).getMonths();
    private ActivityRefListEntity listEntity;

    public ActivityRefList(ActivityRefListEntity listEntity) {
        this.listEntity = listEntity;
    }

    @Override
    public int size() {
        return this.listEntity.getNumber();
    }

    @Override
    public boolean isEmpty() {
        return this.listEntity.getNumber().equals(0);
    }

    @Override
    public boolean contains(Object o) {
        throw new RuntimeException();
    }

    public ActivityRefIterator iterator() {
        return new ActivityRefIterator(this.listEntity);
    }

    @Override
    public Object[] toArray() {
        throw new RuntimeException();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        throw new RuntimeException();
    }

    @Override
    public boolean add(ActivityRef activityRef) {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        calendar.setTimeInMillis(activityRef.getLastUpdated());
        String year = String.valueOf(calendar.get(1));
        String month = this.MONTH_NAME[calendar.get(2)];
        String day = String.valueOf(calendar.get(5));
        ActivityRefDayEntity dayEntity = this.listEntity.getYear(year).getMonth(month).getDay(day);
        ActivityRef ref = dayEntity.getActivityRefs().get(activityRef.getActivityEntity().getId());
        if (ref == null) {
            ref = dayEntity.createRef();
            dayEntity.getActivityRefs().put(activityRef.getActivityEntity().getId(), ref);
            dayEntity.inc();
        }
        ref.setLastUpdated(activityRef.getLastUpdated());
        ref.setActivityEntity(activityRef.getActivityEntity());
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException();
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new RuntimeException();
    }

    @Override
    public boolean addAll(Collection<? extends ActivityRef> activityRefs) {
        throw new RuntimeException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new RuntimeException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new RuntimeException();
    }

    @Override
    public void clear() {
        throw new RuntimeException();
    }
}

