/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.application.PortletPreferenceRequiredPlugin;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.SpaceApplicationConfigPlugin;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceLifecycle;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceApplicationHandler;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;

public class SpaceServiceImpl
implements SpaceService {
    private static final Log LOG = ExoLogger.getLogger((String)SpaceServiceImpl.class.getName());
    public static final String MEMBER = "member";
    public static final String MANAGER = "manager";
    private SpaceStorage spaceStorage;
    private IdentityStorage identityStorage;
    private ActivityStreamStorage streamStorage;
    private OrganizationService orgService = null;
    private UserACL userACL = null;
    private Map<String, SpaceApplicationHandler> spaceApplicationHandlers = null;
    private SpaceLifecycle spaceLifeCycle = new SpaceLifecycle();
    List<String> portletPrefsRequired = null;
    private SpaceApplicationConfigPlugin spaceApplicationConfigPlugin;
    private SpaceApplicationConfigPlugin.SpaceApplication spaceHomeApplication;
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;

    public SpaceServiceImpl(InitParams params, SpaceStorage spaceStorage, IdentityStorage identityStorage, ActivityStreamStorage streamStorage) throws Exception {
        this.spaceStorage = spaceStorage;
        this.identityStorage = identityStorage;
        this.streamStorage = streamStorage;
        if (params != null) {
            LOG.warn((Object)"The SpaceService configuration you attempt to use is deprecated, please update it byusing external-component-plugins configuration");
            this.spaceApplicationConfigPlugin = new SpaceApplicationConfigPlugin();
            Iterator it = params.getValuesParamIterator();
            while (it.hasNext()) {
                ValuesParam param = (ValuesParam)it.next();
                String name = param.getName();
                if (name.endsWith("homeNodeApp")) {
                    String homeNodeApp = param.getValue();
                    this.spaceHomeApplication = new SpaceApplicationConfigPlugin.SpaceApplication();
                    this.spaceHomeApplication.setPortletName(homeNodeApp);
                    this.spaceHomeApplication.setAppTitle(homeNodeApp);
                    this.spaceHomeApplication.setIcon("SpaceHomeIcon");
                    this.spaceApplicationConfigPlugin.setHomeApplication(this.spaceHomeApplication);
                }
                if (!name.endsWith("apps")) continue;
                List apps = param.getValues();
                for (String app : apps) {
                    boolean isRemovable;
                    String appName;
                    String[] splitedString = app.trim().split(":");
                    if (splitedString.length >= 2) {
                        appName = splitedString[0];
                        isRemovable = Boolean.getBoolean(splitedString[1]);
                    } else {
                        appName = app;
                        isRemovable = false;
                    }
                    SpaceApplicationConfigPlugin.SpaceApplication spaceApplication = new SpaceApplicationConfigPlugin.SpaceApplication();
                    spaceApplication.setPortletName(appName);
                    spaceApplication.isRemovable(isRemovable);
                    this.spaceApplicationConfigPlugin.addToSpaceApplicationList(spaceApplication);
                }
            }
        }
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesWithListAccess().load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public ListAccess<Space> getAllSpacesWithListAccess() {
        return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
    }

    @Override
    public Space getSpaceByDisplayName(String spaceDisplayName) {
        return this.spaceStorage.getSpaceByDisplayName(spaceDisplayName);
    }

    @Override
    public Space getSpaceByName(String spaceName) {
        return this.getSpaceByPrettyName(spaceName);
    }

    @Override
    public Space getSpaceByPrettyName(String spacePrettyName) {
        return this.spaceStorage.getSpaceByPrettyName(spacePrettyName);
    }

    @Override
    public List<Space> getSpacesByFirstCharacterOfName(String firstCharacterOfName) throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesByFilter(new SpaceFilter(firstCharacterOfName.charAt(0))).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getSpacesBySearchCondition(String searchCondition) throws SpaceException {
        try {
            return Arrays.asList(this.getAllSpacesByFilter(new SpaceFilter(searchCondition)).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public Space getSpaceByGroupId(String groupId) {
        return this.spaceStorage.getSpaceByGroupId(groupId);
    }

    @Override
    public Space getSpaceById(String id) {
        return this.spaceStorage.getSpaceById(id);
    }

    @Override
    public Space getSpaceByUrl(String url) {
        return this.spaceStorage.getSpaceByUrl(url);
    }

    @Override
    public List<Space> getSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getMemberSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getAccessibleSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getAccessibleSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.ACCESSIBLE);
    }

    @Override
    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceException {
        try {
            return Arrays.asList(this.getVisibleSpacesWithListAccess(userId, spaceFilter).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public SpaceListAccess getVisibleSpacesWithListAccess(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            if (spaceFilter == null) {
                return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ALL);
            }
            return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.VISIBLE);
    }

    @Override
    public SpaceListAccess getUnifiedSearchSpacesWithListAccess(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.UNIFIED_SEARCH);
    }

    @Override
    public List<Space> getEditableSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getSettingableSpaces(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getInvitedSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getInvitedSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    @Override
    public List<Space> getPublicSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPublicSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPublicSpacesWithListAccess(String userId) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.PUBLIC);
    }

    @Override
    public List<Space> getPendingSpaces(String userId) throws SpaceException {
        try {
            return Arrays.asList(this.getPendingSpacesWithListAccess(userId).load(0, 200));
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_DATASTORE, (Throwable)e);
        }
    }

    public SpaceListAccess getPendingSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.PENDING);
    }

    @Override
    public Space createSpace(Space space, String creator) {
        return this.createSpace(space, creator, null);
    }

    @Override
    public Space createSpace(Space space, String creator, String invitedGroupId) {
        String prettyName;
        Object[] managers = space.getManagers();
        Object[] members = space.getMembers();
        managers = (String[])ArrayUtils.add((Object[])managers, (Object)creator);
        members = (String[])ArrayUtils.add((Object[])members, (Object)creator);
        space.setManagers((String[])managers);
        space.setMembers((String[])members);
        String groupId = null;
        try {
            groupId = SpaceUtils.createGroup(space.getDisplayName(), space.getPrettyName(), creator);
        }
        catch (SpaceException e) {
            LOG.error((Object)"Error while creating group", (Throwable)e);
        }
        ArrayList<String> inviteds = new ArrayList<String>();
        if (invitedGroupId != null) {
            OrganizationService org = this.getOrgService();
            try {
                PageList groupMembersAccess = org.getUserHandler().findUsersByGroup(invitedGroupId);
                List users = groupMembersAccess.getAll();
                for (User user : users) {
                    String userId = user.getUserName();
                    if (userId.equals(creator)) continue;
                    Object[] invitedUsers = space.getInvitedUsers();
                    if (userId.equals(this.getUserACL().getSuperUser())) {
                        members = space.getMembers();
                        if (ArrayUtils.contains((Object[])members, (Object)userId)) continue;
                        members = (String[])ArrayUtils.add((Object[])members, (Object)userId);
                        space.setMembers((String[])members);
                        continue;
                    }
                    if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) continue;
                    invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
                    inviteds.add(userId);
                    space.setInvitedUsers((String[])invitedUsers);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to invite users from group " + invitedGroupId), (Throwable)e);
            }
        }
        if (!(prettyName = groupId.split("/")[2]).equals(space.getPrettyName())) {
            space.setPrettyName(groupId.split("/")[2]);
        }
        space.setGroupId(groupId);
        space.setUrl(space.getPrettyName());
        try {
            SpaceApplicationHandler spaceApplicationHandler = this.getSpaceApplicationHandler(space);
            spaceApplicationHandler.initApps(space, this.getSpaceApplicationConfigPlugin());
            for (SpaceApplicationConfigPlugin.SpaceApplication spaceApplication : this.getSpaceApplicationConfigPlugin().getSpaceApplicationList()) {
                this.setApp(space, spaceApplication.getPortletName(), spaceApplication.getAppTitle(), spaceApplication.isRemovable(), "active");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to init apps", (Throwable)e);
        }
        this.saveSpace(space, true);
        this.spaceLifeCycle.spaceCreated(space, creator);
        for (String invited : inviteds) {
            this.spaceLifeCycle.addInvitedUser(space, invited);
        }
        return space;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) {
        Space oldSpace = this.getSpaceById(space.getId());
        this.spaceStorage.saveSpace(space, isNew);
        if (!isNew && !oldSpace.getVisibility().equals(space.getVisibility())) {
            this.spaceLifeCycle.spaceAccessEdited(space, space.getEditor());
        }
    }

    @Override
    public void renameSpace(Space space, String newDisplayName) {
        this.spaceStorage.renameSpace(space, newDisplayName);
        this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
    }

    @Override
    public void renameSpace(String remoteId, Space space, String newDisplayName) {
        if (remoteId != null && remoteId.equals(this.getUserACL().getSuperUser()) && !this.isMember(space, remoteId)) {
            this.spaceStorage.renameSpace(remoteId, space, newDisplayName);
        } else {
            this.spaceStorage.renameSpace(space, newDisplayName);
        }
        this.spaceLifeCycle.spaceRenamed(space, space.getEditor());
    }

    @Override
    public void deleteSpace(Space space) {
        try {
            Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
            if (spaceIdentity != null) {
                this.identityStorage.hardDeleteIdentity(spaceIdentity);
            }
            SpaceUtils.removeMembershipFromGroup(space);
            this.spaceStorage.deleteSpace(space.getId());
            OrganizationService orgService = this.getOrgService();
            UserACL acl = this.getUserACL();
            GroupHandler groupHandler = orgService.getGroupHandler();
            Group deletedGroup = groupHandler.findGroupById(space.getGroupId());
            List mandatories = acl.getMandatoryGroups();
            if (deletedGroup != null) {
                if (!this.isMandatory(groupHandler, deletedGroup, mandatories)) {
                    SpaceUtils.removeGroup(space);
                }
            } else {
                LOG.warn((Object)"deletedGroup is null");
            }
            SpaceUtils.removePagesAndGroupNavigation(space);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable delete space", (Throwable)e);
        }
        this.spaceLifeCycle.spaceRemoved(space, null);
    }

    @Override
    public void deleteSpace(String spaceId) {
        this.deleteSpace(this.getSpaceById(spaceId));
    }

    @Override
    public void initApp(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void initApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void deInitApps(Space space) throws SpaceException {
        LOG.warn((Object)"Does nothing, just for compatible. It will be removed at 1.3.x");
    }

    @Override
    public void addMember(Space space, String userId) {
        Object[] members = space.getMembers();
        space = this.removeInvited(space, userId);
        space = this.removePending(space, userId);
        if (!ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.add((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            this.updateSpace(space);
            SpaceUtils.addUserToGroupWithMemberMembership(userId, space.getGroupId());
            this.spaceLifeCycle.memberJoined(space, userId);
        }
    }

    @Override
    public void addMember(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void removeMember(Space space, String userId) {
        Identity spaceIdentity = this.identityStorage.findIdentity("space", space.getPrettyName());
        if (spaceIdentity.isDeleted()) {
            return;
        }
        Object[] members = space.getMembers();
        if (ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.removeElement((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            this.spaceLifeCycle.memberLeft(space, userId);
        }
    }

    @Override
    public void removeMember(String spaceId, String userId) {
        this.removeMember(this.getSpaceById(spaceId), userId);
    }

    private Space addPending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (!ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.add((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removePending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.removeElement((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space addInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (!ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.add((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private Space removeInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.removeElement((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    @Override
    public List<String> getMembers(Space space) {
        if (space.getMembers() != null) {
            return Arrays.asList(space.getMembers());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getMembers(String spaceId) {
        return this.getMembers(this.getSpaceById(spaceId));
    }

    @Override
    public void setLeader(Space space, String userId, boolean isLeader) {
        this.setManager(space, userId, isLeader);
    }

    @Override
    public void setLeader(String spaceId, String userId, boolean isLeader) {
        this.setManager(this.getSpaceById(spaceId), userId, isLeader);
    }

    @Override
    public boolean isLeader(Space space, String userId) {
        return this.isManager(space, userId);
    }

    @Override
    public boolean isLeader(String spaceId, String userId) {
        return this.isManager(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isOnlyLeader(Space space, String userId) {
        return this.isOnlyManager(space, userId);
    }

    @Override
    public boolean isOnlyLeader(String spaceId, String userId) {
        return this.isOnlyManager(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isMember(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
            return true;
        }
        return SpaceUtils.isUserHasMembershipTypesInGroup(userId, space.getGroupId(), "*");
    }

    @Override
    public boolean isMember(String spaceId, String userId) {
        return this.isMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasAccessPermission(Space space, String userId) {
        return userId.equals(this.getUserACL().getSuperUser()) || ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) || ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean hasAccessPermission(String spaceId, String userId) {
        return this.hasAccessPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean hasEditPermission(Space space, String userId) {
        return this.hasSettingPermission(space, userId);
    }

    @Override
    public boolean hasEditPermission(String spaceId, String userId) {
        return this.hasSettingPermission(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isInvited(Space space, String userId) {
        return this.isInvitedUser(space, userId);
    }

    @Override
    public boolean isInvited(String spaceId, String userId) {
        return this.isInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public boolean isPending(Space space, String userId) {
        return this.isPendingUser(space, userId);
    }

    @Override
    public boolean isPending(String spaceId, String userId) {
        return this.isPendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void installApplication(String spaceId, String appId) throws SpaceException {
        this.installApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void installApplication(Space space, String appId) throws SpaceException {
        this.spaceLifeCycle.addApplication(space, this.getPortletId(appId));
    }

    @Override
    public void activateApplication(Space space, String appId) throws SpaceException {
        String appName = null;
        appName = SpaceUtils.isInstalledApp(space, appId) ? appId + System.currentTimeMillis() : appId;
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        this.setApp(space, appId, appName, true, "active");
        this.saveSpace(space, false);
        appHandler.activateApplication(space, appId, appName);
        this.spaceLifeCycle.activateApplication(space, this.getPortletId(appId));
    }

    @Override
    public void activateApplication(String spaceId, String appId) throws SpaceException {
        this.activateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void deactivateApplication(Space space, String appId) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            LOG.warn((Object)"appStatus is null!");
            return;
        }
        if (appStatus.equals("deactive")) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.deactiveApplication(space, appId);
        this.setApp(space, appId, appId, SpaceUtils.isRemovableApp(space, appId), "deactive");
        this.saveSpace(space, false);
        this.spaceLifeCycle.deactivateApplication(space, this.getPortletId(appId));
    }

    @Override
    public void deactivateApplication(String spaceId, String appId) throws SpaceException {
        this.deactivateApplication(this.getSpaceById(spaceId), appId);
    }

    @Override
    public void removeApplication(Space space, String appId, String appName) throws SpaceException {
        String appStatus = SpaceUtils.getAppStatus(space, appId);
        if (appStatus == null) {
            return;
        }
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandler(space);
        appHandler.removeApplication(space, appId, appName);
        this.removeApp(space, appId, appName);
        this.spaceLifeCycle.removeApplication(space, this.getPortletId(appId));
    }

    @Override
    public void removeApplication(String spaceId, String appId, String appName) throws SpaceException {
        this.removeApplication(this.getSpaceById(spaceId), appId, appName);
    }

    @Override
    public void requestJoin(String spaceId, String userId) {
        this.addPendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void requestJoin(Space space, String userId) {
        this.addPendingUser(space, userId);
    }

    @Override
    public void revokeRequestJoin(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    @Override
    public void revokeRequestJoin(String spaceId, String userId) {
        this.removePending(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void inviteMember(Space space, String userId) {
        this.addInvitedUser(space, userId);
    }

    @Override
    public void inviteMember(String spaceId, String userId) {
        this.addInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void revokeInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    @Override
    public void revokeInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void acceptInvitation(Space space, String userId) throws SpaceException {
        this.addMember(space, userId);
    }

    @Override
    public void acceptInvitation(String spaceId, String userId) throws SpaceException {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(String spaceId, String userId) {
        this.removeInvitedUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void denyInvitation(Space space, String userId) {
        this.removeInvitedUser(space, userId);
    }

    @Override
    public void validateRequest(Space space, String userId) {
        this.addMember(space, userId);
    }

    @Override
    public void validateRequest(String spaceId, String userId) {
        this.addMember(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void declineRequest(Space space, String userId) {
        this.removePendingUser(space, userId);
    }

    @Override
    public void declineRequest(String spaceId, String userId) {
        this.removePendingUser(this.getSpaceById(spaceId), userId);
    }

    @Override
    public void registerSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.addListener(listener);
    }

    @Override
    public void unregisterSpaceLifeCycleListener(SpaceLifeCycleListener listener) {
        this.spaceLifeCycle.removeListener(listener);
    }

    public void addSpaceListener(SpaceListenerPlugin plugin) {
        this.registerSpaceLifeCycleListener(plugin);
    }

    @Override
    public void setPortletsPrefsRequired(PortletPreferenceRequiredPlugin portletPrefsRequiredPlugin) {
        List<String> portletPrefs = portletPrefsRequiredPlugin.getPortletPrefs();
        if (this.portletPrefsRequired == null) {
            this.portletPrefsRequired = new ArrayList<String>();
        }
        this.portletPrefsRequired.addAll(portletPrefs);
    }

    @Override
    public String[] getPortletsPrefsRequired() {
        return this.portletPrefsRequired.toArray(new String[this.portletPrefsRequired.size()]);
    }

    @Override
    public void setSpaceApplicationConfigPlugin(SpaceApplicationConfigPlugin spaceApplicationConfigPlugin) {
        if (spaceApplicationConfigPlugin.getHomeApplication() == null) {
            spaceApplicationConfigPlugin.setHomeApplication(this.spaceHomeApplication);
        }
        this.spaceApplicationConfigPlugin = spaceApplicationConfigPlugin;
    }

    @Override
    public SpaceApplicationConfigPlugin getSpaceApplicationConfigPlugin() {
        return this.spaceApplicationConfigPlugin;
    }

    private OrganizationService getOrgService() {
        if (this.orgService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        }
        return this.orgService;
    }

    private UserACL getUserACL() {
        if (this.userACL == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            return (UserACL)container.getComponentInstanceOfType(UserACL.class);
        }
        return this.userACL;
    }

    private Map<String, SpaceApplicationHandler> getSpaceApplicationHandlers() {
        if (this.spaceApplicationHandlers == null) {
            this.spaceApplicationHandlers = new HashMap<String, SpaceApplicationHandler>();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DefaultSpaceApplicationHandler appHandler = (DefaultSpaceApplicationHandler)container.getComponentInstanceOfType(DefaultSpaceApplicationHandler.class);
            this.spaceApplicationHandlers.put(appHandler.getName(), appHandler);
        }
        return this.spaceApplicationHandlers;
    }

    private SpaceApplicationHandler getSpaceApplicationHandler(Space space) throws SpaceException {
        SpaceApplicationHandler appHandler = this.getSpaceApplicationHandlers().get(space.getType());
        if (appHandler == null) {
            throw new SpaceException(SpaceException.Code.UNKNOWN_SPACE_TYPE);
        }
        return appHandler;
    }

    public void setApp(Space space, String appId, String appName, boolean isRemovable, String status) throws SpaceException {
        String apps = space.getApp();
        String applicationStatus = appId + ":" + appName;
        applicationStatus = isRemovable ? applicationStatus + ":true" : applicationStatus + ":false";
        applicationStatus = applicationStatus + ":" + status;
        apps = apps == null ? applicationStatus : apps + "," + applicationStatus;
        space.setApp(apps);
    }

    private void removeApp(Space space, String appId, String appName) throws SpaceException {
        String apps = space.getApp();
        StringBuffer remainApp = new StringBuffer();
        String[] listApp = apps.split(",");
        for (int idx = 0; idx < listApp.length; ++idx) {
            String app = listApp[idx];
            String[] appPart = app.split(":");
            if (appPart[1].equals(appName)) continue;
            if (remainApp.length() != 0) {
                remainApp.append(",");
            }
            remainApp.append(app);
        }
        space.setApp(remainApp.toString());
        this.saveSpace(space, false);
    }

    private boolean isMandatory(GroupHandler groupHandler, Group group, List<String> mandatories) throws Exception {
        if (mandatories.contains(group.getId())) {
            return true;
        }
        Collection children = groupHandler.findGroups(group);
        for (Group g : children) {
            if (!this.isMandatory(groupHandler, g, mandatories)) continue;
            return true;
        }
        return false;
    }

    public SpaceStorage getStorage() {
        return this.spaceStorage;
    }

    public void setStorage(SpaceStorage storage) {
        this.spaceStorage = storage;
    }

    @Override
    public void addInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            LOG.warn((Object)"User already invited");
            return;
        }
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId) && !userId.equals(this.getUserACL().getSuperUser())) {
            LOG.warn((Object)"User already member");
            return;
        }
        if (this.isPending(space, userId)) {
            space = this.removePending(space, userId);
            this.addMember(space, userId);
        } else {
            space = this.addInvited(space, userId);
        }
        this.updateSpace(space);
        this.spaceLifeCycle.addInvitedUser(space, userId);
    }

    @Override
    public void addPendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
            return;
        }
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            this.addMember(space, userId);
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
            return;
        }
        String registration = space.getRegistration();
        String visibility = space.getVisibility();
        if (visibility.equals("hidden")) {
            LOG.warn((Object)"Unable request to join hidden");
            return;
        }
        if (registration.equals("open")) {
            this.addMember(space, userId);
        } else if (registration.equals("validation")) {
            space = this.addPending(space, userId);
            this.saveSpace(space, false);
        } else {
            LOG.warn((Object)"Unable request to join");
        }
        this.spaceLifeCycle.addPendingUser(space, userId);
    }

    @Override
    public ListAccess<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser()) && (spaceFilter == null || spaceFilter.getAppId() == null)) {
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.ACCESSIBLE_FILTER);
    }

    @Override
    public ListAccess<Space> getAllSpacesByFilter(SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
    }

    @Override
    public ListAccess<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.INVITED_FILTER);
    }

    @Override
    public ListAccess<Space> getMemberSpaces(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.MEMBER);
    }

    @Override
    public ListAccess<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.MEMBER_FILTER);
    }

    @Override
    public ListAccess<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.PENDING_FILTER);
    }

    @Override
    public ListAccess<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.PUBLIC_SUPER_USER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.PUBLIC_FILTER);
    }

    @Override
    public ListAccess<Space> getSettingableSpaces(String userId) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.spaceStorage, SpaceListAccess.Type.ALL);
        }
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.SETTING);
    }

    @Override
    public ListAccess<Space> getSettingabledSpacesByFilter(String userId, SpaceFilter spaceFilter) {
        if (userId.equals(this.getUserACL().getSuperUser())) {
            return new SpaceListAccess(this.spaceStorage, spaceFilter, SpaceListAccess.Type.ALL_FILTER);
        }
        return new SpaceListAccess(this.spaceStorage, userId, spaceFilter, SpaceListAccess.Type.SETTING_FILTER);
    }

    @Override
    public boolean hasSettingPermission(Space space, String userId) {
        if (userId.equals(this.getUserACL().getSuperUser()) || ArrayUtils.contains((Object[])space.getManagers(), (Object)userId)) {
            return true;
        }
        return SpaceUtils.isUserHasMembershipTypesInGroup(userId, space.getGroupId(), "*");
    }

    @Override
    public boolean isInvitedUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId);
    }

    @Override
    public boolean isManager(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getManagers(), (Object)userId)) {
            return true;
        }
        return SpaceUtils.isUserHasMembershipTypesInGroup(userId, space.getGroupId(), "*");
    }

    @Override
    public boolean isOnlyManager(Space space, String userId) {
        return space.getManagers() != null && space.getManagers().length == 1 && ArrayUtils.contains((Object[])space.getManagers(), (Object)userId);
    }

    @Override
    public boolean isPendingUser(Space space, String userId) {
        return ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId);
    }

    @Override
    public void registerSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.addListener(spaceListenerPlugin);
    }

    @Override
    public void removeInvitedUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
            space = this.removeInvited(space, userId);
            this.updateSpace(space);
        }
    }

    @Override
    public void removePendingUser(Space space, String userId) {
        if (ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) {
            space = this.removePending(space, userId);
            this.updateSpace(space);
        }
    }

    @Override
    public void setManager(Space space, String userId, boolean isManager) {
        Object[] managers = space.getManagers();
        if (isManager) {
            if (!ArrayUtils.contains((Object[])managers, (Object)userId)) {
                managers = (String[])ArrayUtils.add((Object[])managers, (Object)userId);
                space.setManagers((String[])managers);
                this.updateSpace(space);
                SpaceUtils.addUserToGroupWithManagerMembership(userId, space.getGroupId());
                this.spaceLifeCycle.grantedLead(space, userId);
            }
        } else if (ArrayUtils.contains((Object[])managers, (Object)userId)) {
            managers = (String[])ArrayUtils.removeElement((Object[])managers, (Object)userId);
            space.setManagers((String[])managers);
            this.updateSpace(space);
            SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            Space updatedSpace = this.getSpaceById(space.getId());
            if (this.isMember(updatedSpace, userId)) {
                this.spaceLifeCycle.revokedLead(space, userId);
            }
        }
    }

    @Override
    public void unregisterSpaceListenerPlugin(SpaceListenerPlugin spaceListenerPlugin) {
        this.spaceLifeCycle.removeListener(spaceListenerPlugin);
    }

    @Override
    public Space updateSpace(Space existingSpace) {
        this.spaceStorage.saveSpace(existingSpace, false);
        if (Space.UpdatedField.DESCRIPTION.equals((Object)existingSpace.getField())) {
            this.spaceLifeCycle.spaceDescriptionEdited(existingSpace, existingSpace.getEditor());
        }
        return existingSpace;
    }

    @Override
    public Space updateSpaceAvatar(Space existingSpace) {
        Identity spaceIdentity = this.identityStorage.findIdentity("space", existingSpace.getPrettyName());
        Profile profile = spaceIdentity.getProfile();
        profile.setProperty("avatar", existingSpace.getAvatarAttachment());
        this.identityStorage.updateProfile(profile);
        this.spaceLifeCycle.spaceAvatarEdited(existingSpace, existingSpace.getEditor());
        return existingSpace;
    }

    @Override
    public ListAccess<Space> getInvitedSpacesWithListAccess(String userId) {
        return new SpaceListAccess(this.spaceStorage, userId, SpaceListAccess.Type.INVITED);
    }

    private String getPortletId(String appId) {
        int SEPARATOR = 46;
        if (appId.indexOf(46) != -1) {
            int beginIndex = appId.lastIndexOf(46) + 1;
            int endIndex = appId.length();
            return appId.substring(beginIndex, endIndex);
        }
        return appId;
    }

    @Override
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceException {
        if (this.isMember(space, remoteId)) {
            this.spaceStorage.updateSpaceAccessed(remoteId, space);
        }
    }

    @Override
    public List<Space> getLastAccessedSpace(String remoteId, String appId, int offset, int limit) throws SpaceException {
        SpaceFilter filter = new SpaceFilter(remoteId, appId);
        return this.spaceStorage.getLastAccessedSpace(filter, offset, limit);
    }

    @Override
    public List<Space> getLastSpaces(int limit) {
        return this.spaceStorage.getLastSpaces(limit);
    }

    @Override
    public ListAccess<Space> getLastAccessedSpace(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.LASTEST_ACCESSED);
    }

    @Override
    public ListAccess<Space> getVisitedSpaces(String remoteId, String appId) {
        return new SpaceListAccess(this.spaceStorage, remoteId, appId, SpaceListAccess.Type.VISITED);
    }
}

