/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.utils.ObjectHelper;
import org.exoplatform.social.common.service.utils.TraceElement;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.chromattic.entity.ActivityEntity;
import org.exoplatform.social.core.chromattic.entity.ActivityRef;
import org.exoplatform.social.core.chromattic.entity.ActivityRefListEntity;
import org.exoplatform.social.core.chromattic.entity.HidableEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.StreamsEntity;
import org.exoplatform.social.core.chromattic.filter.JCRFilterLiteral;
import org.exoplatform.social.core.chromattic.utils.ActivityRefIterator;
import org.exoplatform.social.core.chromattic.utils.ActivityRefList;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.ActivityBuilderWhere;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.ChromatticNameEncode;
import org.exoplatform.social.core.storage.streams.StreamConfig;
import org.exoplatform.social.core.storage.streams.StreamProcessContext;

public class ActivityStreamStorageImpl
extends AbstractStorage
implements ActivityStreamStorage {
    private final IdentityStorageImpl identityStorage;
    private SpaceStorage spaceStorage;
    private RelationshipStorage relationshipStorage;
    private ActivityStorage activityStorage;
    private static final Log LOG = ExoLogger.getLogger(ActivityStreamStorageImpl.class);
    private Lock activityWriteLock;
    private Lock activityReadLock;

    public ActivityStreamStorageImpl(IdentityStorageImpl identityStorage) {
        this.identityStorage = identityStorage;
        ReentrantReadWriteLock activityLock = new ReentrantReadWriteLock();
        this.activityWriteLock = activityLock.writeLock();
        this.activityReadLock = activityLock.readLock();
    }

    private ActivityStorage getStorage() {
        if (this.activityStorage == null) {
            this.activityStorage = (ActivityStorage)CommonsUtils.getService(ActivityStorage.class);
        }
        return this.activityStorage;
    }

    private SpaceStorage getSpaceStorage() {
        if (this.spaceStorage == null) {
            this.spaceStorage = (SpaceStorage)CommonsUtils.getService(SpaceStorage.class);
        }
        return this.spaceStorage;
    }

    private RelationshipStorage getRelationshipStorage() {
        if (this.relationshipStorage == null) {
            this.relationshipStorage = (RelationshipStorage)CommonsUtils.getService(RelationshipStorage.class);
        }
        return this.relationshipStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            Identity owner = streamCtx.getIdentity();
            ActivityEntity activityEntity = null;
            try {
                activityEntity = this._findById(ActivityEntity.class, streamCtx.getActivityEntity().getId());
            }
            catch (Exception e) {
                activityEntity = streamCtx.getActivityEntity();
            }
            if ("organization".equals(owner.getProviderId())) {
                Identity poster = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(streamCtx.getPosterId());
                this.user(poster, activityEntity);
                this.addMentioner(streamCtx.getMentioners(), activityEntity);
            } else if ("space".equals(owner.getProviderId())) {
                this.space(owner, activityEntity);
                this.addMentioner(streamCtx.getMentioners(), activityEntity);
            }
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            LOG.warn((Object)"Failed to add Activity references.", (Throwable)e);
            LOG.debug((Object)"Failed to add Activity references.", (Throwable)e);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePoster(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            Identity owner = streamCtx.getIdentity();
            ActivityEntity activityEntity = streamCtx.getActivityEntity();
            if ("organization".equals(owner.getProviderId())) {
                Identity poster = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(activityEntity.getPosterIdentity().getId());
                this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
                this.createOwnerRefs(poster, activityEntity);
            } else if ("space".equals(owner.getProviderId())) {
                this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.SPACE_STREAM);
                Identity ownerPosterOnSpace = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(activityEntity.getPosterIdentity().getId());
                this.ownerSpaceMembersRefs(ownerPosterOnSpace, activityEntity);
            }
        }
        catch (NodeNotFoundException e) {
            ctx.setException((Throwable)e);
            LOG.warn((Object)"Failed to add Activity references.");
            LOG.debug((Object)"Failed to add Activity references.", (Throwable)e);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    private void user(Identity poster, ActivityEntity activityEntity) throws NodeNotFoundException, RepositoryException {
        TraceElement trace = TraceElement.getInstance((String)("creating ref-" + poster.getRemoteId()));
        trace.start();
        StreamConfig streamConfig = (StreamConfig)CommonsUtils.getService(StreamConfig.class);
        String userGroups = streamConfig.getActiveUserGroups();
        ActiveIdentityFilter filter = new ActiveIdentityFilter(userGroups);
        Set<String> activeGroups = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).getActiveUsers(filter);
        int days = streamConfig.getLastLoginAroundDays();
        filter = new ActiveIdentityFilter(days);
        int i = this.createRefForActiveUsers(poster, activityEntity, filter, activeGroups);
        trace.end();
        if (i > 0) {
            LOG.info((Object)("loop times = " + i + trace.toString()));
        }
    }

    private int createRefForActiveUsers(Identity owner, ActivityEntity activityEntity, ActiveIdentityFilter filer, Set<String> activeGroups) throws NodeNotFoundException, RepositoryException {
        Set<String> activeUsers = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).getActiveUsers(filer);
        if (activeUsers == null) {
            activeUsers = new HashSet<String>();
        }
        if (activeGroups.size() > 0) {
            activeUsers.addAll(activeGroups);
        }
        int i = activeUsers.size() > 0 ? this.createRefWithActiveUser(owner, activityEntity, activeUsers) : this.createRefWithoutActiveUser(owner, activityEntity);
        return i;
    }

    private int createRefWithoutActiveUser(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        List<Identity> got;
        StreamConfig streamConfig = (StreamConfig)CommonsUtils.getService(StreamConfig.class);
        int limitLoading = streamConfig.getLimitThresholdLoading();
        int connectionsThreshold = streamConfig.getConnectionsThreshold();
        int timesLoop = connectionsThreshold / limitLoading;
        LOG.info((Object)("Identity:" + owner.getRemoteId()));
        int offset = 0;
        int i = 0;
        for (i = 0; i < timesLoop && (got = this.getRelationshipStorage().getConnections(owner, offset, limitLoading)).size() > 0; ++i) {
            this.createConnectionsRefs(got, activityEntity);
            offset += limitLoading;
            StorageUtils.persist();
        }
        return i;
    }

    private int createRefWithActiveUser(Identity owner, ActivityEntity activityEntity, Set<String> activeUsers) throws NodeNotFoundException, RepositoryException {
        StreamConfig streamConfig = (StreamConfig)CommonsUtils.getService(StreamConfig.class);
        int connectionsThreshold = streamConfig.getConnectionsThreshold();
        int limitLoading = streamConfig.getLimitThresholdLoading();
        LOG.debug((Object)("active users: " + (activeUsers.size() - 1)));
        int offset = 0;
        IdentityEntity ownerEntity = this._findById(IdentityEntity.class, owner.getId());
        String nodePath = ownerEntity.getPath();
        StringBuilder relationshipPath = new StringBuilder();
        int batchIndex = 0;
        ArrayList<Identity> inputIdentities = new ArrayList<Identity>();
        for (String userName : activeUsers) {
            if (owner.getRemoteId().equals(userName)) continue;
            relationshipPath.delete(0, relationshipPath.length());
            relationshipPath.append(nodePath).append("/").append("soc:relationship").append("/").append("soc:").append(ChromatticNameEncode.encodeNodeName(userName));
            Identity identity2 = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentity("organization", userName);
            boolean hasRelationship = this.getRelationshipStorage().hasRelationship(owner, identity2, relationshipPath.toString());
            if (!hasRelationship) continue;
            LOG.debug((Object)("creates activity ref: " + userName));
            if (identity2 != null) {
                inputIdentities.add(identity2);
                if (++batchIndex == limitLoading) {
                    this.createConnectionsRefs(inputIdentities, activityEntity);
                    batchIndex = 0;
                    inputIdentities.clear();
                    LOG.debug((Object)"start - persist to storage...");
                    StorageUtils.persist();
                    LOG.debug((Object)"end - persist to storage...");
                }
            }
            if (++offset != connectionsThreshold) continue;
            break;
        }
        if (batchIndex > 0 && inputIdentities.size() > 0) {
            this.createConnectionsRefs(inputIdentities, activityEntity);
        }
        return offset;
    }

    private void removeActivityRefs(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            Identity owner = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(activityEntity.getIdentity().getId());
            for (String identityId : identityIds) {
                if (identityId.equals(owner.getId()) || identityId.equals(activityEntity.getPosterIdentity().getId())) continue;
                Identity identity = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(identityId);
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.MY_ACTIVITIES);
                Relationship relationship = this.relationshipStorage.getRelationship(owner, identity);
                if (relationship != null && relationship.getStatus().equals((Object)Relationship.Type.CONFIRMED)) continue;
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.FEED);
            }
        }
    }

    private void addMentioner(String[] identityIds, ActivityEntity activityEntity) throws NodeNotFoundException {
        if (identityIds != null && identityIds.length > 0) {
            for (String identityId : identityIds) {
                Identity identity = ((IdentityStorage)CommonsUtils.getService(IdentityStorage.class)).findIdentityById(identityId);
                this.createOwnerRefs(identity, activityEntity);
            }
        }
    }

    private void space(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        Space space = this.getSpaceStorage().getSpaceByPrettyName(owner.getRemoteId());
        if (space == null) {
            return;
        }
        List<Identity> identities = this.getMemberIdentities(space);
        this.createSpaceMembersRefs(identities, activityEntity);
    }

    private List<Identity> getMemberIdentities(Space space) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (String remoteId : space.getMembers()) {
            identities.add(this.identityStorage._findIdentityEntity("organization", remoteId, false));
        }
        return identities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String activityId) {
        this.activityWriteLock.lock();
        try {
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activityId);
            HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
            Collection<ActivityRef> references = activityEntity.getActivityRefs();
            ArrayList<ActivityRefListEntity> refList = new ArrayList<ActivityRefListEntity>();
            for (ActivityRef ref : references) {
                refList.add(ref.getDay().getMonth().getYear().getList());
            }
            for (ActivityRefListEntity list : refList) {
                list.remove(activityEntity, hidableActivity.getHidden(), null);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activities references.", (Throwable)e);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void like(Identity liker, ExoSocialActivity activity) {
        this.activityWriteLock.lock();
        try {
            ActivityEntity entity = this._findById(ActivityEntity.class, activity.getId());
            this.manageRefList(new ActivityStreamStorage.UpdateContext(liker, null), entity, ActivityRefType.FEED);
            this.manageRefList(new ActivityStreamStorage.UpdateContext(liker, null), entity, ActivityRefType.MY_ACTIVITIES);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to make Activity References for like case.");
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLike(Identity removedLike, ExoSocialActivity activity) {
        this.activityWriteLock.lock();
        try {
            ActivityEntity entity = this._findById(ActivityEntity.class, activity.getId());
            boolean notDelete = ArrayUtils.contains((Object[])activity.getCommentedIds(), (Object)removedLike.getId());
            if (notDelete |= this.hasMentioned(removedLike, activity)) {
                return;
            }
            this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedLike), entity, ActivityRefType.MY_ACTIVITIES);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity References for unlike case.");
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    private boolean hasMentioned(Identity removedLike, ExoSocialActivity activity) {
        for (String id : activity.getMentionedIds()) {
            if (id.indexOf(removedLike.getId()) <= -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCommenter(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            Identity commenter = streamCtx.getIdentity();
            ActivityEntity activityEntity = streamCtx.getActivityEntity();
            long oldUpdated = streamCtx.getOldLastUpdated();
            this.updateCommenterActivityRefs(commenter, activityEntity, ActivityRefType.MY_ACTIVITIES, oldUpdated);
            this.updateCommenterActivityRefs(commenter, activityEntity, ActivityRefType.FEED, oldUpdated);
            this.createRefForPoster(activityEntity, oldUpdated);
        }
        catch (NodeNotFoundException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ChromatticException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    private void updateCommenterActivityRefs(Identity identity, ActivityEntity activityEntity, ActivityRefType type, long oldUpdated) throws NodeNotFoundException {
        IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(identity.getProviderId(), identity.getRemoteId());
        ActivityRefListEntity refList = type.refsOf(identityEntity);
        ActivityRef ref = refList.get(activityEntity, oldUpdated);
        HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
        if (ref != null) {
            LOG.trace((Object)("remove activityRefId " + ref.getId() + " for commenter: " + identityEntity.getRemoteId()));
            refList.remove(activityEntity, hidableActivity.getHidden(), oldUpdated);
        }
        refList.getOrCreated(activityEntity, hidableActivity.getHidden());
    }

    private void createRefForPoster(ActivityEntity activityEntity, long oldUpdated) throws NodeNotFoundException {
        IdentityEntity posterIdentity = activityEntity.getIdentity();
        boolean has = this.hasActivityRefs(posterIdentity, activityEntity, ActivityRefType.MY_ACTIVITIES, oldUpdated);
        if (!has) {
            this.addRefList(posterIdentity, activityEntity, ActivityRefType.MY_ACTIVITIES, false);
            LOG.debug((Object)("createRefForPoster::MyActivities stream :" + posterIdentity.getRemoteId()));
        }
        if (!(has = this.hasActivityRefs(posterIdentity, activityEntity, ActivityRefType.FEED, oldUpdated))) {
            this.addRefList(posterIdentity, activityEntity, ActivityRefType.FEED, false);
            LOG.debug((Object)("createRefForPoster::Feed stream :" + posterIdentity.getRemoteId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, streamCtx.getActivity().getId());
            HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
            Collection<ActivityRef> references = activityEntity.getActivityRefs();
            long oldUpdated = streamCtx.getOldLastUpdated();
            ActivityRef newRef = null;
            Collection<ActivityRef> collection = references;
            synchronized (collection) {
                for (ActivityRef old : references) {
                    ActivityRefListEntity refList = old.getDay().getMonth().getYear().getList();
                    if (old.getName().equalsIgnoreCase(activityEntity.getId())) {
                        refList.update(activityEntity, old, oldUpdated, hidableActivity.getHidden());
                        continue;
                    }
                    newRef = refList.getOrCreated(activityEntity, hidableActivity.getHidden());
                    newRef.setLastUpdated(activityEntity.getLastUpdated());
                    newRef.setActivityEntity(activityEntity);
                    refList.remove(activityEntity, hidableActivity.getHidden(), oldUpdated);
                }
            }
        }
        catch (NodeNotFoundException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (ChromatticException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    @Override
    public void deleteComment(ProcessContext ctx) {
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ExoSocialActivity activity = streamCtx.getActivity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            this.removeActivityRefs(streamCtx.getMentioners(), activityEntity);
            this.removeActivityRefs(streamCtx.getCommenters(), activityEntity);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity references for mentioner and commenter.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSpaceMember(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            this.createSpaceMemberRefs(streamCtx.getIdentity(), streamCtx.getSpaceIdentity());
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to addSpaceMember Activity references.");
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSpaceMember(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            this.removeSpaceMemberRefs(streamCtx.getIdentity(), streamCtx.getSpaceIdentity());
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to removeSpaceMember Activity references.");
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    @Override
    public List<ExoSocialActivity> getFeed(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.FEED, owner, offset, limit);
    }

    @Override
    public List<String> getIdsFeed(Identity owner, int offset, int limit) {
        return this.getIdsNotQuery(ActivityRefType.FEED, owner, offset, limit);
    }

    @Override
    public int getNumberOfFeed(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.FEED, owner);
    }

    @Override
    public List<ExoSocialActivity> getConnections(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.CONNECTION, owner, offset, limit);
    }

    @Override
    public List<String> getIdsConnections(Identity owner, int offset, int limit) {
        return this.getIdsNotQuery(ActivityRefType.CONNECTION, owner, offset, limit);
    }

    @Override
    public int getNumberOfConnections(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.CONNECTION, owner);
    }

    @Override
    public List<ExoSocialActivity> getMySpaces(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.MY_SPACES, owner, offset, limit);
    }

    @Override
    public List<String> getIdsMySpaces(Identity owner, int offset, int limit) {
        return this.getIdsNotQuery(ActivityRefType.MY_SPACES, owner, offset, limit);
    }

    @Override
    public int getNumberOfMySpaces(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.MY_SPACES, owner);
    }

    @Override
    public List<ExoSocialActivity> getSpaceStream(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.SPACE_STREAM, owner, offset, limit);
    }

    @Override
    public List<String> getIdsSpaceStream(Identity owner, int offset, int limit) {
        return this.getIdsNotQuery(ActivityRefType.SPACE_STREAM, owner, offset, limit);
    }

    @Override
    public int getNumberOfSpaceStream(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.SPACE_STREAM, owner);
    }

    @Override
    public List<ExoSocialActivity> getMyActivities(Identity owner, int offset, int limit) {
        return this.getActivitiesNotQuery(ActivityRefType.MY_ACTIVITIES, owner, offset, limit);
    }

    @Override
    public List<String> getIdsMyActivities(Identity owner, int offset, int limit) {
        return this.getIdsNotQuery(ActivityRefType.MY_ACTIVITIES, owner, offset, limit);
    }

    @Override
    public int getNumberOfMyActivities(Identity owner) {
        return this.getNumberOfActivities(ActivityRefType.MY_ACTIVITIES, owner);
    }

    @Override
    public List<ExoSocialActivity> getViewerActivities(Identity owner, int offset, int limit) {
        return this.getOwnerActivitiesNotQuery(ActivityRefType.MY_ACTIVITIES, owner, offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Identity sender, Identity receiver) {
        try {
            this.activityWriteLock.lock();
            List<ActivityEntity> activities = this.getActivitiesByPoster(sender);
            IdentityEntity receiverEntity = this.identityStorage._findIdentityEntity(receiver.getProviderId(), receiver.getRemoteId());
            if (activities != null) {
                for (ActivityEntity entity : activities) {
                    if (this.isExistingActivityRef(receiverEntity, entity, ActivityRefType.CONNECTION) || entity.getPath().contains("/soc:providers/soc:space/")) continue;
                    this.createConnectionsRefs(receiver, entity);
                }
            }
            IdentityEntity senderEntity = this.identityStorage._findIdentityEntity(sender.getProviderId(), sender.getRemoteId());
            activities = this.getActivitiesByPoster(receiver);
            if (activities != null) {
                for (ActivityEntity entity : activities) {
                    if (this.isExistingActivityRef(senderEntity, entity, ActivityRefType.CONNECTION) || entity.getPath().contains("/soc:providers/soc:space/")) continue;
                    this.createConnectionsRefs(sender, entity);
                }
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to add Activity references when create relationship.");
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    @Override
    public void deleteConnect(Identity sender, Identity receiver) {
        try {
            ActivityEntity entity;
            QueryResult<ActivityEntity> activities = this.getActivitiesOfConnections(sender);
            if (activities != null) {
                while (activities.hasNext()) {
                    entity = (ActivityEntity)activities.next();
                    this.removeRelationshipRefs(receiver, entity);
                }
            }
            if ((activities = this.getActivitiesOfConnections(receiver)) != null) {
                while (activities.hasNext()) {
                    entity = (ActivityEntity)activities.next();
                    this.removeRelationshipRefs(sender, entity);
                }
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to delete Activity references when delete relationship.");
        }
    }

    private List<String> getIdsNotQuery(ActivityRefType type, Identity owner, int offset, int limit) {
        LinkedList<String> got = new LinkedList<String>();
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, owner.getId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            ActivityRefList list = new ActivityRefList(refList);
            int nb = 0;
            ActivityRefIterator it = list.iterator();
            this._skip(it, offset);
            int size = refList.getNumber() > 0 ? refList.getNumber() : 0;
            boolean sizeIsZero = size == 0;
            boolean isHide = false;
            while (it.hasNext()) {
                if (sizeIsZero) {
                    ++size;
                }
                try {
                    ActivityRef current = it.next();
                    if (current.getActivityEntity() == null) {
                        current.getDay().getActivityRefs().remove(current.getName());
                        continue;
                    }
                    ActivityEntity entity = current.getActivityEntity();
                    HidableEntity hidable = this._getMixin(entity, HidableEntity.class, false);
                    isHide = hidable != null ? hidable.getHidden() : false;
                    if (got.contains(entity.getId()) || isHide) continue;
                    got.add(entity.getId());
                    if (++nb != limit) continue;
                    break;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception while loading activities for user: " + owner.getRemoteId()));
                }
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to activities!");
        }
        return got;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExoSocialActivity> getActivitiesNotQuery(ActivityRefType type, Identity owner, int offset, int limit) {
        LinkedList<ExoSocialActivity> got = new LinkedList<ExoSocialActivity>();
        this.activityReadLock.lock();
        try {
            boolean sizeIsZero;
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            ActivityRefList list = new ActivityRefList(refList);
            int nb = 0;
            ActivityRefIterator it = list.iterator();
            this._skip(it, offset);
            int size = refList.getNumber() > 0 ? refList.getNumber() : 0;
            boolean bl = sizeIsZero = size == 0;
            while (it.hasNext()) {
                if (sizeIsZero) {
                    ++size;
                }
                try {
                    ActivityRef current = it.next();
                    if (current.getActivityEntity() == null) {
                        current.getDay().getActivityRefs().remove(current.getName());
                        continue;
                    }
                    ExoSocialActivity a = this.getStorage().getActivity(current.getActivityEntity().getId());
                    if ("space".equals(a.getActivityStream().getType().toString())) {
                        Space space = this.getSpaceStorage().getSpaceByPrettyName(a.getStreamOwner());
                        if (null == space) {
                            IdentityEntity spaceIdentity = current.getActivityEntity().getIdentity();
                            LOG.info((Object)("SPACE PATH:" + spaceIdentity.getPath()));
                            space = this.getSpaceStorage().getSpaceByPrettyName(spaceIdentity.getName());
                            if (space != null) {
                                LOG.info((Object)("SPACE was renamed before: " + space.getPrettyName()));
                            }
                        }
                        if ((ActivityRefType.CONNECTION.equals((Object)type) || ActivityRefType.FEED.equals((Object)type)) && space != null && !ArrayUtils.contains((Object[])space.getMembers(), (Object)owner.getRemoteId())) {
                            LOG.info((Object)("Cleanup leak activities " + current.getName() + " of space: " + space.getPrettyName()));
                            current.getDay().getActivityRefs().remove(current.getName());
                            this.getSession().save();
                            --size;
                            continue;
                        }
                    }
                    if (!got.contains(a)) {
                        if (a.isHidden()) continue;
                        got.add(a);
                        if (++nb != limit) continue;
                        break;
                    }
                    current.getDay().getActivityRefs().remove(current.getName());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception while loading activities for user: " + owner.getRemoteId()));
                }
            }
            refList.setNumber(size);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to activities!");
        }
        finally {
            this.activityReadLock.unlock();
        }
        return got;
    }

    private List<ExoSocialActivity> getOwnerActivitiesNotQuery(ActivityRefType type, Identity owner, int offset, int limit) {
        LinkedList<ExoSocialActivity> got = new LinkedList<ExoSocialActivity>();
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            ActivityRefList list = new ActivityRefList(refList);
            int nb = 0;
            ActivityRefIterator it = list.iterator();
            this._skip(it, offset);
            while (it.hasNext()) {
                ActivityRef current = it.next();
                if (current.getActivityEntity() == null) {
                    current.getDay().getActivityRefs().remove(current.getName());
                    continue;
                }
                ExoSocialActivity a = this.getStorage().getActivity(current.getActivityEntity().getId());
                if (!got.contains(a)) {
                    if (a.isHidden() || !a.getStreamOwner().equals(owner.getRemoteId())) continue;
                    got.add(a);
                    if (++nb != limit) continue;
                    break;
                }
                current.getDay().getActivityRefs().remove(current.getName());
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to activities!");
        }
        return got;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumberOfActivities(ActivityRefType type, Identity owner) {
        this.activityReadLock.lock();
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            if (refList == null || refList.getNumber() < 0) {
                int n = 0;
                return n;
            }
            int n = refList.getNumber();
            return n;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to getNumberOfActivities()");
        }
        finally {
            this.activityReadLock.unlock();
        }
        return 0;
    }

    private QueryResult<ActivityEntity> getActivitiesOfConnections(Identity ownerIdentity) {
        ArrayList<Identity> connections = new ArrayList<Identity>();
        if (ownerIdentity == null) {
            return null;
        }
        connections.add(ownerIdentity);
        ActivityFilter filter = ActivityFilter.newer();
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.simple().owners(connections).poster(ownerIdentity), filter, 0L, -1L);
    }

    private List<ActivityEntity> getActivitiesByPoster(Identity ownerIdentity) {
        LinkedList<ActivityEntity> got = new LinkedList<ActivityEntity>();
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(ownerIdentity.getProviderId(), ownerIdentity.getRemoteId());
            ActivityRefListEntity refList = ActivityRefType.MY_ACTIVITIES.refsOf(identityEntity);
            ActivityRefList list = new ActivityRefList(refList);
            for (ActivityRef current : list) {
                got.add(current.getActivityEntity());
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to get the activities!");
        }
        return got;
    }

    private QueryResult<ActivityEntity> getActivitiesOfSpace(Identity spaceIdentity) {
        if (spaceIdentity == null) {
            return null;
        }
        ActivityFilter filter = ActivityFilter.space();
        return this.getActivitiesOfIdentities(ActivityBuilderWhere.space().owners(spaceIdentity), filter, 0L, -1L);
    }

    private QueryResult<ActivityEntity> getActivitiesOfIdentities(ActivityBuilderWhere where, ActivityFilter filter, long offset, long limit) throws ActivityStorageException {
        return this.getActivitiesOfIdentitiesQuery(where, filter).objects(Long.valueOf(offset), Long.valueOf(limit));
    }

    private Query<ActivityEntity> getActivitiesOfIdentitiesQuery(ActivityBuilderWhere whereBuilder, JCRFilterLiteral filter) throws ActivityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ActivityEntity.class);
        builder.where(whereBuilder.build(filter));
        whereBuilder.orderBy((QueryBuilder<ActivityEntity>)builder, filter);
        return builder.get();
    }

    private boolean isExistingActivityRef(IdentityEntity identityEntity, ActivityEntity activityEntity, ActivityRefType type) throws NodeNotFoundException {
        ActivityRefListEntity refList = type.refsOf(identityEntity);
        return refList.get(activityEntity, null) != null;
    }

    private boolean hasActivityRefs(IdentityEntity identityEntity, ActivityEntity activityEntity, ActivityRefType type, long oldUpdated) throws NodeNotFoundException {
        ActivityRefListEntity refList = type.refsOf(identityEntity);
        ActivityRef ref = refList.get(activityEntity, oldUpdated);
        return ref != null && ref.getActivityEntity().getId() == activityEntity.getId();
    }

    private void createOwnerRefs(Identity owner, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(owner, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
    }

    private void createConnectionsRefs(List<Identity> identities, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.CONNECTION);
    }

    private void createConnectionsRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.CONNECTION);
    }

    private void removeRelationshipRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(null, identity), activityEntity, ActivityRefType.CONNECTION);
    }

    private void createSpaceMembersRefs(List<Identity> identities, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identities, null), activityEntity, ActivityRefType.MY_SPACES);
    }

    private void ownerSpaceMembersRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.MY_ACTIVITIES);
    }

    private void createSpaceMembersRefs(Identity identity, ActivityEntity activityEntity) throws NodeNotFoundException {
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.FEED);
        this.manageRefList(new ActivityStreamStorage.UpdateContext(identity, null), activityEntity, ActivityRefType.MY_SPACES);
    }

    private void createSpaceMemberRefs(Identity member, Identity space) throws NodeNotFoundException {
        QueryResult<ActivityEntity> spaceActivities = this.getActivitiesOfSpace(space);
        if (spaceActivities != null) {
            while (spaceActivities.hasNext()) {
                this.createSpaceMembersRefs(member, (ActivityEntity)spaceActivities.next());
            }
        }
    }

    private void removeSpaceMemberRefs(Identity removedMember, Identity space) throws NodeNotFoundException {
        QueryResult<ActivityEntity> spaceActivities = this.getActivitiesOfSpace(space);
        if (spaceActivities != null) {
            while (spaceActivities.hasNext()) {
                ActivityEntity entity = (ActivityEntity)spaceActivities.next();
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedMember), entity, ActivityRefType.FEED);
                this.manageRefList(new ActivityStreamStorage.UpdateContext(null, removedMember), entity, ActivityRefType.MY_SPACES);
            }
        }
    }

    private void manageRefList(ActivityStreamStorage.UpdateContext context, ActivityEntity activityEntity, ActivityRefType type) throws NodeNotFoundException {
        this.manageRefList(context, activityEntity, type, false);
    }

    private void manageRefList(ActivityStreamStorage.UpdateContext context, ActivityEntity activityEntity, ActivityRefType type, boolean mustCheck) throws NodeNotFoundException {
        ActivityRefListEntity listRef;
        IdentityEntity identityEntity;
        HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
        if (context.getAdded() != null) {
            for (Identity identity : context.getAdded()) {
                if (!identity.isEnable() || (identityEntity = this.identityStorage._findIdentityEntity(identity.getProviderId(), identity.getRemoteId())) == null) continue;
                if (type.equals((Object)ActivityRefType.CONNECTION)) {
                    if (activityEntity.getLastUpdated() != null) {
                        identityEntity.setLatestActivityCreatedTime(activityEntity.getLastUpdated());
                    } else {
                        identityEntity.setLatestActivityCreatedTime(activityEntity.getPostedTime());
                    }
                }
                if (mustCheck && this.isExistingActivityRef(identityEntity, activityEntity, type)) continue;
                listRef = type.refsOf(identityEntity);
                listRef.getOrCreated(activityEntity, hidableActivity.getHidden());
            }
        }
        if (context.getRemoved() != null) {
            for (Identity identity : context.getRemoved()) {
                if (!identity.isEnable()) continue;
                identityEntity = this.identityStorage._findIdentityEntity(identity.getProviderId(), identity.getRemoteId());
                listRef = type.refsOf(identityEntity);
                listRef.remove(activityEntity, hidableActivity.getHidden(), null);
            }
        }
    }

    private void addRefList(IdentityEntity identityEntity, ActivityEntity activityEntity, ActivityRefType type, boolean mustCheck) throws NodeNotFoundException {
        if (mustCheck && this.isExistingActivityRef(identityEntity, activityEntity, type)) {
            return;
        }
        HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
        ActivityRefListEntity listRef = type.refsOf(identityEntity);
        ActivityRef ref = listRef.getOrCreated(activityEntity, hidableActivity.getHidden());
        if (ref.getName() == null) {
            ref.setName(activityEntity.getName());
        }
        if (ref.getLastUpdated() == null) {
            ref.setLastUpdated(activityEntity.getLastUpdated());
        }
        ref.setActivityEntity(activityEntity);
    }

    @Override
    public void createFeedActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.FEED);
    }

    @Override
    public void createConnectionsActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.CONNECTION);
    }

    @Override
    public void createMySpacesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.MY_SPACES);
    }

    @Override
    public void createSpaceActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.SPACE_STREAM);
    }

    @Override
    public void createMyActivitiesActivityRef(Identity owner, List<ExoSocialActivity> activities) {
        this.createActivityRef(owner, activities, ActivityRefType.MY_ACTIVITIES);
    }

    @Override
    public void createActivityRef(Identity owner, List<ExoSocialActivity> activities, ActivityRefType type) {
        if (activities == null || activities.size() == 0) {
            return;
        }
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity listRef = type.create(identityEntity);
            ExoSocialActivity entity = activities.get(activities.size() - 1);
            Long value = entity.getUpdated() != null ? entity.getUpdated().getTime() : entity.getPostedTime().longValue();
            Long oldLastMigration = listRef.getLastMigration();
            listRef.setLastMigration((long)value);
            Integer numberOfStream = listRef.getNumber();
            for (ExoSocialActivity a : activities) {
                ActivityEntity activityEntity = (ActivityEntity)this.getSession().findById(ActivityEntity.class, a.getId());
                HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
                ActivityRef ref = listRef.getOrCreated(activityEntity, hidableActivity.getHidden());
                ref.setActivityEntity(activityEntity);
            }
            if (oldLastMigration != null && oldLastMigration > 0L) {
                listRef.setNumber(numberOfStream);
            }
            StorageUtils.persist();
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to create Activity references.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrateStreamSize(Identity owner, int size, ActivityRefType type) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity listRef = type.create(identityEntity);
            listRef.setNumber(size);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to migrateStreamSize.");
        }
        finally {
            StorageUtils.persist();
        }
    }

    @Override
    public boolean hasSizeOfFeed(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.FEED, owner);
    }

    @Override
    public boolean hasSizeOfMySpaces(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.MY_SPACES, owner);
    }

    @Override
    public boolean hasSizeOfSpaceStream(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.SPACE_STREAM, owner);
    }

    @Override
    public boolean hasSizeOfMyActivities(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.MY_ACTIVITIES, owner);
    }

    @Override
    public boolean hasSizeOfConnections(Identity owner) {
        return this.hasSizeOfActivities(ActivityRefType.CONNECTION, owner);
    }

    private boolean hasSizeOfActivities(ActivityRefType type, Identity owner) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity(owner.getProviderId(), owner.getRemoteId());
            ActivityRefListEntity refList = type.refsOf(identityEntity);
            if (refList == null) {
                return false;
            }
            return refList.getNumber() > 0;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Failed to hasSizeOfActivities()");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHidable(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            ExoSocialActivity activity = streamCtx.getActivity();
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, activity.getId());
            Collection<ActivityRef> references = activityEntity.getActivityRefs();
            if (references == null || references.size() == 0) {
                streamCtx.activityEntity(activityEntity);
                this.savePoster((ProcessContext)streamCtx);
                this.save((ProcessContext)streamCtx);
            }
            HidableEntity hidableActivity = this._getMixin(activityEntity, HidableEntity.class, true);
            hidableActivity.setHidden(activity.isHidden());
            for (ActivityRef ref : references) {
                if (!hidableActivity.getHidden().booleanValue()) {
                    ref.getDay().inc();
                    continue;
                }
                ref.getDay().desc();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to update Activity references when change the visibility of activity.", (Throwable)e);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMentioners(ProcessContext ctx) {
        this.activityWriteLock.lock();
        try {
            StreamProcessContext streamCtx = (StreamProcessContext)((Object)ObjectHelper.cast(StreamProcessContext.class, (Object)ctx));
            if (streamCtx.getMentioners() == null || streamCtx.getMentioners().length == 0) {
                return;
            }
            ActivityEntity activityEntity = this._findById(ActivityEntity.class, streamCtx.getActivity().getId());
            this.addMentioner(streamCtx.getMentioners(), activityEntity);
        }
        catch (NodeNotFoundException ex) {
            LOG.warn((Object)"Probably was updated activity reference by another session");
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.activityWriteLock.unlock();
        }
    }

    public static enum ActivityRefType {
        FEED{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getAll();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getAll() == null ? streams.createAllStream() : streams.getAll();
                return refList;
            }
        }
        ,
        CONNECTION{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getConnections();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getConnections() == null ? streams.createConnectionsStream() : streams.getConnections();
                return refList;
            }
        }
        ,
        MY_SPACES{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getMySpaces();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getMySpaces() == null ? streams.createMySpacesStream() : streams.getMySpaces();
                return refList;
            }
        }
        ,
        SPACE_STREAM{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getSpace();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getSpace() == null ? streams.createSpaceStream() : streams.getSpace();
                return refList;
            }
        }
        ,
        MY_ACTIVITIES{

            @Override
            public ActivityRefListEntity refsOf(IdentityEntity identityEntity) {
                if (identityEntity.getStreams() == null) {
                    return this.create(identityEntity);
                }
                if (identityEntity.getStreams().getOwner() == null) {
                    return this.create(identityEntity);
                }
                return identityEntity.getStreams().getOwner();
            }

            @Override
            public ActivityRefListEntity create(IdentityEntity identityEntity) {
                StreamsEntity streams = identityEntity.getStreams();
                if (streams == null) {
                    streams = identityEntity.createStreams();
                    identityEntity.setStreams(streams);
                }
                ActivityRefListEntity refList = streams.getOwner() == null ? streams.createOwnerStream() : streams.getOwner();
                return refList;
            }
        };


        public abstract ActivityRefListEntity refsOf(IdentityEntity var1);

        public abstract ActivityRefListEntity create(IdentityEntity var1);
    }
}

