/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NAryQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathQueryNode
extends NAryQueryNode {
    private boolean absolute;
    private final List<InternalQName> validJcrSystemNodeTypeNames;
    private static final LocationStepQueryNode[] EMPTY = new LocationStepQueryNode[0];

    protected PathQueryNode(QueryNode parent, List<InternalQName> validJcrSystemNodeTypeNames) {
        super(parent);
        this.validJcrSystemNodeTypeNames = validJcrSystemNodeTypeNames;
    }

    public List<InternalQName> getValidJcrSystemNodeTypeNames() {
        return this.validJcrSystemNodeTypeNames;
    }

    @Override
    public Object accept(QueryNodeVisitor visitor, Object data) throws RepositoryException {
        return visitor.visit(this, data);
    }

    @Override
    public int getType() {
        return 11;
    }

    public void addPathStep(LocationStepQueryNode step) {
        this.addOperand(step);
    }

    public LocationStepQueryNode[] getPathSteps() {
        if (this.operands == null) {
            return EMPTY;
        }
        return this.operands.toArray(new LocationStepQueryNode[this.operands.size()]);
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PathQueryNode) {
            PathQueryNode other = (PathQueryNode)obj;
            return super.equals(obj) && this.absolute == other.absolute;
        }
        return false;
    }

    @Override
    public boolean needsSystemTree() {
        LocationStepQueryNode[] pathSteps = this.getPathSteps();
        if (pathSteps == null || pathSteps.length == 0) {
            return true;
        }
        InternalQName firstPathStepName = pathSteps[0].getNameTest();
        if (firstPathStepName == null) {
            NodeTypeQueryNode nodeTypeQueryNode;
            QueryNode[] pathStepOperands = pathSteps[0].getOperands();
            return pathStepOperands.length <= 0 || !(pathStepOperands[0] instanceof NodeTypeQueryNode) || this.validJcrSystemNodeTypeNames.contains((Object)(nodeTypeQueryNode = (NodeTypeQueryNode)pathStepOperands[0]).getValue());
        }
        LocationStepQueryNode firstWorkspaceRelativeStep = pathSteps[0];
        if (firstPathStepName.equals((Object)Constants.ROOT_PATH.getName()) && pathSteps.length > 1) {
            firstWorkspaceRelativeStep = pathSteps[1];
        }
        if (firstWorkspaceRelativeStep.getIncludeDescendants()) {
            return true;
        }
        InternalQName firstWorkspaceRelativeName = firstWorkspaceRelativeStep.getNameTest();
        if (firstWorkspaceRelativeName == null || firstWorkspaceRelativeName.equals((Object)Constants.JCR_SYSTEM)) {
            return true;
        }
        return super.needsSystemTree();
    }
}

