/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectWriter;
import org.exoplatform.services.jcr.impl.quota.PathPatternUtils;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.UnknownQuotaLimitException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuotaPersister
implements QuotaPersister {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.AbstractQuotaPersister");

    @Override
    public void setNodeDataSizeIfQuotaExists(String repositoryName, String workspaceName, String nodePath, long dataSize) {
        this.setNodeDataSize(repositoryName, workspaceName, nodePath, dataSize);
        try {
            this.getNodeQuotaOrGroupOfNodesQuota(repositoryName, workspaceName, nodePath);
        }
        catch (UnknownQuotaLimitException e) {
            this.removeNodeDataSize(repositoryName, workspaceName, nodePath);
        }
    }

    @Override
    public void removeNodeQuotaAndDataSize(String repositoryName, String workspaceName, String nodePath) {
        this.removeNodeQuota(repositoryName, workspaceName, nodePath);
        if (this.getAcceptableGroupOfNodesQuota(repositoryName, workspaceName, nodePath) == null) {
            this.removeNodeDataSize(repositoryName, workspaceName, nodePath);
        }
    }

    @Override
    public void removeGroupOfNodesAndDataSize(String repositoryName, String workspaceName, String patternPath) {
        this.removeGroupOfNodesQuota(repositoryName, workspaceName, patternPath);
        for (String nodePath : this.getAllTrackedNodes(repositoryName, workspaceName)) {
            if (!PathPatternUtils.acceptName(patternPath, nodePath)) continue;
            try {
                this.getNodeQuota(repositoryName, workspaceName, nodePath);
            }
            catch (UnknownQuotaLimitException e) {
                this.removeNodeDataSize(repositoryName, workspaceName, nodePath);
            }
        }
    }

    @Override
    public long getNodeQuotaOrGroupOfNodesQuota(String repositoryName, String workspaceName, String nodePath) throws UnknownQuotaLimitException {
        try {
            return this.getNodeQuota(repositoryName, workspaceName, nodePath);
        }
        catch (UnknownQuotaLimitException e) {
            String patternPath = this.getAcceptableGroupOfNodesQuota(repositoryName, workspaceName, nodePath);
            if (patternPath != null) {
                return this.getGroupOfNodesQuota(repositoryName, workspaceName, patternPath);
            }
            throw new UnknownQuotaLimitException("Quota for " + nodePath + " is not defined");
        }
    }

    @Override
    public boolean isNodeQuotaOrGroupOfNodesQuotaAsync(String repositoryName, String workspaceName, String nodePath) throws UnknownQuotaLimitException {
        try {
            return this.isNodeQuotaAsync(repositoryName, workspaceName, nodePath);
        }
        catch (UnknownQuotaLimitException e) {
            String patternPath = this.getAcceptableGroupOfNodesQuota(repositoryName, workspaceName, nodePath);
            if (patternPath != null) {
                return this.isGroupOfNodesQuotaAsync(repositoryName, workspaceName, patternPath);
            }
            throw new UnknownQuotaLimitException("Quota for " + nodePath + " is not defined");
        }
    }

    @Override
    public String getAcceptableGroupOfNodesQuota(String repositoryName, String workspaceName, String nodePath) {
        Set<String> patterns = this.getAllGroupOfNodesQuota(repositoryName, workspaceName);
        for (String patternPath : patterns) {
            if (!PathPatternUtils.acceptName(patternPath, nodePath)) continue;
            return patternPath;
        }
        return null;
    }

    @Override
    public Set<String> getAllParentNodesWithQuota(String repositoryName, String workspaceName, String nodePath) {
        HashSet<String> quotableParents = new HashSet<String>();
        for (String quoteablePath : this.getAllNodeQuota(repositoryName, workspaceName)) {
            if (!nodePath.startsWith(quoteablePath)) continue;
            quotableParents.add(quoteablePath);
        }
        for (String pattern : this.getAllGroupOfNodesQuota(repositoryName, workspaceName)) {
            if (!PathPatternUtils.acceptDescendant(pattern, nodePath)) continue;
            String commonAncestor = PathPatternUtils.extractCommonAncestor(pattern, nodePath);
            quotableParents.add(commonAncestor);
        }
        return quotableParents;
    }

    @Override
    public void backupWorkspaceData(String repositoryName, String workspaceName, ZipObjectWriter out) throws BackupException {
        try {
            this.backupWorkspaceDataSize(repositoryName, workspaceName, out);
            this.backupWorkspaceQuota(repositoryName, workspaceName, out);
            this.backupAllNodeDataSize(repositoryName, workspaceName, out);
            this.backupAllNodeQuota(repositoryName, workspaceName, out);
            this.backupAllGroupOfNodesQuota(repositoryName, workspaceName, out);
        }
        catch (IOException e) {
            throw new BackupException(e.getMessage(), e);
        }
    }

    @Override
    public void restoreWorkspaceData(String repositoryName, String workspaceName, ZipObjectReader in) throws BackupException {
        try {
            this.restoreWorkspaceDataSize(repositoryName, workspaceName, in);
            this.restoreWorkspaceQuota(repositoryName, workspaceName, in);
            this.restoreAllNodeDataSize(repositoryName, workspaceName, in);
            this.restoreAllNodeQuota(repositoryName, workspaceName, in);
            this.restoreAllGroupOfNodesQuota(repositoryName, workspaceName, in);
        }
        catch (IOException e) {
            throw new BackupException(e.getMessage(), e);
        }
    }

    private void backupWorkspaceQuota(String repositoryName, String workspaceName, ZipObjectWriter out) throws IOException {
        block2: {
            out.putNextEntry(new ZipEntry("workspace-quota-limit"));
            try {
                long quotaLimit = this.getWorkspaceQuota(repositoryName, workspaceName);
                out.writeLong(quotaLimit);
            }
            catch (UnknownQuotaLimitException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        out.closeEntry();
    }

    private void backupWorkspaceDataSize(String repositoryName, String workspaceName, ZipObjectWriter out) throws IOException {
        block2: {
            out.putNextEntry(new ZipEntry("workspace-data-size"));
            try {
                long size = this.getWorkspaceDataSize(repositoryName, workspaceName);
                out.writeLong(size);
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        out.closeEntry();
    }

    private void backupAllNodeDataSize(String repositoryName, String workspaceName, ZipObjectWriter out) throws IOException {
        out.putNextEntry(new ZipEntry("workspace-nodes-data-size"));
        Set<String> paths = this.getAllTrackedNodes(repositoryName, workspaceName);
        out.writeInt(paths.size());
        for (String nodePath : paths) {
            try {
                long size = this.getNodeDataSize(repositoryName, workspaceName, nodePath);
                out.writeString(nodePath);
                out.writeLong(size);
            }
            catch (UnknownDataSizeException e) {
                throw new IOException("Node is tracked but data size is unknown.", e);
            }
        }
        out.closeEntry();
    }

    private void backupAllNodeQuota(String repositoryName, String workspaceName, ZipObjectWriter out) throws IOException {
        out.putNextEntry(new ZipEntry("workspace-all-node-quota"));
        Set<String> paths = this.getAllNodeQuota(repositoryName, workspaceName);
        out.writeInt(paths.size());
        for (String nodePath : paths) {
            try {
                long quotaLimit = this.getNodeQuota(repositoryName, workspaceName, nodePath);
                boolean async = this.isNodeQuotaAsync(repositoryName, workspaceName, nodePath);
                out.writeString(nodePath);
                out.writeLong(quotaLimit);
                out.writeBoolean(async);
            }
            catch (UnknownQuotaLimitException e) {
                throw new IOException("Node is quoted but qouta limit is unknown.", e);
            }
        }
        out.closeEntry();
    }

    private void backupAllGroupOfNodesQuota(String repositoryName, String workspaceName, ZipObjectWriter out) throws IOException {
        out.putNextEntry(new ZipEntry("workspace-all-group-of-nodes-quota"));
        Set<String> paths = this.getAllGroupOfNodesQuota(repositoryName, workspaceName);
        out.writeInt(paths.size());
        for (String patternPath : paths) {
            try {
                long quotaLimit = this.getGroupOfNodesQuota(repositoryName, workspaceName, patternPath);
                boolean async = this.isGroupOfNodesQuotaAsync(repositoryName, workspaceName, patternPath);
                out.writeString(patternPath);
                out.writeLong(quotaLimit);
                out.writeBoolean(async);
            }
            catch (UnknownQuotaLimitException e) {
                throw new IOException("Node is quoted but qouta limit is unknown.", e);
            }
        }
        out.closeEntry();
    }

    private void restoreWorkspaceQuota(String repositoryName, String workspaceName, ZipObjectReader in) throws IOException {
        block2: {
            in.getNextEntry();
            try {
                Long quotaLimit = in.readLong();
                this.setWorkspaceQuota(repositoryName, workspaceName, quotaLimit);
            }
            catch (EOFException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void restoreWorkspaceDataSize(String repositoryName, String workspaceName, ZipObjectReader in) throws IOException {
        block2: {
            in.getNextEntry();
            try {
                Long dataSize = in.readLong();
                this.setWorkspaceDataSize(repositoryName, workspaceName, dataSize);
            }
            catch (EOFException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void restoreAllNodeDataSize(String repositoryName, String workspaceName, ZipObjectReader in) throws IOException {
        in.getNextEntry();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String nodePath = in.readString();
            long dataSize = in.readLong();
            this.setNodeDataSize(repositoryName, workspaceName, nodePath, dataSize);
        }
    }

    private void restoreAllNodeQuota(String repositoryName, String workspaceName, ZipObjectReader in) throws IOException {
        in.getNextEntry();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String nodePath = in.readString();
            long quotaLimit = in.readLong();
            boolean asyncUpdate = in.readBoolean();
            this.setNodeQuota(repositoryName, workspaceName, nodePath, quotaLimit, asyncUpdate);
        }
    }

    private void restoreAllGroupOfNodesQuota(String repositoryName, String workspaceName, ZipObjectReader in) throws IOException {
        in.getNextEntry();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            String patternPath = in.readString();
            long quotaLimit = in.readLong();
            boolean asyncUpdate = in.readBoolean();
            this.setGroupOfNodesQuota(repositoryName, workspaceName, patternPath, quotaLimit, asyncUpdate);
        }
    }
}

