/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuotaExecutorService
implements ExecutorService,
Suspendable {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.QuotaExecutorService");
    private ExecutorService delegated;
    protected final AtomicBoolean isSuspended = new AtomicBoolean();
    protected final String uniqueName;

    public QuotaExecutorService(String uniqueName) {
        this.uniqueName = uniqueName;
        this.initExecutorService();
    }

    @Override
    public void execute(Runnable command) {
        if (this.isSuspended.get()) {
            throw new IllegalStateException("Executor service is suspended");
        }
        this.delegated.execute(command);
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegated.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void suspend() throws SuspendException {
        this.isSuspended.set(true);
        this.awaitTasksTermination();
    }

    @Override
    public void resume() throws ResumeException {
        this.initExecutorService();
        this.isSuspended.set(false);
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    @Override
    public int getPriority() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    protected void awaitTasksTermination() {
        this.delegated.shutdown();
        try {
            this.delegated.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.warn((Object)"Termination has been interrupted");
        }
    }

    protected void initExecutorService() {
        this.delegated = Executors.newFixedThreadPool(1, new ThreadFactory(){

            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, "QuotaManagerThread " + QuotaExecutorService.this.uniqueName);
            }
        });
    }
}

