/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.DataRestoreContext;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ZipObjectWriter;
import org.exoplatform.services.jcr.impl.quota.ApplyPersistedChangesTask;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WorkspaceQuotaRestore
implements DataRestore {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceQuotaRestore");
    protected static final String BACKUP_FILE_NAME = "quota";
    private final File tempFile;
    private final File backupFile;
    private final WorkspaceQuotaManager wqm;
    private final String wsName;
    private final String rName;
    private final QuotaPersister quotaPersister;

    WorkspaceQuotaRestore(WorkspaceQuotaManager wqm, DataRestoreContext context) {
        this(wqm, (File)context.getObject("storage-dir"));
    }

    WorkspaceQuotaRestore(WorkspaceQuotaManager wqm, File storageDir) {
        this.wqm = wqm;
        this.backupFile = new File(storageDir, "quota.dump");
        File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
        this.tempFile = new File(tempDir, "temp.dump");
        this.wsName = wqm.getContext().wsName;
        this.rName = wqm.getContext().rName;
        this.quotaPersister = wqm.getContext().quotaPersister;
    }

    public void clean() throws BackupException {
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BackupException {
                    WorkspaceQuotaRestore.this.doBackup(WorkspaceQuotaRestore.this.tempFile);
                    WorkspaceQuotaRestore.this.doClean();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BackupException) {
                throw (BackupException)cause;
            }
            throw new BackupException(cause);
        }
    }

    public void restore() throws BackupException {
        this.doRestore(this.backupFile);
    }

    public void commit() throws BackupException {
    }

    public void rollback() throws BackupException {
        this.doClean();
        this.doRestore(this.tempFile);
    }

    public void close() throws BackupException {
        PrivilegedFileHelper.delete((File)this.tempFile);
    }

    public void backup() throws BackupException {
        this.doBackup(this.backupFile);
    }

    /*
     * Unable to fully structure code
     */
    protected void doRestore(File backupFile) throws BackupException {
        block10: {
            if (!PrivilegedFileHelper.exists((File)backupFile)) {
                this.LOG.warn((Object)"Nothing to restore for quotas");
                return;
            }
            in = null;
            try {
                in = new ZipObjectReader(PrivilegedFileHelper.zipInputStream((File)backupFile));
                this.quotaPersister.restoreWorkspaceData(this.rName, this.wsName, in);
                var5_3 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var4_8) {
                var5_4 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.LOG.error((Object)"Can't close input stream", (Throwable)e);
                    }
                }
                throw var4_8;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Can't close input stream", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block10;
                catch (IOException e) {
                    throw new BackupException(e);
                }
            }
        }
        this.repairDataSize();
    }

    private void repairDataSize() {
        block2: {
            try {
                long dataSize = this.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
                ChangesItem changesItem = new ChangesItem();
                changesItem.updateWorkspaceChangedSize(dataSize);
                this.quotaPersister.setWorkspaceDataSize(this.rName, this.wsName, 0L);
                ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(this.wqm.getContext(), changesItem);
                task.run();
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doBackup(File backupFile) throws BackupException {
        ZipObjectWriter out = null;
        out = new ZipObjectWriter(PrivilegedFileHelper.zipOutputStream((File)backupFile));
        this.quotaPersister.backupWorkspaceData(this.rName, this.wsName, out);
        Object var5_3 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Can't close output stream", (Throwable)e);
        }
        return;
        {
            catch (IOException e) {
                throw new BackupException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                this.LOG.error((Object)"Can't close output stream", (Throwable)e);
            }
            throw throwable;
        }
    }

    protected void doClean() throws BackupException {
        block2: {
            try {
                long dataSize = this.wqm.quotaPersister.getWorkspaceDataSize(this.rName, this.wsName);
                ChangesItem changesItem = new ChangesItem();
                changesItem.updateWorkspaceChangedSize(-dataSize);
                ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(this.wqm.getContext(), changesItem);
                task.run();
            }
            catch (UnknownDataSizeException e) {
                if (!this.LOG.isTraceEnabled()) break block2;
                this.LOG.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.quotaPersister.clearWorkspaceData(this.wqm.rName, this.wqm.wsName);
    }
}

