/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.impl.quota.infinispan.WorkspaceBasedKey;

public abstract class PathBasedKey
extends WorkspaceBasedKey {
    private String path;

    public PathBasedKey() {
    }

    public PathBasedKey(String workspaceUniqueName, String path) {
        super(workspaceUniqueName, workspaceUniqueName + '/' + path);
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        byte[] data = this.path.getBytes("UTF-8");
        out.writeInt(data.length);
        out.write(data);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.path = new String(data, "UTF-8");
    }
}

