/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.IOException;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.DB2DBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.H2DBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.HSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.MSSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.MysqlDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.SybaseDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2ConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DefaultOracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.H2ConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MSSQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreSCSConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SybaseConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class CQJDBCWorkspaceDataContainer
extends JDBCWorkspaceDataContainer
implements Startable {
    public CQJDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, DataSourceProvider dsProvider, FileCleanerHolder fileCleanerHolder) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        super(wsConfig, repConfig, contextInit, valueStorageProvider, dsProvider, fileCleanerHolder);
    }

    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        DBInitializer dbInitializer = null;
        if (this.containerConfig.dbDialect.equals("ORACLE-OCI")) {
            LOG.warn((Object)"ORACLE-OCI dialect is experimental!");
            this.connFactory = new DefaultOracleConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new OracleDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("ORACLE")) {
            this.connFactory = new DefaultOracleConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new OracleDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.equals("PGSQL")) {
            this.connFactory = new PostgreConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new PgSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.equals("PGSQL-SCS")) {
            this.connFactory = new PostgreSCSConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new PgSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("MYSQL")) {
            if (this.containerConfig.dbDialect.startsWith("MYSQL-MyISAM")) {
                LOG.warn((Object)"MyISAM is not supported due to its lack of transaction support and integrity check, so use it only if you don't expect any support and performances in read accesses are more important than the consistency in your use-case. This dialect is only dedicated to the community.");
            }
            this.connFactory = new MySQLConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new MysqlDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("MSSQL")) {
            this.connFactory = new MSSQLConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new MSSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("DERBY")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer();
        } else if (this.containerConfig.dbDialect.startsWith("DB2")) {
            this.connFactory = new DB2ConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new DB2DBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("SYBASE")) {
            this.connFactory = new SybaseConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new SybaseDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("INGRES")) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new IngresSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("HSQLDB")) {
            this.connFactory = new HSQLDBConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new HSQLDBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else if (this.containerConfig.dbDialect.startsWith("H2")) {
            this.connFactory = new H2ConnectionFactory(this.getDataSource(), this.containerConfig);
            dbInitializer = new H2DBInitializer(this.connFactory.getJdbcConnection(), this.containerConfig);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer();
        }
        this.validateBatchingUpdate();
        try {
            dbInitializer.init();
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateBatchingUpdate() {
        con = null;
        if (this.containerConfig.batchSize <= 1) return;
        if (CQJDBCWorkspaceDataContainer.LOG.isDebugEnabled()) {
            CQJDBCWorkspaceDataContainer.LOG.debug((Object)("Batching update is enabled with batch size " + this.containerConfig.batchSize));
        }
        try {
            block14: {
                if (!this.containerConfig.dbDialect.startsWith("SYBASE")) break block14;
                this.containerConfig.batchSize = -1;
                CQJDBCWorkspaceDataContainer.LOG.info((Object)"Batching update is disabled on Sybase DB.");
                var4_2 = null;
                if (con == null) return;
                ** GOTO lbl55
            }
            con = this.getConnectionFactory().getJdbcConnection();
            if (!con.getMetaData().supportsBatchUpdates()) {
                this.containerConfig.batchSize = -1;
                CQJDBCWorkspaceDataContainer.LOG.info((Object)"Batching update is disabled since DB does not support it.");
            }
            ** GOTO lbl62
        }
        catch (SQLException e) {
            CQJDBCWorkspaceDataContainer.LOG.error((Object)"Error checking batching update support.", (Throwable)e);
            var4_4 = null;
            if (con == null) return;
            try {
                con.close();
                return;
            }
            catch (SQLException e) {
                if (CQJDBCWorkspaceDataContainer.LOG.isTraceEnabled() == false) return;
                CQJDBCWorkspaceDataContainer.LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                return;
            }
        }
        catch (RepositoryException e) {
            CQJDBCWorkspaceDataContainer.LOG.error((Object)"Error checking batching update support.", (Throwable)e);
            var4_5 = null;
            if (con == null) return;
            try {}
            catch (SQLException e) {
                if (CQJDBCWorkspaceDataContainer.LOG.isTraceEnabled() == false) return;
                CQJDBCWorkspaceDataContainer.LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                return;
            }
            con.close();
            return;
        }
        {
            catch (Throwable var3_14) {
                var4_6 = null;
                if (con == null) throw var3_14;
                ** try [egrp 2[TRYBLOCK] [9 : 188->197)] { 
lbl49:
                // 1 sources

                con.close();
                throw var3_14;
lbl51:
                // 1 sources

                catch (SQLException e) {
                    if (CQJDBCWorkspaceDataContainer.LOG.isTraceEnabled() == false) throw var3_14;
                    CQJDBCWorkspaceDataContainer.LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                throw var3_14;
            }
lbl55:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 188->197)] { 
lbl56:
            // 1 sources

            con.close();
            return;
lbl58:
            // 1 sources

            catch (SQLException e) {
                if (CQJDBCWorkspaceDataContainer.LOG.isTraceEnabled() == false) return;
                CQJDBCWorkspaceDataContainer.LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return;
lbl62:
            // 1 sources

            var4_3 = null;
            if (con == null) return;
            try {}
            catch (SQLException e) {}
            if (CQJDBCWorkspaceDataContainer.LOG.isTraceEnabled() == false) return;
            CQJDBCWorkspaceDataContainer.LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            return;
            con.close();
            return;
        }
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        return new GenericCQConnectionFactory(this.getDataSource(), this.containerConfig);
    }
}

