/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

public class DB2MultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public DB2MultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P" + " join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from " + this.JCR_ITEM + " I" + " where I.I_CLASS=1 AND I.ID > ? order by I.ID FETCH FIRST $rowNb ROWS ONLY) J on P.PARENT_ID = J.ID" + " where P.I_CLASS=2 and V.PROPERTY_ID=P.ID  order by J.ID";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_LAST_ORDER_NUMBER = "SELECT " + this.JCR_ITEM_NEXT_VAL + " ('" + this.JCR_ITEM_SEQ + "', ?, ?) FROM SYSIBM.SYSDUMMY1";
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P " + " join (select J.* from " + this.JCR_ITEM + " J where J.I_CLASS=1 and J.PARENT_ID=?" + "  AND J.N_ORDER_NUM  >= ? order by J.N_ORDER_NUM, J.ID  FETCH FIRST $rowNb ROWS ONLY) I on P.PARENT_ID = I.ID" + " where P.I_CLASS=2 and P.PARENT_ID=I.ID and" + " (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or" + " P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')" + " and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        }
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.FIND_NODES_AND_PROPERTIES = this.FIND_NODES_AND_PROPERTIES.replace("$rowNb", Integer.toString(limit));
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, this.getInternalId(lastNodeId));
        return this.findNodesAndProperties.executeQuery();
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replace("$rowNb", Integer.toString(limit));
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(2, fromOrderNum);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    protected void startTxIfNeeded() throws SQLException {
        if (this.containerConfig.isManaged && this.dbConnection.getAutoCommit()) {
            this.dbConnection.setAutoCommit(false);
        }
    }
}

