/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.lifecycle;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.InitParamsValue;

public class LifeCycleCompletionService {
    private final String THREAD_NUMBER_KEY = "thread-number";
    private final String ASYNC_EXECUTION_KEY = "async-execution";
    private final String PRIORITY_KEY = "thread-priority";
    private final String KEEP_ALIVE_TIME = "keepAliveTime";
    private Executor executor;
    private ExecutorCompletionService<?> ecs;
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final int DEFAULT_THREAD_NUMBER = 1;
    private final boolean DEFAULT_ASYNC_EXECUTION = true;
    private final int DEFAULT_KEEP_ALIVE_TIME = 10;
    private final int DEFAULT_THREAD_PRIORITY = 10;
    private final boolean configAsyncExecution;

    public LifeCycleCompletionService(InitParams params) {
        int configThreadNumber = InitParamsValue.getInteger(params, "thread-number", 1);
        int keepAliveTime = InitParamsValue.getInteger(params, "keepAliveTime", 10);
        final int threadPriority = InitParamsValue.getInteger(params, "thread-priority", 10);
        this.configAsyncExecution = InitParamsValue.getBoolean(params, "async-execution", true);
        int threadNumber_ = configThreadNumber <= 0 ? configThreadNumber : Runtime.getRuntime().availableProcessors();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Forum-Thread");
                t.setPriority(threadPriority);
                return t;
            }
        };
        if (this.configAsyncExecution) {
            this.executor = new ThreadPoolExecutor(threadNumber_, threadNumber_, (long)keepAliveTime, TimeUnit.SECONDS, this.workQueue, threadFactory);
            ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
        } else {
            this.executor = new DirectExecutor();
        }
        this.ecs = new ExecutorCompletionService(this.executor);
    }

    public void addTask(Callable callable) {
        this.ecs.submit(callable);
    }

    public void waitCompletionFinished() {
        try {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shutdownNow() {
        Future<?> f;
        boolean isDone = true;
        while (this.ecs != null && (f = this.ecs.poll()) != null) {
            isDone &= f.cancel(true);
        }
        return isDone;
    }

    public boolean isAsync() {
        return this.configAsyncExecution;
    }

    private class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            if (Thread.interrupted()) {
                throw new RuntimeException();
            }
            runnable.run();
        }
    }
}

