/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.impl.UserImpl;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.impl.api.SimpleAttribute;

public class DisableUserUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)DisableUserUpgradePlugin.class.getName());
    private OrganizationService service;
    private int threadNum = 20;
    private int batchSize = 100;
    public static final String THREAD_CONFIG = "numberOfThreads";
    public static final String BATCH_CONFIG = "batchSize";
    private static final String VERSION = "4.3";

    public DisableUserUpgradePlugin(OrganizationService service, InitParams initParams) {
        super(initParams);
        if (initParams.containsKey((Object)THREAD_CONFIG)) {
            int tn = this.threadNum;
            try {
                tn = Integer.parseInt(initParams.getValueParam(THREAD_CONFIG).getValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (tn > 0) {
                this.threadNum = tn;
            }
        }
        if (initParams.containsKey((Object)BATCH_CONFIG)) {
            int b = this.threadNum;
            try {
                b = Integer.parseInt(initParams.getValueParam(BATCH_CONFIG).getValue());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (b > 0) {
                this.batchSize = b;
            }
        }
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info("Start {} .............", new Object[]{((Object)((Object)this)).getClass().getName()});
        if (this.service instanceof PicketLinkIDMOrganizationServiceImpl) {
            final PicketLinkIDMOrganizationServiceImpl impl = (PicketLinkIDMOrganizationServiceImpl)this.service;
            if (!impl.getConfiguration().isDisableUserActived()) {
                LOG.info((Object)"Ignore upgrade user due to disable-user feature is not activated");
                return;
            }
            UserHandler handler = this.service.getUserHandler();
            ListAccess users = null;
            int size = 0;
            try {
                RequestLifeCycle.begin((ComponentRequestLifecycle)impl);
                users = handler.findAllUsers(UserStatus.ANY);
                size = users.getSize();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            finally {
                RequestLifeCycle.end();
            }
            this.batchSize = this.batchSize > size ? size : this.batchSize;
            int tSize = size / this.threadNum;
            tSize = tSize > 0 ? tSize : size;
            final int odd = tSize == size ? 0 : size % this.threadNum;
            LOG.info("start upgrading {} users by {} threads, batchSize: {}", new Object[]{size, this.threadNum, this.batchSize});
            ExecutorService execService = Executors.newFixedThreadPool(this.threadNum);
            final AtomicLong count = new AtomicLong();
            LinkedList<Future<Boolean>> results = new LinkedList<Future<Boolean>>();
            final ExoContainer container = ExoContainerContext.getCurrentContainer();
            final PicketLinkIDMService idmService = (PicketLinkIDMService)container.getComponentInstanceOfType(PicketLinkIDMService.class);
            final int threadSize = tSize;
            final ListAccess usrs = users;
            final int totalSize = size;
            int i = 0;
            while (i < this.threadNum) {
                final int n = i++;
                results.add(execService.submit(new Callable<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean call() throws Exception {
                        int start = n * threadSize;
                        int end = start + threadSize;
                        if (n == DisableUserUpgradePlugin.this.threadNum - 1) {
                            end += odd;
                        }
                        ExoContainerContext.setCurrentContainer((ExoContainer)container);
                        int startBatch = start;
                        int endBatch = startBatch + DisableUserUpgradePlugin.this.batchSize;
                        int n2 = endBatch = endBatch > end ? end : endBatch;
                        while (endBatch <= totalSize && endBatch <= end && startBatch < endBatch) {
                            LOG.info("{} start: {}, end: {}", new Object[]{Thread.currentThread(), startBatch, endBatch});
                            RequestLifeCycle.begin((ComponentRequestLifecycle)impl);
                            IdentitySession session = idmService.getIdentitySession();
                            User[] tmp = (User[])usrs.load(startBatch, endBatch - startBatch);
                            try {
                                for (User u : tmp) {
                                    DisableUserUpgradePlugin.this.enableUser(u, session);
                                }
                                count.addAndGet(endBatch - startBatch);
                                startBatch = endBatch;
                                endBatch = startBatch + DisableUserUpgradePlugin.this.batchSize;
                                endBatch = endBatch > end ? end : endBatch;
                                LOG.info("{} finished successfully!", new Object[]{Thread.currentThread()});
                            }
                            catch (Exception e) {
                                LOG.error((Object)"An unexpected error occurs when migrating pages:", (Throwable)e);
                                Boolean bl = false;
                                return bl;
                            }
                            finally {
                                RequestLifeCycle.end();
                            }
                        }
                        return true;
                    }
                }));
            }
            try {
                for (Future future : results) {
                    if (((Boolean)future.get()).booleanValue()) continue;
                    LOG.error((Object)"Disable user migration completed with errors");
                }
                LOG.info("Finish upgrading {} users", new Object[]{count.get()});
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        } else {
            LOG.info((Object)"Ignore upgrade user due to not using PicketLinkIDMOrganizationServiceImpl");
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)VERSION);
    }

    private void enableUser(User u, IdentitySession session) {
        if (u instanceof UserImpl) {
            ((UserImpl)u).setEnabled(Boolean.valueOf(true));
            Attribute[] attrs = new Attribute[]{new SimpleAttribute("enabled", (Object)String.valueOf(true))};
            AttributesManager am = session.getAttributesManager();
            try {
                am.updateAttributes(u.getUserName(), attrs);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }
}

