/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.QueryBuilder;
import org.exoplatform.services.database.ReflectionMapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DAO<T extends DBObject> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.database.DAO");
    protected ExoDatasource eXoDS_;
    protected DBObjectMapper<T> mapper_;
    static int totalQueryTime = 0;
    static int totalBathTime = 0;
    static int totalCloseConnect = 0;

    public DAO(ExoDatasource datasource) {
        this.eXoDS_ = datasource;
        this.mapper_ = new ReflectionMapper();
    }

    public DAO(ExoDatasource datasource, DBObjectMapper<T> mapper) {
        this.eXoDS_ = datasource;
        this.mapper_ = mapper;
    }

    public ExoDatasource getExoDatasource() {
        return this.eXoDS_;
    }

    public abstract T load(long var1) throws Exception;

    public abstract PageList loadAll() throws Exception;

    public abstract void update(T var1) throws Exception;

    public abstract void update(List<T> var1) throws Exception;

    public abstract void save(T var1) throws Exception;

    public abstract void save(List<T> var1) throws Exception;

    public abstract void remove(T var1) throws Exception;

    public abstract T remove(long var1) throws Exception;

    public abstract T createInstance() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T loadUnique(String query) throws Exception {
        Connection connection = this.eXoDS_.getConnection();
        try {
            T t = this.loadUnique(connection, query);
            return t;
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T loadUnique(Connection connection, String query) throws Exception {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            if (!resultSet.next()) {
                T t = null;
                return t;
            }
            T bean = this.createInstance();
            this.mapper_.mapResultSet(resultSet, bean);
            resultSet.close();
            T t = bean;
            return t;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstances(String loadQuery, List<T> list) throws Exception {
        Connection connection = this.eXoDS_.getConnection();
        try {
            this.loadInstances(connection, loadQuery, list);
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInstances(Connection connection, String loadQuery, List<T> list) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(loadQuery);
            while (resultSet.next()) {
                T bean = this.createInstance();
                this.mapper_.mapResultSet(resultSet, bean);
                list.add(bean);
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    LOG.debug((Object)"Could not close the result set");
                }
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not close the statement");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String query, T bean) throws Exception {
        Connection connection = this.eXoDS_.getConnection();
        try {
            this.execute(connection, query, bean);
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    protected void execute(Connection connection, String query, T bean) throws Exception {
        PreparedStatement statement = connection.prepareStatement(query);
        if (bean != null) {
            this.mapper_.mapUpdate(bean, statement);
        }
        statement.executeUpdate();
        this.eXoDS_.commit(connection);
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E loadDBField(String query) throws Exception {
        Connection connection = this.eXoDS_.getConnection();
        try {
            E e = this.loadDBField(connection, query);
            return e;
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    protected <E> E loadDBField(Connection connection, String query) throws Exception {
        Statement statement = connection.createStatement();
        long startGet = System.currentTimeMillis();
        ResultSet resultSet = statement.executeQuery(query);
        totalQueryTime = (int)((long)totalQueryTime + (System.currentTimeMillis() - startGet));
        if (!resultSet.next()) {
            return null;
        }
        Object value = resultSet.getObject(1);
        resultSet.close();
        statement.close();
        return (E)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(String template, List<T> beans) throws Exception {
        Connection connection = this.eXoDS_.getConnection();
        try {
            this.execute(connection, template, beans);
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    protected void execute(Connection connection, String template, List<T> beans) throws Exception {
        PreparedStatement statement = connection.prepareStatement(template);
        QueryBuilder builder = this.eXoDS_.getQueryBuilder();
        for (DBObject bean : beans) {
            String query = builder.mapDataToSql(template, this.mapper_.toParameters(bean));
            statement.addBatch(query);
            LOG.info((Object)(" addBatch " + query));
        }
        statement.executeBatch();
        statement.close();
        this.eXoDS_.commit(connection);
    }

    public DBObjectMapper<T> getDBObjectMapper() {
        return this.mapper_;
    }
}

