/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.tokens;

import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectUtilities;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.semantics.InterpretationType;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

public abstract class Token {
    protected final FrozenSlice slice;
    protected final TokenType type;
    protected final LaTeXMode latexMode;
    protected final Interpretation interpretation;

    protected Token(FrozenSlice slice, TokenType type, LaTeXMode latexMode) {
        this(slice, type, latexMode, null);
    }

    protected Token(FrozenSlice slice, TokenType type, LaTeXMode latexMode, Interpretation interpretation) {
        this.slice = slice;
        this.type = type;
        this.latexMode = latexMode;
        this.interpretation = interpretation;
    }

    @ObjectDumperOptions(value=DumpMode.TO_STRING)
    public FrozenSlice getSlice() {
        return this.slice;
    }

    public TokenType getType() {
        return this.type;
    }

    public LaTeXMode getLatexMode() {
        return this.latexMode;
    }

    public Interpretation getInterpretation() {
        return this.interpretation;
    }

    public InterpretationType getInterpretationType() {
        return this.interpretation != null ? this.interpretation.getType() : null;
    }

    public boolean isInterpretationType(InterpretationType ... types) {
        if (this.interpretation == null) {
            return false;
        }
        InterpretationType interpretationType = this.interpretation.getType();
        for (InterpretationType testType : types) {
            if (testType != interpretationType) continue;
            return true;
        }
        return false;
    }

    public boolean isCommand(BuiltinCommand command) {
        return this instanceof CommandToken && ((CommandToken)this).getCommand() == command;
    }

    public String toString() {
        return ObjectUtilities.beanToString(this);
    }
}

