/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;

@Path(value="social/notifications")
public class NotificationsRestService
implements ResourceContainer {
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private static String ACTIVITY_ID_PREFIX = "activity";

    @GET
    @Path(value="inviteToConnect/{receiverId}/{senderId}")
    public Response inviteToConnect(@Context UriInfo uriInfo, @PathParam(value="receiverId") String receiverId, @PathParam(value="senderId") String senderId) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        Identity sender = this.getIdentityManager().getOrCreateIdentity("organization", senderId != null ? senderId : ConversationState.getCurrent().getIdentity().getUserId(), true);
        Identity receiver = this.getIdentityManager().getOrCreateIdentity("organization", receiverId, true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.getRelationshipManager().inviteToConnect(sender, receiver);
        String targetURL = Util.getBaseUrl() + LinkProvider.getUserProfileUri((String)receiver.getRemoteId());
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="confirmInvitationToConnect/{senderId}/{receiverId}")
    public Response confirmInvitationToConnect(@PathParam(value="senderId") String senderId, @PathParam(value="receiverId") String receiverId) throws Exception {
        Identity sender = this.getIdentityManager().getOrCreateIdentity("organization", senderId, true);
        Identity receiver = this.getIdentityManager().getOrCreateIdentity("organization", receiverId, true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isAcceptedUser(sender, receiver)) {
            this.getRelationshipManager().confirm(sender, receiver);
        }
        String targetURL = Util.getBaseUrl() + LinkProvider.getUserActivityUri((String)sender.getRemoteId());
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="ignoreInvitationToConnect/{senderId}/{receiverId}")
    public Response ignoreInvitationToConnect(@PathParam(value="senderId") String senderId, @PathParam(value="receiverId") String receiverId) throws Exception {
        Identity sender = this.getIdentityManager().getOrCreateIdentity("organization", senderId, true);
        Identity receiver = this.getIdentityManager().getOrCreateIdentity("organization", receiverId, true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isAcceptedUser(sender, receiver)) {
            this.getRelationshipManager().deny(sender, receiver);
        }
        String targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)("connexions/receivedInvitations/" + receiver.getRemoteId() + "?feedbackMessage=ConnectionRequestRefuse&userName=" + sender.getRemoteId()));
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="acceptInvitationToJoinSpace/{spaceId}/{userId}")
    public Response acceptInvitationToJoinSpace(@PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId) throws Exception {
        Space space = this.getSpaceService().getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isAcceptedUser(userId, space.getInvitedUsers())) {
            this.getSpaceService().addMember(space, userId);
        }
        String targetURL = Util.getBaseUrl() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="ignoreInvitationToJoinSpace/{spaceId}/{userId}")
    public Response ignoreInvitationToJoinSpace(@PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId) throws Exception {
        Space space = this.getSpaceService().getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String targetURL = Util.getBaseUrl();
        if (this.isAcceptedUser(userId, space.getInvitedUsers())) {
            if (this.getSpaceService().isMember(space, userId)) {
                targetURL = targetURL + LinkProvider.getRedirectUri((String)("all-spaces?feedbackMessage=SpaceInvitationAlreadyMember&spaceId=" + spaceId));
            } else {
                this.getSpaceService().removeInvitedUser(space, userId);
                targetURL = targetURL + LinkProvider.getRedirectUri((String)("all-spaces?feedbackMessage=SpaceInvitationRefuse&spaceId=" + spaceId));
            }
        }
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="validateRequestToJoinSpace/{spaceId}/{userId}")
    public Response validateRequestToJoinSpace(@PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        Space space = this.getSpaceService().getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.getSpaceService().isManager(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        StringBuilder sb = new StringBuilder().append("?feedbackMessage=");
        if (this.getSpaceService().isMember(space, userId)) {
            sb.append("SpaceRequestAlreadyMember&spaceId=").append(spaceId);
        } else {
            sb.append("SpaceRequestApprove");
        }
        sb.append("&userName=").append(userId);
        this.getSpaceService().addMember(space, userId);
        String targetURL = Util.getBaseUrl() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")) + "/settings/members" + sb.toString();
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    @GET
    @Path(value="refuseRequestToJoinSpace/{spaceId}/{userId}")
    public Response refuseRequestToJoinSpace(@PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        Space space = this.getSpaceService().getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.getSpaceService().isManager(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String baseUrl = Util.getBaseUrl();
        String spaceHomeUrl = LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
        StringBuilder targetURL = new StringBuilder().append(baseUrl).append(spaceHomeUrl).append("/settings/members?feedbackMessage=");
        if (this.getSpaceService().isMember(space, userId)) {
            targetURL.append("SpaceRequestAlreadyMember&spaceId=").append(spaceId).append("&userName=").append(userId);
        } else {
            this.getSpaceService().removePendingUser(space, userId);
            targetURL.append("SpaceRequestRefuse&userName=").append(userId);
        }
        return Response.seeOther((URI)URI.create(targetURL.toString())).build();
    }

    @GET
    @Path(value="redirectUrl/{type}/{objectId}")
    public Response redirectUrl(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="objectId") String objectId) throws Exception {
        Space space = null;
        Identity userIdentity = null;
        String targetURL = null;
        HttpServletRequest currentServletRequest = Util.getCurrentServletRequest();
        boolean hasLoggedIn = currentServletRequest.getRemoteUser() != null;
        String redirectLink = null;
        if (!hasLoggedIn) {
            redirectLink = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "/redirect/" + type + "/" + objectId));
        }
        try {
            RestChecker.checkAuthenticatedRequest();
            URL_TYPE urlType = URL_TYPE.valueOf(type);
            switch (urlType) {
                case view_full_activity: {
                    targetURL = hasLoggedIn ? Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "?id=" + objectId)) : redirectLink;
                    break;
                }
                case view_full_activity_highlight_comment: {
                    String activityId = objectId.split("-")[0];
                    String commentId = objectId.split("-")[1];
                    targetURL = hasLoggedIn ? Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "?id=" + activityId + "#comment-" + commentId)) : redirectLink;
                    break;
                }
                case view_likers_activity: {
                    targetURL = hasLoggedIn ? Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "?id=" + objectId + "&likes=1")) : redirectLink;
                    break;
                }
                case reply_activity: {
                    targetURL = hasLoggedIn ? Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "?id=" + objectId + "&comment=1")) : redirectLink;
                    break;
                }
                case reply_activity_highlight_comment: {
                    String activityId = objectId.split("-")[0];
                    String commentId = objectId.split("-")[1];
                    targetURL = hasLoggedIn ? Util.getBaseUrl() + LinkProvider.getRedirectUri((String)(ACTIVITY_ID_PREFIX + "?id=" + activityId + "#comment-" + commentId + "&comment=1")) : redirectLink;
                    break;
                }
                case user: {
                    userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", objectId, true);
                    targetURL = Util.getBaseUrl() + LinkProvider.getUserProfileUri((String)userIdentity.getRemoteId());
                    break;
                }
                case user_activity_stream: {
                    userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", objectId, true);
                    targetURL = Util.getBaseUrl() + LinkProvider.getUserActivityUri((String)userIdentity.getRemoteId());
                    break;
                }
                case space: {
                    space = this.getSpaceService().getSpaceById(objectId);
                    targetURL = Util.getBaseUrl() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", ""));
                    break;
                }
                case space_members: {
                    space = this.getSpaceService().getSpaceById(objectId);
                    targetURL = Util.getBaseUrl() + LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")) + "/settings/members";
                    break;
                }
                case portal_home: {
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)"");
                    break;
                }
                case all_space: {
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)"all-spaces");
                    break;
                }
                case connections: {
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)"connexions");
                    break;
                }
                case connections_request: {
                    userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", objectId, true);
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)("connexions/receivedInvitations/" + userIdentity.getRemoteId()));
                    break;
                }
                case space_invitation: {
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)"invitationSpace");
                    break;
                }
                case notification_settings: {
                    userIdentity = this.getIdentityManager().getOrCreateIdentity("organization", objectId, true);
                    targetURL = Util.getBaseUrl() + LinkProvider.getUserNotificationSettingUri((String)userIdentity.getRemoteId());
                    break;
                }
                default: {
                    targetURL = Util.getBaseUrl() + LinkProvider.getRedirectUri((String)"");
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        return Response.seeOther((URI)URI.create(targetURL)).build();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getPortalContainer().getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)this.getPortalContainer().getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.getPortalContainer().getComponentInstanceOfType(ActivityManager.class);
        }
        return this.activityManager;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)this.getPortalContainer().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private ExoContainer getPortalContainer() {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        if (exoContainer == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return exoContainer;
    }

    private boolean isAcceptedUser(String userId, String ... invitedUsers) {
        if (userId == null) {
            return false;
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        List<String> invitedUserList = Arrays.asList(invitedUsers);
        return userId.equals(authenticatedUser) && invitedUserList.contains(authenticatedUser);
    }

    private boolean isAcceptedUser(Identity sender, Identity receiver) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        return receiver.getRemoteId().equals(authenticatedUser) && Relationship.Type.PENDING.equals((Object)this.getRelationshipManager().getStatus(sender, receiver));
    }

    public static enum URL_TYPE {
        user,
        space,
        space_members,
        reply_activity,
        reply_activity_highlight_comment,
        view_full_activity,
        view_full_activity_highlight_comment,
        view_likers_activity,
        portal_home,
        all_space,
        connections,
        notification_settings,
        connections_request,
        space_invitation,
        user_activity_stream;

    }
}

