/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.Query;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.api.ChromatticSessionImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceListEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceRef;
import org.exoplatform.social.core.chromattic.entity.SpaceRootEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.core.storage.api.ActivityStreamStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;
import org.exoplatform.social.core.storage.streams.StreamInvocationHelper;

public class SpaceStorageImpl
extends AbstractStorage
implements SpaceStorage {
    private static final Log LOG = ExoLogger.getLogger(SpaceStorageImpl.class);
    private final IdentityStorageImpl identityStorage;
    private final ActivityStreamStorage streamStorage;
    private static final int TWO_SECONDS = 2000;

    public SpaceStorageImpl(IdentityStorageImpl identityStorage, ActivityStreamStorage streamStorage) {
        this.identityStorage = identityStorage;
        this.streamStorage = streamStorage;
    }

    private void fillSpaceFromEntity(SpaceEntity entity, Space space) {
        space.setApp(entity.getApp());
        space.setId(entity.getId());
        space.setDisplayName(entity.getDisplayName());
        space.setPrettyName(entity.getPrettyName());
        space.setRegistration(entity.getRegistration());
        space.setDescription(entity.getDescription());
        space.setType(entity.getType());
        space.setVisibility(entity.getVisibility());
        space.setPriority(entity.getPriority());
        space.setGroupId(entity.getGroupId());
        space.setUrl(entity.getURL());
        space.setPendingUsers(entity.getPendingMembersId());
        space.setInvitedUsers(entity.getInvitedMembersId());
        space.setCreatedTime(entity.getCreatedTime());
        String[] members = entity.getMembersId();
        String[] managers = entity.getManagerMembersId();
        HashSet<String> membersList = new HashSet<String>();
        if (members != null) {
            membersList.addAll(Arrays.asList(members));
        }
        if (managers != null) {
            membersList.addAll(Arrays.asList(managers));
        }
        space.setMembers(membersList.toArray(new String[0]));
        space.setManagers(entity.getManagerMembersId());
        if (entity.getAvatarLastUpdated() != null) {
            try {
                PortalContainer container = PortalContainer.getInstance();
                ChromatticSession chromatticSession = this.getSession();
                String url = String.format("/%s/jcr/%s/%s/production/soc:providers/soc:space/soc:%s/soc:profile/soc:avatar/?upd=%d", container.getRestContextName(), this.lifeCycle.getRepositoryName(), chromatticSession.getJCRSession().getWorkspace().getName(), entity.getPrettyName(), entity.getAvatarLastUpdated());
                space.setAvatarUrl(LinkProvider.escapeJCRSpecialCharacters(url));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to build avatar url: " + e.getMessage()));
            }
        }
        space.setAvatarLastUpdated(entity.getAvatarLastUpdated());
    }

    private void fillSpaceSimpleFromEntity(SpaceEntity entity, Space space) {
        space.setId(entity.getId());
        space.setDisplayName(entity.getDisplayName());
        space.setPrettyName(entity.getPrettyName());
        space.setDescription(entity.getDescription());
        space.setGroupId(entity.getGroupId());
        space.setUrl(entity.getURL());
        space.setCreatedTime(entity.getCreatedTime());
        if (entity.getAvatarLastUpdated() != null) {
            try {
                PortalContainer container = PortalContainer.getInstance();
                ChromatticSession chromatticSession = this.getSession();
                String url = String.format("/%s/jcr/%s/%s/production/soc:providers/soc:space/soc:%s/soc:profile/soc:avatar/?upd=%d", container.getRestContextName(), this.lifeCycle.getRepositoryName(), chromatticSession.getJCRSession().getWorkspace().getName(), entity.getPrettyName(), entity.getAvatarLastUpdated());
                space.setAvatarUrl(LinkProvider.escapeJCRSpecialCharacters(url));
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to build avatar url: " + e.getMessage()));
            }
        }
        space.setAvatarLastUpdated(entity.getAvatarLastUpdated());
    }

    private void fillEntityFromSpace(Space space, SpaceEntity entity) {
        entity.setName(space.getPrettyName());
        entity.setApp(space.getApp());
        entity.setPrettyName(space.getPrettyName());
        entity.setDisplayName(space.getDisplayName());
        entity.setRegistration(space.getRegistration());
        entity.setDescription(space.getDescription());
        entity.setType(space.getType());
        entity.setVisibility(space.getVisibility());
        entity.setPriority(space.getPriority());
        entity.setGroupId(space.getGroupId());
        entity.setURL(space.getUrl());
        entity.setMembersId(space.getMembers());
        entity.setManagerMembersId(space.getManagers());
        entity.setPendingMembersId(space.getPendingUsers());
        entity.setInvitedMembersId(space.getInvitedUsers());
        entity.setAvatarLastUpdated(space.getAvatarLastUpdated());
        entity.setCreatedTime(space.getCreatedTime() != 0L ? space.getCreatedTime() : System.currentTimeMillis());
    }

    private void applyOrder(QueryBuilder builder, SpaceFilter spaceFilter) {
        Sorting sorting = spaceFilter == null ? new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC) : spaceFilter.getSorting();
        Ordering ordering = Ordering.valueOf((String)sorting.orderBy.toString());
        switch (sorting.sortBy) {
            case DATE: {
                builder.orderBy(SpaceEntity.createdTime.getName(), ordering);
                break;
            }
            case RELEVANCY: {
                builder.orderBy(JCRProperties.JCR_RELEVANCY.getName(), ordering);
            }
            case TITLE: {
                builder.orderBy(SpaceEntity.name.getName(), ordering);
            }
        }
    }

    private String[] sub(String[] l1, String[] l2) {
        if (l1 == null) {
            return new String[0];
        }
        if (l2 == null) {
            return l1;
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(l1));
        l.removeAll(Arrays.asList(l2));
        return l.toArray(new String[0]);
    }

    private void createRefs(SpaceEntity spaceEntity, Space space) throws NodeNotFoundException {
        String[] removedMembers = this.sub(spaceEntity.getMembersId(), space.getMembers());
        String[] removedManagers = this.sub(spaceEntity.getManagerMembersId(), space.getManagers());
        String[] removedInvited = this.sub(spaceEntity.getInvitedMembersId(), space.getInvitedUsers());
        String[] removedPending = this.sub(spaceEntity.getPendingMembersId(), space.getPendingUsers());
        String[] addedMembers = this.sub(space.getMembers(), spaceEntity.getMembersId());
        String[] addedManagers = this.sub(space.getManagers(), spaceEntity.getManagerMembersId());
        String[] addedInvited = this.sub(space.getInvitedUsers(), spaceEntity.getInvitedMembersId());
        String[] addedPending = this.sub(space.getPendingUsers(), spaceEntity.getPendingMembersId());
        this.manageRefList(new UpdateContext(addedMembers, removedMembers), spaceEntity, RefType.MEMBER);
        this.manageActivityRefList(new UpdateContext(addedMembers, removedMembers), spaceEntity, RefType.MEMBER);
        this.manageRefList(new UpdateContext(addedManagers, removedManagers), spaceEntity, RefType.MANAGER);
        this.manageRefList(new UpdateContext(addedInvited, removedInvited), spaceEntity, RefType.INVITED);
        this.manageRefList(new UpdateContext(addedPending, removedPending), spaceEntity, RefType.PENDING);
    }

    private void changeSpaceRef(SpaceEntity spaceEntity, Space space, RefType type) {
        String[] listUserNames = null;
        listUserNames = RefType.MEMBER.equals((Object)type) ? spaceEntity.getMembersId() : (RefType.MANAGER.equals((Object)type) ? spaceEntity.getManagerMembersId() : (RefType.INVITED.equals((Object)type) ? spaceEntity.getInvitedMembersId() : spaceEntity.getPendingMembersId()));
        if (listUserNames != null) {
            for (String userName : listUserNames) {
                try {
                    IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", userName);
                    SpaceListEntity listRef = type.refsOf(identityEntity);
                    SpaceRef ref = listRef.getRef(spaceEntity.getName());
                    ref.setName(space.getPrettyName());
                }
                catch (NodeNotFoundException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void changeSpaceRef(String remoteId, SpaceEntity spaceEntity, Space space, RefType type) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", remoteId);
            SpaceListEntity listRef = type.refsOf(identityEntity);
            SpaceRef ref = listRef.getRef(spaceEntity.getName());
            ref.setName(space.getPrettyName());
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void manageRefList(UpdateContext context, SpaceEntity spaceEntity, RefType type) {
        if (context.getAdded() != null) {
            SpaceRef ref;
            SpaceListEntity listRef;
            IdentityEntity identityEntity;
            for (String userName : context.getAdded()) {
                try {
                    identityEntity = this.identityStorage._findIdentityEntity("organization", userName);
                    listRef = type.refsOf(identityEntity);
                    ref = listRef.getRef(spaceEntity.getName());
                    if (!ref.getName().equals(spaceEntity.getName())) {
                        ref.setName(spaceEntity.getName());
                    }
                    ref.setSpaceRef(spaceEntity);
                }
                catch (NodeNotFoundException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (String userName : context.getRemoved()) {
                try {
                    identityEntity = this.identityStorage._findIdentityEntity("organization", userName);
                    listRef = type.refsOf(identityEntity);
                    ref = listRef.getRef(spaceEntity.getName());
                    this.getSession().remove((Object)ref);
                }
                catch (NodeNotFoundException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void manageActivityRefList(UpdateContext context, SpaceEntity spaceEntity, RefType type) {
        Identity identity;
        Identity spaceIdentity = this.identityStorage.findIdentity("space", spaceEntity.getPrettyName());
        if (context.getAdded() != null) {
            for (String userName : context.getAdded()) {
                identity = this.identityStorage.findIdentity("organization", userName);
                StreamInvocationHelper.addSpaceMember(identity, spaceIdentity);
            }
        }
        if (context.getRemoved() != null) {
            for (String userName : context.getRemoved()) {
                identity = this.identityStorage.findIdentity("organization", userName);
                StreamInvocationHelper.removeSpaceMember(identity, spaceIdentity);
            }
        }
    }

    private boolean validateFilter(SpaceFilter filter) {
        if (filter == null) {
            return false;
        }
        if (filter.getSpaceNameSearchCondition() != null && filter.getSpaceNameSearchCondition().length() != 0) {
            return this.isValidInput(filter.getSpaceNameSearchCondition());
        }
        return !Character.isDigit(filter.getFirstCharacterOfSpaceName());
    }

    private SpaceEntity createSpace(Space space) throws SpaceStorageException {
        SpaceRootEntity spaceRootEntity = this.getSpaceRoot();
        SpaceEntity spaceEntity = spaceRootEntity.getSpace(space.getPrettyName());
        space.setId(spaceEntity.getId());
        return spaceEntity;
    }

    private SpaceEntity _saveSpace(Space space) throws NodeNotFoundException {
        return this._findById(SpaceEntity.class, space.getId());
    }

    private void _applyFilter(WhereExpression whereExpression, SpaceFilter spaceFilter) {
        String spaceNameSearchCondition = spaceFilter.getSpaceNameSearchCondition();
        char firstCharacterOfName = spaceFilter.getFirstCharacterOfSpaceName();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            if (this.isValidInput(spaceNameSearchCondition)) {
                spaceNameSearchCondition = "%" + spaceNameSearchCondition.replace("*", "%").toLowerCase() + "%";
                whereExpression.startGroup();
                whereExpression.like(whereExpression.callFunction(QueryFunction.LOWER, SpaceEntity.name), spaceNameSearchCondition).or().like(whereExpression.callFunction(QueryFunction.LOWER, SpaceEntity.displayName), spaceNameSearchCondition).or().like(whereExpression.callFunction(QueryFunction.LOWER, SpaceEntity.description), StringEscapeUtils.escapeHtml((String)spaceNameSearchCondition));
                whereExpression.endGroup();
                List<Space> exclusions = spaceFilter.getExclusions();
                if (exclusions != null) {
                    for (Space space : exclusions) {
                        whereExpression.and().not().equals(SpaceEntity.name, space.getPrettyName());
                    }
                }
            }
        } else if (!Character.isDigit(firstCharacterOfName)) {
            String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
            String firstCharacterOfNameLowerCase = firstCharacterOfNameString.toLowerCase() + "%";
            whereExpression.like(whereExpression.callFunction(QueryFunction.LOWER, SpaceEntity.name), firstCharacterOfNameLowerCase);
        }
    }

    private boolean isValidInput(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        String cleanString = input.replaceAll("\\*", "");
        return (cleanString = cleanString.replaceAll("\\%", "")).length() != 0;
    }

    private List<String> processUnifiedSearchCondition(String searchCondition) {
        String[] spaceConditions = searchCondition.split(" ");
        ArrayList<String> result = new ArrayList<String>(spaceConditions.length);
        for (String conditionValue : spaceConditions) {
            result.add(conditionValue.toString());
        }
        return result;
    }

    private Query<SpaceEntity> _getSpacesByFilterQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
        }
        if (userId != null && this.validateFilter(spaceFilter)) {
            whereExpression.and().equals(SpaceEntity.membersId, userId);
        } else if (userId != null && !this.validateFilter(spaceFilter)) {
            whereExpression.equals(SpaceEntity.membersId, userId);
        }
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getAllSpacesQuery(SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
            whereExpression.startGroup();
        }
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getAccessibleSpacesByFilterQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
            if (spaceFilter.getAppId() != null) {
                whereExpression.contains(SpaceEntity.app, spaceFilter.getAppId());
                whereExpression.and();
            }
            whereExpression.startGroup();
        } else if (spaceFilter != null && spaceFilter.getAppId() != null) {
            whereExpression.contains(SpaceEntity.app, spaceFilter.getAppId());
            whereExpression.and();
            whereExpression.startGroup();
        }
        whereExpression.equals(SpaceEntity.membersId, userId).or().equals(SpaceEntity.managerMembersId, userId);
        whereExpression.endAllGroup();
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getPublicSpacesQuery(String userId) {
        return this.getPublicSpacesQuery(userId, null);
    }

    private Query<SpaceEntity> getPublicSpacesQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
        }
        builder.where(whereExpression.not().equals(SpaceEntity.membersId, userId).and().not().equals(SpaceEntity.managerMembersId, userId).and().not().equals(SpaceEntity.invitedMembersId, userId).and().not().equals(SpaceEntity.pendingMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getPublicSpacesOfMemberQuery(String userId) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        builder.where(whereExpression.equals(SpaceEntity.membersId, userId).and().equals(SpaceEntity.visibility, "public").and().not().equals(SpaceEntity.managerMembersId, userId).and().not().equals(SpaceEntity.invitedMembersId, userId).and().not().equals(SpaceEntity.pendingMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        builder.orderBy(SpaceEntity.name.getName(), Ordering.ASC);
        return builder.get();
    }

    private Query<SpaceEntity> getSpacesOfMemberQuery(String userId) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        builder.where(whereExpression.equals(SpaceEntity.membersId, userId).and().not().equals(SpaceEntity.visibility, "hidden").and().not().equals(SpaceEntity.invitedMembersId, userId).and().not().equals(SpaceEntity.pendingMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        builder.orderBy(SpaceEntity.name.getName(), Ordering.ASC);
        return builder.get();
    }

    private Query<SpaceEntity> getPendingSpacesFilterQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
        }
        builder.where(whereExpression.equals(SpaceEntity.pendingMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getInvitedSpacesFilterQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
        }
        builder.where(whereExpression.equals(SpaceEntity.invitedMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getEditableSpacesFilterQuery(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
        }
        builder.where(whereExpression.equals(SpaceEntity.managerMembersId, userId).toString());
        if (whereExpression.toString().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private Query<SpaceEntity> getSpacesByFilterQuery(SpaceFilter spaceFilter) {
        return this._getSpacesByFilterQuery(null, spaceFilter);
    }

    @Override
    public Space getSpaceByDisplayName(String spaceDisplayName) throws SpaceStorageException {
        Space space = null;
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.equals(SpaceEntity.displayName, spaceDisplayName);
        QueryResult result = builder.where(whereExpression.toString()).get().objects();
        if (result.hasNext()) {
            space = new Space();
            this.fillSpaceFromEntity((SpaceEntity)result.next(), space);
        }
        return space;
    }

    @Override
    public void saveSpace(Space space, boolean isNew) throws SpaceStorageException {
        try {
            SpaceEntity entity = isNew ? this.createSpace(space) : this._saveSpace(space);
            this.createRefs(entity, space);
            this.fillEntityFromSpace(space, entity);
            if (!isNew) {
                this.getSession().save();
            }
            LOG.debug((Object)String.format("Space %s (%s) saved", space.getPrettyName(), space.getId()));
        }
        catch (NodeNotFoundException e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_SAVE_SPACE, e.getMessage(), e);
        }
    }

    @Override
    public void renameSpace(Space space, String newDisplayName) {
        this.renameSpace(null, space, newDisplayName);
    }

    @Override
    public void renameSpace(String remoteId, Space space, String newDisplayName) {
        try {
            String oldPrettyName = space.getPrettyName();
            space.setDisplayName(newDisplayName);
            space.setPrettyName(space.getDisplayName());
            space.setUrl(SpaceUtils.cleanString(newDisplayName));
            SpaceEntity entity = this._saveSpace(space);
            this.changeSpaceRef(entity, space, RefType.MEMBER);
            this.changeSpaceRef(entity, space, RefType.MANAGER);
            this.changeSpaceRef(entity, space, RefType.INVITED);
            this.changeSpaceRef(entity, space, RefType.PENDING);
            if (remoteId != null) {
                this.changeSpaceRef(remoteId, entity, space, RefType.MEMBER);
            }
            this.fillEntityFromSpace(space, entity);
            this.getSession().save();
            Identity identitySpace = this.identityStorage.findIdentity("space", oldPrettyName);
            if (identitySpace != null) {
                Profile profileSpace = identitySpace.getProfile();
                profileSpace.setProperty("firstName", space.getDisplayName());
                profileSpace.setProperty("username", space.getPrettyName());
                profileSpace.setProperty("Url", space.getUrl());
                this.identityStorage.saveProfile(profileSpace);
                identitySpace.setRemoteId(space.getPrettyName());
                this.renameIdentity(identitySpace);
            }
            LOG.debug((Object)String.format("Space %s (%s) saved", space.getPrettyName(), space.getId()));
        }
        catch (NodeNotFoundException e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_RENAME_SPACE, e.getMessage(), e);
        }
    }

    private void renameIdentity(Identity identity) throws NodeNotFoundException {
        ProviderEntity providerEntity = this.getProviderRoot().getProvider(identity.getProviderId());
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
        providerEntity.getIdentities().put(identity.getRemoteId(), identityEntity);
        identityEntity.setRemoteId(identity.getRemoteId());
    }

    @Override
    public void deleteSpace(String id) throws SpaceStorageException {
        String name;
        try {
            name = this._findById(SpaceEntity.class, id).getPrettyName();
        }
        catch (NodeNotFoundException e) {
            throw new SpaceStorageException(SpaceStorageException.Type.FAILED_TO_DELETE_SPACE, e.getMessage());
        }
        this._removeById(SpaceEntity.class, id);
        this.getSession().save();
        LOG.debug((Object)String.format("Space %s removed", name));
    }

    @Override
    public int getMemberSpacesCount(String userId) throws SpaceStorageException {
        try {
            return this.identityStorage._findIdentityEntity("organization", userId).getSpaces().getRefs().size();
        }
        catch (NodeNotFoundException e) {
            return 0;
        }
    }

    @Override
    public int getMemberSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this._getSpacesByFilterQuery(userId, spaceFilter).objects().size();
    }

    @Override
    public List<Space> getMemberSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getSpacesByFilterQuery(userId, null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getMemberSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getSpacesByFilterQuery(userId, null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getMemberSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getSpacesByFilterQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getPendingSpacesCount(String userId) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", userId);
            Collection<SpaceRef> spaceEntities = identityEntity.getPendingSpaces().getRefs().values();
            return spaceEntities.size();
        }
        catch (NodeNotFoundException e) {
            return 0;
        }
    }

    @Override
    public int getPendingSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getPendingSpacesFilterQuery(userId, spaceFilter).objects().size();
    }

    @Override
    public List<Space> getPendingSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPendingSpacesFilterQuery(userId, null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getPendingSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPendingSpacesFilterQuery(userId, null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getPendingSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPendingSpacesFilterQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getInvitedSpacesCount(String userId) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", userId);
            Collection<SpaceRef> spaceEntities = identityEntity.getInvitedSpaces().getRefs().values();
            return spaceEntities.size();
        }
        catch (NodeNotFoundException e) {
            return 0;
        }
    }

    @Override
    public int getInvitedSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        if (this.validateFilter(spaceFilter)) {
            return this.getInvitedSpacesFilterQuery(userId, spaceFilter).objects().size();
        }
        return 0;
    }

    @Override
    public List<Space> getInvitedSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getInvitedSpacesFilterQuery(userId, null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getInvitedSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getInvitedSpacesFilterQuery(userId, null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getInvitedSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getInvitedSpacesFilterQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getPublicSpacesCount(String userId) throws SpaceStorageException {
        return this.getPublicSpacesQuery(userId).objects().size();
    }

    @Override
    public int getPublicSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        if (this.validateFilter(spaceFilter)) {
            return this.getPublicSpacesQuery(userId, spaceFilter).objects().size();
        }
        return 0;
    }

    @Override
    public List<Space> getPublicSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        try {
            this.identityStorage._findIdentityEntity("organization", userId);
        }
        catch (NodeNotFoundException e) {
            userId = null;
        }
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPublicSpacesQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getPublicSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPublicSpacesQuery(userId).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getPublicSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getPublicSpacesQuery(userId).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getAccessibleSpacesCount(String userId) throws SpaceStorageException {
        return this.getAccessibleSpacesByFilterQuery(userId, null).objects().size();
    }

    @Override
    public int getAccessibleSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getAccessibleSpacesByFilterQuery(userId, spaceFilter).objects().size();
    }

    @Override
    public int getLastAccessedSpaceCount(SpaceFilter filter) {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", filter.getRemoteId());
            SpaceListEntity listRef = RefType.MEMBER.refsOf(identityEntity);
            Map<String, SpaceRef> mapRefs = listRef.getRefs();
            int counter = 0;
            for (Map.Entry<String, SpaceRef> entry : mapRefs.entrySet()) {
                SpaceRef ref = entry.getValue();
                if (ref.getSpaceRef() == null) {
                    listRef.removeRef(entry.getKey());
                    continue;
                }
                if (filter.getAppId() == null) {
                    ++counter;
                    continue;
                }
                if (ref.getSpaceRef().getApp().toLowerCase().indexOf(filter.getAppId().toLowerCase()) <= 0) continue;
                ++counter;
            }
            return counter;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getAccessibleSpacesByFilterQuery(userId, null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getVisibleSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this._getVisibleSpaces(userId, spaceFilter).objects().size();
    }

    @Override
    public int getUnifiedSearchSpacesCount(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        return this._getUnifiedSearchSpaces(userId, spaceFilter).objects().size();
    }

    @Override
    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getVisibleSpaces(userId, spaceFilter).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getVisibleSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getVisibleSpaces(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getUnifiedSearchSpaces(String userId, SpaceFilter spaceFilter, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this._getUnifiedSearchSpaces(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    private Query<SpaceEntity> _getUnifiedSearchSpaces(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        this._applyUnifiedSearchFilter(whereExpression, spaceFilter);
        if (whereExpression.toString().trim().length() > 0) {
            builder.where(whereExpression.toString());
        }
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    private void _applyUnifiedSearchFilter(WhereExpression whereExpression, SpaceFilter spaceFilter) {
        if (spaceFilter == null) {
            return;
        }
        String spaceNameSearchCondition = StorageUtils.escapeSpecialCharacter(spaceFilter.getSpaceNameSearchCondition());
        char firstCharacterOfName = spaceFilter.getFirstCharacterOfSpaceName();
        if (spaceNameSearchCondition != null && spaceNameSearchCondition.length() != 0) {
            List<String> unifiedSearchConditions = this.processUnifiedSearchCondition(spaceNameSearchCondition);
            if (unifiedSearchConditions.size() > 0) {
                whereExpression.startGroup();
            }
            boolean first = true;
            for (String condition : unifiedSearchConditions) {
                if (!first) {
                    whereExpression.and();
                }
                whereExpression.startGroup();
                whereExpression.contains(SpaceEntity.name, condition.toLowerCase()).or().contains(SpaceEntity.displayName, condition.toLowerCase()).or().contains(SpaceEntity.description, StringEscapeUtils.escapeHtml((String)condition).toLowerCase());
                whereExpression.endGroup();
                first = false;
            }
            if (unifiedSearchConditions.size() > 0) {
                whereExpression.endGroup();
            }
        } else if (!Character.isDigit(firstCharacterOfName)) {
            String firstCharacterOfNameString = Character.toString(firstCharacterOfName);
            String firstCharacterOfNameLowerCase = firstCharacterOfNameString.toLowerCase() + "%";
            whereExpression.like(whereExpression.callFunction(QueryFunction.LOWER, SpaceEntity.name), firstCharacterOfNameLowerCase);
        }
    }

    private Query<SpaceEntity> _getVisibleSpaces(String userId, SpaceFilter spaceFilter) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        if (this.validateFilter(spaceFilter)) {
            this._applyFilter(whereExpression, spaceFilter);
            whereExpression.and();
            whereExpression.startGroup();
        }
        whereExpression.startGroup();
        whereExpression.like(SpaceEntity.visibility, "private");
        whereExpression.endGroup();
        whereExpression.or();
        whereExpression.startGroup();
        whereExpression.equals(SpaceEntity.membersId, userId).or().equals(SpaceEntity.managerMembersId, userId).or().equals(SpaceEntity.invitedMembersId, userId);
        whereExpression.endGroup();
        whereExpression.endAllGroup();
        builder.where(whereExpression.toString());
        this.applyOrder(builder, spaceFilter);
        return builder.get();
    }

    @Override
    public List<Space> getAccessibleSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getAccessibleSpacesByFilterQuery(userId, null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getAccessibleSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getAccessibleSpacesByFilterQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getEditableSpacesCount(String userId) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", userId);
            return identityEntity.getManagerSpaces().getRefs().size();
        }
        catch (NodeNotFoundException e) {
            return 0;
        }
    }

    @Override
    public int getEditableSpacesByFilterCount(String userId, SpaceFilter spaceFilter) {
        return this.getEditableSpacesFilterQuery(userId, spaceFilter).objects().size();
    }

    @Override
    public List<Space> getEditableSpaces(String userId) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getEditableSpacesFilterQuery(userId, null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getEditableSpaces(String userId, long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getEditableSpacesFilterQuery(userId, null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getEditableSpacesByFilter(String userId, SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getEditableSpacesFilterQuery(userId, spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getAllSpacesCount() throws SpaceStorageException {
        return this.getSpaceRoot().getSpaces().size();
    }

    @Override
    public List<Space> getAllSpaces() throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getSpacesByFilterQuery(null).objects();
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public int getAllSpacesByFilterCount(SpaceFilter spaceFilter) {
        if (this.validateFilter(spaceFilter)) {
            return this.getSpacesByFilterQuery(spaceFilter).objects().size();
        }
        return 0;
    }

    @Override
    public List<Space> getSpaces(long offset, long limit) throws SpaceStorageException {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getSpacesByFilterQuery(null).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public List<Space> getSpacesByFilter(SpaceFilter spaceFilter, long offset, long limit) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        QueryResult results = this.getSpacesByFilterQuery(spaceFilter).objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            SpaceEntity currentSpace = (SpaceEntity)results.next();
            Space space = new Space();
            this.fillSpaceFromEntity(currentSpace, space);
            spaces.add(space);
        }
        return spaces;
    }

    @Override
    public Space getSpaceById(String id) throws SpaceStorageException {
        try {
            SpaceEntity spaceEntity = this._findById(SpaceEntity.class, id);
            Space space = new Space();
            this.fillSpaceFromEntity(spaceEntity, space);
            return space;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public Space getSpaceSimpleById(String id) throws SpaceStorageException {
        try {
            SpaceEntity spaceEntity = this._findById(SpaceEntity.class, id);
            Space space = new Space();
            this.fillSpaceSimpleFromEntity(spaceEntity, space);
            return space;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public Space getSpaceByPrettyName(String spacePrettyName) throws SpaceStorageException {
        try {
            SpaceEntity entity = this._findByPath(SpaceEntity.class, String.format("/production/soc:spaces/soc:%s", spacePrettyName));
            Space space = new Space();
            this.fillSpaceFromEntity(entity, space);
            return space;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public Space getSpaceByGroupId(String groupId) throws SpaceStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        builder.where(whereExpression.equals(SpaceEntity.groupId, groupId).toString());
        QueryResult result = builder.get().objects();
        if (result.hasNext()) {
            SpaceEntity entity = (SpaceEntity)result.next();
            Space space = new Space();
            this.fillSpaceFromEntity(entity, space);
            return space;
        }
        return null;
    }

    @Override
    public Space getSpaceByUrl(String url) throws SpaceStorageException {
        QueryResult result;
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        if (url != null) {
            WhereExpression whereExpression = new WhereExpression();
            whereExpression.equals(SpaceEntity.url, url);
            builder.where(whereExpression.toString());
        }
        if ((result = builder.get().objects()).hasNext()) {
            Space space = new Space();
            SpaceEntity entity = (SpaceEntity)builder.get().objects().next();
            this.fillSpaceFromEntity(entity, space);
            return space;
        }
        return null;
    }

    @Override
    public void updateSpaceAccessed(String remoteId, Space space) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", remoteId);
            SpaceListEntity listRef = RefType.MEMBER.refsOf(identityEntity);
            SpaceEntity spaceEntity = this._findById(SpaceEntity.class, space.getId());
            SpaceRef ref = listRef.getRef(spaceEntity.getName());
            if (!ref.getName().equals(spaceEntity.getName())) {
                ref.setName(spaceEntity.getName());
            }
            ref.setSpaceRef(spaceEntity);
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<Space> getLastAccessedSpace(SpaceFilter filter, int offset, int limit) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", filter.getRemoteId());
            SpaceListEntity listRef = RefType.MEMBER.refsOf(identityEntity);
            Map<String, SpaceRef> mapRefs = listRef.getRefs();
            ChromatticSessionImpl chromatticSession = (ChromatticSessionImpl)this.getSession();
            Map<SpaceRef, Long> spaceRefs = new LinkedHashMap();
            Space space = null;
            for (Map.Entry<String, SpaceRef> entry : mapRefs.entrySet()) {
                long lastModifedDate;
                SpaceRef ref = entry.getValue();
                Node node = chromatticSession.getNode((Object)ref);
                Property p = this.getProperty(node, JCRProperties.JCR_LAST_MODIFIED_DATE.getName());
                long l = lastModifedDate = p == null ? 0L : p.getDate().getTimeInMillis();
                if (ref.getSpaceRef() == null) {
                    listRef.removeRef(entry.getKey());
                    continue;
                }
                if (filter.getAppId() == null) {
                    spaceRefs.put(ref, lastModifedDate);
                    continue;
                }
                if (ref.getSpaceRef().getApp().toLowerCase().indexOf(filter.getAppId().toLowerCase()) <= 0) continue;
                spaceRefs.put(ref, lastModifedDate);
            }
            spaceRefs = StorageUtils.sortMapByValue(spaceRefs, false);
            LinkedList<Space> got = new LinkedList<Space>();
            Iterator it1 = spaceRefs.keySet().iterator();
            this._skip(it1, offset);
            int numberOfSpace = 0;
            while (it1.hasNext()) {
                space = new Space();
                this.fillSpaceSimpleFromEntity(((SpaceRef)it1.next()).getSpaceRef(), space);
                got.add(space);
                if (++numberOfSpace != limit) continue;
            }
            return got;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)"Get last accessed spaces failure.", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)"Get last accessed spaces failure.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Space> getLastSpaces(int limit) {
        QueryBuilder builder = this.getSession().createQueryBuilder(SpaceEntity.class);
        Ordering ordering = Ordering.valueOf((String)Sorting.OrderBy.DESC.toString());
        builder.orderBy(SpaceEntity.createdTime.getName(), ordering);
        QueryResult result = builder.get().objects(Long.valueOf(0L), Long.valueOf(limit));
        LinkedList<Space> got = new LinkedList<Space>();
        while (result.hasNext()) {
            SpaceEntity entity = (SpaceEntity)result.next();
            Space space = new Space();
            this.fillSpaceFromEntity(entity, space);
            got.add(space);
        }
        return got;
    }

    @Override
    public int getNumberOfMemberPublicSpaces(String userId) {
        return this.getSpacesOfMemberQuery(userId).objects().size();
    }

    @Override
    public List<Space> getVisitedSpaces(SpaceFilter filter, int offset, int limit) throws SpaceStorageException {
        try {
            IdentityEntity identityEntity = this.identityStorage._findIdentityEntity("organization", filter.getRemoteId());
            SpaceListEntity listRef = RefType.MEMBER.refsOf(identityEntity);
            Map<String, SpaceRef> mapRefs = listRef.getRefs();
            Map<SpaceRef, Long> visitedSpaceRefs = new LinkedHashMap<SpaceRef, Long>();
            LinkedList<SpaceRef> neverVisitedSpaceRefs = new LinkedList<SpaceRef>();
            visitedSpaceRefs = this.getSpaceRefs(mapRefs, visitedSpaceRefs, neverVisitedSpaceRefs, filter.getAppId());
            Iterator<SpaceRef> spaceRefs = visitedSpaceRefs.keySet().iterator();
            if (offset < visitedSpaceRefs.size()) {
                this._skip(spaceRefs, offset);
                offset = 0;
            } else {
                this._skip(spaceRefs, offset);
                offset -= visitedSpaceRefs.size();
            }
            LinkedList<Space> got = new LinkedList<Space>();
            this.getSpacesFromSpaceRefs(spaceRefs, got, limit);
            int remain = limit - got.size();
            if (neverVisitedSpaceRefs.isEmpty() || remain == 0) {
                return got;
            }
            spaceRefs = neverVisitedSpaceRefs.iterator();
            this._skip(spaceRefs, offset);
            List<Space> neverVisitedSpaces = new LinkedList<Space>();
            this.getSpacesFromSpaceRefs(spaceRefs, neverVisitedSpaces, -1);
            neverVisitedSpaces = StorageUtils.sortSpaceByName(neverVisitedSpaces, true);
            got.addAll(neverVisitedSpaces.subList(0, Math.min(remain, neverVisitedSpaces.size())));
            return got;
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Map<SpaceRef, Long> getSpaceRefs(Map<String, SpaceRef> spaceRefs, Map<SpaceRef, Long> visitedSpaceRefs, List<SpaceRef> neverVisitedSpaceRefs, String appId) throws RepositoryException {
        ChromatticSessionImpl chromatticSession = (ChromatticSessionImpl)this.getSession();
        for (Map.Entry<String, SpaceRef> entry : spaceRefs.entrySet()) {
            SpaceRef ref = entry.getValue();
            Node node = chromatticSession.getNode((Object)ref);
            Property p1 = this.getProperty(node, JCRProperties.JCR_LAST_CREATED_DATE.getName());
            Property p2 = this.getProperty(node, JCRProperties.JCR_LAST_MODIFIED_DATE.getName());
            long createdTime = p1 == null ? 0L : p1.getDate().getTimeInMillis();
            long lastModifedDate = p2 == null ? 0L : p2.getDate().getTimeInMillis();
            boolean isValid = false;
            if (appId == null) {
                isValid = true;
            } else if (ref.getSpaceRef().getApp().toLowerCase().indexOf(appId.toLowerCase()) > 0) {
                isValid = true;
            }
            if (lastModifedDate - createdTime < 2000L && isValid) {
                neverVisitedSpaceRefs.add(ref);
                continue;
            }
            if (!isValid) continue;
            visitedSpaceRefs.put(ref, lastModifedDate);
        }
        return StorageUtils.sortMapByValue(visitedSpaceRefs, false);
    }

    private void getSpacesFromSpaceRefs(Iterator<SpaceRef> it, List<Space> list, int limit) {
        Space space = null;
        int numberOfSpace = 0;
        while (it.hasNext()) {
            space = new Space();
            this.fillSpaceFromEntity(it.next().getSpaceRef(), space);
            list.add(space);
            if (++numberOfSpace != limit) continue;
            break;
        }
    }

    private Property getProperty(Node node, String propertyName) {
        try {
            return node.getProperty(propertyName);
        }
        catch (RepositoryException e) {
            LOG.error((Object)String.format("Get property %s failed", propertyName));
            return null;
        }
    }

    @Override
    public List<String> getMemberSpaceIds(String identityId, int offset, int limit) throws SpaceStorageException {
        ArrayList<String> identitiesId = new ArrayList<String>();
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identityId);
            Set<String> spaceNames = identityEntity.getSpaces().getRefs().keySet();
            ProviderEntity providerEntity = this.getProviderRoot().getProvider("space");
            for (String spacePrettyName : spaceNames) {
                IdentityEntity spaceIdentity = providerEntity.getIdentities().get(spacePrettyName);
                if (spaceIdentity == null) continue;
                identitiesId.add(spaceIdentity.getId());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get list of space identity of current user");
        }
        return identitiesId;
    }

    private class UpdateContext {
        private String[] added;
        private String[] removed;

        private UpdateContext(String[] added, String[] removed) {
            this.added = added;
            this.removed = removed;
        }

        public String[] getAdded() {
            return this.added;
        }

        public String[] getRemoved() {
            return this.removed;
        }
    }

    public static enum RefType {
        MEMBER{

            @Override
            public SpaceListEntity refsOf(IdentityEntity identityEntity) {
                return identityEntity.getSpaces();
            }

            @Override
            public String[] idsOf(Space space) {
                return space.getMembers();
            }

            @Override
            public void setIds(Space space, String[] ids) {
                space.setMembers(ids);
            }
        }
        ,
        MANAGER{

            @Override
            public SpaceListEntity refsOf(IdentityEntity identityEntity) {
                return identityEntity.getManagerSpaces();
            }

            @Override
            public String[] idsOf(Space space) {
                return space.getManagers();
            }

            @Override
            public void setIds(Space space, String[] ids) {
                space.setManagers(ids);
            }
        }
        ,
        PENDING{

            @Override
            public SpaceListEntity refsOf(IdentityEntity identityEntity) {
                return identityEntity.getPendingSpaces();
            }

            @Override
            public String[] idsOf(Space space) {
                return space.getPendingUsers();
            }

            @Override
            public void setIds(Space space, String[] ids) {
                space.setPendingUsers(ids);
            }
        }
        ,
        INVITED{

            @Override
            public SpaceListEntity refsOf(IdentityEntity identityEntity) {
                return identityEntity.getInvitedSpaces();
            }

            @Override
            public String[] idsOf(Space space) {
                return space.getInvitedUsers();
            }

            @Override
            public void setIds(Space space, String[] ids) {
                space.setInvitedUsers(ids);
            }
        };


        public abstract SpaceListEntity refsOf(IdentityEntity var1);

        public abstract String[] idsOf(Space var1);

        public abstract void setIds(Space var1, String[] var2);
    }
}

