/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class CustomRejectionPolicy
implements RejectedExecutionHandler {
    public static final String NAME = "custom";
    private RejectedExecutionHandler custom;

    public CustomRejectionPolicy(String rejection_policy) {
        if (!rejection_policy.toLowerCase().startsWith("custom=")) {
            throw new IllegalStateException(rejection_policy);
        }
        String className = rejection_policy.substring(7);
        try {
            Class<?> policyClass = Class.forName(className);
            Object policy = policyClass.newInstance();
            if (!(policy instanceof RejectedExecutionHandler)) {
                throw new IllegalArgumentException(className + " does not implement RejectedExecutionHandler");
            }
            this.custom = (RejectedExecutionHandler)policy;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot instantiate rejection policy '" + rejection_policy + "'", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate rejection policy '" + rejection_policy + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate rejection policy '" + rejection_policy + "'", e);
        }
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.custom.rejectedExecution(r, executor);
    }
}

