/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RenamePrototypes
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean aggressiveRenaming;
    private final char[] reservedCharacters;
    private final VariableMap prevUsedRenameMap;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property a1, Property a2) {
            int n2;
            int n1 = a1.count();
            if (n1 != (n2 = a2.count())) {
                return n2 - n1;
            }
            return a1.oldName.compareTo(a2.oldName);
        }
    };
    private final Set<Node> stringNodes = new HashSet<Node>();
    private final Map<String, Property> properties = new HashMap<String, Property>();
    private final Set<String> reservedNames = new HashSet<String>(Arrays.asList("indexOf", "lastIndexOf", "toString", "valueOf"));
    private final Set<Node> prototypeObjLits = new HashSet<Node>();

    RenamePrototypes(AbstractCompiler compiler, boolean aggressiveRenaming, @Nullable char[] reservedCharacters, @Nullable VariableMap prevUsedRenameMap) {
        this.compiler = compiler;
        this.aggressiveRenaming = aggressiveRenaming;
        this.reservedCharacters = reservedCharacters;
        this.prevUsedRenameMap = prevUsedRenameMap;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, externs, new ProcessExternedProperties());
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        TreeSet<Property> propsByFrequency = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        Iterator<Map.Entry<String, Property>> it = this.properties.entrySet().iterator();
        while (it.hasNext()) {
            Property a = it.next().getValue();
            if (a.canRename() && !this.reservedNames.contains(a.oldName)) {
                propsByFrequency.add(a);
                continue;
            }
            it.remove();
            this.reservedNames.add(a.oldName);
        }
        if (this.prevUsedRenameMap != null) {
            this.reusePrototypeNames(propsByFrequency);
        }
        NameGenerator nameGen = new NameGenerator(this.reservedNames, "", this.reservedCharacters);
        StringBuilder debug = new StringBuilder();
        for (Property a : propsByFrequency) {
            if (a.newName == null) {
                a.newName = nameGen.generateNextName();
                this.reservedNames.add(a.newName);
            }
            debug.append(a.oldName).append(" => ").append(a.newName).append('\n');
        }
        this.compiler.addToDebugLog("JS property assignments:\n" + debug);
        boolean changed = false;
        for (Node n : this.stringNodes) {
            String oldName = n.getString();
            Property a = this.properties.get(oldName);
            if (a == null || a.newName == null) continue;
            n.setString(a.newName);
            changed = changed || !a.newName.equals(oldName);
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED_OBFUSCATED);
    }

    private void reusePrototypeNames(Set<Property> properties) {
        for (Property prop : properties) {
            String prevName = this.prevUsedRenameMap.lookupNewName(prop.oldName);
            if (prevName == null || this.reservedNames.contains(prevName)) continue;
            prop.newName = prevName;
            this.reservedNames.add(prevName);
        }
    }

    VariableMap getPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Property p : this.properties.values()) {
            if (p.newName == null) continue;
            map.put(p.oldName, p.newName);
        }
        return new VariableMap(map);
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString()) break;
                    String s = dest.getString();
                    if (s.equals("prototype")) {
                        this.processPrototypeParent(parent, t.getInput());
                        break;
                    }
                    this.markPropertyAccessCandidate(dest, t.getInput());
                    break;
                }
                case 64: {
                    if (RenamePrototypes.this.prototypeObjLits.contains(n)) break;
                    for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                        if (!TokenStream.isJSIdentifier(child.getString())) continue;
                        this.markObjLitPropertyCandidate(child, t.getInput());
                    }
                    break;
                }
            }
        }

        private void processPrototypeParent(Node n, CompilerInput input) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString()) break;
                    this.markPrototypePropertyCandidate(dest, input);
                    break;
                }
                case 37: 
                case 86: {
                    Node map = n.isAssign() ? n.getFirstChild().getNext() : n.getLastChild();
                    if (!map.isObjectLit()) break;
                    RenamePrototypes.this.prototypeObjLits.add(map);
                    for (Node key = map.getFirstChild(); key != null; key = key.getNext()) {
                        if (!TokenStream.isJSIdentifier(key.getString())) continue;
                        this.markPrototypePropertyCandidate(key, input);
                    }
                    break;
                }
            }
        }

        private void markPrototypePropertyCandidate(Node n, CompilerInput input) {
            RenamePrototypes.this.stringNodes.add(n);
            ++this.getProperty((String)n.getString()).prototypeCount;
        }

        private void markObjLitPropertyCandidate(Node n, CompilerInput input) {
            RenamePrototypes.this.stringNodes.add(n);
            ++this.getProperty((String)n.getString()).objLitCount;
        }

        private void markPropertyAccessCandidate(Node n, CompilerInput input) {
            RenamePrototypes.this.stringNodes.add(n);
            ++this.getProperty((String)n.getString()).refCount;
        }

        private Property getProperty(String name) {
            Property prop = (Property)RenamePrototypes.this.properties.get(name);
            if (prop == null) {
                prop = new Property(name);
                RenamePrototypes.this.properties.put(name, prop);
            }
            return prop;
        }
    }

    private class ProcessExternedProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternedProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString()) break;
                    RenamePrototypes.this.reservedNames.add(dest.getString());
                }
            }
        }
    }

    private class Property {
        String oldName;
        String newName;
        int prototypeCount;
        int objLitCount;
        int refCount;

        Property(String name) {
            this.oldName = name;
            this.newName = null;
            this.prototypeCount = 0;
            this.objLitCount = 0;
            this.refCount = 0;
        }

        int count() {
            return this.prototypeCount + this.objLitCount + this.refCount;
        }

        boolean canRename() {
            if (this.prototypeCount > 0 && this.objLitCount == 0) {
                return this.canRenamePrototypeProperty();
            }
            if (this.objLitCount > 0 && this.prototypeCount == 0) {
                return this.canRenameObjLitProperty();
            }
            return this.canRenamePrototypeProperty() && this.canRenameObjLitProperty();
        }

        private boolean canRenamePrototypeProperty() {
            if (RenamePrototypes.this.compiler.getCodingConvention().isExported(this.oldName)) {
                return false;
            }
            if (RenamePrototypes.this.compiler.getCodingConvention().isPrivate(this.oldName)) {
                return true;
            }
            if (RenamePrototypes.this.aggressiveRenaming) {
                return true;
            }
            int n = this.oldName.length();
            for (int i = 0; i < n; ++i) {
                char ch = this.oldName.charAt(i);
                if (!Character.isUpperCase(ch) && Character.isLetter(ch)) continue;
                return true;
            }
            return false;
        }

        private boolean canRenameObjLitProperty() {
            if (RenamePrototypes.this.compiler.getCodingConvention().isExported(this.oldName)) {
                return false;
            }
            return RenamePrototypes.this.compiler.getCodingConvention().isPrivate(this.oldName);
        }
    }
}

