/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.encoder;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.portal.installer.PBEUtils;
import org.picocontainer.Startable;

@Managed
@ManagedDescription(value="Encoder Service")
@NameTemplate(value={@Property(key="name", value="encoderService"), @Property(key="service", value="EncoderService")})
@RESTEndpoint(path="encoderService")
public class EncoderService
implements Startable {
    private static final String ENCODING_KEY_STORE_PASSWORD_DEFAULT = "somearbitrarycrazystringthatdoesnotmatter";
    private static final Logger log = LoggerFactory.getLogger(EncoderService.class);
    private final char[] keyStorePassword;
    private final byte[] salt;
    private final int iterationCount;
    private SecretKey cipherKey;
    private final String cipherAlgorithm;
    private PBEParameterSpec cipherSpec;

    public EncoderService(InitParams params) throws UnsupportedEncodingException {
        ValueParam keyStorePasswordParam = params.getValueParam("keyStorePassword");
        String keyStorePassword = keyStorePasswordParam != null ? keyStorePasswordParam.getValue() : ENCODING_KEY_STORE_PASSWORD_DEFAULT;
        this.keyStorePassword = keyStorePassword.toCharArray();
        this.cipherAlgorithm = this.getParam(params, "cipherAlgorithm");
        String saltParam = this.getParam(params, "salt");
        String iterationCountParam = this.getParam(params, "iterationCount");
        if (saltParam.length() < 8) {
            throw new IllegalArgumentException("Salt param needs to have length at least 8. Current value is " + saltParam);
        }
        this.salt = saltParam.substring(0, 8).getBytes("UTF-8");
        this.iterationCount = Integer.parseInt(iterationCountParam);
    }

    public void start() {
        try {
            this.cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            PBEKeySpec keySpec = new PBEKeySpec(this.keyStorePassword);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.cipherAlgorithm);
            this.cipherKey = factory.generateSecret(keySpec);
        }
        catch (Exception e) {
            log.error((Object)"Error starting EncoderService", (Throwable)e);
        }
    }

    public void stop() {
        if (this.keyStorePassword != null) {
            Arrays.fill(this.keyStorePassword, '\u0000');
        }
        this.cipherKey = null;
    }

    @Managed
    @ManagedDescription(value="Encode a secret as a base64 string using the cipher algorithm and the KeyStore password")
    @Impact(value=ImpactType.READ)
    public String encode64(@ManagedDescription(value="secret") @ManagedName(value="The secret in plain-text to be encoded") String secret) throws Exception {
        byte[] secretBytes = secret.getBytes("UTF-8");
        return PBEUtils.encode64(secretBytes, this.cipherAlgorithm, this.cipherKey, this.cipherSpec);
    }

    @Managed
    @ManagedDescription(value="Decode a base64 secret using the cipher algorithm and the KeyStore password")
    @Impact(value=ImpactType.READ)
    public String decode64(@ManagedDescription(value="secret") @ManagedName(value="The masked secret to be decoded") String secret) throws Exception {
        return PBEUtils.decode64(secret, this.cipherAlgorithm, this.cipherKey, this.cipherSpec);
    }

    private String getParam(InitParams params, String paramName) {
        ValueParam param = params.getValueParam(paramName);
        if (param == null) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' needs to be provided");
        }
        return param.getValue();
    }
}

