/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.addons.rdbms.listener;

import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class ForumActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(ForumActivityUpdaterListener.class);

    public ForumActivityUpdaterListener(ForumService forumService) {
    }

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String newActivityId = (String)event.getData();
        if ("ks-forum:spaces".equals(activity.getType())) {
            if (activity.isComment()) {
                Post post = ForumActivityUtils.getPost(activity);
                if (post != null) {
                    ForumActivityUtils.takeCommentBack(post, newActivityId);
                } else {
                    LOG.warn((Object)String.format("Failed to migration the forum post comment width old id %s - new id %s. Because, missing post's Id on template-parameters", activity.getId(), event.getData()));
                }
            } else {
                Topic topic = ForumActivityUtils.getTopic(activity);
                if (topic != null) {
                    ForumActivityUtils.takeActivityBack(topic, newActivityId);
                } else {
                    LOG.warn((Object)String.format("Failed to migration the forum topic activity width old id %s - new id %s. Because, missing post's Id on template-parameters", activity.getId(), event.getData()));
                }
            }
        }
    }
}

