/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ModifiedInputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int SPACE = 32;
    private static final int COLON = 58;
    private static final int SEMICOLON = 59;
    private static final int MINUS = 45;

    public static InputStream getIcsModifiedStream(InputStream in) throws IOException {
        int readChar;
        int prevChar = -1;
        int currentPos = 0;
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((readChar = bis.read()) > -1) {
            if (prevChar == 10 && readChar != 32 && !ModifiedInputStream.beginWithAProperty(bis, readChar, ++currentPos)) {
                baos.write(32);
            }
            baos.write(readChar);
            prevChar = readChar;
        }
        bis.close();
        in.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static boolean beginWithAProperty(BufferedInputStream bis, int readChar, int currentPos) throws IOException {
        if (!Character.isLetter((char)readChar)) {
            return false;
        }
        if (readChar >= 97) {
            return false;
        }
        String testString = ModifiedInputStream.getPseudoProperty(bis, readChar, currentPos);
        return ModifiedInputStream.isProperty(testString);
    }

    private static boolean isProperty(String str) throws IOException {
        char lastChar = str.charAt(str.length() - 1);
        return lastChar == ':' || lastChar == ';';
    }

    private static String getPseudoProperty(BufferedInputStream bis, int c, int currentPos) throws IOException {
        bis.mark(currentPos);
        StringBuilder sb = new StringBuilder(Character.toString((char)c));
        for (int count = 0; count < 20; ++count) {
            int tmpChar = bis.read();
            if (tmpChar == 13 || tmpChar == 10) break;
            if (tmpChar != 59 && tmpChar != 58) continue;
            sb.append((char)tmpChar);
            break;
        }
        bis.reset();
        return sb.toString();
    }
}

