/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.service;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.api.search.SearchService;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.search.service.SearchSetting;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;

@Path(value="/search")
@Produces(value={"application/json"})
public class UnifiedSearchService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(UnifiedSearchService.class);
    private static final CacheControl cacheControl;
    private static SearchSetting defaultSearchSetting;
    private static SearchSetting defaultQuicksearchSetting;
    private SearchService searchService;
    private UserPortalConfigService userPortalConfigService;
    private SettingService settingService;
    private Router router;

    public UnifiedSearchService(SearchService searchService, SettingService settingService, UserPortalConfigService userPortalConfigService, WebAppController webAppController) {
        this.searchService = searchService;
        this.settingService = settingService;
        this.userPortalConfigService = userPortalConfigService;
        try {
            File controllerXml = new File(webAppController.getConfigurationPath());
            URL url = controllerXml.toURI().toURL();
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(url.openStream());
            this.router = new Router(routerDesc);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @GET
    public Response REST_search(@Context UriInfo uriInfo, @QueryParam(value="q") String query, @QueryParam(value="sites") @DefaultValue(value="all") String sSites, @QueryParam(value="types") String sTypes, @QueryParam(value="offset") @DefaultValue(value="0") String sOffset, @QueryParam(value="limit") String sLimit, @QueryParam(value="sort") @DefaultValue(value="relevancy") String sort, @QueryParam(value="order") @DefaultValue(value="desc") String order) {
        try {
            List<String> types;
            MultivaluedMap queryParams = uriInfo.getQueryParameters();
            String siteName = (String)queryParams.getFirst((Object)"searchContext[siteName]");
            SearchContext context = new SearchContext(this.router, siteName);
            if (null == query || query.isEmpty()) {
                return Response.ok((Object)"", (String)"application/json").cacheControl(cacheControl).build();
            }
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            boolean isAnonymous = null == userId || userId.isEmpty() || userId.equals("__anonim");
            SearchSetting searchSetting = isAnonymous ? this.getAnonymSearchSetting() : this.getSearchSetting();
            List sites = Arrays.asList(sSites.split(",\\s*"));
            if (sites.contains("all")) {
                sites = this.userPortalConfigService.getAllPortalNames();
            }
            List<String> list = types = null == sTypes ? searchSetting.getSearchTypes() : Arrays.asList(sTypes.split(",\\s*"));
            if (isAnonymous && null != sTypes) {
                types = this.getAnonymSearchTypes(types);
            }
            int offset = Integer.parseInt(sOffset);
            int limit = null == sLimit || sLimit.isEmpty() ? (int)searchSetting.getResultsPerPage() : Integer.parseInt(sLimit);
            Map results = this.searchService.search(context, query, (Collection)sites, types, offset, limit, sort, order);
            String baseUri = uriInfo.getBaseUri().toString();
            baseUri = baseUri.substring(0, baseUri.lastIndexOf(new URL(baseUri).getPath()));
            for (Collection connectorResults : results.values()) {
                for (SearchResult result : connectorResults) {
                    String resultUrl = result.getUrl();
                    String previewUrl = result.getPreviewUrl();
                    String imageUrl = result.getImageUrl();
                    if (null != resultUrl && resultUrl.startsWith("/")) {
                        result.setUrl(baseUri + resultUrl);
                    }
                    if (null != previewUrl && previewUrl.startsWith("/")) {
                        result.setPreviewUrl(baseUri + previewUrl);
                    }
                    if (null == imageUrl || !imageUrl.startsWith("/")) continue;
                    result.setImageUrl(baseUri + imageUrl);
                }
            }
            return Response.ok((Object)results, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/registry")
    public Response REST_getRegistry() {
        LinkedHashMap<String, SearchServiceConnector> searchConnectors = new LinkedHashMap<String, SearchServiceConnector>();
        for (SearchServiceConnector connector : this.searchService.getConnectors()) {
            searchConnectors.put(connector.getSearchType(), connector);
        }
        return Response.ok(Arrays.asList(searchConnectors, UnifiedSearchService.getEnabledSearchTypes()), (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/sites")
    public Response REST_getSites() {
        try {
            return Response.ok((Object)this.userPortalConfigService.getAllPortalNames(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private SearchSetting getAnonymSearchSetting() {
        SearchSetting newSearchSetting = this.getSearchSetting();
        newSearchSetting.setSearchTypes(this.getAnonymSearchTypes(newSearchSetting.getSearchTypes()));
        return newSearchSetting;
    }

    private List<String> getAnonymSearchTypes(List<String> inputSearchTypes) {
        ArrayList<String> anonymSearchTypes = inputSearchTypes.contains("all") ? new ArrayList<String>(this.getEnabledSearchTypes()) : new ArrayList<String>(inputSearchTypes);
        anonymSearchTypes.remove("people");
        anonymSearchTypes.remove("space");
        return anonymSearchTypes;
    }

    private SearchSetting getSearchSetting() {
        SearchSetting newSearchSetting = defaultSearchSetting;
        try {
            Long resultsPerPage = (Long)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_resultsPerPage").getValue();
            newSearchSetting.setResultsPerPage(resultsPerPage);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchResult_resultsPerPage parameter for search settings. Use default one instead");
        }
        try {
            String searchTypes = (String)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_searchTypes").getValue();
            newSearchSetting.setSearchTypes(Arrays.asList(searchTypes.split(",\\s*")));
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchResult_searchTypes parameter for search settings. Use default one instead");
        }
        try {
            Boolean searchCurrentSiteOnly = (Boolean)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_searchCurrentSiteOnly").getValue();
            newSearchSetting.setSearchCurrentSiteOnly(searchCurrentSiteOnly);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchResult_searchCurrentSiteOnly parameter for search settings. Use default one instead");
        }
        try {
            Boolean hideSearchForm = (Boolean)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_hideSearchForm").getValue();
            newSearchSetting.setHideSearchForm(hideSearchForm);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchResult_hideSearchForm parameter for search settings. Use default one instead");
        }
        try {
            Boolean hideFacetsFilter = (Boolean)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_hideFacetsFilter").getValue();
            newSearchSetting.setHideFacetsFilter(hideFacetsFilter);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchResult_hideFacetsFilter parameter for search settings. Use default one instead");
        }
        return newSearchSetting;
    }

    @GET
    @Path(value="/setting")
    public Response REST_getSearchSetting() {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok((Object)(userId.equals("__anonim") ? this.getAnonymSearchSetting() : this.getSearchSetting()), (String)"application/json").cacheControl(cacheControl).build();
    }

    @POST
    @Path(value="/setting")
    public Response REST_setSearchSetting(@FormParam(value="resultsPerPage") long resultsPerPage, @FormParam(value="searchTypes") String searchTypes, @FormParam(value="searchCurrentSiteOnly") boolean searchCurrentSiteOnly, @FormParam(value="hideSearchForm") boolean hideSearchForm, @FormParam(value="hideFacetsFilter") boolean hideFacetsFilter) {
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_resultsPerPage", new SettingValue((Object)resultsPerPage));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_searchTypes", new SettingValue((Object)searchTypes));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_searchCurrentSiteOnly", new SettingValue((Object)searchCurrentSiteOnly));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_hideSearchForm", new SettingValue((Object)hideSearchForm));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchResult_hideFacetsFilter", new SettingValue((Object)hideFacetsFilter));
        return Response.ok((Object)"ok", (String)"application/json").cacheControl(cacheControl).build();
    }

    private SearchSetting getQuickSearchSetting() {
        SearchSetting newSearchSetting = defaultQuicksearchSetting;
        try {
            Long resultsPerPage = (Long)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "resultsPerPage").getValue();
            newSearchSetting.setResultsPerPage(resultsPerPage);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get resultsPerPage parameter for quick search settings. Use default one instead");
        }
        try {
            String searchTypes = (String)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchTypes").getValue();
            newSearchSetting.setSearchTypes(Arrays.asList(searchTypes.split(",\\s*")));
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchTypes parameter for quick search settings. Use default one instead");
        }
        try {
            Boolean searchCurrentSiteOnly = (Boolean)this.settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchCurrentSiteOnly").getValue();
            newSearchSetting.setSearchCurrentSiteOnly(searchCurrentSiteOnly);
        }
        catch (Exception e) {
            LOG.info((Object)"Cannot get searchCurrentSiteOnly parameter for quick search settings. Use default one instead");
        }
        return newSearchSetting;
    }

    @GET
    @Path(value="/setting/quicksearch")
    public Response REST_getQuicksearchSetting() {
        return Response.ok((Object)this.getQuickSearchSetting(), (String)"application/json").cacheControl(cacheControl).build();
    }

    @POST
    @Path(value="/setting/quicksearch")
    public Response REST_setQuicksearchSetting(@FormParam(value="resultsPerPage") long resultsPerPage, @FormParam(value="searchTypes") String searchTypes, @FormParam(value="searchCurrentSiteOnly") boolean searchCurrentSiteOnly) {
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "resultsPerPage", new SettingValue((Object)resultsPerPage));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchTypes", new SettingValue((Object)searchTypes));
        this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.WINDOWS, "searchCurrentSiteOnly", new SettingValue((Object)searchCurrentSiteOnly));
        return Response.ok((Object)"ok", (String)"application/json").cacheControl(cacheControl).build();
    }

    public static List<String> getEnabledSearchTypes() {
        SettingService settingService = (SettingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SettingService.class);
        SettingValue enabledSearchTypes = settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.APPLICATION, "enabledSearchTypes");
        if (null != enabledSearchTypes) {
            return Arrays.asList(((String)enabledSearchTypes.getValue()).split(",\\s*"));
        }
        SearchService searchService = (SearchService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SearchService.class);
        LinkedList<String> allSearchTypes = new LinkedList<String>();
        for (SearchServiceConnector connector : searchService.getConnectors()) {
            if (!connector.isEnable()) continue;
            allSearchTypes.add(connector.getSearchType());
        }
        return allSearchTypes;
    }

    @POST
    @Path(value="/enabled-searchtypes/{searchTypes}")
    public Response REST_setEnabledSearchtypes(@PathParam(value="searchTypes") String searchTypes) {
        UserACL userAcl = (UserACL)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserACL.class);
        if (ConversationState.getCurrent().getIdentity().isMemberOf(userAcl.getAdminGroups())) {
            this.settingService.set(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.APPLICATION, "enabledSearchTypes", new SettingValue((Object)searchTypes));
            return Response.ok((Object)"ok", (String)"application/json").cacheControl(cacheControl).build();
        }
        return Response.ok((Object)"nok: administrators only", (String)"application/json").cacheControl(cacheControl).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        defaultSearchSetting = new SearchSetting(10L, Arrays.asList("all"), false, false, false);
        defaultQuicksearchSetting = new SearchSetting(5L, Arrays.asList("all"), true, true, true);
    }
}

