/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.control.action.AddDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.control.action.EditDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.control.action.EditPropertyActionComponent;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIJCRExplorerPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger((String)UIJCRExplorerPortlet.class.getName());
    public static final String ISDIRECTLY_DRIVE = "isDirectlyDrive";
    public static final String DRIVE_NAME = "driveName";
    public static final String USECASE = "usecase";
    public static final String JAILED = "jailed";
    public static final String SELECTION = "selection";
    public static final String PERSONAL = "personal";
    public static final String PARAMETERIZE = "parameterize";
    public static final String PARAMETERIZE_PATH = "nodePath";
    public static final String SHOW_TOP_BAR = "showTopBar";
    public static final String SHOW_ACTION_BAR = "showActionBar";
    public static final String SHOW_SIDE_BAR = "showSideBar";
    public static final String SHOW_FILTER_BAR = "showFilterBar";
    private static final String DOC_NOT_FOUND = "doc-not-found";
    private String backTo = "";
    private boolean flagSelect = false;
    private Pattern driveParameteriedPathPattern = Pattern.compile(".*\\$\\{(.*)\\}.*");

    public UIJCRExplorerPortlet() throws Exception {
        if (Util.getPortalRequestContext().getRemoteUser() != null) {
            UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.addChild(UIJcrExplorerContainer.class, null, null);
            explorerContainer.initExplorer();
            ((UIJcrExplorerEditContainer)this.addChild(UIJcrExplorerEditContainer.class, null, null)).setRendered(false);
        }
    }

    public boolean isFlagSelect() {
        return this.flagSelect;
    }

    public void setFlagSelect(boolean flagSelect) {
        this.flagSelect = flagSelect;
    }

    public boolean isShowTopBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_TOP_BAR, "false"));
    }

    public boolean isShowActionBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_ACTION_BAR, "false")) != false && (!((UIJCRExplorer)this.findFirstComponentOfType(UIJCRExplorer.class)).isAddingDocument() || ((UIActionBar)((UIWorkingArea)this.findFirstComponentOfType(UIWorkingArea.class)).getChild(UIActionBar.class)).hasBackButton());
    }

    public boolean isShowSideBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_SIDE_BAR, "false"));
    }

    public boolean isShowFilterBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_FILTER_BAR, "false"));
    }

    public String getBacktoValue() {
        return this.backTo;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        UIJCRExplorer uiExplorer;
        HashMap changeDrive;
        if (Util.getPortalRequestContext().getRemoteUser() == null) {
            ((PortletRequestContext)context).getWriter().write(String.format("<p style='text-align:center'>%s</p>", context.getApplicationResourceBundle().getString("UIJCRExplorerPortlet.msg.anonymous-access-denied")));
            return;
        }
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.getChild(UIJcrExplorerContainer.class);
        UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class);
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        HashMap map = this.getElementByContext(context);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String backToValue = Util.getPortalRequestContext().getRequestParameter("backto");
        if (!portletReqContext.useAjax()) {
            this.backTo = backToValue;
        }
        if ((changeDrive = (HashMap)pcontext.getAttribute("jcrexplorer-show-document")) != null) {
            map = changeDrive;
            context.setAttribute("jcrexplorer-show-document", null);
        }
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (map.size() > 0) {
                this.showDocument(context, map);
            } else {
                this.initwhenDirect(explorerContainer, editContainer);
            }
            explorerContainer.setRendered(true);
            uiExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            if (uiExplorer != null) {
                try {
                    uiExplorer.getSession();
                    try {
                        uiExplorer.getSession().getItem(uiExplorer.getRootPath());
                    }
                    catch (PathNotFoundException e) {
                        this.reloadWhenBroken(uiExplorer);
                        super.processRender(app, context);
                        return;
                    }
                }
                catch (RepositoryException repo) {
                    super.processRender(app, context);
                }
            }
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(false);
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\n>>>>>>>>>>>>>>>>>>> IN HELP  MODE \n");
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            explorerContainer.setRendered(false);
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(true);
        }
        uiExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
        UITreeExplorer uiTreeExplorer = (UITreeExplorer)uiExplorer.findFirstComponentOfType(UITreeExplorer.class);
        AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
        context.getJavascriptManager().require("SHARED/multiUpload", "multiUpload").require("SHARED/jquery", "gj").addScripts("multiUpload.setLocation('" + uiExplorer.getWorkspaceName() + "','" + uiExplorer.getDriveData().getName() + "','" + uiTreeExplorer.getLabel() + "','" + uiExplorer.getCurrentPath() + "','" + Utils.getPersonalDrivePath((String)uiExplorer.getDriveData().getHomePath(), (String)ConversationState.getCurrent().getIdentity().getUserId()) + "', '" + autoVersionService.isVersionSupport(uiExplorer.getCurrentPath(), uiExplorer.getCurrentWorkspace()) + "');").addScripts("gj(document).ready(function() { gj(\"*[rel='tooltip']\").tooltip();});");
        super.processRender(app, context);
    }

    public void initwhenDirect(UIJcrExplorerContainer explorerContainer, UIJcrExplorerEditContainer editContainer) throws Exception {
        if (((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).isFlagSelectRender()) {
            explorerContainer.initExplorer();
            ((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).setFlagSelectRender(false);
        }
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue("repository", "");
        return repository;
    }

    public String getPreferenceTrashHomeNodePath() {
        return this.getPortletPreferences().getValue("trashHomeNodePath", "");
    }

    public String getPreferenceTrashRepository() {
        return this.getPortletPreferences().getValue("trashRepository", "");
    }

    public String getPreferenceTrashWorkspace() {
        return this.getPortletPreferences().getValue("trashWorkspace", "");
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    public DriveData getUserDrive() throws Exception {
        ManageDriveService manageDriveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        for (DriveData userDrive : manageDriveService.getPersonalDrives(userId)) {
            if (!userDrive.getHomePath().endsWith("/Private")) continue;
            return userDrive;
        }
        return null;
    }

    public boolean canUseConfigDrive(String driveName) throws Exception {
        ManageDriveService dservice = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        for (DriveData drive : dservice.getDriveByUserRoles(userId, userRoles)) {
            if (!drive.getName().equals(driveName)) continue;
            return true;
        }
        return false;
    }

    public void reloadWhenBroken(UIJCRExplorer uiExplorer) {
        ((UIControl)uiExplorer.getChild(UIControl.class)).setRendered(false);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        uiWorkingArea.setRenderedChild(UIDrivesArea.class);
        UIRightClickPopupMenu uiRightClickPopupMenu = (UIRightClickPopupMenu)uiWorkingArea.getChild(UIRightClickPopupMenu.class);
        if (uiRightClickPopupMenu != null) {
            uiRightClickPopupMenu.setRendered(true);
        }
    }

    private Map<String, String> getElementByContext(WebuiRequestContext context) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        if (context.useAjax()) {
            return mapParam;
        }
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        Map requestParams = pcontext.getRequest().getParameterMap();
        for (String requestParamName : requestParams.keySet()) {
            if (requestParamName.equals("path")) {
                String nodePathParam = pcontext.getRequestParameter("path");
                String currentRepo = WCMCoreUtils.getRepository().getConfiguration().getName();
                if (nodePathParam == null || nodePathParam.length() <= 0) continue;
                Pattern patternUrl = Pattern.compile("([^/]+)/(.*)");
                Matcher matcher = patternUrl.matcher(nodePathParam);
                if (matcher.find()) {
                    mapParam.put("repository", currentRepo);
                    mapParam.put("drive", matcher.group(1));
                    mapParam.put("path", matcher.group(2));
                    continue;
                }
                patternUrl = Pattern.compile("(.*)");
                matcher = patternUrl.matcher(nodePathParam);
                if (!matcher.find()) continue;
                mapParam.put("repository", currentRepo);
                mapParam.put("drive", matcher.group(1));
                mapParam.put("path", "/");
                continue;
            }
            mapParam.put(requestParamName, pcontext.getRequest().getParameter(requestParamName));
        }
        return mapParam;
    }

    private void showDocument(WebuiRequestContext context, Map<String, String> map) throws Exception {
        String publicHomePath;
        String repositoryName = String.valueOf(map.get("repository"));
        String driveName = String.valueOf(map.get("drive"));
        if (driveName.equals(DOC_NOT_FOUND)) {
            UIApplication uiApp = (UIApplication)this.findFirstComponentOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.not-found", null, 1));
            return;
        }
        String path = String.valueOf(map.get("path"));
        if (path.indexOf("&") > 0) {
            path = path.substring(0, path.indexOf("&"));
        }
        if (!path.equals("/")) {
            ArrayList<String> encodeNameArr = new ArrayList<String>();
            for (String name : path.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars((String)name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            path = encodedPath.toString();
        }
        UIApplication uiApp = (UIApplication)this.findFirstComponentOfType(UIApplication.class);
        ManageDriveService manageDrive = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        DriveData driveData = null;
        try {
            driveData = manageDrive.getDriveByName(driveName);
            if (driveData == null) {
                throw new PathNotFoundException();
            }
        }
        catch (PathNotFoundException e) {
            Object[] args = new Object[]{driveName};
            return;
        }
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> viewList = new ArrayList<String>();
        for (String role : org.exoplatform.ecm.webui.utils.Utils.getMemberships()) {
            for (String viewName : driveData.getViews().split(",")) {
                if (viewList.contains(viewName.trim())) continue;
                Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), WCMCoreUtils.getSystemSessionProvider());
                String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                if (permiss.contains("${userId}")) {
                    permiss = permiss.replace("${userId}", userId);
                }
                String[] viewPermissions = permiss.split(",");
                if (permiss.equals("*")) {
                    viewList.add(viewName.trim());
                }
                if (!driveData.hasPermission(viewPermissions, role)) continue;
                viewList.add(viewName.trim());
            }
        }
        StringBuffer viewListStr = new StringBuffer();
        ArrayList<SelectItemOption> viewOptions = new ArrayList<SelectItemOption>();
        ResourceBundle res = context.getApplicationResourceBundle();
        String viewLabel = null;
        for (String viewName : viewList) {
            try {
                viewLabel = res.getString("Views.label." + viewName);
            }
            catch (MissingResourceException e) {
                viewLabel = viewName;
            }
            viewOptions.add(new SelectItemOption(viewLabel, (Object)viewName));
            if (viewListStr.length() > 0) {
                viewListStr.append(",").append(viewName);
                continue;
            }
            viewListStr.append(viewName);
        }
        driveData.setViews(viewListStr.toString());
        String homePath = driveData.getHomePath();
        Matcher matcher = this.driveParameteriedPathPattern.matcher(homePath);
        if (matcher.matches()) {
            String drivePathParamName = matcher.group(1);
            String drivePathParamValue = map.get(drivePathParamName);
            driveData.getParameters().put(drivePathParamName, drivePathParamValue);
            if (StringUtils.isNotEmpty((String)drivePathParamValue)) {
                homePath = "userId".equals(drivePathParamName) ? Utils.getPersonalDrivePath((String)homePath, (String)drivePathParamValue) : StringUtils.replaceOnce((String)homePath, (String)("${" + drivePathParamName + "}"), (String)drivePathParamValue);
            }
        }
        String contentRealPath = path;
        int firstSlash = path.indexOf("/");
        if (firstSlash >= 0) {
            contentRealPath = path.substring(firstSlash);
        }
        this.setFlagSelect(true);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.findFirstComponentOfType(UIJCRExplorer.class);
        uiExplorer.setDriveData(driveData);
        uiExplorer.setIsReferenceNode(false);
        try {
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(driveData.getWorkspace(), rservice.getCurrentRepository());
            session.getItem(contentRealPath);
        }
        catch (AccessDeniedException ace) {
            Object[] args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.access-denied", args, 1));
            return;
        }
        catch (NoSuchWorkspaceException nosuchWS) {
            Object[] args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.workspace-not-exist", args, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        uiExplorer.setRepositoryName(repositoryName);
        uiExplorer.setWorkspaceName(driveData.getWorkspace());
        uiExplorer.setRootPath(homePath);
        String addressPath = contentRealPath.replaceAll("/+", "/");
        if (driveData.getName().equals("Personal Documents") && !addressPath.startsWith(homePath) && addressPath.startsWith(publicHomePath = homePath.replace("/Private", "/Public"))) {
            addressPath = addressPath.replace("/Public", "/Private/Public");
        }
        Preference pref = uiExplorer.getPreference();
        pref.setShowSideBar(driveData.getViewSideBar());
        pref.setShowNonDocumentType(driveData.getViewNonDocument());
        pref.setShowPreferenceDocuments(driveData.getViewPreferences());
        pref.setAllowCreateFoder(driveData.getAllowCreateFolders());
        pref.setShowHiddenNode(driveData.getShowHiddenNode());
        uiExplorer.setIsReferenceNode(false);
        UIControl uiControl = (UIControl)uiExplorer.getChild(UIControl.class);
        UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
        uiAddressBar.setViewList(viewList);
        uiAddressBar.setSelectedViewName((String)viewList.get(0));
        uiAddressBar.setRendered(this.isShowTopBar());
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.findFirstComponentOfType(UIWorkingArea.class);
        UIActionBar uiActionbar = (UIActionBar)uiWorkingArea.getChild(UIActionBar.class);
        boolean isShowActionBar = this.isShowActionBar();
        uiActionbar.setTabOptions((String)viewList.get(0));
        uiActionbar.setRendered(isShowActionBar);
        uiExplorer.clearNodeHistory(addressPath);
        uiExplorer.setSelectNode(driveData.getWorkspace(), addressPath, homePath);
        UIDocumentWorkspace uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        uiDocWorkspace.setRenderedChild(UIDocumentContainer.class);
        uiDocWorkspace.setRendered(true);
        UIDrivesArea uiDrive = (UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class);
        if (uiDrive != null) {
            uiDrive.setRendered(false);
        }
        context.addUIComponentToUpdateByAjax((UIComponent)uiDocWorkspace);
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        if (popupAction != null && popupAction.isRendered()) {
            popupAction.deActivate();
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        Boolean isEdit = Boolean.valueOf(Util.getPortalRequestContext().getRequestParameter("edit"));
        Node selectedNode = uiExplorer.getCurrentNode();
        if (isEdit.booleanValue()) {
            if (uiExplorer.getCurrentPath().equals(addressPath)) {
                if (this.canManageNode(selectedNode, uiApp, uiExplorer, uiActionbar, context, EditDocumentActionComponent.getFilters())) {
                    EditDocumentActionComponent.editDocument(null, context, (UIComponent)this, uiExplorer, selectedNode, uiApp);
                } else if (this.canManageNode(selectedNode, uiApp, uiExplorer, uiActionbar, context, EditPropertyActionComponent.getFilters())) {
                    EditPropertyActionComponent.editDocument(null, context, (UIComponent)this, uiExplorer, selectedNode, uiApp);
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UIJCRExplorerPortlet.msg.file-access-denied", null, 1));
            }
        }
        boolean isAddNew = Boolean.valueOf(Util.getPortalRequestContext().getRequestParameter("addNew"));
        if (!isEdit.booleanValue() && isAddNew) {
            if (this.canManageNode(selectedNode, uiApp, uiExplorer, uiActionbar, context, AddDocumentActionComponent.getFilters())) {
                AddDocumentActionComponent.addDocument(null, uiExplorer, uiApp, (UIComponent)this, context);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIJCRExplorerPortlet.msg.file-access-denied", null, 1));
            }
        }
        uiExplorer.refreshExplorer(null, isAddNew && isEdit != false);
    }

    private boolean canManageNode(Node selectedNode, UIApplication uiApp, UIJCRExplorer uiExplorer, UIActionBar uiActionBar, Object context, List<UIExtensionFilter> filters) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put(UIActionBar.class.getName(), (Object)uiActionBar);
        ctx.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
        ctx.put(UIApplication.class.getName(), uiApp);
        ctx.put(Node.class.getName(), selectedNode);
        ctx.put(WebuiRequestContext.class.getName(), context);
        for (UIExtensionFilter filter : filters) {
            try {
                if (filter.accept(ctx)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

