/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionHistoryUtils {
    protected static final Log log = ExoLogger.getLogger(VersionHistoryUtils.class);
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_MAX = 0;
    private static final int DOCUMENT_AUTO_DEFAULT_VERSION_EXPIRED = 0;
    public static final String NT_FILE = "nt:file";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    private static String maxAllowVersionProp = "jcr.documents.versions.max";
    private static String expirationTimeProp = "jcr.documents.versions.expiration";
    private static int maxAllowVersion;
    private static long maxLiveTime;

    public static Version createVersion(Node nodeVersioning) throws Exception {
        if (!nodeVersioning.isNodeType(NT_FILE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Version history is not impact with non-nt:file documents, there'is not any version created.");
            }
            return null;
        }
        if (!nodeVersioning.isNodeType(MIX_VERSIONABLE)) {
            if (nodeVersioning.canAddMixin(MIX_VERSIONABLE)) {
                nodeVersioning.addMixin(MIX_VERSIONABLE);
                nodeVersioning.save();
            }
            return null;
        }
        Version version = null;
        if (!nodeVersioning.isCheckedOut()) {
            nodeVersioning.checkout();
        } else {
            version = nodeVersioning.checkin();
            nodeVersioning.checkout();
        }
        if (maxAllowVersion != 0 || maxLiveTime != 0L) {
            VersionHistoryUtils.removeRedundant(nodeVersioning);
        }
        nodeVersioning.save();
        return version;
    }

    private static void removeRedundant(Node nodeVersioning) throws Exception {
        VersionHistory versionHistory = nodeVersioning.getVersionHistory();
        String baseVersion = nodeVersioning.getBaseVersion().getName();
        String rootVersion = nodeVersioning.getVersionHistory().getRootVersion().getName();
        VersionIterator versions = versionHistory.getAllVersions();
        Date currentDate = new Date();
        HashMap<String, String> lstVersions = new HashMap<String, String>();
        ArrayList<String> lstVersionTime = new ArrayList<String>();
        while (versions.hasNext()) {
            Version version = versions.nextVersion();
            if (rootVersion.equals(version.getName()) || baseVersion.equals(version.getName())) continue;
            if (maxLiveTime != 0L && currentDate.getTime() - version.getCreated().getTime().getTime() > maxLiveTime) {
                versionHistory.removeVersion(version.getName());
                continue;
            }
            lstVersions.put(String.valueOf(version.getCreated().getTimeInMillis()), version.getName());
            lstVersionTime.add(String.valueOf(version.getCreated().getTimeInMillis()));
        }
        if (maxAllowVersion <= lstVersionTime.size() && maxAllowVersion != 0) {
            Collections.sort(lstVersionTime);
            String[] lsts = lstVersionTime.toArray(new String[lstVersionTime.size()]);
            for (int j = 0; j <= lsts.length - maxAllowVersion; ++j) {
                versionHistory.removeVersion((String)lstVersions.get(lsts[j]));
            }
        }
    }

    static {
        try {
            maxAllowVersion = Integer.parseInt(System.getProperty(maxAllowVersionProp));
            maxLiveTime = Integer.parseInt(System.getProperty(expirationTimeProp));
            if (maxAllowVersion < 0) {
                maxAllowVersion = 0;
            }
            if (maxLiveTime < 0L) {
                maxLiveTime = 0L;
            }
        }
        catch (NumberFormatException nex) {
            maxAllowVersion = 0;
            maxLiveTime = 0L;
        }
        maxLiveTime = maxLiveTime * 24L * 60L * 60L * 1000L;
    }
}

