/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source;

import java.util.Map;
import org.jfree.data.general.Dataset;
import org.xwiki.chart.dataset.DatasetType;
import org.xwiki.chart.model.ChartModel;
import org.xwiki.chart.plot.PlotType;
import org.xwiki.rendering.internal.macro.chart.source.AxisConfigurator;
import org.xwiki.rendering.internal.macro.chart.source.DataSource;
import org.xwiki.rendering.internal.macro.chart.source.LocaleConfiguration;
import org.xwiki.rendering.internal.macro.chart.source.SimpleChartModel;
import org.xwiki.rendering.macro.MacroExecutionException;

public abstract class AbstractDataSource
implements DataSource {
    public static final String DATASET_PARAM = "dataset";
    public static final String PLOT_TYPE_PARAM = "type";
    private DatasetType datasetType;
    private PlotType plotType;
    private SimpleChartModel chartModel;
    private LocaleConfiguration localeConfiguration = new LocaleConfiguration();
    private AxisConfigurator axisConfigurator = new AxisConfigurator(this.localeConfiguration);

    protected void validateParameters(Map<String, String> parameters) throws MacroExecutionException {
        for (String key : parameters.keySet()) {
            if (DATASET_PARAM.equals(key)) {
                this.datasetType = DatasetType.forName((String)parameters.get(key));
                if (this.datasetType != null) continue;
                this.invalidParameterValue(DATASET_PARAM, parameters.get(key));
                continue;
            }
            if (PLOT_TYPE_PARAM.equals(key)) {
                this.plotType = PlotType.forName((String)parameters.get(key));
                if (this.plotType != null) continue;
                this.invalidParameterValue(PLOT_TYPE_PARAM, parameters.get(key));
                continue;
            }
            if (this.localeConfiguration.setParameter(key, parameters.get(key)) || this.axisConfigurator.setParameter(key, parameters.get(key))) continue;
            this.setParameter(key, parameters.get(key));
        }
        this.localeConfiguration.validateParameters();
        this.axisConfigurator.validateParameters();
        this.validatePlotType();
        this.validateDatasetType();
        this.validateParameters();
    }

    protected abstract boolean setParameter(String var1, String var2) throws MacroExecutionException;

    protected abstract void validateParameters() throws MacroExecutionException;

    protected void validateDatasetType() throws MacroExecutionException {
        if (this.getDatasetType() == null) {
            this.setDatasetType(this.plotType.getDefaultDatasetType());
        }
    }

    protected void validatePlotType() throws MacroExecutionException {
        if (this.plotType == null) {
            throw new MacroExecutionException(String.format("The parameter [%s] is mandatory!", PLOT_TYPE_PARAM));
        }
    }

    protected void setAxes() throws MacroExecutionException {
        this.axisConfigurator.setAxes(this.plotType, this.chartModel);
    }

    public DatasetType getDatasetType() {
        return this.datasetType;
    }

    public void setDatasetType(DatasetType datasetType) {
        this.datasetType = datasetType;
    }

    @Override
    public ChartModel getChartModel() {
        return this.chartModel;
    }

    protected void setChartModel(SimpleChartModel chartModel) {
        this.chartModel = chartModel;
    }

    protected void setDataset(Dataset dataset) {
        this.chartModel.setDataset(dataset);
    }

    protected void invalidParameterValue(String parameterName, String value) throws MacroExecutionException {
        throw new MacroExecutionException(String.format("Invalid value for parameter [%s]: [%s]", parameterName, value));
    }

    protected LocaleConfiguration getLocaleConfiguration() {
        return this.localeConfiguration;
    }
}

