/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.TextFlowContext;
import uk.ac.ed.ph.snuggletex.dombuilding.CommandHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.semantics.StyleDeclarationInterpretation;
import uk.ac.ed.ph.snuggletex.tokens.ArgumentContainerToken;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class StyleInterpretationHandler
implements CommandHandler,
EnvironmentHandler {
    public void handleCommand(DOMBuilder builder, Element parentElement, CommandToken token) throws SnuggleParseException {
        StyleDeclarationInterpretation styleInterpretation = (StyleDeclarationInterpretation)token.getCommand().getInterpretation();
        this.handleContent(builder, parentElement, styleInterpretation, token.getArguments()[0]);
    }

    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        StyleDeclarationInterpretation styleInterpretation = (StyleDeclarationInterpretation)token.getEnvironment().getInterpretation();
        this.handleContent(builder, parentElement, styleInterpretation, token.getContent());
    }

    public void handleContent(DOMBuilder builder, Element parentElement, StyleDeclarationInterpretation interpretation, ArgumentContainerToken contentContainerToken) throws SnuggleParseException {
        Element result = parentElement;
        if (builder.isBuildingMathMLIsland()) {
            String mathVariant = interpretation.getTargetMathMLMathVariantName();
            if (mathVariant != null) {
                result = builder.appendMathMLElement(parentElement, "mstyle");
                result.setAttribute("mathvariant", mathVariant);
            }
        } else {
            boolean hasBlockContent = false;
            for (FlowToken contentToken : contentContainerToken) {
                if (contentToken.getTextFlowContext() != TextFlowContext.START_NEW_XHTML_BLOCK) continue;
                hasBlockContent = true;
            }
            if (hasBlockContent && interpretation.getTargetBlockXHTMLElementName() != null) {
                result = builder.appendXHTMLElement(parentElement, interpretation.getTargetBlockXHTMLElementName());
                if (interpretation.getTargetBlockCSSClassName() != null) {
                    builder.applyCSSStyle(result, interpretation.getTargetBlockCSSClassName());
                }
            } else if (!hasBlockContent && interpretation.getTargetInlineXHTMLElementName() != null) {
                result = builder.appendXHTMLElement(parentElement, interpretation.getTargetInlineXHTMLElementName());
                if (interpretation.getTargetInlineCSSClassName() != null) {
                    builder.applyCSSStyle(result, interpretation.getTargetInlineCSSClassName());
                }
            }
        }
        builder.handleTokens(result, contentContainerToken, false);
    }
}

