/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.entity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.social.core.jpa.storage.entity.AppEntity;
import org.exoplatform.social.core.jpa.storage.entity.SpaceMemberEntity;
import org.exoplatform.social.core.space.model.Space;

@Entity(name="SocSpaceEntity")
@ExoEntity
@Table(name="SOC_SPACES")
@NamedQueries(value={@NamedQuery(name="SpaceEntity.getLastSpaces", query="SELECT sp FROM SocSpaceEntity sp ORDER BY sp.createdDate DESC"), @NamedQuery(name="SpaceEntity.getSpaceByGroupId", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.groupId = :groupId"), @NamedQuery(name="SpaceEntity.getSpaceByPrettyName", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.prettyName = :prettyName"), @NamedQuery(name="SpaceEntity.getSpaceByDisplayName", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.displayName = :displayName"), @NamedQuery(name="SpaceEntity.getSpaceByURL", query="SELECT sp FROM SocSpaceEntity sp WHERE sp.url = :url")})
public class SpaceEntity
implements Serializable {
    private static final long serialVersionUID = 3223615477747436986L;
    @Id
    @SequenceGenerator(name="SEQ_SOC_SPACES_ID", sequenceName="SEQ_SOC_SPACES_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_SOC_SPACES_ID")
    @Column(name="SPACE_ID")
    private Long id;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="space", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<SpaceMemberEntity> members = new HashSet<SpaceMemberEntity>();
    @ElementCollection
    @CollectionTable(name="SOC_APPS", joinColumns={@JoinColumn(name="SPACE_ID")})
    private Set<AppEntity> app = new HashSet<AppEntity>();
    @Column(name="PRETTY_NAME")
    private String prettyName;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="REGISTRATION")
    private REGISTRATION registration;
    @Column(name="DESCRIPTION")
    private String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="AVATAR_LAST_UPDATED")
    private Date avatarLastUpdated;
    @Column(name="VISIBILITY")
    public VISIBILITY visibility;
    @Column(name="PRIORITY")
    public PRIORITY priority;
    @Column(name="GROUP_ID")
    public String groupId;
    @Column(name="URL")
    public String url;
    @Column(name="TYPE")
    private String type;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_DATE", nullable=false)
    private Date createdDate = new Date();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<AppEntity> getApp() {
        return this.app;
    }

    public void setApp(Set<AppEntity> app) {
        this.app = app;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = prettyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public REGISTRATION getRegistration() {
        return this.registration;
    }

    public void setRegistration(REGISTRATION registration) {
        this.registration = registration;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Date avatarLastUpdated) {
        this.avatarLastUpdated = avatarLastUpdated;
    }

    public VISIBILITY getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VISIBILITY visibility) {
        this.visibility = visibility;
    }

    public PRIORITY getPriority() {
        return this.priority;
    }

    public void setPriority(PRIORITY priority) {
        this.priority = priority;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<SpaceMemberEntity> getMembers() {
        return this.members;
    }

    public SpaceEntity buildFrom(Space space) {
        this.setApp(AppEntity.parse(space.getApp()));
        if (space.getAvatarLastUpdated() != null) {
            this.setAvatarLastUpdated(space.getAvatarLastUpdated() > 0L ? new Date(space.getAvatarLastUpdated()) : null);
        }
        this.setCreatedDate(space.getCreatedTime() > 0L ? new Date(space.getCreatedTime()) : new Date());
        this.setDescription(space.getDescription());
        this.setType(space.getType());
        this.setDisplayName(space.getDisplayName());
        this.setGroupId(space.getGroupId());
        this.setPrettyName(space.getPrettyName());
        PRIORITY priority = null;
        if ("1".equals(space.getPriority())) {
            priority = PRIORITY.HIGH;
        } else if ("2".equals(space.getPriority())) {
            priority = PRIORITY.INTERMEDIATE;
        } else if ("3".equals(space.getPriority())) {
            priority = PRIORITY.LOW;
        }
        this.setPriority(priority);
        if (space.getRegistration() != null) {
            this.setRegistration(REGISTRATION.valueOf(space.getRegistration().toUpperCase()));
        }
        this.setUrl(space.getUrl());
        VISIBILITY visibility = null;
        if (space.getVisibility() != null) {
            visibility = VISIBILITY.valueOf(space.getVisibility().toUpperCase());
        }
        this.setVisibility(visibility);
        this.buildMembers(space);
        return this;
    }

    public String[] getPendingMembersId() {
        return this.getUserIds(SpaceMemberEntity.Status.PENDING);
    }

    public String[] getInvitedMembersId() {
        return this.getUserIds(SpaceMemberEntity.Status.INVITED);
    }

    public String[] getMembersId() {
        return this.getUserIds(SpaceMemberEntity.Status.MEMBER);
    }

    public String[] getManagerMembersId() {
        return this.getUserIds(SpaceMemberEntity.Status.MANAGER);
    }

    private void buildMembers(Space space) {
        Set<SpaceMemberEntity> invited = this.getMembers(SpaceMemberEntity.Status.INVITED);
        this.merge(invited, space.getInvitedUsers(), SpaceMemberEntity.Status.INVITED);
        Set<SpaceMemberEntity> manager = this.getMembers(SpaceMemberEntity.Status.MANAGER);
        this.merge(manager, space.getManagers(), SpaceMemberEntity.Status.MANAGER);
        Set<SpaceMemberEntity> member = this.getMembers(SpaceMemberEntity.Status.MEMBER);
        this.merge(member, space.getMembers(), SpaceMemberEntity.Status.MEMBER);
        Set<SpaceMemberEntity> pending = this.getMembers(SpaceMemberEntity.Status.PENDING);
        this.merge(pending, space.getPendingUsers(), SpaceMemberEntity.Status.PENDING);
    }

    private void merge(Set<SpaceMemberEntity> spaceMembers, String[] userIds, SpaceMemberEntity.Status status) {
        HashSet ids = new HashSet(userIds != null ? Arrays.asList(userIds) : Collections.emptyList());
        for (SpaceMemberEntity mem : spaceMembers) {
            String id = mem.getUserId();
            if (ids.contains(mem.getUserId())) {
                ids.remove(id);
                continue;
            }
            this.getMembers().remove(mem);
        }
        for (String id : ids) {
            this.getMembers().add(new SpaceMemberEntity(this, id, status));
        }
    }

    private Set<SpaceMemberEntity> getMembers(SpaceMemberEntity.Status status) {
        HashSet<SpaceMemberEntity> mems = new HashSet<SpaceMemberEntity>();
        for (SpaceMemberEntity mem : this.getMembers()) {
            if (!mem.getStatus().equals((Object)status)) continue;
            mems.add(mem);
        }
        return mems;
    }

    private String[] getUserIds(SpaceMemberEntity.Status status) {
        LinkedList<String> ids = new LinkedList<String>();
        for (SpaceMemberEntity mem : this.getMembers(status)) {
            ids.add(mem.getUserId());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static enum REGISTRATION {
        OPEN,
        VALIDATION,
        CLOSE;

    }

    public static enum PRIORITY {
        HIGH,
        INTERMEDIATE,
        LOW;

    }

    public static enum VISIBILITY {
        PUBLIC,
        PRIVATE,
        HIDDEN;

    }
}

